/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.ModifierContributor;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.ByteBuddyCommons;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Field {
    public static final String BEAN_PROPERTY = "";

    public boolean serializableProxy() default false;

    public String value() default "";

    public Class<?> definingType() default void.class;

    public static class Binder
    implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Field> {
        private static final MethodDescription DEFINING_TYPE;
        private static final MethodDescription FIELD_NAME;
        private static final MethodDescription SERIALIZABLE_PROXY;
        private final MethodDescription getterMethod;
        private final MethodDescription setterMethod;

        protected Binder(MethodDescription getterMethod, MethodDescription setterMethod) {
            this.getterMethod = getterMethod;
            this.setterMethod = setterMethod;
        }

        public static TargetMethodAnnotationDrivenBinder.ParameterBinder<Field> install(Class<?> getterType, Class<?> setterType) {
            return Binder.install(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(getterType)), new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(setterType)));
        }

        public static TargetMethodAnnotationDrivenBinder.ParameterBinder<Field> install(TypeDescription getterType, TypeDescription setterType) {
            MethodDescription getterMethod = Binder.onlyMethod(ByteBuddyCommons.nonNull(getterType));
            if (!getterMethod.getReturnType().represents(Object.class)) {
                throw new IllegalArgumentException(getterMethod + " must take a single Object-typed parameter");
            }
            if (getterMethod.getParameterTypes().size() != 0) {
                throw new IllegalArgumentException(getterMethod + " must not declare parameters");
            }
            MethodDescription setterMethod = Binder.onlyMethod(ByteBuddyCommons.nonNull(setterType));
            if (!setterMethod.getReturnType().represents(Void.TYPE)) {
                throw new IllegalArgumentException(setterMethod + " must return void");
            }
            if (setterMethod.getParameterTypes().size() != 1 || !((TypeDescription)setterMethod.getParameterTypes().get(0)).represents(Object.class)) {
                throw new IllegalArgumentException(setterMethod + " must declare a single Object-typed parameters");
            }
            return new Binder(getterMethod, setterMethod);
        }

        private static MethodDescription onlyMethod(TypeDescription typeDescription) {
            if (!typeDescription.isInterface()) {
                throw new IllegalArgumentException(typeDescription + " is not an interface");
            }
            if (typeDescription.getInterfaces().size() > 0) {
                throw new IllegalArgumentException(typeDescription + " must not extend other interfaces");
            }
            if (!typeDescription.isPublic()) {
                throw new IllegalArgumentException(typeDescription + " is mot public");
            }
            MethodList methodCandidates = typeDescription.getDeclaredMethods().filter(MethodMatchers.not(MethodMatchers.isStatic()));
            if (methodCandidates.size() != 1) {
                throw new IllegalArgumentException(typeDescription + " must declare exactly one non-static method");
            }
            return methodCandidates.getOnly();
        }

        @Override
        public Class<Field> getHandledType() {
            return Field.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Field> annotation, int targetParameterIndex, MethodDescription source, MethodDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            AccessType accessType;
            TypeDescription parameterType = (TypeDescription)target.getParameterTypes().get(targetParameterIndex);
            if (parameterType.equals(this.getterMethod.getDeclaringType())) {
                accessType = AccessType.GETTER;
            } else if (parameterType.equals(this.setterMethod.getDeclaringType())) {
                accessType = AccessType.SETTER;
            } else {
                throw new IllegalStateException(target + " uses a @Field annotation on an non-installed type");
            }
            FieldLocator.Resolution resolution = FieldLocator.of(annotation.getValue(FIELD_NAME, String.class), source).lookup(annotation.getValue(DEFINING_TYPE, TypeDescription.class), instrumentationTarget.getTypeDescription()).resolve(instrumentationTarget.getTypeDescription());
            return resolution.isValid() ? new MethodDelegationBinder.ParameterBinding.Anonymous(new AccessorProxy(resolution.getFieldDescription(), assigner, instrumentationTarget.getTypeDescription(), accessType, annotation.getValue(SERIALIZABLE_PROXY, Boolean.class))) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.getterMethod.equals(((Binder)other).getterMethod) && this.setterMethod.equals(((Binder)other).setterMethod);
        }

        public int hashCode() {
            int result = this.getterMethod.hashCode();
            result = 31 * result + this.setterMethod.hashCode();
            return result;
        }

        public String toString() {
            return "Field.Binder{getterMethod=" + this.getterMethod + ", setterMethod=" + this.setterMethod + '}';
        }

        static {
            MethodList methodList = new TypeDescription.ForLoadedType(Field.class).getDeclaredMethods();
            DEFINING_TYPE = methodList.filter(MethodMatchers.named("definingType")).getOnly();
            FIELD_NAME = methodList.filter(MethodMatchers.named("value")).getOnly();
            SERIALIZABLE_PROXY = methodList.filter(MethodMatchers.named("serializableProxy")).getOnly();
        }

        protected class AccessorProxy
        implements AuxiliaryType,
        StackManipulation {
            protected static final String FIELD_NAME = "instance";
            private final FieldDescription accessedField;
            private final TypeDescription instrumentedType;
            private final Assigner assigner;
            private final AccessType accessType;
            private final boolean serializableProxy;

            protected AccessorProxy(FieldDescription accessedField, Assigner assigner, TypeDescription instrumentedType, AccessType accessType, boolean serializableProxy) {
                this.accessedField = accessedField;
                this.assigner = assigner;
                this.instrumentedType = instrumentedType;
                this.accessType = accessType;
                this.serializableProxy = serializableProxy;
            }

            @Override
            public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
                Class[] classArray;
                DynamicType.Builder builder = new ByteBuddy(classFileVersion).subclass(this.accessType.proxyType(Binder.this.getterMethod, Binder.this.setterMethod), (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER);
                if (this.serializableProxy) {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = Serializable.class;
                } else {
                    classArray = new Class[]{};
                }
                return builder.implement(classArray).defineConstructor(this.accessedField.isStatic() ? Collections.emptyList() : Collections.singletonList(this.instrumentedType), new ModifierContributor.ForMethod[0]).intercept(this.accessedField.isStatic() ? StaticFieldConstructor.INSTANCE : new InstanceFieldConstructor(this.instrumentedType)).method(MethodMatchers.isDeclaredBy(this.accessType.proxyType(Binder.this.getterMethod, Binder.this.setterMethod))).intercept(this.accessType.access(this.accessedField, this.assigner, methodAccessorFactory)).make();
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                TypeDescription auxiliaryType = instrumentationContext.register(this);
                return new StackManipulation.Compound(TypeCreation.forType(auxiliaryType), Duplication.SINGLE, this.accessedField.isStatic() ? StackManipulation.LegalTrivial.INSTANCE : MethodVariableAccess.REFERENCE.loadFromIndex(0), MethodInvocation.invoke(auxiliaryType.getDeclaredMethods().filter(MethodMatchers.isConstructor()).getOnly())).apply(methodVisitor, instrumentationContext);
            }

            private Binder getOuter() {
                return Binder.this;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                AccessorProxy that = (AccessorProxy)other;
                return this.serializableProxy == that.serializableProxy && this.accessType == that.accessType && this.accessedField.equals(that.accessedField) && this.assigner.equals(that.assigner) && Binder.this.equals(that.getOuter()) && this.instrumentedType.equals(that.instrumentedType);
            }

            public int hashCode() {
                int result = this.accessedField.hashCode();
                result = 31 * result + this.instrumentedType.hashCode();
                result = 31 * result + this.assigner.hashCode();
                result = 31 * result + Binder.this.hashCode();
                result = 31 * result + this.accessType.hashCode();
                result = 31 * result + (this.serializableProxy ? 1 : 0);
                return result;
            }

            public String toString() {
                return "Field.Binder.AccessorProxy{accessedField=" + this.accessedField + ", instrumentedType=" + this.instrumentedType + ", assigner=" + this.assigner + ", accessType=" + (Object)((Object)this.accessType) + ", serializableProxy=" + this.serializableProxy + ", binder=" + Binder.this + '}';
            }
        }

        protected static abstract class FieldLocator {
            protected FieldLocator() {
            }

            protected static FieldLocator of(String fieldName, MethodDescription methodDescription) {
                return Field.BEAN_PROPERTY.equals(fieldName) ? Legal.consider(methodDescription) : new Legal(fieldName);
            }

            protected abstract LookupEngine lookup(TypeDescription var1, TypeDescription var2);

            protected static class Illegal
            extends FieldLocator {
                protected Illegal() {
                }

                @Override
                protected LookupEngine lookup(TypeDescription typeDescription, TypeDescription instrumentedType) {
                    return new LookupEngine.Illegal();
                }

                public int hashCode() {
                    return 31;
                }

                public boolean equals(Object other) {
                    return other == this || other != null && other.getClass() == this.getClass();
                }

                public String toString() {
                    return "Field.Binder.FieldLocator.Illegal{}";
                }
            }

            protected static class Legal
            extends FieldLocator {
                private final String fieldName;

                protected Legal(String fieldName) {
                    this.fieldName = fieldName;
                }

                protected static FieldLocator consider(MethodDescription methodDescription) {
                    String fieldName;
                    if (MethodMatchers.isSetter().matches(methodDescription)) {
                        fieldName = methodDescription.getInternalName().substring(3);
                    } else if (MethodMatchers.isGetter().matches(methodDescription)) {
                        fieldName = methodDescription.getInternalName().substring(methodDescription.getInternalName().startsWith("is") ? 2 : 3);
                    } else {
                        return new Illegal();
                    }
                    return new Legal(Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1));
                }

                @Override
                protected LookupEngine lookup(TypeDescription typeDescription, TypeDescription instrumentedType) {
                    return typeDescription.represents(Void.TYPE) ? new LookupEngine.ForHierarchy(this.fieldName) : new LookupEngine.ForExplicitType(this.fieldName, typeDescription.represents(TargetType.class) ? instrumentedType : typeDescription);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((Legal)other).fieldName);
                }

                public int hashCode() {
                    return this.fieldName.hashCode();
                }

                public String toString() {
                    return "Field.Binder.FieldLocator.Legal{fieldName='" + this.fieldName + '\'' + '}';
                }
            }

            protected static abstract class LookupEngine {
                protected LookupEngine() {
                }

                protected abstract Resolution resolve(TypeDescription var1);

                protected static class ForExplicitType
                extends LookupEngine {
                    private final String fieldName;
                    private final TypeDescription typeDescription;

                    protected ForExplicitType(String fieldName, TypeDescription typeDescription) {
                        this.fieldName = fieldName;
                        this.typeDescription = typeDescription;
                    }

                    @Override
                    protected Resolution resolve(TypeDescription instrumentedType) {
                        for (FieldDescription fieldDescription : this.typeDescription.getDeclaredFields()) {
                            if (!fieldDescription.getInternalName().equals(this.fieldName)) continue;
                            return fieldDescription.isVisibleTo(instrumentedType) ? new Resolution.Resolved(fieldDescription) : new Resolution.Unresolved();
                        }
                        return new Resolution.Unresolved();
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForExplicitType)other).fieldName) && this.typeDescription.equals(((ForExplicitType)other).typeDescription);
                    }

                    public int hashCode() {
                        int result = this.fieldName.hashCode();
                        result = 31 * result + this.typeDescription.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "Field.Binder.FieldLocator.LookupEngine.ForExplicitType{fieldName='" + this.fieldName + '\'' + ", typeDescription=" + this.typeDescription + '}';
                    }
                }

                protected static class ForHierarchy
                extends LookupEngine {
                    private final String fieldName;

                    protected ForHierarchy(String fieldName) {
                        this.fieldName = fieldName;
                    }

                    @Override
                    protected Resolution resolve(TypeDescription instrumentedType) {
                        TypeDescription currentType = instrumentedType;
                        do {
                            for (FieldDescription fieldDescription : currentType.getDeclaredFields()) {
                                if (!fieldDescription.getInternalName().equals(this.fieldName) || !fieldDescription.isVisibleTo(instrumentedType)) continue;
                                return new Resolution.Resolved(fieldDescription);
                            }
                        } while ((currentType = currentType.getSupertype()) != null);
                        return new Resolution.Unresolved();
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForHierarchy)other).fieldName);
                    }

                    public int hashCode() {
                        return this.fieldName.hashCode();
                    }

                    public String toString() {
                        return "Field.Binder.FieldLocator.LookupEngine.ForHierarchy{fieldName='" + this.fieldName + '\'' + '}';
                    }
                }

                protected static class Illegal
                extends LookupEngine {
                    protected Illegal() {
                    }

                    @Override
                    protected Resolution resolve(TypeDescription instrumentedType) {
                        return new Resolution.Unresolved();
                    }

                    public int hashCode() {
                        return 17;
                    }

                    public boolean equals(Object other) {
                        return other == this || other != null && other.getClass() == this.getClass();
                    }

                    public String toString() {
                        return "Field.Binder.FieldLocator.LookupEngine.Illegal{}";
                    }
                }
            }

            protected static abstract class Resolution {
                protected Resolution() {
                }

                protected abstract boolean isValid();

                protected abstract FieldDescription getFieldDescription();

                protected static class Resolved
                extends Resolution {
                    private final FieldDescription fieldDescription;

                    protected Resolved(FieldDescription fieldDescription) {
                        this.fieldDescription = fieldDescription;
                    }

                    @Override
                    protected boolean isValid() {
                        return true;
                    }

                    @Override
                    protected FieldDescription getFieldDescription() {
                        return this.fieldDescription;
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.fieldDescription.equals(((Resolved)other).fieldDescription);
                    }

                    public int hashCode() {
                        return this.fieldDescription.hashCode();
                    }

                    public String toString() {
                        return "Field.Binder.FieldLocator.Resolution.Resolved{fieldDescription=" + this.fieldDescription + '}';
                    }
                }

                protected static class Unresolved
                extends Resolution {
                    protected Unresolved() {
                    }

                    @Override
                    protected boolean isValid() {
                        return false;
                    }

                    @Override
                    protected FieldDescription getFieldDescription() {
                        throw new IllegalStateException("Cannot resolve an unresolved field lookup");
                    }

                    public int hashCode() {
                        return 17;
                    }

                    public boolean equals(Object other) {
                        return other == this || other != null && other.getClass() == this.getClass();
                    }

                    public String toString() {
                        return "Field.Binder.FieldLocator.Resolution.Unresolved{}";
                    }
                }
            }
        }

        protected static class InstanceFieldConstructor
        implements Instrumentation {
            private final TypeDescription instrumentedType;

            protected InstanceFieldConstructor(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField("instance", this.instrumentedType, 18);
            }

            @Override
            public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
                return new Appender(instrumentationTarget);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((InstanceFieldConstructor)other).instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "Field.Binder.InstanceFieldConstructor{instrumentedType=" + this.instrumentedType + '}';
            }

            protected static class Appender
            implements ByteCodeAppender {
                private final FieldDescription fieldDescription;

                protected Appender(Instrumentation.Target instrumentationTarget) {
                    this.fieldDescription = instrumentationTarget.getTypeDescription().getDeclaredFields().named("instance");
                }

                @Override
                public boolean appendsCode() {
                    return true;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                    StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFromIndex(0), MethodInvocation.invoke(StaticFieldConstructor.INSTANCE.objectTypeDefaultConstructor), MethodVariableAccess.loadThisReferenceAndArguments(instrumentedMethod), FieldAccess.forField(this.fieldDescription).putter(), MethodReturn.VOID).apply(methodVisitor, instrumentationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldDescription.equals(((Appender)other).fieldDescription);
                }

                public int hashCode() {
                    return this.fieldDescription.hashCode();
                }

                public String toString() {
                    return "Field.Binder.InstanceFieldConstructor.Appender{fieldDescription=" + this.fieldDescription + '}';
                }
            }
        }

        protected static enum AccessType {
            GETTER{

                @Override
                protected TypeDescription proxyType(MethodDescription getterMethod, MethodDescription setterMethod) {
                    return getterMethod.getDeclaringType();
                }

                @Override
                protected Instrumentation access(FieldDescription fieldDescription, Assigner assigner, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
                    return new Getter(fieldDescription, assigner, methodAccessorFactory);
                }
            }
            ,
            SETTER{

                @Override
                protected TypeDescription proxyType(MethodDescription getterMethod, MethodDescription setterMethod) {
                    return setterMethod.getDeclaringType();
                }

                @Override
                protected Instrumentation access(FieldDescription fieldDescription, Assigner assigner, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
                    return new Setter(fieldDescription, assigner, methodAccessorFactory);
                }
            };


            protected abstract TypeDescription proxyType(MethodDescription var1, MethodDescription var2);

            protected abstract Instrumentation access(FieldDescription var1, Assigner var2, AuxiliaryType.MethodAccessorFactory var3);

            protected static class Setter
            implements Instrumentation {
                private final FieldDescription accessedField;
                private final Assigner assigner;
                private final AuxiliaryType.MethodAccessorFactory methodAccessorFactory;

                protected Setter(FieldDescription accessedField, Assigner assigner, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
                    this.accessedField = accessedField;
                    this.assigner = assigner;
                    this.methodAccessorFactory = methodAccessorFactory;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
                    return new Appender(instrumentationTarget);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Setter getter = (Setter)other;
                    return this.accessedField.equals(getter.accessedField) && this.assigner.equals(getter.assigner) && this.methodAccessorFactory.equals(getter.methodAccessorFactory);
                }

                public int hashCode() {
                    int result = this.accessedField.hashCode();
                    result = 31 * result + this.assigner.hashCode();
                    result = 31 * result + this.methodAccessorFactory.hashCode();
                    return result;
                }

                public String toString() {
                    return "Field.Binder.AccessType.Setter{accessedField=" + this.accessedField + ", assigner=" + this.assigner + ", methodAccessorFactory=" + this.methodAccessorFactory + '}';
                }

                protected class Appender
                implements ByteCodeAppender {
                    private final TypeDescription typeDescription;

                    protected Appender(Instrumentation.Target instrumentationTarget) {
                        this.typeDescription = instrumentationTarget.getTypeDescription();
                    }

                    @Override
                    public boolean appendsCode() {
                        return true;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                        TypeDescription parameterType = (TypeDescription)instrumentedMethod.getParameterTypes().get(0);
                        MethodDescription setterMethod = Setter.this.methodAccessorFactory.registerSetterFor(Setter.this.accessedField);
                        StackManipulation.Size stackSize = new StackManipulation.Compound(Setter.this.accessedField.isStatic() ? StackManipulation.LegalTrivial.INSTANCE : new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFromIndex(0), FieldAccess.forField(this.typeDescription.getDeclaredFields().named("instance")).getter()), MethodVariableAccess.forType(parameterType).loadFromIndex(1), Setter.this.assigner.assign(parameterType, (TypeDescription)setterMethod.getParameterTypes().get(0), true), MethodInvocation.invoke(setterMethod), MethodReturn.VOID).apply(methodVisitor, instrumentationContext);
                        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    private Setter getOuter() {
                        return Setter.this;
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && Setter.this.equals(((Appender)other).getOuter()) && this.typeDescription.equals(((Appender)other).typeDescription);
                    }

                    public int hashCode() {
                        return this.typeDescription.hashCode() + 31 * Setter.this.hashCode();
                    }

                    public String toString() {
                        return "Field.Binder.AccessType.Setter.Appender{setter=" + Setter.this + "typeDescription=" + this.typeDescription + '}';
                    }
                }
            }

            protected static class Getter
            implements Instrumentation {
                private final FieldDescription accessedField;
                private final Assigner assigner;
                private final AuxiliaryType.MethodAccessorFactory methodAccessorFactory;

                protected Getter(FieldDescription accessedField, Assigner assigner, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
                    this.accessedField = accessedField;
                    this.assigner = assigner;
                    this.methodAccessorFactory = methodAccessorFactory;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
                    return new Appender(instrumentationTarget);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Getter getter = (Getter)other;
                    return this.accessedField.equals(getter.accessedField) && this.assigner.equals(getter.assigner) && this.methodAccessorFactory.equals(getter.methodAccessorFactory);
                }

                public int hashCode() {
                    int result = this.accessedField.hashCode();
                    result = 31 * result + this.assigner.hashCode();
                    result = 31 * result + this.methodAccessorFactory.hashCode();
                    return result;
                }

                public String toString() {
                    return "Field.Binder.AccessType.Getter{accessedField=" + this.accessedField + ", assigner=" + this.assigner + ", methodAccessorFactory=" + this.methodAccessorFactory + '}';
                }

                protected class Appender
                implements ByteCodeAppender {
                    private final TypeDescription typeDescription;

                    protected Appender(Instrumentation.Target instrumentationTarget) {
                        this.typeDescription = instrumentationTarget.getTypeDescription();
                    }

                    @Override
                    public boolean appendsCode() {
                        return true;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                        MethodDescription getterMethod = Getter.this.methodAccessorFactory.registerGetterFor(Getter.this.accessedField);
                        StackManipulation.Size stackSize = new StackManipulation.Compound(Getter.this.accessedField.isStatic() ? StackManipulation.LegalTrivial.INSTANCE : new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFromIndex(0), FieldAccess.forField(this.typeDescription.getDeclaredFields().named("instance")).getter()), MethodInvocation.invoke(getterMethod), Getter.this.assigner.assign(getterMethod.getReturnType(), instrumentedMethod.getReturnType(), true), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
                        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    private Getter getOuter() {
                        return Getter.this;
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && Getter.this.equals(((Appender)other).getOuter()) && this.typeDescription.equals(((Appender)other).typeDescription);
                    }

                    public int hashCode() {
                        return this.typeDescription.hashCode() + 31 * Getter.this.hashCode();
                    }

                    public String toString() {
                        return "Field.Binder.AccessType.Getter.Appender{getter=" + Getter.this + "typeDescription=" + this.typeDescription + '}';
                    }
                }
            }
        }

        protected static enum StaticFieldConstructor implements Instrumentation
        {
            INSTANCE;

            protected final MethodDescription objectTypeDefaultConstructor = new TypeDescription.ForLoadedType(Object.class).getDeclaredMethods().filter(MethodMatchers.isConstructor()).getOnly();

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
                return new ByteCodeAppender.Simple(MethodVariableAccess.REFERENCE.loadFromIndex(0), MethodInvocation.invoke(this.objectTypeDefaultConstructor), MethodReturn.VOID);
            }
        }
    }
}

