/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive;

import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveBoxingDelegate;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveUnboxingDelegate;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveWideningDelegate;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class PrimitiveTypeAwareAssigner
implements Assigner {
    private final Assigner referenceTypeAwareAssigner;

    public PrimitiveTypeAwareAssigner(Assigner referenceTypeAwareAssigner) {
        this.referenceTypeAwareAssigner = referenceTypeAwareAssigner;
    }

    @Override
    public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, boolean considerRuntimeType) {
        if (sourceType.isPrimitive() && targetType.isPrimitive()) {
            return PrimitiveWideningDelegate.forPrimitive(sourceType).widenTo(targetType);
        }
        if (sourceType.isPrimitive()) {
            return PrimitiveBoxingDelegate.forPrimitive(sourceType).assignBoxedTo(targetType, this.referenceTypeAwareAssigner, considerRuntimeType);
        }
        if (targetType.isPrimitive()) {
            return PrimitiveUnboxingDelegate.forReferenceType(sourceType).assignUnboxedTo(targetType, this.referenceTypeAwareAssigner, considerRuntimeType);
        }
        return this.referenceTypeAwareAssigner.assign(sourceType, targetType, considerRuntimeType);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.referenceTypeAwareAssigner.equals(((PrimitiveTypeAwareAssigner)other).referenceTypeAwareAssigner);
    }

    public int hashCode() {
        return this.referenceTypeAwareAssigner.hashCode();
    }

    public String toString() {
        return "PrimitiveTypeAwareAssigner{referenceTypeAwareAssigner=" + this.referenceTypeAwareAssigner + '}';
    }
}

