/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive;

import net.bytebuddy.instrumentation.method.bytecode.stack.Removal;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.DefaultValue;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class VoidAwareAssigner
implements Assigner {
    private final Assigner chained;
    private final boolean returnDefaultValue;

    public VoidAwareAssigner(Assigner chained, boolean returnDefaultValue) {
        this.chained = chained;
        this.returnDefaultValue = returnDefaultValue;
    }

    @Override
    public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, boolean considerRuntimeType) {
        if (sourceType.represents(Void.TYPE) && targetType.represents(Void.TYPE)) {
            return StackManipulation.LegalTrivial.INSTANCE;
        }
        if (sourceType.represents(Void.TYPE)) {
            return this.returnDefaultValue ? DefaultValue.of(targetType) : StackManipulation.Illegal.INSTANCE;
        }
        if (targetType.represents(Void.TYPE)) {
            return Removal.pop(sourceType);
        }
        return this.chained.assign(sourceType, targetType, considerRuntimeType);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.returnDefaultValue == ((VoidAwareAssigner)other).returnDefaultValue && this.chained.equals(((VoidAwareAssigner)other).chained);
    }

    public int hashCode() {
        return 31 * this.chained.hashCode() + (this.returnDefaultValue ? 1 : 0);
    }

    public String toString() {
        return "VoidAwareAssigner{chained=" + this.chained + ", returnDefaultValue=" + this.returnDefaultValue + '}';
    }
}

