/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.type;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;

public interface InstrumentedType
extends TypeDescription {
    public InstrumentedType withField(String var1, TypeDescription var2, int var3);

    public InstrumentedType withMethod(String var1, TypeDescription var2, List<? extends TypeDescription> var3, List<? extends TypeDescription> var4, int var5);

    public InstrumentedType withInitializer(LoadedTypeInitializer var1);

    public LoadedTypeInitializer getLoadedTypeInitializer();

    public TypeDescription detach();

    public static abstract class AbstractBase
    extends TypeDescription.AbstractTypeDescription.OfSimpleType
    implements InstrumentedType {
        protected final LoadedTypeInitializer loadedTypeInitializer;
        protected final List<FieldDescription> fieldDescriptions;
        protected final List<MethodDescription> methodDescriptions;

        protected AbstractBase() {
            this.loadedTypeInitializer = LoadedTypeInitializer.NoOp.INSTANCE;
            this.fieldDescriptions = Collections.emptyList();
            this.methodDescriptions = Collections.emptyList();
        }

        protected AbstractBase(LoadedTypeInitializer loadedTypeInitializer, String typeName, List<? extends FieldDescription> fieldDescriptions, List<? extends MethodDescription> methodDescriptions) {
            this.loadedTypeInitializer = loadedTypeInitializer;
            this.fieldDescriptions = new ArrayList<FieldDescription>(fieldDescriptions.size());
            for (FieldDescription fieldDescription : fieldDescriptions) {
                this.fieldDescriptions.add(new FieldToken(typeName, fieldDescription));
            }
            this.methodDescriptions = new ArrayList<MethodDescription>(methodDescriptions.size());
            for (MethodDescription methodDescription : methodDescriptions) {
                this.methodDescriptions.add(new MethodToken(typeName, methodDescription));
            }
        }

        private TypeDescription withSubstitutedSelfReference(String typeName, TypeDescription typeDescription) {
            return typeDescription.getName().equals(typeName) ? this : typeDescription;
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return null;
        }

        @Override
        public TypeDescription getEnclosingType() {
            return null;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return null;
        }

        @Override
        public boolean isAnonymousClass() {
            return false;
        }

        @Override
        public String getCanonicalName() {
            return this.getName();
        }

        @Override
        public boolean isLocalClass() {
            return false;
        }

        @Override
        public boolean isMemberClass() {
            return false;
        }

        @Override
        public FieldList getDeclaredFields() {
            return new FieldList.Explicit(this.fieldDescriptions);
        }

        @Override
        public MethodList getDeclaredMethods() {
            return new MethodList.Explicit(this.methodDescriptions);
        }

        @Override
        public LoadedTypeInitializer getLoadedTypeInitializer() {
            return this.loadedTypeInitializer;
        }

        protected class MethodToken
        extends MethodDescription.AbstractMethodDescription {
            private final String internalName;
            private final TypeDescription returnType;
            private final List<TypeDescription> parameterTypes;
            private final List<TypeDescription> exceptionTypes;
            private final int modifiers;

            public MethodToken(String internalName, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, List<? extends TypeDescription> exceptionTypes, int modifiers) {
                this.internalName = internalName;
                this.returnType = returnType;
                this.parameterTypes = new ArrayList<TypeDescription>(parameterTypes);
                this.exceptionTypes = new ArrayList<TypeDescription>(exceptionTypes);
                this.modifiers = modifiers;
            }

            private MethodToken(String typeName, MethodDescription methodDescription) {
                this.internalName = methodDescription.getInternalName();
                this.returnType = AbstractBase.this.withSubstitutedSelfReference(typeName, methodDescription.getReturnType());
                this.parameterTypes = new ArrayList<TypeDescription>(methodDescription.getParameterTypes().size());
                for (TypeDescription typeDescription : methodDescription.getParameterTypes()) {
                    this.parameterTypes.add(AbstractBase.this.withSubstitutedSelfReference(typeName, typeDescription));
                }
                this.exceptionTypes = new ArrayList<TypeDescription>(methodDescription.getExceptionTypes().size());
                for (TypeDescription typeDescription : methodDescription.getExceptionTypes()) {
                    this.exceptionTypes.add(AbstractBase.this.withSubstitutedSelfReference(typeName, typeDescription));
                }
                this.modifiers = methodDescription.getModifiers();
            }

            @Override
            public TypeDescription getReturnType() {
                return this.returnType;
            }

            @Override
            public TypeList getParameterTypes() {
                return new TypeList.Explicit(this.parameterTypes);
            }

            @Override
            public TypeList getExceptionTypes() {
                return new TypeList.Explicit(this.exceptionTypes);
            }

            @Override
            public boolean isConstructor() {
                return "<init>".equals(this.internalName);
            }

            @Override
            public boolean isTypeInitializer() {
                return false;
            }

            @Override
            public boolean represents(Method method) {
                return false;
            }

            @Override
            public boolean represents(Constructor<?> constructor) {
                return false;
            }

            @Override
            public List<AnnotationList> getParameterAnnotations() {
                return AnnotationList.Empty.asList(this.parameterTypes.size());
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Empty();
            }

            @Override
            public String getInternalName() {
                return this.internalName;
            }

            @Override
            public TypeDescription getDeclaringType() {
                return AbstractBase.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }

            @Override
            public Object getDefaultValue() {
                return null;
            }
        }

        protected class FieldToken
        extends FieldDescription.AbstractFieldDescription {
            private final String name;
            private final TypeDescription fieldType;
            private final int modifiers;

            public FieldToken(String name, TypeDescription fieldType, int modifiers) {
                this.name = name;
                this.fieldType = fieldType;
                this.modifiers = modifiers;
            }

            private FieldToken(String typeName, FieldDescription fieldDescription) {
                this.name = fieldDescription.getName();
                this.fieldType = AbstractBase.this.withSubstitutedSelfReference(typeName, fieldDescription.getFieldType());
                this.modifiers = fieldDescription.getModifiers();
            }

            @Override
            public TypeDescription getFieldType() {
                return this.fieldType;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Empty();
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getDescriptor() {
                return this.fieldType.getDescriptor();
            }

            @Override
            public TypeDescription getDeclaringType() {
                return AbstractBase.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }
        }
    }
}

