/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface MethodRegistry {
    public MethodRegistry prepend(LatentMethodMatcher var1, Instrumentation var2, MethodAttributeAppender.Factory var3);

    public MethodRegistry append(LatentMethodMatcher var1, Instrumentation var2, MethodAttributeAppender.Factory var3);

    public Prepared prepare(InstrumentedType var1);

    public static class Default
    implements MethodRegistry {
        private final List<Entry> entries;

        public Default() {
            this.entries = Collections.emptyList();
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public MethodRegistry prepend(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
            return new Default(ByteBuddyCommons.join(new Entry(latentMethodMatcher, instrumentation, attributeAppenderFactory), this.entries));
        }

        @Override
        public MethodRegistry append(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
            return new Default(ByteBuddyCommons.join(this.entries, new Entry(latentMethodMatcher, instrumentation, attributeAppenderFactory)));
        }

        @Override
        public net.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared prepare(InstrumentedType instrumentedType) {
            LinkedList<Entry> additionalEntries = new LinkedList<Entry>();
            HashSet<Instrumentation> instrumentations = new HashSet<Instrumentation>(this.entries.size());
            for (Entry entry : this.entries) {
                if (!instrumentations.add(entry.getInstrumentation())) continue;
                MethodList beforePreparation = instrumentedType.getDeclaredMethods();
                instrumentedType = entry.getInstrumentation().prepare(instrumentedType);
                if (beforePreparation.size() >= instrumentedType.getDeclaredMethods().size()) continue;
                additionalEntries.add(new Entry(new ListDifferenceMethodMatcher(beforePreparation, instrumentedType.getDeclaredMethods()), entry.getInstrumentation(), MethodAttributeAppender.NoOp.INSTANCE));
            }
            return new Prepared(instrumentedType.detach(), instrumentedType.getLoadedTypeInitializer(), instrumentedType.getTypeInitializer(), this.entries, additionalEntries);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Default)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "MethodRegistry.Default{entries=" + this.entries + '}';
        }

        protected static class Entry {
            private final LatentMethodMatcher latentMethodMatcher;
            private final Instrumentation instrumentation;
            private final MethodAttributeAppender.Factory attributeAppenderFactory;

            protected Entry(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
                this.latentMethodMatcher = latentMethodMatcher;
                this.instrumentation = instrumentation;
                this.attributeAppenderFactory = attributeAppenderFactory;
            }

            public LatentMethodMatcher getLatentMethodMatcher() {
                return this.latentMethodMatcher;
            }

            public Instrumentation getInstrumentation() {
                return this.instrumentation;
            }

            public MethodAttributeAppender.Factory getAttributeAppenderFactory() {
                return this.attributeAppenderFactory;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.attributeAppenderFactory.equals(entry.attributeAppenderFactory) && this.instrumentation.equals(entry.instrumentation) && this.latentMethodMatcher.equals(entry.latentMethodMatcher);
            }

            public int hashCode() {
                int result = this.latentMethodMatcher.hashCode();
                result = 31 * result + this.instrumentation.hashCode();
                result = 31 * result + this.attributeAppenderFactory.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Entry{latentMethodMatcher=" + this.latentMethodMatcher + ", instrumentation=" + this.instrumentation + ", attributeAppenderFactory=" + this.attributeAppenderFactory + '}';
            }
        }

        protected static class ListDifferenceMethodMatcher
        implements ElementMatcher<MethodDescription>,
        LatentMethodMatcher {
            private final MethodList matchedMethods;

            protected ListDifferenceMethodMatcher(MethodList beforeMethods, MethodList afterMethods) {
                this.matchedMethods = (MethodList)afterMethods.subList(beforeMethods.size(), afterMethods.size());
            }

            @Override
            public boolean matches(MethodDescription methodDescription) {
                return ((MethodList)this.matchedMethods.filter(ElementMatchers.is(methodDescription))).size() == 1;
            }

            @Override
            public ElementMatcher<? super MethodDescription> manifest(TypeDescription typeDescription) {
                return this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.matchedMethods.equals(((ListDifferenceMethodMatcher)other).matchedMethods);
            }

            public int hashCode() {
                return this.matchedMethods.hashCode();
            }

            public String toString() {
                return "oneOf(" + this.matchedMethods + ')';
            }
        }

        protected static class Compiled
        implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final InstrumentedType.TypeInitializer typeInitializer;
            private final MethodList invokableMethods;
            private final List<Entry> entries;
            private final TypeWriter.MethodPool.Entry fallback;

            protected Compiled(TypeDescription instrumentedType, LoadedTypeInitializer loadedTypeInitializer, InstrumentedType.TypeInitializer typeInitializer, MethodList invokableMethods, List<Entry> entries, TypeWriter.MethodPool.Entry fallback) {
                this.instrumentedType = instrumentedType;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.invokableMethods = invokableMethods;
                this.entries = entries;
                this.fallback = fallback;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public InstrumentedType.TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList getInvokableMethods() {
                return this.invokableMethods;
            }

            @Override
            public TypeWriter.MethodPool.Entry target(MethodDescription methodDescription) {
                for (Entry entry : this.entries) {
                    if (!entry.matches(methodDescription)) continue;
                    return entry;
                }
                return this.fallback;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Compiled compiled = (Compiled)other;
                return this.entries.equals(compiled.entries) && this.fallback.equals(compiled.fallback) && this.instrumentedType.equals(compiled.instrumentedType) && this.invokableMethods.equals(compiled.invokableMethods) && this.loadedTypeInitializer.equals(compiled.loadedTypeInitializer) && this.typeInitializer.equals(compiled.typeInitializer);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.loadedTypeInitializer.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.invokableMethods.hashCode();
                result = 31 * result + this.entries.hashCode();
                result = 31 * result + this.fallback.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Compiled{instrumentedType=" + this.instrumentedType + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", invokableMethods=" + this.invokableMethods + ", entries=" + this.entries + ", fallback=" + this.fallback + '}';
            }

            protected static class Entry
            extends TypeWriter.MethodPool.Entry.Simple
            implements ElementMatcher<MethodDescription> {
                private final ElementMatcher<? super MethodDescription> methodMatcher;

                protected Entry(ElementMatcher<? super MethodDescription> methodMatcher, ByteCodeAppender byteCodeAppender, MethodAttributeAppender attributeAppender) {
                    super(byteCodeAppender, attributeAppender);
                    this.methodMatcher = methodMatcher;
                }

                @Override
                public boolean matches(MethodDescription methodDescription) {
                    return this.methodMatcher.matches(methodDescription);
                }

                @Override
                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.methodMatcher.equals(((Entry)other).methodMatcher);
                }

                @Override
                public int hashCode() {
                    return 31 * super.hashCode() + this.methodMatcher.hashCode();
                }

                @Override
                public String toString() {
                    return "MethodRegistry.Default.Compiled.Entry{methodMatcher=" + this.methodMatcher + ", byteCodeAppender=" + this.getByteCodeAppender() + ", attributeAppender=" + this.getAttributeAppender() + '}';
                }
            }
        }

        protected static class Prepared
        implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared {
            private static final int AT_BEGINNING = 0;
            private final TypeDescription instrumentedType;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final InstrumentedType.TypeInitializer typeInitializer;
            private final List<Entry> entries;
            private final List<Entry> additionalEntries;

            protected Prepared(TypeDescription instrumentedType, LoadedTypeInitializer loadedTypeInitializer, InstrumentedType.TypeInitializer typeInitializer, List<Entry> entries, List<Entry> additionalEntries) {
                this.instrumentedType = instrumentedType;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.entries = entries;
                this.additionalEntries = additionalEntries;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled compile(Instrumentation.Target.Factory instrumentationTargetFactory, MethodLookupEngine methodLookupEngine, TypeWriter.MethodPool.Entry.Factory fallback) {
                MethodLookupEngine.Finding finding = methodLookupEngine.process(this.instrumentedType);
                Instrumentation.Target instrumentationTarget = instrumentationTargetFactory.make(finding);
                HashMap<Instrumentation, ByteCodeAppender> byteCodeAppenders = new HashMap<Instrumentation, ByteCodeAppender>(this.entries.size());
                LinkedList<Compiled.Entry> compiledEntries = new LinkedList<Compiled.Entry>();
                for (Entry entry : this.entries) {
                    if (!byteCodeAppenders.containsKey(entry.getInstrumentation())) {
                        byteCodeAppenders.put(entry.getInstrumentation(), entry.getInstrumentation().appender(instrumentationTarget));
                    }
                    compiledEntries.add(new Compiled.Entry(entry.getLatentMethodMatcher().manifest(instrumentationTarget.getTypeDescription()), (ByteCodeAppender)byteCodeAppenders.get(entry.getInstrumentation()), entry.getAttributeAppenderFactory().make(instrumentationTarget.getTypeDescription())));
                }
                for (Entry entry : this.additionalEntries) {
                    compiledEntries.add(0, new Compiled.Entry(entry.getLatentMethodMatcher().manifest(instrumentationTarget.getTypeDescription()), (ByteCodeAppender)byteCodeAppenders.get(entry.getInstrumentation()), entry.getAttributeAppenderFactory().make(instrumentationTarget.getTypeDescription())));
                }
                return new Compiled(this.instrumentedType, this.loadedTypeInitializer, this.typeInitializer, finding.getInvokableMethods(), new ArrayList<Compiled.Entry>(compiledEntries), fallback.compile(instrumentationTarget));
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Prepared prepared = (Prepared)other;
                return this.additionalEntries.equals(prepared.additionalEntries) && this.entries.equals(prepared.entries) && this.instrumentedType.equals(prepared.instrumentedType) && this.loadedTypeInitializer.equals(prepared.loadedTypeInitializer) && this.typeInitializer.equals(prepared.typeInitializer);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.loadedTypeInitializer.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.entries.hashCode();
                result = 31 * result + this.additionalEntries.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Prepared{instrumentedType=" + this.instrumentedType + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", entries=" + this.entries + ", additionalEntries=" + this.additionalEntries + '}';
            }
        }
    }

    public static interface LatentMethodMatcher {
        public ElementMatcher<? super MethodDescription> manifest(TypeDescription var1);

        public static class Simple
        implements LatentMethodMatcher {
            private final ElementMatcher<? super MethodDescription> methodMatcher;

            public Simple(ElementMatcher<? super MethodDescription> methodMatcher) {
                this.methodMatcher = methodMatcher;
            }

            @Override
            public ElementMatcher<? super MethodDescription> manifest(TypeDescription instrumentedType) {
                return this.methodMatcher;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodMatcher.equals(((Simple)other).methodMatcher);
            }

            public int hashCode() {
                return this.methodMatcher.hashCode();
            }

            public String toString() {
                return "MethodRegistry.LatentMethodMatcher.Simple{methodMatcher=" + this.methodMatcher + '}';
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.MethodPool {
        public TypeDescription getInstrumentedType();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public InstrumentedType.TypeInitializer getTypeInitializer();

        public MethodList getInvokableMethods();
    }

    public static interface Prepared {
        public TypeDescription getInstrumentedType();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public Compiled compile(Instrumentation.Target.Factory var1, MethodLookupEngine var2, TypeWriter.MethodPool.Entry.Factory var3);
    }
}

