/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;

public class Forwarding
implements Instrumentation {
    private static final String FIELD_PREFIX = "forwarding";
    protected final String fieldName;
    protected final TypeDescription fieldType;
    protected final PreparationHandler preparationHandler;

    protected Forwarding(String fieldName, TypeDescription fieldType, PreparationHandler preparationHandler) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.preparationHandler = preparationHandler;
    }

    public static Instrumentation to(Object delegate) {
        return Forwarding.to(delegate, String.format("%s$%d", FIELD_PREFIX, delegate.hashCode()));
    }

    public static Instrumentation to(Object delegate, String fieldName) {
        return new Forwarding(ByteBuddyCommons.isValidIdentifier(fieldName), new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(delegate).getClass()), new PreparationHandler.ForStaticInstance(delegate));
    }

    public static Instrumentation toStaticField(String fieldName, Class<?> fieldType) {
        return Forwarding.toStaticField(fieldName, new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(fieldType)));
    }

    public static Instrumentation toStaticField(String fieldName, TypeDescription fieldType) {
        return new Forwarding(ByteBuddyCommons.isValidIdentifier(fieldName), ByteBuddyCommons.nonVoid(fieldType), PreparationHandler.ForStaticField.INSTANCE);
    }

    public static Instrumentation toInstanceField(String fieldName, Class<?> fieldType) {
        return Forwarding.toInstanceField(fieldName, new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(fieldType)));
    }

    public static Instrumentation toInstanceField(String fieldName, TypeDescription fieldType) {
        return new Forwarding(ByteBuddyCommons.isValidIdentifier(fieldName), ByteBuddyCommons.nonNull(fieldType), PreparationHandler.ForInstanceField.INSTANCE);
    }

    @Override
    public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
        return new Appender(this.loadDelegate(instrumentationTarget.getTypeDescription()));
    }

    private StackManipulation loadDelegate(TypeDescription instrumentedType) {
        return new StackManipulation.Compound(this.preparationHandler.loadFieldOwner(), FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.preparationHandler.prepare(instrumentedType, this.fieldName, this.fieldType);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Forwarding that = (Forwarding)other;
        return this.fieldName.equals(that.fieldName) && this.fieldType.equals(that.fieldType) && this.preparationHandler.equals(that.preparationHandler);
    }

    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.fieldType.hashCode();
        result = 31 * result + this.preparationHandler.hashCode();
        return result;
    }

    public String toString() {
        return "Forwarding{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + ", preparationHandler=" + this.preparationHandler + '}';
    }

    protected class Appender
    implements ByteCodeAppender {
        private final StackManipulation delegateLoadingInstruction;

        private Appender(StackManipulation delegateLoadingInstruction) {
            this.delegateLoadingInstruction = delegateLoadingInstruction;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            if (!instrumentedMethod.getDeclaringType().isAssignableFrom(Forwarding.this.fieldType)) {
                throw new IllegalArgumentException("Cannot forward " + instrumentedMethod + " to " + Forwarding.this.fieldType);
            }
            if (instrumentedMethod.isStatic()) {
                throw new IllegalArgumentException("Cannot forward the static method " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(this.delegateLoadingInstruction, MethodVariableAccess.loadArguments(instrumentedMethod), MethodInvocation.invoke(instrumentedMethod).virtual(Forwarding.this.fieldType), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.delegateLoadingInstruction.equals(((Appender)other).delegateLoadingInstruction) && Forwarding.this.equals(((Appender)other).getForwarding());
        }

        private Forwarding getForwarding() {
            return Forwarding.this;
        }

        public int hashCode() {
            return Forwarding.this.hashCode() + 31 * this.delegateLoadingInstruction.hashCode();
        }

        public String toString() {
            return "Forwarding.Appender{delegateLoadingInstruction=" + this.delegateLoadingInstruction + '}';
        }
    }

    protected static interface PreparationHandler {
        public InstrumentedType prepare(InstrumentedType var1, String var2, TypeDescription var3);

        public StackManipulation loadFieldOwner();

        public static class ForStaticInstance
        implements PreparationHandler {
            private final Object target;

            public ForStaticInstance(Object target) {
                this.target = target;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType, String fieldName, TypeDescription fieldType) {
                return instrumentedType.withField(fieldName, fieldType, 10).withInitializer(new LoadedTypeInitializer.ForStaticField<Object>(fieldName, this.target, true));
            }

            @Override
            public StackManipulation loadFieldOwner() {
                return StackManipulation.LegalTrivial.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.target.equals(((ForStaticInstance)other).target);
            }

            public int hashCode() {
                return this.target.hashCode();
            }

            public String toString() {
                return "Forwarding.PreparationHandler.ForStaticInstance{target=" + this.target + '}';
            }
        }

        public static enum ForStaticField implements PreparationHandler
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType, String fieldName, TypeDescription fieldType) {
                return instrumentedType.withField(fieldName, fieldType, 10);
            }

            @Override
            public StackManipulation loadFieldOwner() {
                return StackManipulation.LegalTrivial.INSTANCE;
            }
        }

        public static enum ForInstanceField implements PreparationHandler
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType, String fieldName, TypeDescription fieldType) {
                return instrumentedType.withField(fieldName, fieldType, 2);
            }

            @Override
            public StackManipulation loadFieldOwner() {
                return MethodVariableAccess.REFERENCE.loadFromIndex(0);
            }
        }
    }
}

