/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

public interface ModifierReviewable {
    public boolean isFinal();

    public boolean isStatic();

    public boolean isPublic();

    public boolean isProtected();

    public boolean isPackagePrivate();

    public boolean isPrivate();

    public boolean isAbstract();

    public boolean isNative();

    public boolean isSynchronized();

    public boolean isStrict();

    public boolean isSynthetic();

    public boolean isMandated();

    public boolean isSuper();

    public boolean isBridge();

    public boolean isDeprecated();

    public boolean isAnnotation();

    public boolean isEnum();

    public boolean isInterface();

    public boolean isTransient();

    public boolean isVolatile();

    public boolean isVarArgs();

    public int getModifiers();

    public static abstract class AbstractModifierReviewable
    implements ModifierReviewable {
        @Override
        public boolean isAbstract() {
            return this.matchesMask(1024);
        }

        @Override
        public boolean isFinal() {
            return this.matchesMask(16);
        }

        @Override
        public boolean isStatic() {
            return this.matchesMask(8);
        }

        @Override
        public boolean isPublic() {
            return this.matchesMask(1);
        }

        @Override
        public boolean isProtected() {
            return this.matchesMask(4);
        }

        @Override
        public boolean isPackagePrivate() {
            return !this.isPublic() && !this.isProtected() && !this.isPrivate();
        }

        @Override
        public boolean isPrivate() {
            return this.matchesMask(2);
        }

        @Override
        public boolean isNative() {
            return this.matchesMask(256);
        }

        @Override
        public boolean isSynchronized() {
            return this.matchesMask(32);
        }

        @Override
        public boolean isStrict() {
            return this.matchesMask(2048);
        }

        @Override
        public boolean isMandated() {
            return this.matchesMask(32768);
        }

        @Override
        public boolean isSynthetic() {
            return this.matchesMask(4096);
        }

        @Override
        public boolean isSuper() {
            return this.matchesMask(32);
        }

        @Override
        public boolean isBridge() {
            return this.matchesMask(64);
        }

        @Override
        public boolean isDeprecated() {
            return this.matchesMask(131072);
        }

        @Override
        public boolean isAnnotation() {
            return this.matchesMask(8192);
        }

        @Override
        public boolean isEnum() {
            return this.matchesMask(16384);
        }

        @Override
        public boolean isInterface() {
            return this.matchesMask(512);
        }

        @Override
        public boolean isTransient() {
            return this.matchesMask(128);
        }

        @Override
        public boolean isVolatile() {
            return this.matchesMask(64);
        }

        @Override
        public boolean isVarArgs() {
            return this.matchesMask(128);
        }

        private boolean matchesMask(int mask) {
            return (this.getModifiers() & mask) == mask;
        }
    }
}

