/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.Removal;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.ByteBuddyCommons;

public enum SuperMethodCall implements Instrumentation
{
    INSTANCE;


    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
        return new Appender(instrumentationTarget, Appender.TerminationHandler.RETURNING);
    }

    public Instrumentation andThen(Instrumentation instrumentation) {
        return new Instrumentation.Compound(WithoutReturn.INSTANCE, ByteBuddyCommons.nonNull(instrumentation));
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final Instrumentation.Target instrumentationTarget;
        private final TerminationHandler terminationHandler;

        protected Appender(Instrumentation.Target instrumentationTarget, TerminationHandler terminationHandler) {
            this.instrumentationTarget = instrumentationTarget;
            this.terminationHandler = terminationHandler;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            Instrumentation.SpecialMethodInvocation superMethodCall = this.instrumentationTarget.invokeSuper(instrumentedMethod, Instrumentation.Target.MethodLookup.Default.EXACT);
            if (!superMethodCall.isValid()) {
                throw new IllegalArgumentException("Cannot call super method of " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisReferenceAndArguments(instrumentedMethod), superMethodCall, this.terminationHandler.of(instrumentedMethod)).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.instrumentationTarget.equals(((Appender)other).instrumentationTarget) && this.terminationHandler.equals((Object)((Appender)other).terminationHandler);
        }

        public int hashCode() {
            return this.instrumentationTarget.hashCode() + 31 * this.terminationHandler.hashCode();
        }

        public String toString() {
            return "SuperMethodCall.Appender{instrumentationTarget=" + this.instrumentationTarget + ", terminationHandler=" + (Object)((Object)this.terminationHandler) + '}';
        }

        protected static enum TerminationHandler {
            RETURNING{

                @Override
                protected StackManipulation of(MethodDescription methodDescription) {
                    return MethodReturn.returning(methodDescription.getReturnType());
                }
            }
            ,
            DROPPING{

                @Override
                protected StackManipulation of(MethodDescription methodDescription) {
                    return Removal.pop(methodDescription.getReturnType());
                }
            };


            protected abstract StackManipulation of(MethodDescription var1);
        }
    }

    protected static enum WithoutReturn implements Instrumentation
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new Appender(instrumentationTarget, Appender.TerminationHandler.DROPPING);
        }
    }
}

