/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.ModifierContributor;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.modifier.Visibility;
import net.bytebuddy.utility.ByteBuddyCommons;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Pipe {
    public boolean serializableProxy() default false;

    public static class Binder
    implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe>,
    MethodLookupEngine.Factory,
    MethodLookupEngine {
        private final MethodDescription forwardingMethod;

        protected Binder(MethodDescription forwardingMethod) {
            this.forwardingMethod = forwardingMethod;
        }

        public static TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe> install(Class<?> type) {
            return Binder.install(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
        }

        public static TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe> install(TypeDescription typeDescription) {
            return new Binder(Binder.onlyMethod(ByteBuddyCommons.nonNull(typeDescription)));
        }

        private static MethodDescription onlyMethod(TypeDescription typeDescription) {
            if (!typeDescription.isInterface()) {
                throw new IllegalArgumentException(typeDescription + " is not an interface");
            }
            if (typeDescription.getInterfaces().size() > 0) {
                throw new IllegalArgumentException(typeDescription + " must not extend other interfaces");
            }
            if (!typeDescription.isPublic()) {
                throw new IllegalArgumentException(typeDescription + " is mot public");
            }
            MethodList methodCandidates = (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isStatic()));
            if (methodCandidates.size() != 1) {
                throw new IllegalArgumentException(typeDescription + " must declare exactly one non-static method");
            }
            MethodDescription methodDescription = (MethodDescription)methodCandidates.getOnly();
            if (!methodDescription.getReturnType().represents(Object.class)) {
                throw new IllegalArgumentException(methodDescription + " does not return an Object-type");
            }
            if (methodDescription.getParameterTypes().size() != 1 || !((TypeDescription)methodDescription.getParameterTypes().get(0)).represents(Object.class)) {
                throw new IllegalArgumentException(methodDescription + " does not take a single Object-typed argument");
            }
            return methodDescription;
        }

        @Override
        public Class<Pipe> getHandledType() {
            return Pipe.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Pipe> annotation, int targetParameterIndex, MethodDescription source, MethodDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            TypeDescription parameterType = (TypeDescription)target.getParameterTypes().get(targetParameterIndex);
            if (!parameterType.equals(this.forwardingMethod.getDeclaringType())) {
                throw new IllegalStateException(String.format("The installed type %s for the @Pipe annotation does not equal the annotated parameter type on %s", parameterType, target));
            }
            if (source.isStatic()) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(new Redirection(this.forwardingMethod.getDeclaringType(), source, assigner, annotation.loadSilent().serializableProxy(), this));
        }

        @Override
        public MethodLookupEngine make(boolean extractDefaultMethods) {
            return this;
        }

        @Override
        public MethodLookupEngine.Finding process(TypeDescription typeDescription) {
            return new PrecomputedFinding(typeDescription);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.forwardingMethod.equals(((Binder)other).forwardingMethod);
        }

        public int hashCode() {
            return this.forwardingMethod.hashCode();
        }

        public String toString() {
            return "Pipe.Binder{forwardingMethod=" + this.forwardingMethod + '}';
        }

        protected class PrecomputedFinding
        implements MethodLookupEngine.Finding {
            private final TypeDescription typeDescription;

            public PrecomputedFinding(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public MethodList getInvokableMethods() {
                ArrayList<MethodDescription> invokableMethods = new ArrayList<MethodDescription>(2);
                invokableMethods.addAll(this.typeDescription.getDeclaredMethods());
                invokableMethods.add(Binder.this.forwardingMethod);
                return new MethodList.Explicit(invokableMethods);
            }

            @Override
            public Map<TypeDescription, Set<MethodDescription>> getInvokableDefaultMethods() {
                return Collections.emptyMap();
            }

            private Binder getBinder() {
                return Binder.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((PrecomputedFinding)other).typeDescription) && Binder.this.equals(((PrecomputedFinding)other).getBinder());
            }

            public int hashCode() {
                return this.typeDescription.hashCode() + 31 * Binder.this.hashCode();
            }

            public String toString() {
                return "Pipe.Binder.PrecomputedFinding{binder=" + Binder.this + ", typeDescription=" + this.typeDescription + '}';
            }
        }

        protected static class Redirection
        implements AuxiliaryType,
        StackManipulation {
            private static final String FIELD_NAME_PREFIX = "argument";
            private final TypeDescription forwardingType;
            private final MethodDescription sourceMethod;
            private final Assigner assigner;
            private final boolean serializableProxy;
            private final MethodLookupEngine.Factory methodLookupEngineFactory;

            protected Redirection(TypeDescription forwardingType, MethodDescription sourceMethod, Assigner assigner, boolean serializableProxy, MethodLookupEngine.Factory methodLookupEngineFactory) {
                this.forwardingType = forwardingType;
                this.sourceMethod = sourceMethod;
                this.assigner = assigner;
                this.serializableProxy = serializableProxy;
                this.methodLookupEngineFactory = methodLookupEngineFactory;
            }

            private static LinkedHashMap<String, TypeDescription> extractFields(MethodDescription methodDescription) {
                TypeList parameterTypes = methodDescription.getParameterTypes();
                LinkedHashMap<String, TypeDescription> typeDescriptions = new LinkedHashMap<String, TypeDescription>(parameterTypes.size());
                int currentIndex = 0;
                for (TypeDescription parameterType : parameterTypes) {
                    typeDescriptions.put(Redirection.fieldName(currentIndex++), parameterType);
                }
                return typeDescriptions;
            }

            private static String fieldName(int index) {
                return String.format("%s%d", FIELD_NAME_PREFIX, index);
            }

            @Override
            public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
                Class[] classArray;
                LinkedHashMap<String, TypeDescription> parameterFields = Redirection.extractFields(this.sourceMethod);
                DynamicType.Builder builder = new ByteBuddy(classFileVersion).subclass(this.forwardingType, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER).methodLookupEngine(this.methodLookupEngineFactory);
                if (this.serializableProxy) {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = Serializable.class;
                } else {
                    classArray = new Class[]{};
                }
                DynamicType.Builder builder2 = builder.implement(classArray).method(ElementMatchers.isDeclaredBy(this.forwardingType)).intercept(new MethodCall(this.sourceMethod, this.assigner)).defineConstructor((List<TypeDescription>)new ArrayList<TypeDescription>(parameterFields.values()), new ModifierContributor.ForMethod[0]).intercept(ConstructorCall.INSTANCE);
                for (Map.Entry<String, TypeDescription> field : parameterFields.entrySet()) {
                    builder2 = builder2.defineField(field.getKey(), field.getValue(), Visibility.PRIVATE);
                }
                return builder2.make();
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                TypeDescription forwardingType = instrumentationContext.register(this);
                return new StackManipulation.Compound(TypeCreation.forType(forwardingType), Duplication.SINGLE, MethodVariableAccess.loadArguments(this.sourceMethod), MethodInvocation.invoke((MethodDescription)((MethodList)forwardingType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly())).apply(methodVisitor, instrumentationContext);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Redirection that = (Redirection)other;
                return this.serializableProxy == that.serializableProxy && this.assigner.equals(that.assigner) && this.forwardingType.equals(that.forwardingType) && this.methodLookupEngineFactory.equals(that.methodLookupEngineFactory) && this.sourceMethod.equals(that.sourceMethod);
            }

            public int hashCode() {
                int result = this.forwardingType.hashCode();
                result = 31 * result + this.sourceMethod.hashCode();
                result = 31 * result + this.assigner.hashCode();
                result = 31 * result + this.methodLookupEngineFactory.hashCode();
                result = 31 * result + (this.serializableProxy ? 1 : 0);
                return result;
            }

            public String toString() {
                return "Pipe.Binder.Redirection{forwardingType=" + this.forwardingType + ", sourceMethod=" + this.sourceMethod + ", assigner=" + this.assigner + ", serializableProxy=" + this.serializableProxy + ", methodLookupEngineFactory=" + this.methodLookupEngineFactory + '}';
            }

            protected static class MethodCall
            implements Instrumentation {
                private final MethodDescription redirectedMethod;
                private final Assigner assigner;

                private MethodCall(MethodDescription redirectedMethod, Assigner assigner) {
                    this.redirectedMethod = redirectedMethod;
                    this.assigner = assigner;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
                    return new Appender(instrumentationTarget.getTypeDescription());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.redirectedMethod.equals(((MethodCall)other).redirectedMethod) && this.assigner.equals(((MethodCall)other).assigner);
                }

                public int hashCode() {
                    return this.redirectedMethod.hashCode() + 31 * this.assigner.hashCode();
                }

                public String toString() {
                    return "Pipe.Binder.Redirection.MethodCall{redirectedMethod=" + this.redirectedMethod + ", assigner=" + this.assigner + '}';
                }

                private class Appender
                implements ByteCodeAppender {
                    private final TypeDescription instrumentedType;

                    private Appender(TypeDescription instrumentedType) {
                        this.instrumentedType = instrumentedType;
                    }

                    @Override
                    public boolean appendsCode() {
                        return true;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                        StackManipulation thisReference = MethodVariableAccess.forType(this.instrumentedType).loadFromIndex(0);
                        FieldList fieldList = this.instrumentedType.getDeclaredFields();
                        StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                        int index = 0;
                        for (FieldDescription fieldDescription : fieldList) {
                            fieldLoading[index++] = new StackManipulation.Compound(thisReference, FieldAccess.forField(fieldDescription).getter());
                        }
                        StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFromIndex(1), MethodCall.this.assigner.assign(new TypeDescription.ForLoadedType(Object.class), MethodCall.this.redirectedMethod.getDeclaringType(), true), new StackManipulation.Compound(fieldLoading), MethodInvocation.invoke(MethodCall.this.redirectedMethod), MethodCall.this.assigner.assign(MethodCall.this.redirectedMethod.getReturnType(), instrumentedMethod.getReturnType(), true), MethodReturn.REFERENCE).apply(methodVisitor, instrumentationContext);
                        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    private MethodCall getMethodCall() {
                        return MethodCall.this;
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && MethodCall.this.equals(((Appender)other).getMethodCall());
                    }

                    public int hashCode() {
                        return 31 * MethodCall.this.hashCode() + this.instrumentedType.hashCode();
                    }

                    public String toString() {
                        return "Pipe.Binder.Redirection.MethodCall.Appender{methodCall=" + MethodCall.this + ", instrumentedType=" + this.instrumentedType + '}';
                    }
                }
            }

            protected static enum ConstructorCall implements Instrumentation
            {
                INSTANCE;

                private final MethodDescription objectTypeDefaultConstructor = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Object.class).getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
                    return new Appender(instrumentationTarget.getTypeDescription());
                }

                private static class Appender
                implements ByteCodeAppender {
                    private final TypeDescription instrumentedType;

                    private Appender(TypeDescription instrumentedType) {
                        this.instrumentedType = instrumentedType;
                    }

                    @Override
                    public boolean appendsCode() {
                        return true;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                        StackManipulation thisReference = MethodVariableAccess.forType(instrumentedMethod.getDeclaringType()).loadFromIndex(0);
                        FieldList fieldList = this.instrumentedType.getDeclaredFields();
                        StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                        int index = 0;
                        for (FieldDescription fieldDescription : fieldList) {
                            fieldLoading[index] = new StackManipulation.Compound(thisReference, MethodVariableAccess.forType(fieldDescription.getFieldType()).loadFromIndex(instrumentedMethod.getParameterOffset(index)), FieldAccess.forField(fieldDescription).putter());
                            ++index;
                        }
                        StackManipulation.Size stackSize = new StackManipulation.Compound(thisReference, MethodInvocation.invoke(INSTANCE.objectTypeDefaultConstructor), new StackManipulation.Compound(fieldLoading), MethodReturn.VOID).apply(methodVisitor, instrumentationContext);
                        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType);
                    }

                    public int hashCode() {
                        return this.instrumentedType.hashCode();
                    }

                    public String toString() {
                        return "Pipe.Binder.Redirection.ConstructorCall.Appender{instrumentedType=" + this.instrumentedType + '}';
                    }
                }
            }
        }
    }
}

