/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive;

import net.bytebuddy.instrumentation.method.bytecode.stack.Removal;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.DefaultValue;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class VoidAwareAssigner
implements Assigner {
    private final Assigner chained;

    public VoidAwareAssigner(Assigner chained) {
        this.chained = chained;
    }

    @Override
    public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, boolean dynamicallyTyped) {
        if (sourceType.represents(Void.TYPE) && targetType.represents(Void.TYPE)) {
            return StackManipulation.LegalTrivial.INSTANCE;
        }
        if (sourceType.represents(Void.TYPE)) {
            return dynamicallyTyped ? DefaultValue.of(targetType) : StackManipulation.Illegal.INSTANCE;
        }
        if (targetType.represents(Void.TYPE)) {
            return Removal.pop(sourceType);
        }
        return this.chained.assign(sourceType, targetType, dynamicallyTyped);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.chained.equals(((VoidAwareAssigner)other).chained);
    }

    public int hashCode() {
        return this.chained.hashCode();
    }

    public String toString() {
        return "VoidAwareAssigner{chained=" + this.chained + '}';
    }
}

