/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public class DownCasting
implements StackManipulation {
    private final String targetTypeInternalName;

    public DownCasting(TypeDescription targetType) {
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast to primitive type " + targetType);
        }
        this.targetTypeInternalName = targetType.getInternalName();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
        methodVisitor.visitTypeInsn(192, this.targetTypeInternalName);
        return StackSize.ZERO.toIncreasingSize();
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.targetTypeInternalName.equals(((DownCasting)other).targetTypeInternalName);
    }

    public int hashCode() {
        return this.targetTypeInternalName.hashCode();
    }

    public String toString() {
        return "DownCasting{targetTypeInternalName='" + this.targetTypeInternalName + '\'' + '}';
    }
}

