/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.type;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.instrumentation.ByteCodeElement;
import net.bytebuddy.instrumentation.ModifierReviewable;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.type.PackageDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface TypeDescription
extends ByteCodeElement {
    public boolean isInstance(Object var1);

    public boolean isAssignableFrom(Class<?> var1);

    public boolean isAssignableFrom(TypeDescription var1);

    public boolean isAssignableTo(Class<?> var1);

    public boolean isAssignableTo(TypeDescription var1);

    public boolean represents(Class<?> var1);

    public boolean isArray();

    public TypeDescription getComponentType();

    public boolean isPrimitive();

    public TypeDescription getSupertype();

    public TypeList getInterfaces();

    public TypeList getInheritedInterfaces();

    public MethodDescription getEnclosingMethod();

    public TypeDescription getEnclosingType();

    public int getActualModifiers(boolean var1);

    public String getSimpleName();

    public String getCanonicalName();

    @Override
    public String getGenericSignature();

    public boolean isAnonymousClass();

    public boolean isLocalClass();

    public boolean isMemberClass();

    public FieldList getDeclaredFields();

    public MethodList getDeclaredMethods();

    public PackageDescription getPackage();

    public StackSize getStackSize();

    public AnnotationList getInheritedAnnotations();

    public boolean isSamePackage(TypeDescription var1);

    public static class ArrayProjection
    extends AbstractTypeDescription {
        private static final int ARRAY_MODIFIERS = 1041;
        private final TypeDescription componentType;
        private final int arity;

        protected ArrayProjection(TypeDescription componentType, int arity) {
            this.componentType = componentType;
            this.arity = arity;
        }

        public static TypeDescription of(TypeDescription componentType, int arity) {
            if (arity < 0) {
                throw new IllegalArgumentException("Arrays cannot have a negative arity");
            }
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
                ++arity;
            }
            return arity == 0 ? componentType : new ArrayProjection(componentType, arity);
        }

        private static boolean isArrayAssignable(TypeDescription sourceType, TypeDescription targetType) {
            int sourceArity = 0;
            int targetArity = 0;
            while (sourceType.isArray()) {
                ++sourceArity;
                sourceType = sourceType.getComponentType();
            }
            while (targetType.isArray()) {
                ++targetArity;
                targetType = targetType.getComponentType();
            }
            return sourceArity == targetArity && sourceType.isAssignableFrom(targetType);
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.isAssignableFrom(new ForLoadedType(type));
        }

        @Override
        public boolean isAssignableFrom(TypeDescription typeDescription) {
            return ArrayProjection.isArrayAssignable(this, typeDescription);
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            return this.isAssignableTo(new ForLoadedType(type));
        }

        @Override
        public boolean isAssignableTo(TypeDescription typeDescription) {
            return typeDescription.represents(Object.class) || ArrayProjection.isArrayAssignable(typeDescription, this);
        }

        @Override
        public boolean represents(Class<?> type) {
            int arity = 0;
            while (type.isArray()) {
                type = type.getComponentType();
                ++arity;
            }
            return arity == this.arity && this.componentType.represents(type);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public TypeDescription getComponentType() {
            return this.arity == 1 ? this.componentType : new ArrayProjection(this.componentType, this.arity - 1);
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public TypeDescription getSupertype() {
            return new ForLoadedType(Object.class);
        }

        @Override
        public TypeList getInterfaces() {
            return new TypeList.ForLoadedType(Cloneable.class, Serializable.class);
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return null;
        }

        @Override
        public TypeDescription getEnclosingType() {
            return null;
        }

        @Override
        public String getSimpleName() {
            StringBuilder stringBuilder = new StringBuilder(this.componentType.getSimpleName());
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }

        @Override
        public String getCanonicalName() {
            StringBuilder stringBuilder = new StringBuilder(this.componentType.getCanonicalName());
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean isAnonymousClass() {
            return false;
        }

        @Override
        public boolean isLocalClass() {
            return false;
        }

        @Override
        public boolean isMemberClass() {
            return false;
        }

        @Override
        public FieldList getDeclaredFields() {
            return new FieldList.Empty();
        }

        @Override
        public MethodList getDeclaredMethods() {
            return new MethodList.Empty();
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.SINGLE;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public AnnotationList getInheritedAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public PackageDescription getPackage() {
            return null;
        }

        @Override
        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append('[');
            }
            return stringBuilder.append(this.componentType.getDescriptor().replace('/', '.')).toString();
        }

        @Override
        public String getDescriptor() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append('[');
            }
            return stringBuilder.append(this.componentType.getDescriptor()).toString();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return null;
        }

        @Override
        public int getModifiers() {
            return 1041;
        }
    }

    public static class ForLoadedType
    extends AbstractTypeDescription {
        private final Class<?> type;

        public ForLoadedType(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean isInstance(Object object) {
            return this.type.isInstance(object);
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.type.isAssignableFrom(type);
        }

        @Override
        public boolean isAssignableFrom(TypeDescription typeDescription) {
            return typeDescription.isAssignableTo(this.type);
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            return type.isAssignableFrom(this.type);
        }

        @Override
        public boolean isAssignableTo(TypeDescription typeDescription) {
            return typeDescription.isAssignableFrom(this.type);
        }

        @Override
        public boolean represents(Class<?> type) {
            return type == this.type;
        }

        @Override
        public boolean isInterface() {
            return this.type.isInterface();
        }

        @Override
        public boolean isArray() {
            return this.type.isArray();
        }

        @Override
        public TypeDescription getComponentType() {
            return this.type.getComponentType() == null ? null : new ForLoadedType(this.type.getComponentType());
        }

        @Override
        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        @Override
        public boolean isAnnotation() {
            return this.type.isAnnotation();
        }

        @Override
        public TypeDescription getSupertype() {
            return this.type.getSuperclass() == null ? null : new ForLoadedType(this.type.getSuperclass());
        }

        @Override
        public TypeList getInterfaces() {
            return this.type.isArray() ? new TypeList.ForLoadedType(Cloneable.class, Serializable.class) : new TypeList.ForLoadedType(this.type.getInterfaces());
        }

        @Override
        public TypeDescription getDeclaringType() {
            Class<?> declaringType = this.type.getDeclaringClass();
            return declaringType == null ? null : new ForLoadedType(declaringType);
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            Method enclosingMethod = this.type.getEnclosingMethod();
            Constructor<?> enclosingConstructor = this.type.getEnclosingConstructor();
            if (enclosingMethod != null) {
                return new MethodDescription.ForLoadedMethod(enclosingMethod);
            }
            if (enclosingConstructor != null) {
                return new MethodDescription.ForLoadedConstructor(enclosingConstructor);
            }
            return null;
        }

        @Override
        public TypeDescription getEnclosingType() {
            Class<?> enclosingType = this.type.getEnclosingClass();
            return enclosingType == null ? null : new ForLoadedType(enclosingType);
        }

        @Override
        public String getSimpleName() {
            return this.type.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.type.getCanonicalName();
        }

        @Override
        public boolean isAnonymousClass() {
            return this.type.isAnonymousClass();
        }

        @Override
        public boolean isLocalClass() {
            return this.type.isLocalClass();
        }

        @Override
        public boolean isMemberClass() {
            return this.type.isMemberClass();
        }

        @Override
        public FieldList getDeclaredFields() {
            return new FieldList.ForLoadedField(this.type.getDeclaredFields());
        }

        @Override
        public MethodList getDeclaredMethods() {
            return new MethodList.ForLoadedType(this.type);
        }

        @Override
        public PackageDescription getPackage() {
            Package aPackage = this.type.getPackage();
            return aPackage == null ? null : new PackageDescription.ForLoadedPackage(aPackage);
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.of(this.type);
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        public String getDescriptor() {
            return Type.getDescriptor(this.type);
        }

        @Override
        public int getModifiers() {
            return this.type.getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.type.getDeclaredAnnotations());
        }

        @Override
        public AnnotationList getInheritedAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.type.getAnnotations());
        }
    }

    public static abstract class AbstractTypeDescription
    extends ModifierReviewable.AbstractModifierReviewable
    implements TypeDescription {
        private static void collect(TypeDescription typeDescription, Set<TypeDescription> interfaces) {
            if (interfaces.add(typeDescription)) {
                for (TypeDescription interfaceType : typeDescription.getInterfaces()) {
                    AbstractTypeDescription.collect(interfaceType, interfaces);
                }
            }
        }

        @Override
        public boolean isInstance(Object object) {
            return this.isAssignableFrom(object.getClass());
        }

        @Override
        public String getInternalName() {
            return this.getName().replace('.', '/');
        }

        @Override
        public int getActualModifiers(boolean superFlag) {
            int actualModifiers = this.isPrivate() ? this.getModifiers() & 0xFFFFFFF5 : (this.isProtected() ? this.getModifiers() & 0xFFFFFFF3 | 1 : this.getModifiers() & 0xFFFFFFF7);
            return superFlag ? actualModifiers | 0x20 : actualModifiers;
        }

        @Override
        public String getGenericSignature() {
            return null;
        }

        @Override
        public boolean isSamePackage(TypeDescription typeDescription) {
            PackageDescription thisPackage = this.getPackage();
            PackageDescription otherPackage = typeDescription.getPackage();
            return thisPackage == null || otherPackage == null ? thisPackage == otherPackage : thisPackage.equals(otherPackage);
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.isPublic() || this.isProtected() || this.isSamePackage(typeDescription);
        }

        @Override
        public TypeList getInheritedInterfaces() {
            HashSet<TypeDescription> interfaces = new HashSet<TypeDescription>();
            TypeDescription current = this;
            do {
                for (TypeDescription interfaceType : current.getInterfaces()) {
                    AbstractTypeDescription.collect(interfaceType, interfaces);
                }
            } while ((current = current.getSupertype()) != null);
            return new TypeList.Explicit(new ArrayList<TypeDescription>(interfaces));
        }

        @Override
        public AnnotationList getInheritedAnnotations() {
            AnnotationList declaredAnnotations = this.getDeclaredAnnotations();
            if (this.getSupertype() == null) {
                return declaredAnnotations;
            }
            HashSet<TypeDescription> annotationTypes = new HashSet<TypeDescription>(declaredAnnotations.size());
            for (AnnotationDescription annotationDescription : declaredAnnotations) {
                annotationTypes.add(annotationDescription.getAnnotationType());
            }
            return new AnnotationList.Explicit(ByteBuddyCommons.join(declaredAnnotations, this.getSupertype().getInheritedAnnotations().inherited(annotationTypes)));
        }

        @Override
        public String getSourceCodeName() {
            if (this.isArray()) {
                TypeDescription typeDescription = this;
                int dimensions = 0;
                do {
                    ++dimensions;
                } while ((typeDescription = typeDescription.getComponentType()).isArray());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(typeDescription.getSourceCodeName());
                for (int i = 0; i < dimensions; ++i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            return this.getName();
        }

        protected String getPackageName() {
            String name = this.getName();
            int packageIndex = name.lastIndexOf(46);
            return packageIndex == -1 ? null : name.substring(0, packageIndex);
        }

        public boolean equals(Object other) {
            return other == this || other instanceof TypeDescription && this.getName().equals(((TypeDescription)other).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return (this.isPrimitive() ? "" : (this.isInterface() ? "interface" : "class") + " ") + this.getName();
        }

        public static abstract class OfSimpleType
        extends AbstractTypeDescription {
            private static boolean isAssignable(TypeDescription sourceType, TypeDescription targetType) {
                if (sourceType.equals(targetType)) {
                    return true;
                }
                if (sourceType.represents(Object.class) && !targetType.isPrimitive()) {
                    return true;
                }
                TypeDescription targetTypeSuperType = targetType.getSupertype();
                if (targetTypeSuperType != null && targetTypeSuperType.isAssignableTo(sourceType)) {
                    return true;
                }
                if (sourceType.isInterface()) {
                    for (TypeDescription interfaceType : targetType.getInterfaces()) {
                        if (!interfaceType.isAssignableTo(sourceType)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean isAssignableFrom(Class<?> type) {
                return this.isAssignableFrom(new ForLoadedType(type));
            }

            @Override
            public boolean isAssignableFrom(TypeDescription typeDescription) {
                return OfSimpleType.isAssignable(this, typeDescription);
            }

            @Override
            public boolean isAssignableTo(Class<?> type) {
                return this.isAssignableTo(new ForLoadedType(type));
            }

            @Override
            public boolean isAssignableTo(TypeDescription typeDescription) {
                return OfSimpleType.isAssignable(typeDescription, this);
            }

            @Override
            public boolean isInstance(Object object) {
                return this.isAssignableFrom(object.getClass());
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public TypeDescription getComponentType() {
                return null;
            }

            @Override
            public boolean represents(Class<?> type) {
                return type.getName().equals(this.getName());
            }

            @Override
            public String getDescriptor() {
                return "L" + this.getInternalName() + ";";
            }

            @Override
            public String getSimpleName() {
                int simpleNameIndex = this.getInternalName().lastIndexOf(36);
                simpleNameIndex = simpleNameIndex == -1 ? this.getInternalName().lastIndexOf(47) : simpleNameIndex;
                return simpleNameIndex == -1 ? this.getInternalName() : this.getInternalName().substring(simpleNameIndex + 1);
            }

            @Override
            public StackSize getStackSize() {
                return StackSize.SINGLE;
            }
        }
    }
}

