/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.type.auxiliary;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.Throw;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.DefaultValue;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.modifier.Ownership;

public class TypeProxy
implements AuxiliaryType,
MethodLookupEngine.Factory {
    public static final String REFLECTION_METHOD = "make";
    public static final String INSTANCE_FIELD = "target";
    private final TypeDescription proxiedType;
    private final Instrumentation.Target instrumentationTarget;
    private final InvocationFactory invocationFactory;
    private final boolean ignoreFinalizer;
    private final boolean serializableProxy;

    public TypeProxy(TypeDescription proxiedType, Instrumentation.Target instrumentationTarget, InvocationFactory invocationFactory, boolean ignoreFinalizer, boolean serializableProxy) {
        this.proxiedType = proxiedType;
        this.instrumentationTarget = instrumentationTarget;
        this.invocationFactory = invocationFactory;
        this.ignoreFinalizer = ignoreFinalizer;
        this.serializableProxy = serializableProxy;
    }

    @Override
    public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
        Class[] classArray;
        DynamicType.Builder builder = new ByteBuddy(classFileVersion).withIgnoredMethods(this.ignoreFinalizer ? ElementMatchers.isFinalizer() : ElementMatchers.none()).subclass(this.proxiedType).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER).methodLookupEngine(this);
        if (this.serializableProxy) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Serializable.class;
        } else {
            classArray = new Class[]{};
        }
        return builder.implement(classArray).method(ElementMatchers.any()).intercept(new MethodCall(methodAccessorFactory)).defineMethod(REFLECTION_METHOD, TargetType.DESCRIPTION, Collections.emptyList(), Ownership.STATIC).intercept(SilentConstruction.INSTANCE).make();
    }

    @Override
    public MethodLookupEngine make(boolean extractDefaultMethods) {
        return MethodLookupEngine.Default.Factory.INSTANCE.make(false);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TypeProxy typeProxy = (TypeProxy)other;
        return this.ignoreFinalizer == typeProxy.ignoreFinalizer && this.serializableProxy == typeProxy.serializableProxy && this.instrumentationTarget.equals(typeProxy.instrumentationTarget) && this.invocationFactory.equals(typeProxy.invocationFactory) && this.proxiedType.equals(typeProxy.proxiedType);
    }

    public int hashCode() {
        int result = this.proxiedType.hashCode();
        result = 31 * result + this.instrumentationTarget.hashCode();
        result = 31 * result + this.invocationFactory.hashCode();
        result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
        result = 31 * result + (this.serializableProxy ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TypeProxy{proxiedType=" + this.proxiedType + ", instrumentationTarget=" + this.instrumentationTarget + ", invocationFactory=" + this.invocationFactory + ", ignoreFinalizer=" + this.ignoreFinalizer + ", serializableProxy=" + this.serializableProxy + '}';
    }

    protected class MethodCall
    implements Instrumentation {
        private final AuxiliaryType.MethodAccessorFactory methodAccessorFactory;

        protected MethodCall(AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
            this.methodAccessorFactory = methodAccessorFactory;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(TypeProxy.INSTANCE_FIELD, TypeProxy.this.instrumentationTarget.getTypeDescription(), 4096);
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new Appender(instrumentationTarget.getTypeDescription());
        }

        private TypeProxy getTypeProxy() {
            return TypeProxy.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodAccessorFactory.equals(((MethodCall)other).methodAccessorFactory) && TypeProxy.this.equals(((MethodCall)other).getTypeProxy());
        }

        public int hashCode() {
            return 31 * TypeProxy.this.hashCode() + this.methodAccessorFactory.hashCode();
        }

        public String toString() {
            return "TypeProxy.MethodCall{typeProxy=" + TypeProxy.this + "methodAccessorFactory=" + this.methodAccessorFactory + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final StackManipulation fieldLoadingInstruction;

            protected Appender(TypeDescription instrumentedType) {
                this.fieldLoadingInstruction = FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(TypeProxy.INSTANCE_FIELD))).getOnly()).getter();
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                StackManipulation.Size stackSize = this.implement(instrumentedMethod, TypeProxy.this.invocationFactory.invoke(TypeProxy.this.instrumentationTarget, TypeProxy.this.proxiedType, instrumentedMethod)).apply(methodVisitor, instrumentationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private StackManipulation implement(MethodDescription instrumentedMethod, Instrumentation.SpecialMethodInvocation specialMethodInvocation) {
                return specialMethodInvocation.isValid() ? new AccessorMethodInvocation(instrumentedMethod, specialMethodInvocation) : AbstractMethodErrorThrow.INSTANCE;
            }

            private MethodCall getMethodCall() {
                return MethodCall.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldLoadingInstruction.equals(((Appender)other).fieldLoadingInstruction) && MethodCall.this.equals(((Appender)other).getMethodCall());
            }

            public int hashCode() {
                return 31 * MethodCall.this.hashCode() + this.fieldLoadingInstruction.hashCode();
            }

            public String toString() {
                return "TypeProxy.MethodCall.Appender{methodCall=" + MethodCall.this + "fieldLoadingInstruction=" + this.fieldLoadingInstruction + '}';
            }

            protected class AccessorMethodInvocation
            implements StackManipulation {
                private final MethodDescription instrumentedMethod;
                private final Instrumentation.SpecialMethodInvocation specialMethodInvocation;

                protected AccessorMethodInvocation(MethodDescription instrumentedMethod, Instrumentation.SpecialMethodInvocation specialMethodInvocation) {
                    this.instrumentedMethod = instrumentedMethod;
                    this.specialMethodInvocation = specialMethodInvocation;
                }

                @Override
                public boolean isValid() {
                    return true;
                }

                @Override
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                    MethodDescription proxyMethod = MethodCall.this.methodAccessorFactory.registerAccessorFor(this.specialMethodInvocation);
                    return new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFromIndex(0), Appender.this.fieldLoadingInstruction, MethodVariableAccess.forBridgeMethodInvocation(this.instrumentedMethod, proxyMethod), MethodInvocation.invoke(proxyMethod), MethodReturn.returning(this.instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
                }

                private Appender getAppender() {
                    return Appender.this;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    AccessorMethodInvocation that = (AccessorMethodInvocation)other;
                    return Appender.this.equals(that.getAppender()) && this.instrumentedMethod.equals(that.instrumentedMethod) && this.specialMethodInvocation.equals(that.specialMethodInvocation);
                }

                public int hashCode() {
                    int result = Appender.this.hashCode();
                    result = 31 * result + this.instrumentedMethod.hashCode();
                    result = 31 * result + this.specialMethodInvocation.hashCode();
                    return result;
                }

                public String toString() {
                    return "TypeProxy.MethodCall.Appender.AccessorMethodInvocation{appender=" + Appender.this + ", instrumentedMethod=" + this.instrumentedMethod + ", specialMethodInvocation=" + this.specialMethodInvocation + '}';
                }
            }
        }
    }

    public static class ForDefaultMethod
    implements StackManipulation {
        private final TypeDescription proxiedType;
        private final Instrumentation.Target instrumentationTarget;
        private final boolean serializableProxy;

        public ForDefaultMethod(TypeDescription proxiedType, Instrumentation.Target instrumentationTarget, boolean serializableProxy) {
            this.proxiedType = proxiedType;
            this.instrumentationTarget = instrumentationTarget;
            this.serializableProxy = serializableProxy;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            TypeDescription proxyType = instrumentationContext.register(new TypeProxy(this.proxiedType, this.instrumentationTarget, InvocationFactory.Default.DEFAULT_METHOD, true, this.serializableProxy));
            return new StackManipulation.Compound(TypeCreation.forType(proxyType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription)((MethodList)proxyType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), Duplication.SINGLE, MethodVariableAccess.forType(this.instrumentationTarget.getTypeDescription()).loadFromIndex(0), FieldAccess.forField((FieldDescription)((FieldList)proxyType.getDeclaredFields().filter(ElementMatchers.named(TypeProxy.INSTANCE_FIELD))).getOnly()).putter()).apply(methodVisitor, instrumentationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForDefaultMethod that = (ForDefaultMethod)other;
            return this.serializableProxy == that.serializableProxy && this.instrumentationTarget.equals(that.instrumentationTarget) && this.proxiedType.equals(that.proxiedType);
        }

        public int hashCode() {
            int result = this.proxiedType.hashCode();
            result = 31 * result + this.instrumentationTarget.hashCode();
            result = 31 * result + (this.serializableProxy ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeProxy.ForDefaultMethod{proxiedType=" + this.proxiedType + ", instrumentationTarget=" + this.instrumentationTarget + ", serializableProxy=" + this.serializableProxy + '}';
        }
    }

    public static class ForSuperMethodByReflectionFactory
    implements StackManipulation {
        private final TypeDescription proxiedType;
        private final Instrumentation.Target instrumentationTarget;
        private final boolean ignoreFinalizer;
        private final boolean serializableProxy;

        public ForSuperMethodByReflectionFactory(TypeDescription proxiedType, Instrumentation.Target instrumentationTarget, boolean ignoreFinalizer, boolean serializableProxy) {
            this.proxiedType = proxiedType;
            this.instrumentationTarget = instrumentationTarget;
            this.ignoreFinalizer = ignoreFinalizer;
            this.serializableProxy = serializableProxy;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            TypeDescription proxyType = instrumentationContext.register(new TypeProxy(this.proxiedType, this.instrumentationTarget, InvocationFactory.Default.SUPER_METHOD, this.ignoreFinalizer, this.serializableProxy));
            return new StackManipulation.Compound(MethodInvocation.invoke((MethodDescription)((MethodList)proxyType.getDeclaredMethods().filter(ElementMatchers.named(TypeProxy.REFLECTION_METHOD).and(ElementMatchers.takesArguments(0)))).getOnly()), Duplication.SINGLE, MethodVariableAccess.forType(this.instrumentationTarget.getTypeDescription()).loadFromIndex(0), FieldAccess.forField((FieldDescription)((FieldList)proxyType.getDeclaredFields().filter(ElementMatchers.named(TypeProxy.INSTANCE_FIELD))).getOnly()).putter()).apply(methodVisitor, instrumentationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForSuperMethodByReflectionFactory that = (ForSuperMethodByReflectionFactory)other;
            return this.ignoreFinalizer == that.ignoreFinalizer && this.instrumentationTarget.equals(that.instrumentationTarget) && this.proxiedType.equals(that.proxiedType) && this.serializableProxy == that.serializableProxy;
        }

        public int hashCode() {
            int result = this.proxiedType.hashCode();
            result = 31 * result + this.instrumentationTarget.hashCode();
            result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
            result = 31 * result + (this.serializableProxy ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeProxy.ForSuperMethodByReflectionFactory{proxiedType=" + this.proxiedType + ", instrumentationTarget=" + this.instrumentationTarget + ", ignoreFinalizer=" + this.ignoreFinalizer + ", serializableProxy=" + this.serializableProxy + '}';
        }
    }

    public static class ForSuperMethodByConstructor
    implements StackManipulation {
        private final TypeDescription proxiedType;
        private final Instrumentation.Target instrumentationTarget;
        private final List<TypeDescription> constructorParameters;
        private final boolean ignoreFinalizer;
        private final boolean serializableProxy;

        public ForSuperMethodByConstructor(TypeDescription proxiedType, Instrumentation.Target instrumentationTarget, List<TypeDescription> constructorParameters, boolean ignoreFinalizer, boolean serializableProxy) {
            this.proxiedType = proxiedType;
            this.instrumentationTarget = instrumentationTarget;
            this.constructorParameters = constructorParameters;
            this.ignoreFinalizer = ignoreFinalizer;
            this.serializableProxy = serializableProxy;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            TypeDescription proxyType = instrumentationContext.register(new TypeProxy(this.proxiedType, this.instrumentationTarget, InvocationFactory.Default.SUPER_METHOD, this.ignoreFinalizer, this.serializableProxy));
            StackManipulation[] constructorValue = new StackManipulation[this.constructorParameters.size()];
            int index = 0;
            for (TypeDescription parameterType : this.constructorParameters) {
                constructorValue[index++] = DefaultValue.of(parameterType);
            }
            return new StackManipulation.Compound(TypeCreation.forType(proxyType), Duplication.SINGLE, new StackManipulation.Compound(constructorValue), MethodInvocation.invoke((MethodDescription)((MethodList)proxyType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(this.constructorParameters)))).getOnly()), Duplication.SINGLE, MethodVariableAccess.forType(this.instrumentationTarget.getTypeDescription()).loadFromIndex(0), FieldAccess.forField((FieldDescription)((FieldList)proxyType.getDeclaredFields().filter(ElementMatchers.named(TypeProxy.INSTANCE_FIELD))).getOnly()).putter()).apply(methodVisitor, instrumentationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForSuperMethodByConstructor that = (ForSuperMethodByConstructor)other;
            return this.ignoreFinalizer == that.ignoreFinalizer && this.serializableProxy == that.serializableProxy && this.constructorParameters.equals(that.constructorParameters) && this.instrumentationTarget.equals(that.instrumentationTarget) && this.proxiedType.equals(that.proxiedType);
        }

        public int hashCode() {
            int result = this.proxiedType.hashCode();
            result = 31 * result + this.instrumentationTarget.hashCode();
            result = 31 * result + this.constructorParameters.hashCode();
            result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
            result = 31 * result + (this.serializableProxy ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeProxy.ForSuperMethodByConstructor{proxiedType=" + this.proxiedType + ", instrumentationTarget=" + this.instrumentationTarget + ", constructorParameters=" + this.constructorParameters + ", ignoreFinalizer=" + this.ignoreFinalizer + ", serializableProxy=" + this.serializableProxy + '}';
        }
    }

    public static interface InvocationFactory {
        public Instrumentation.SpecialMethodInvocation invoke(Instrumentation.Target var1, TypeDescription var2, MethodDescription var3);

        public static enum Default implements InvocationFactory
        {
            SUPER_METHOD{

                @Override
                public Instrumentation.SpecialMethodInvocation invoke(Instrumentation.Target instrumentationTarget, TypeDescription proxiedType, MethodDescription instrumentedMethod) {
                    return instrumentationTarget.invokeSuper(instrumentedMethod, Instrumentation.Target.MethodLookup.Default.MOST_SPECIFIC);
                }
            }
            ,
            DEFAULT_METHOD{

                @Override
                public Instrumentation.SpecialMethodInvocation invoke(Instrumentation.Target instrumentationTarget, TypeDescription proxiedType, MethodDescription instrumentedMethod) {
                    return instrumentationTarget.invokeDefault(proxiedType, instrumentedMethod.getUniqueSignature());
                }
            };

        }
    }

    protected static enum SilentConstruction implements Instrumentation
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new Appender(instrumentationTarget.getTypeDescription());
        }

        protected static class Appender
        implements ByteCodeAppender {
            public static final String REFLECTION_FACTORY_INTERNAL_NAME = "sun/reflect/ReflectionFactory";
            public static final String GET_REFLECTION_FACTORY_METHOD_NAME = "getReflectionFactory";
            public static final String GET_REFLECTION_FACTORY_METHOD_DESCRIPTOR = "()Lsun/reflect/ReflectionFactory;";
            public static final String NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_NAME = "newConstructorForSerialization";
            public static final String NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_DESCRIPTOR = "(Ljava/lang/Class;Ljava/lang/reflect/Constructor;)Ljava/lang/reflect/Constructor;";
            public static final String JAVA_LANG_OBJECT_DESCRIPTOR = "Ljava/lang/Object;";
            public static final String JAVA_LANG_OBJECT_INTERNAL_NAME = "java/lang/Object";
            public static final String JAVA_LANG_CONSTRUCTOR_INTERNAL_NAME = "java/lang/reflect/Constructor";
            public static final String NEW_INSTANCE_METHOD_NAME = "newInstance";
            public static final String NEW_INSTANCE_METHOD_DESCRIPTOR = "([Ljava/lang/Object;)Ljava/lang/Object;";
            public static final String JAVA_LANG_CLASS_INTERNAL_NAME = "java/lang/Class";
            public static final String GET_DECLARED_CONSTRUCTOR_METHOD_NAME = "getDeclaredConstructor";
            public static final String GET_DECLARED_CONSTRUCTOR_METHOD_DESCRIPTOR = "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;";
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitMethodInsn(184, REFLECTION_FACTORY_INTERNAL_NAME, GET_REFLECTION_FACTORY_METHOD_NAME, GET_REFLECTION_FACTORY_METHOD_DESCRIPTOR, false);
                methodVisitor.visitLdcInsn(Type.getType(this.instrumentedType.getDescriptor()));
                methodVisitor.visitLdcInsn(Type.getType(JAVA_LANG_OBJECT_DESCRIPTOR));
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, JAVA_LANG_CLASS_INTERNAL_NAME);
                methodVisitor.visitMethodInsn(182, JAVA_LANG_CLASS_INTERNAL_NAME, GET_DECLARED_CONSTRUCTOR_METHOD_NAME, GET_DECLARED_CONSTRUCTOR_METHOD_DESCRIPTOR, false);
                methodVisitor.visitMethodInsn(182, REFLECTION_FACTORY_INTERNAL_NAME, NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_NAME, NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_DESCRIPTOR, false);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, JAVA_LANG_OBJECT_INTERNAL_NAME);
                methodVisitor.visitMethodInsn(182, JAVA_LANG_CONSTRUCTOR_INTERNAL_NAME, NEW_INSTANCE_METHOD_NAME, NEW_INSTANCE_METHOD_DESCRIPTOR, false);
                methodVisitor.visitTypeInsn(192, this.instrumentedType.getInternalName());
                methodVisitor.visitInsn(176);
                return new ByteCodeAppender.Size(4, 0);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "TypeProxy.SilentConstruction.Appender{instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static enum AbstractMethodErrorThrow implements StackManipulation
    {
        INSTANCE;

        private final StackManipulation implementation;

        private AbstractMethodErrorThrow() {
            TypeDescription.ForLoadedType abstractMethodError = new TypeDescription.ForLoadedType(AbstractMethodError.class);
            MethodDescription constructor = (MethodDescription)((MethodList)abstractMethodError.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly();
            this.implementation = new StackManipulation.Compound(TypeCreation.forType(abstractMethodError), Duplication.SINGLE, MethodInvocation.invoke(constructor), Throw.INSTANCE);
        }

        @Override
        public boolean isValid() {
            return this.implementation.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            return this.implementation.apply(methodVisitor, instrumentationContext);
        }
    }
}

