/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.StreamDrainer;

public interface ClassFileLocator {
    public static final String CLASS_FILE_EXTENSION = ".class";

    public Resolution locate(String var1) throws IOException;

    public static class Compound
    implements ClassFileLocator {
        private final ClassFileLocator[] classFileLocator;

        public Compound(ClassFileLocator ... classFileLocator) {
            this.classFileLocator = classFileLocator;
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocator) {
                Resolution resolution = classFileLocator.locate(typeName);
                if (!resolution.isResolved()) continue;
                return resolution;
            }
            return null;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.classFileLocator, ((Compound)other).classFileLocator);
        }

        public int hashCode() {
            return Arrays.hashCode(this.classFileLocator);
        }

        public String toString() {
            return "ClassFileLocator.Compound{classFileLocator=" + Arrays.toString(this.classFileLocator) + '}';
        }
    }

    public static class AgentBased
    implements ClassFileLocator {
        private static final String BYTE_BUDDY_AGENT_TYPE = "net.bytebuddy.agent.ByteBuddyAgent";
        private static final String GET_INSTRUMENTATION_METHOD = "getInstrumentation";
        private static final Object STATIC_METHOD = null;
        private final Instrumentation instrumentation;
        private final ClassLoader classLoader;

        public AgentBased(Instrumentation instrumentation, ClassLoader classLoader) {
            if (!instrumentation.isRetransformClassesSupported()) {
                throw new IllegalArgumentException(instrumentation + " does not support retransformation");
            }
            this.instrumentation = instrumentation;
            this.classLoader = ByteBuddyCommons.nonNull(classLoader);
        }

        public static ClassFileLocator fromInstalledAgent(ClassLoader classLoader) {
            try {
                return new AgentBased((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(BYTE_BUDDY_AGENT_TYPE).getDeclaredMethod(GET_INSTRUMENTATION_METHOD, new Class[0]).invoke(STATIC_METHOD, new Object[0]), classLoader);
            }
            catch (Exception e) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) {
            Resolution resolution;
            ExtractionClassFileTransformer classFileTransformer = new ExtractionClassFileTransformer(this.classLoader, typeName);
            try {
                this.instrumentation.addTransformer(classFileTransformer, true);
                this.instrumentation.retransformClasses(this.classLoader.loadClass(typeName));
                byte[] binaryRepresentation = classFileTransformer.getBinaryRepresentation();
                resolution = binaryRepresentation == null ? Resolution.Illegal.INSTANCE : new Resolution.Explicit(binaryRepresentation);
                this.instrumentation.removeTransformer(classFileTransformer);
            }
            catch (Throwable throwable) {
                try {
                    this.instrumentation.removeTransformer(classFileTransformer);
                    throw throwable;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            return resolution;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoader.equals(((AgentBased)other).classLoader) && this.instrumentation.equals(((AgentBased)other).instrumentation);
        }

        public int hashCode() {
            return 31 * this.instrumentation.hashCode() + this.classLoader.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.AgentBased{instrumentation=" + this.instrumentation + ", classLoader=" + this.classLoader + '}';
        }

        protected static class ExtractionClassFileTransformer
        implements ClassFileTransformer {
            private static final byte[] DO_NOT_TRANSFORM = null;
            private final ClassLoader classLoader;
            private final String typeName;
            private volatile byte[] binaryRepresentation;

            protected ExtractionClassFileTransformer(ClassLoader classLoader, String typeName) {
                this.classLoader = classLoader;
                this.typeName = typeName;
            }

            @Override
            public byte[] transform(ClassLoader classLoader, String internalName, Class<?> redefinedType, ProtectionDomain protectionDomain, byte[] classFile) throws IllegalClassFormatException {
                if (this.isChild(classLoader) && this.typeName.equals(redefinedType.getName())) {
                    this.binaryRepresentation = classFile;
                }
                return DO_NOT_TRANSFORM;
            }

            private boolean isChild(ClassLoader classLoader) {
                if (this.classLoader == null) {
                    return true;
                }
                do {
                    if (classLoader != this.classLoader) continue;
                    return true;
                } while ((classLoader = classLoader.getParent()) != null);
                return false;
            }

            protected byte[] getBinaryRepresentation() {
                return this.binaryRepresentation;
            }

            public String toString() {
                return "ClassFileLocator.AgentBased.ExtractionClassFileTransformer{classLoader=" + this.classLoader + ", typeName=" + this.typeName + ", binaryRepresentation=" + Arrays.toString(this.binaryRepresentation) + '}';
            }
        }
    }

    public static class ForClassLoader
    implements ClassFileLocator {
        private final ClassLoader classLoader;

        protected ForClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public static ClassFileLocator ofClassPath() {
            return new ForClassLoader(ClassLoader.getSystemClassLoader());
        }

        public static ClassFileLocator of(ClassLoader classLoader) {
            return new ForClassLoader(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            InputStream inputStream = this.classLoader.getResourceAsStream(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (inputStream != null) {
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(new StreamDrainer().drain(inputStream));
                    return explicit;
                }
                finally {
                    inputStream.close();
                }
            }
            return Resolution.Illegal.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoader.equals(((ForClassLoader)other).classLoader);
        }

        public int hashCode() {
            return this.classLoader.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForClassLoader{classLoader=" + this.classLoader + '}';
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public byte[] resolve();

        public static class Explicit
        implements Resolution {
            private final byte[] binaryRepresentation;

            public Explicit(byte[] binaryRepresentation) {
                this.binaryRepresentation = binaryRepresentation;
            }

            public static Resolution of(Class<?> type) {
                InputStream inputStream = (type.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : type.getClassLoader()).getResourceAsStream(type.getName().replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
                if (inputStream == null) {
                    return Illegal.INSTANCE;
                }
                try {
                    return new Explicit(new StreamDrainer().drain(inputStream));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            public byte[] resolve() {
                return this.binaryRepresentation;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.binaryRepresentation, ((Explicit)other).binaryRepresentation);
            }

            public int hashCode() {
                return Arrays.hashCode(this.binaryRepresentation);
            }

            public String toString() {
                return "ClassFileLocator.Resolution.Explicit{binaryRepresentation=" + Arrays.toString(this.binaryRepresentation) + '}';
            }
        }

        public static enum Illegal implements Resolution
        {
            INSTANCE;


            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public byte[] resolve() {
                throw new IllegalStateException("Could not read binary data");
            }
        }
    }
}

