/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.attribute.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.utility.PropertyDispatcher;

public interface AnnotationDescription {
    public Object getValue(MethodDescription var1);

    public <T> T getValue(MethodDescription var1, Class<T> var2);

    public TypeDescription getAnnotationType();

    public <T extends Annotation> Loadable<T> prepare(Class<T> var1);

    public static class ForLoadedAnnotation<S extends Annotation>
    extends AbstractAnnotationDescription.ForPrepared<S>
    implements Loadable<S> {
        private final S annotation;

        protected ForLoadedAnnotation(S annotation) {
            this.annotation = annotation;
        }

        public static <U extends Annotation> Loadable<U> of(U annotation) {
            return new ForLoadedAnnotation<U>(annotation);
        }

        public static Object wrap(Object value, TypeDescription typeDescription) {
            if (typeDescription.represents(Class.class)) {
                value = new TypeDescription.ForLoadedType((Class)value);
            } else if (typeDescription.represents(Class[].class)) {
                value = new TypeList.ForLoadedType((Class[])value).toArray(new TypeDescription[((Class[])value).length]);
            } else if (typeDescription.isAssignableTo(Enum.class)) {
                value = new EnumerationValue.ForLoadedEnumeration((Enum)value);
            } else if (typeDescription.isAssignableTo(Enum[].class)) {
                value = EnumerationValue.ForLoadedEnumeration.asList((Enum[])value).toArray(new EnumerationValue[((Enum[])value).length]);
            } else if (typeDescription.isAssignableTo(Annotation.class)) {
                value = ForLoadedAnnotation.of((Annotation)value);
            } else if (typeDescription.isAssignableTo(Annotation[].class)) {
                value = new AnnotationList.ForLoadedAnnotation((Annotation[])value).toArray(new AnnotationDescription[((Annotation[])value).length]);
            }
            return value;
        }

        @Override
        public S load() {
            return this.annotation;
        }

        @Override
        public S load(ClassLoader classLoader) {
            return this.annotation;
        }

        @Override
        public Object getValue(MethodDescription methodDescription) {
            if (!methodDescription.getDeclaringType().represents(this.annotation.annotationType())) {
                throw new IllegalArgumentException(methodDescription + " does not represent " + this.annotation.annotationType());
            }
            try {
                Method method;
                boolean visible = methodDescription.isVisibleTo(new TypeDescription.ForLoadedType(this.getClass()));
                Method method2 = method = methodDescription instanceof MethodDescription.ForLoadedMethod ? ((MethodDescription.ForLoadedMethod)methodDescription).getLoadedMethod() : null;
                if (method == null || !visible && !method.isAccessible()) {
                    method = this.annotation.annotationType().getDeclaredMethod(methodDescription.getName(), new Class[0]);
                    if (!visible) {
                        method.setAccessible(true);
                    }
                }
                return ForLoadedAnnotation.wrap(method.invoke(this.annotation, new Object[0]), methodDescription.getReturnType());
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot access annotation property " + methodDescription, e);
            }
        }

        @Override
        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            if (!this.annotation.annotationType().equals(annotationType)) {
                throw new IllegalArgumentException("Annotation is not of type " + annotationType);
            }
            return this;
        }

        @Override
        public TypeDescription getAnnotationType() {
            return new TypeDescription.ForLoadedType(this.annotation.annotationType());
        }
    }

    public static abstract class AbstractAnnotationDescription
    implements AnnotationDescription {
        @Override
        public <T> T getValue(MethodDescription methodDescription, Class<T> type) {
            return type.cast(this.getValue(methodDescription));
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof AnnotationDescription)) {
                return false;
            }
            AnnotationDescription annotationDescription = (AnnotationDescription)other;
            if (!annotationDescription.getAnnotationType().equals(this.getAnnotationType())) {
                return false;
            }
            for (MethodDescription methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                Object value = this.getValue(methodDescription);
                if (PropertyDispatcher.of(value.getClass()).equals(value, annotationDescription.getValue(methodDescription))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 0;
            for (MethodDescription methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                Object value = this.getValue(methodDescription);
                hashCode += 31 * PropertyDispatcher.of(value.getClass()).hashCode(value);
            }
            return hashCode;
        }

        public String toString() {
            StringBuilder toString = new StringBuilder();
            toString.append('@');
            toString.append(this.getAnnotationType().getName());
            toString.append('(');
            boolean firstMember = true;
            for (MethodDescription methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString.append(", ");
                }
                toString.append(methodDescription.getName());
                toString.append('=');
                Object value = this.getValue(methodDescription);
                toString.append(PropertyDispatcher.of(value.getClass()).toString(value));
            }
            toString.append(')');
            return toString.toString();
        }

        public static abstract class ForPrepared<S extends Annotation>
        extends AbstractAnnotationDescription
        implements Loadable<S> {
            public static final String ERROR_MESSAGE = "Could not load a type that is linked by the annotation value";

            @Override
            public S loadSilent() {
                try {
                    return this.load();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(ERROR_MESSAGE, e);
                }
            }

            @Override
            public S loadSilent(ClassLoader classLoader) {
                try {
                    return this.load(classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(ERROR_MESSAGE, e);
                }
            }
        }
    }

    public static interface Loadable<S extends Annotation>
    extends AnnotationDescription {
        public S load() throws ClassNotFoundException;

        public S load(ClassLoader var1) throws ClassNotFoundException;

        public S loadSilent();

        public S loadSilent(ClassLoader var1);
    }

    public static interface EnumerationValue {
        public String getValue();

        public TypeDescription getEnumerationType();

        public <T extends Enum<T>> T load(Class<T> var1);

        public static class ForLoadedEnumeration
        extends AbstractEnumerationValue {
            private final Enum<?> value;

            public ForLoadedEnumeration(Enum<?> value) {
                this.value = value;
            }

            public static List<EnumerationValue> asList(Enum<?>[] enumerations) {
                ArrayList<EnumerationValue> result = new ArrayList<EnumerationValue>(enumerations.length);
                for (Enum<?> enumeration : enumerations) {
                    result.add(new ForLoadedEnumeration(enumeration));
                }
                return result;
            }

            @Override
            public String getValue() {
                return this.value.name();
            }

            @Override
            public TypeDescription getEnumerationType() {
                return new TypeDescription.ForLoadedType(this.value.getDeclaringClass());
            }

            @Override
            public <T extends Enum<T>> T load(Class<T> type) {
                if (this.value.getDeclaringClass() != type) {
                    throw new IllegalArgumentException(type + " does not represent " + this.value);
                }
                return (T)this.value;
            }
        }

        public static abstract class AbstractEnumerationValue
        implements EnumerationValue {
            public boolean equals(Object other) {
                return other == this || other instanceof EnumerationValue && ((EnumerationValue)other).getEnumerationType().equals(this.getEnumerationType()) && ((EnumerationValue)other).getValue().equals(this.getValue());
            }

            public int hashCode() {
                return this.getValue().hashCode() + 31 * this.getEnumerationType().hashCode();
            }

            public String toString() {
                return this.getValue();
            }
        }
    }
}

