/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.constant;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

public class MethodTypeConstant
implements StackManipulation {
    private static final String METHOD_TYPE_TYPE_INTERNAL_NAME = "java/lang/invoke/MethodType";
    private static final StackManipulation.Size SIZE = StackSize.SINGLE.toIncreasingSize();
    private final Type methodType;

    public MethodTypeConstant(MethodDescription methodDescription) {
        this.methodType = Type.getMethodType(methodDescription.getDescriptor());
    }

    public static boolean isRepresentedBy(TypeDescription typeDescription) {
        return typeDescription.getInternalName().equals(METHOD_TYPE_TYPE_INTERNAL_NAME);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
        methodVisitor.visitLdcInsn(this.methodType);
        return SIZE;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.methodType.equals(((MethodTypeConstant)other).methodType);
    }

    public int hashCode() {
        return this.methodType.hashCode();
    }

    public String toString() {
        return "MethodTypeConstant{methodType=" + this.methodType + '}';
    }
}

