/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.DoubleConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.FloatConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.IntegerConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.LongConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.NullConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.TextConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;

public abstract class FixedValue
implements Instrumentation {
    protected final Assigner assigner;
    protected final boolean dynamicallyTyped;

    protected FixedValue(Assigner assigner, boolean dynamicallyTyped) {
        this.assigner = assigner;
        this.dynamicallyTyped = dynamicallyTyped;
    }

    public static Instrumentation nullValue() {
        return FixedValue.value(null);
    }

    public static AssignerConfigurable value(Object fixedValue) {
        if (fixedValue == null) {
            return new ForPoolValue(NullConstant.INSTANCE, new TypeDescription.ForLoadedType(Object.class), FixedValue.defaultAssigner(), true);
        }
        Class<?> type = fixedValue.getClass();
        if (type == String.class) {
            return new ForPoolValue(new TextConstant((String)fixedValue), new TypeDescription.ForLoadedType(String.class), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Boolean.class) {
            return new ForPoolValue(IntegerConstant.forValue((Boolean)fixedValue), new TypeDescription.ForLoadedType(Boolean.TYPE), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Byte.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Byte)fixedValue).byteValue()), new TypeDescription.ForLoadedType(Byte.TYPE), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Short.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Short)fixedValue).shortValue()), new TypeDescription.ForLoadedType(Short.TYPE), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Character.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Character)fixedValue).charValue()), new TypeDescription.ForLoadedType(Character.TYPE), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Integer.class) {
            return new ForPoolValue(IntegerConstant.forValue((Integer)fixedValue), new TypeDescription.ForLoadedType(Integer.TYPE), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Long.class) {
            return new ForPoolValue(LongConstant.forValue((Long)fixedValue), new TypeDescription.ForLoadedType(Long.TYPE), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Float.class) {
            return new ForPoolValue(FloatConstant.forValue(((Float)fixedValue).floatValue()), new TypeDescription.ForLoadedType(Float.TYPE), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Double.class) {
            return new ForPoolValue(DoubleConstant.forValue((Double)fixedValue), new TypeDescription.ForLoadedType(Double.TYPE), FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        return FixedValue.reference(fixedValue);
    }

    public static AssignerConfigurable reference(Object fixedValue) {
        if (fixedValue == null) {
            return new ForPoolValue(NullConstant.INSTANCE, new TypeDescription.ForLoadedType(Object.class), FixedValue.defaultAssigner(), true);
        }
        return new ForStaticField(fixedValue, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
    }

    public static AssignerConfigurable reference(Object fixedValue, String fieldName) {
        if (fixedValue == null) {
            throw new IllegalArgumentException("The fixed value must not be null");
        }
        return new ForStaticField(ByteBuddyCommons.isValidIdentifier(fieldName), fixedValue, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
    }

    private static Assigner defaultAssigner() {
        return new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE));
    }

    private static boolean defaultConsiderRuntimeType() {
        return false;
    }

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod, TypeDescription fixedValueType, StackManipulation valueLoadingInstruction) {
        StackManipulation assignment = this.assigner.assign(fixedValueType, instrumentedMethod.getReturnType(), this.dynamicallyTyped);
        if (!assignment.isValid()) {
            throw new IllegalArgumentException("Cannot return value of type " + fixedValueType + " for " + instrumentedMethod);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(valueLoadingInstruction, assignment, MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.dynamicallyTyped == ((FixedValue)other).dynamicallyTyped && this.assigner.equals(((FixedValue)other).assigner);
    }

    public int hashCode() {
        return 31 * this.assigner.hashCode() + (this.dynamicallyTyped ? 1 : 0);
    }

    protected static class ForStaticField
    extends FixedValue
    implements AssignerConfigurable {
        private static final String PREFIX = "fixedValue";
        private final String fieldName;
        private final Object fixedValue;
        private final TypeDescription fieldType;

        protected ForStaticField(Object fixedValue, Assigner assigner, boolean dynamicallyTyped) {
            this(String.format("%s$%d", PREFIX, Math.abs(fixedValue.hashCode())), fixedValue, assigner, dynamicallyTyped);
        }

        protected ForStaticField(String fieldName, Object fixedValue, Assigner assigner, boolean dynamicallyTyped) {
            super(assigner, dynamicallyTyped);
            this.fieldName = fieldName;
            this.fixedValue = fixedValue;
            this.fieldType = new TypeDescription.ForLoadedType(fixedValue.getClass());
        }

        @Override
        public Instrumentation withAssigner(Assigner assigner, boolean dynamicallyTyped) {
            return new ForStaticField(this.fieldName, this.fixedValue, ByteBuddyCommons.nonNull(assigner), dynamicallyTyped);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(this.fieldName, this.fieldType, 4106).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.fixedValue));
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new StaticFieldByteCodeAppender(instrumentationTarget.getTypeDescription());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForStaticField)other).fieldName) && this.fixedValue.equals(((ForStaticField)other).fixedValue) && super.equals(other);
        }

        @Override
        public int hashCode() {
            return 961 * super.hashCode() + 31 * this.fieldName.hashCode() + this.fixedValue.hashCode();
        }

        public String toString() {
            return "FixedValue.ForStaticField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + ", fixedValue=" + this.fixedValue + ", assigner=" + this.assigner + ", dynamicallyTyped=" + this.dynamicallyTyped + '}';
        }

        private class StaticFieldByteCodeAppender
        implements ByteCodeAppender {
            private final StackManipulation fieldGetAccess;

            private StaticFieldByteCodeAppender(TypeDescription instrumentedType) {
                this.fieldGetAccess = FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(ForStaticField.this.fieldName))).getOnly()).getter();
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                return ForStaticField.this.apply(methodVisitor, instrumentationContext, instrumentedMethod, ForStaticField.this.fieldType, this.fieldGetAccess);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldGetAccess.equals(((StaticFieldByteCodeAppender)other).fieldGetAccess);
            }

            public int hashCode() {
                return this.fieldGetAccess.hashCode();
            }

            public String toString() {
                return "StaticFieldByteCodeAppender{fieldGetAccess=" + this.fieldGetAccess + '}';
            }
        }
    }

    protected static class ForPoolValue
    extends FixedValue
    implements AssignerConfigurable,
    ByteCodeAppender {
        private final StackManipulation valueLoadInstruction;
        private final TypeDescription loadedType;

        private ForPoolValue(StackManipulation valueLoadInstruction, TypeDescription loadedType, Assigner assigner, boolean dynamicallyTyped) {
            super(assigner, dynamicallyTyped);
            this.valueLoadInstruction = valueLoadInstruction;
            this.loadedType = loadedType;
        }

        @Override
        public Instrumentation withAssigner(Assigner assigner, boolean dynamicallyTyped) {
            return new ForPoolValue(this.valueLoadInstruction, this.loadedType, ByteBuddyCommons.nonNull(assigner), dynamicallyTyped);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return this;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            return this.apply(methodVisitor, instrumentationContext, instrumentedMethod, this.loadedType, this.valueLoadInstruction);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.loadedType.equals(((ForPoolValue)other).loadedType) && this.valueLoadInstruction.equals(((ForPoolValue)other).valueLoadInstruction);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.valueLoadInstruction.hashCode();
            result = 31 * result + this.loadedType.hashCode();
            return result;
        }

        public String toString() {
            return "FixedValue.ForPoolValue{valueLoadInstruction=" + this.valueLoadInstruction + ", loadedType=" + this.loadedType + ", assigner=" + this.assigner + ", dynamicallyTyped=" + this.dynamicallyTyped + '}';
        }
    }

    public static interface AssignerConfigurable
    extends Instrumentation {
        public Instrumentation withAssigner(Assigner var1, boolean var2);
    }
}

