/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.attribute.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

public interface AnnotationAppender {
    public AnnotationAppender append(AnnotationDescription var1, AnnotationVisibility var2);

    public static class Default
    implements AnnotationAppender {
        private static final String ASM_IGNORE_NAME = null;
        private final Target target;

        public Default(Target target) {
            this.target = target;
        }

        @Override
        public AnnotationAppender append(AnnotationDescription annotation, AnnotationVisibility annotationVisibility) {
            if (!annotationVisibility.isSuppressed()) {
                this.doAppend(annotation, annotationVisibility.isVisible());
            }
            return this;
        }

        private void doAppend(AnnotationDescription annotation, boolean visible) {
            this.handle(this.target.visit(annotation.getAnnotationType().getDescriptor(), visible), annotation);
        }

        private void handle(AnnotationVisitor annotationVisitor, AnnotationDescription annotation) {
            for (MethodDescription methodDescription : annotation.getAnnotationType().getDeclaredMethods()) {
                this.apply(annotationVisitor, methodDescription.getReturnType(), methodDescription.getName(), annotation.getValue(methodDescription));
            }
            annotationVisitor.visitEnd();
        }

        private void apply(AnnotationVisitor annotationVisitor, TypeDescription valueType, String name, Object value) {
            if (valueType.isAnnotation()) {
                this.handle(annotationVisitor.visitAnnotation(name, valueType.getDescriptor()), (AnnotationDescription)value);
            } else if (valueType.isEnum()) {
                annotationVisitor.visitEnum(name, valueType.getDescriptor(), ((AnnotationDescription.EnumerationValue)value).getValue());
            } else if (valueType.isAssignableFrom(Class.class)) {
                annotationVisitor.visit(name, Type.getType(((TypeDescription)value).getDescriptor()));
            } else if (valueType.isArray()) {
                AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                int length = Array.getLength(value);
                TypeDescription componentType = valueType.getComponentType();
                for (int index = 0; index < length; ++index) {
                    this.apply(arrayVisitor, componentType, ASM_IGNORE_NAME, Array.get(value, index));
                }
                arrayVisitor.visitEnd();
            } else {
                annotationVisitor.visit(name, value);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.target.equals(((Default)other).target);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return "AnnotationAppender.Default{target=" + this.target + '}';
        }
    }

    public static interface Target {
        public AnnotationVisitor visit(String var1, boolean var2);

        public static class OnField
        implements Target {
            private final FieldVisitor fieldVisitor;

            public OnField(FieldVisitor fieldVisitor) {
                this.fieldVisitor = fieldVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.fieldVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldVisitor.equals(((OnField)other).fieldVisitor);
            }

            public int hashCode() {
                return this.fieldVisitor.hashCode();
            }

            public String toString() {
                return "AnnotationAppender.Target.OnField{fieldVisitor=" + this.fieldVisitor + '}';
            }
        }

        public static class OnMethodParameter
        implements Target {
            private final MethodVisitor methodVisitor;
            private final int parameterIndex;

            public OnMethodParameter(MethodVisitor methodVisitor, int parameterIndex) {
                this.methodVisitor = methodVisitor;
                this.parameterIndex = parameterIndex;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.methodVisitor.visitParameterAnnotation(this.parameterIndex, annotationTypeDescriptor, visible);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.parameterIndex == ((OnMethodParameter)other).parameterIndex && this.methodVisitor.equals(((OnMethodParameter)other).methodVisitor);
            }

            public int hashCode() {
                return this.methodVisitor.hashCode() + 31 * this.parameterIndex;
            }

            public String toString() {
                return "AnnotationAppender.Target.OnMethodParameter{methodVisitor=" + this.methodVisitor + ", parameterIndex=" + this.parameterIndex + '}';
            }
        }

        public static class OnMethod
        implements Target {
            private final MethodVisitor methodVisitor;

            public OnMethod(MethodVisitor methodVisitor) {
                this.methodVisitor = methodVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.methodVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodVisitor.equals(((OnMethod)other).methodVisitor);
            }

            public int hashCode() {
                return this.methodVisitor.hashCode();
            }

            public String toString() {
                return "AnnotationAppender.Target.OnMethod{methodVisitor=" + this.methodVisitor + '}';
            }
        }

        public static class OnType
        implements Target {
            private final ClassVisitor classVisitor;

            public OnType(ClassVisitor classVisitor) {
                this.classVisitor = classVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.classVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.classVisitor.equals(((OnType)other).classVisitor);
            }

            public int hashCode() {
                return this.classVisitor.hashCode();
            }

            public String toString() {
                return "AnnotationAppender.Target.OnType{classVisitor=" + this.classVisitor + '}';
            }
        }
    }

    public static enum AnnotationVisibility {
        RUNTIME(true, false),
        CLASS_FILE(false, false),
        INVISIBLE(false, true);

        private final boolean visible;
        private final boolean suppressed;

        private AnnotationVisibility(boolean visible, boolean suppressed) {
            this.visible = visible;
            this.suppressed = suppressed;
        }

        public static AnnotationVisibility of(AnnotationDescription annotation) {
            AnnotationDescription.Loadable<Retention> retention = annotation.getAnnotationType().getDeclaredAnnotations().ofType(Retention.class);
            if (retention == null || retention.loadSilent().value() == RetentionPolicy.SOURCE) {
                return INVISIBLE;
            }
            if (retention.loadSilent().value() == RetentionPolicy.CLASS) {
                return CLASS_FILE;
            }
            return RUNTIME;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isSuppressed() {
            return this.suppressed;
        }
    }
}

