/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public interface MethodLookupEngine {
    public Finding process(TypeDescription var1);

    public static class Default
    implements MethodLookupEngine {
        private final DefaultMethodLookup defaultMethodLookup;

        public Default(DefaultMethodLookup defaultMethodLookup) {
            this.defaultMethodLookup = defaultMethodLookup;
        }

        @Override
        public Finding process(TypeDescription typeDescription) {
            MethodBucket methodBucket = new MethodBucket(typeDescription);
            HashSet<TypeDescription> interfaces = new HashSet<TypeDescription>();
            TypeList defaultMethodRelevantInterfaces = typeDescription.getInterfaces();
            while ((typeDescription = typeDescription.getSupertype()) != null) {
                methodBucket.pushClass(typeDescription);
                interfaces.addAll(typeDescription.getInterfaces());
            }
            Map<TypeDescription, Set<MethodDescription>> defaultMethods = this.defaultMethodLookup.apply(methodBucket, interfaces, defaultMethodRelevantInterfaces);
            methodBucket.pushInterfaces(interfaces);
            return new Finding.Default(methodBucket.getTypeOfInterest(), methodBucket.extractInvokableMethods(), defaultMethods);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.defaultMethodLookup == ((Default)other).defaultMethodLookup;
        }

        public int hashCode() {
            return this.defaultMethodLookup.hashCode();
        }

        public String toString() {
            return "MethodLookupEngine.Default{defaultMethodLookup=" + (Object)((Object)this.defaultMethodLookup) + '}';
        }

        protected static class MethodBucket {
            private final Map<String, MethodDescription> classMethods;
            private final Map<String, MethodDescription> interfaceMethods;
            private final Set<TypeDescription> processedTypes;
            private final TypeDescription typeOfInterest;
            private final ElementMatcher<? super MethodDescription> virtualMethodMatcher;

            protected MethodBucket(TypeDescription typeOfInterest) {
                this.typeOfInterest = typeOfInterest;
                this.classMethods = new HashMap<String, MethodDescription>();
                this.interfaceMethods = new HashMap<String, MethodDescription>();
                this.processedTypes = new HashSet<TypeDescription>();
                this.virtualMethodMatcher = ElementMatchers.isMethod().and(ElementMatchers.not(ElementMatchers.isPrivate().or(ElementMatchers.isStatic()).or(ElementMatchers.isPackagePrivate().and(ElementMatchers.not(ElementMatchers.isVisibleTo(typeOfInterest))))));
                this.pushClass(typeOfInterest, ElementMatchers.any());
            }

            private void pushClass(TypeDescription typeDescription) {
                this.pushClass(typeDescription, this.virtualMethodMatcher);
            }

            private void pushClass(TypeDescription typeDescription, ElementMatcher<? super MethodDescription> methodMatcher) {
                if (this.processedTypes.add(typeDescription)) {
                    for (MethodDescription methodDescription : (MethodList)typeDescription.getDeclaredMethods().filter(methodMatcher)) {
                        String uniqueSignature;
                        MethodDescription overridingMethod = this.classMethods.get(uniqueSignature = methodDescription.getUniqueSignature());
                        this.classMethods.put(uniqueSignature, overridingMethod == null ? methodDescription : OverridenClassMethod.of(overridingMethod, methodDescription));
                    }
                }
            }

            private void pushInterfaces(Collection<? extends TypeDescription> typeDescriptions) {
                this.pushInterfaces(typeDescriptions, DefaultMethodLookup.Disabled.INSTANCE);
            }

            private Map<TypeDescription, Set<MethodDescription>> pushInterfacesAndExtractDefaultMethods(Collection<? extends TypeDescription> typeDescriptions) {
                DefaultMethodLookup.Enabled defaultMethodLookup = new DefaultMethodLookup.Enabled(typeDescriptions);
                this.pushInterfaces(typeDescriptions, defaultMethodLookup);
                return defaultMethodLookup.materialize();
            }

            private void pushInterfaces(Collection<? extends TypeDescription> typeDescriptions, DefaultMethodLookup defaultMethodLookup) {
                HashSet<String> processedMethods = new HashSet<String>(this.classMethods.keySet());
                for (TypeDescription typeDescription : typeDescriptions) {
                    this.pushInterface(typeDescription, processedMethods, defaultMethodLookup);
                }
            }

            private void pushInterface(TypeDescription typeDescription, Set<String> processedMethodsInHierarchy, DefaultMethodLookup defaultMethodLookup) {
                HashSet<String> locallyProcessedMethods = new HashSet<String>(processedMethodsInHierarchy);
                if (this.processedTypes.add(typeDescription)) {
                    defaultMethodLookup.begin(typeDescription);
                    for (MethodDescription methodDescription : (MethodList)typeDescription.getDeclaredMethods().filter(this.virtualMethodMatcher)) {
                        String uniqueSignature = methodDescription.getUniqueSignature();
                        if (locallyProcessedMethods.add(uniqueSignature)) {
                            MethodDescription conflictingMethod = this.interfaceMethods.get(uniqueSignature);
                            MethodDescription resolvedMethod = methodDescription;
                            if (conflictingMethod != null && !conflictingMethod.getDeclaringType().isAssignableFrom(typeDescription)) {
                                resolvedMethod = ConflictingInterfaceMethod.of(this.typeOfInterest, conflictingMethod, methodDescription);
                            }
                            this.interfaceMethods.put(uniqueSignature, resolvedMethod);
                        }
                        defaultMethodLookup.register(methodDescription);
                    }
                    for (TypeDescription interfaceType : typeDescription.getInterfaces()) {
                        this.pushInterface(interfaceType, locallyProcessedMethods, defaultMethodLookup);
                    }
                    defaultMethodLookup.complete(typeDescription);
                }
            }

            private MethodList extractInvokableMethods() {
                ArrayList<MethodDescription> invokableMethods = new ArrayList<MethodDescription>(this.classMethods.size() + this.interfaceMethods.size());
                invokableMethods.addAll(this.classMethods.values());
                invokableMethods.addAll(this.interfaceMethods.values());
                return new MethodList.Explicit(invokableMethods);
            }

            private TypeDescription getTypeOfInterest() {
                return this.typeOfInterest;
            }

            public String toString() {
                return "MethodLookupEngine.Default.MethodBucket{typeOfInterest=" + this.typeOfInterest + ", classMethods=" + this.classMethods + ", interfaceMethods=" + this.interfaceMethods + ", processedTypes=" + this.processedTypes + ", virtualMethodMatcher=" + this.virtualMethodMatcher + '}';
            }

            private static interface DefaultMethodLookup {
                public void begin(TypeDescription var1);

                public void register(MethodDescription var1);

                public void complete(TypeDescription var1);

                public static class Enabled
                implements DefaultMethodLookup {
                    private final Collection<? extends TypeDescription> declaredInterfaceTypes;
                    private final Map<TypeDescription, Set<MethodDescription>> defaultMethods;
                    private final Map<TypeDescription, Set<String>> methodDeclarations;

                    protected Enabled(Collection<? extends TypeDescription> declaredInterfaceTypes) {
                        this.declaredInterfaceTypes = declaredInterfaceTypes;
                        this.defaultMethods = new HashMap<TypeDescription, Set<MethodDescription>>();
                        this.methodDeclarations = new HashMap<TypeDescription, Set<String>>();
                    }

                    @Override
                    public void begin(TypeDescription typeDescription) {
                        this.defaultMethods.put(typeDescription, new HashSet());
                        this.methodDeclarations.put(typeDescription, new HashSet());
                    }

                    @Override
                    public void register(MethodDescription methodDescription) {
                        this.methodDeclarations.get(methodDescription.getDeclaringType()).add(methodDescription.getUniqueSignature());
                        if (methodDescription.isDefaultMethod()) {
                            this.defaultMethods.get(methodDescription.getDeclaringType()).add(methodDescription);
                        }
                    }

                    @Override
                    public void complete(TypeDescription typeDescription) {
                        Set<String> methodDeclarations = this.methodDeclarations.get(typeDescription);
                        Set<MethodDescription> defaultMethods = this.defaultMethods.get(typeDescription);
                        for (TypeDescription interfaceType : typeDescription.getInterfaces()) {
                            for (MethodDescription methodDescription : this.defaultMethods.get(interfaceType)) {
                                if (methodDeclarations.contains(methodDescription.getUniqueSignature())) continue;
                                defaultMethods.add(methodDescription);
                            }
                        }
                    }

                    protected Map<TypeDescription, Set<MethodDescription>> materialize() {
                        this.defaultMethods.keySet().retainAll(this.declaredInterfaceTypes);
                        return Collections.unmodifiableMap(this.defaultMethods);
                    }
                }

                public static enum Disabled implements DefaultMethodLookup
                {
                    INSTANCE;


                    @Override
                    public void begin(TypeDescription typeDescription) {
                    }

                    @Override
                    public void register(MethodDescription methodDescription) {
                    }

                    @Override
                    public void complete(TypeDescription typeDescription) {
                    }
                }
            }
        }

        public static enum Factory implements net.bytebuddy.instrumentation.method.MethodLookupEngine$Factory
        {
            INSTANCE;


            @Override
            public MethodLookupEngine make(boolean extractDefaultMethods) {
                return new Default(extractDefaultMethods ? DefaultMethodLookup.ENABLED : DefaultMethodLookup.DISABLED);
            }
        }

        public static enum DefaultMethodLookup {
            ENABLED{

                @Override
                public Map<TypeDescription, Set<MethodDescription>> apply(MethodBucket methodBucket, Collection<TypeDescription> interfaces, Collection<TypeDescription> defaultMethodRelevantInterfaces) {
                    interfaces.removeAll(defaultMethodRelevantInterfaces);
                    return Collections.unmodifiableMap(methodBucket.pushInterfacesAndExtractDefaultMethods(defaultMethodRelevantInterfaces));
                }
            }
            ,
            DISABLED{

                @Override
                public Map<TypeDescription, Set<MethodDescription>> apply(MethodBucket methodBucket, Collection<TypeDescription> interfaces, Collection<TypeDescription> defaultMethodRelevantInterfaces) {
                    interfaces.addAll(defaultMethodRelevantInterfaces);
                    return Collections.emptyMap();
                }
            };


            public abstract Map<TypeDescription, Set<MethodDescription>> apply(MethodBucket var1, Collection<TypeDescription> var2, Collection<TypeDescription> var3);
        }
    }

    public static class ConflictingInterfaceMethod
    extends MethodDescription.AbstractMethodDescription {
        private static final int ANY = 0;
        private static final int CONFLICTING_INTERFACE_MODIFIER = 1025;
        private final TypeDescription virtualHost;
        private final List<MethodDescription> methodDescriptions;

        protected ConflictingInterfaceMethod(TypeDescription virtualHost, List<MethodDescription> methodDescriptions) {
            this.virtualHost = virtualHost;
            this.methodDescriptions = methodDescriptions;
        }

        protected static MethodDescription of(TypeDescription virtualHost, MethodDescription conflictingMethod, MethodDescription discoveredMethod) {
            ArrayList<MethodDescription> methodDescriptions;
            if (conflictingMethod instanceof ConflictingInterfaceMethod) {
                List<MethodDescription> known = ((ConflictingInterfaceMethod)conflictingMethod).methodDescriptions;
                methodDescriptions = new ArrayList(known.size() + 1);
                for (MethodDescription methodDescription : known) {
                    if (methodDescription.getDeclaringType().isAssignableFrom(discoveredMethod.getDeclaringType())) continue;
                    methodDescriptions.add(methodDescription);
                }
                methodDescriptions.add(discoveredMethod);
            } else {
                methodDescriptions = Arrays.asList(conflictingMethod, discoveredMethod);
            }
            return new ConflictingInterfaceMethod(virtualHost, methodDescriptions);
        }

        @Override
        public TypeDescription getReturnType() {
            return this.methodDescriptions.get(0).getReturnType();
        }

        @Override
        public TypeList getParameterTypes() {
            return this.methodDescriptions.get(0).getParameterTypes();
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.Empty();
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean represents(Method method) {
            return false;
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return false;
        }

        @Override
        public List<AnnotationList> getParameterAnnotations() {
            return AnnotationList.Empty.asList(this.methodDescriptions.get(0).getParameterTypes().size());
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public String getName() {
            return this.methodDescriptions.get(0).getName();
        }

        @Override
        public String getInternalName() {
            return this.methodDescriptions.get(0).getInternalName();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.virtualHost;
        }

        @Override
        public int getModifiers() {
            return 1025;
        }

        @Override
        public boolean isSpecializableFor(TypeDescription targetType) {
            MethodDescription invokableMethod = null;
            for (MethodDescription methodDescription : this.methodDescriptions) {
                if (methodDescription.isAbstract() || !methodDescription.getDeclaringType().isAssignableFrom(targetType)) continue;
                if (invokableMethod == null) {
                    invokableMethod = methodDescription;
                    continue;
                }
                return false;
            }
            return invokableMethod != null;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }

    public static class OverridenClassMethod
    extends MethodDescription.AbstractMethodDescription {
        private static final int MOST_SPECIFIC = 0;
        private final List<MethodDescription> methodChain;

        protected OverridenClassMethod(List<MethodDescription> methodChain) {
            this.methodChain = methodChain;
        }

        public static MethodDescription of(MethodDescription overridingMethod, MethodDescription overriddenMethod) {
            ArrayList<MethodDescription> methodChain;
            if (overridingMethod instanceof OverridenClassMethod) {
                OverridenClassMethod overridenClassMethod = (OverridenClassMethod)overridingMethod;
                methodChain = new ArrayList(overridenClassMethod.methodChain.size() + 1);
                methodChain.addAll(overridenClassMethod.methodChain);
            } else {
                methodChain = new ArrayList<MethodDescription>(2);
                methodChain.add(overridingMethod);
            }
            methodChain.add(overriddenMethod);
            return new OverridenClassMethod(methodChain);
        }

        @Override
        public TypeDescription getReturnType() {
            return this.methodChain.get(0).getReturnType();
        }

        @Override
        public TypeList getParameterTypes() {
            return this.methodChain.get(0).getParameterTypes();
        }

        @Override
        public List<AnnotationList> getParameterAnnotations() {
            return this.methodChain.get(0).getParameterAnnotations();
        }

        @Override
        public TypeList getExceptionTypes() {
            return this.methodChain.get(0).getExceptionTypes();
        }

        @Override
        public boolean isConstructor() {
            return this.methodChain.get(0).isConstructor();
        }

        @Override
        public boolean isTypeInitializer() {
            return this.methodChain.get(0).isTypeInitializer();
        }

        @Override
        public boolean represents(Method method) {
            return this.methodChain.get(0).represents(method);
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.methodChain.get(0).represents(constructor);
        }

        @Override
        public String getName() {
            return this.methodChain.get(0).getName();
        }

        @Override
        public String getInternalName() {
            return this.methodChain.get(0).getInternalName();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.methodChain.get(0).getDeclaringType();
        }

        @Override
        public int getModifiers() {
            return this.methodChain.get(0).getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.methodChain.get(0).getDeclaredAnnotations();
        }

        @Override
        public boolean isSpecializableFor(TypeDescription targetType) {
            for (MethodDescription methodDescription : this.methodChain) {
                if (methodDescription.isSpecializableFor(targetType)) {
                    return true;
                }
                if (!methodDescription.getDeclaringType().isAssignableFrom(targetType)) continue;
                return false;
            }
            return false;
        }

        @Override
        public Object getDefaultValue() {
            return this.methodChain.get(0).getDefaultValue();
        }
    }

    public static interface Finding {
        public TypeDescription getTypeDescription();

        public MethodList getInvokableMethods();

        public Map<TypeDescription, Set<MethodDescription>> getInvokableDefaultMethods();

        public static class Default
        implements Finding {
            private final TypeDescription lookedUpType;
            private final MethodList invokableMethods;
            private final Map<TypeDescription, Set<MethodDescription>> invokableDefaultMethods;

            public Default(TypeDescription lookedUpType, MethodList invokableMethods, Map<TypeDescription, Set<MethodDescription>> invokableDefaultMethods) {
                this.lookedUpType = lookedUpType;
                this.invokableMethods = invokableMethods;
                this.invokableDefaultMethods = invokableDefaultMethods;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.lookedUpType;
            }

            @Override
            public MethodList getInvokableMethods() {
                return this.invokableMethods;
            }

            @Override
            public Map<TypeDescription, Set<MethodDescription>> getInvokableDefaultMethods() {
                return this.invokableDefaultMethods;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Default aDefault = (Default)other;
                return this.invokableDefaultMethods.equals(aDefault.invokableDefaultMethods) && this.invokableMethods.equals(aDefault.invokableMethods) && this.lookedUpType.equals(aDefault.lookedUpType);
            }

            public int hashCode() {
                int result = this.lookedUpType.hashCode();
                result = 31 * result + this.invokableMethods.hashCode();
                result = 31 * result + this.invokableDefaultMethods.hashCode();
                return result;
            }

            public String toString() {
                return "MethodLookupEngine.Finding.Default{lookedUpType=" + this.lookedUpType + ", invokableMethods=" + this.invokableMethods + ", invokableDefaultMethods=" + this.invokableDefaultMethods + '}';
            }
        }
    }

    public static interface Factory {
        public MethodLookupEngine make(boolean var1);
    }
}

