/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.ArgumentTypeResolver;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.RuntimeType;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.TypeDescription;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Argument {
    public int value();

    public BindingMechanic bindingMechanic() default BindingMechanic.UNIQUE;

    public static enum NextUnboundAsDefaultsProvider implements TargetMethodAnnotationDrivenBinder.DefaultsProvider
    {
        INSTANCE;


        private static Iterator<Integer> makeFreeIndexList(MethodDescription source, MethodDescription target) {
            LinkedHashSet<Integer> results = new LinkedHashSet<Integer>(source.getParameterTypes().size());
            for (int sourceIndex = 0; sourceIndex < source.getParameterTypes().size(); ++sourceIndex) {
                results.add(sourceIndex);
            }
            for (AnnotationList parameterAnnotations : target.getParameterAnnotations()) {
                AnnotationDescription.Loadable<Argument> annotation = parameterAnnotations.ofType(Argument.class);
                if (annotation == null) continue;
                results.remove(annotation.loadSilent().value());
            }
            return results.iterator();
        }

        @Override
        public Iterator<AnnotationDescription> makeIterator(Instrumentation.Target instrumentationTarget, MethodDescription source, MethodDescription target) {
            return new NextUnboundArgumentIterator(NextUnboundAsDefaultsProvider.makeFreeIndexList(source, target));
        }

        protected static class NextUnboundArgumentIterator
        implements Iterator<AnnotationDescription> {
            private final Iterator<Integer> iterator;

            protected NextUnboundArgumentIterator(Iterator<Integer> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public AnnotationDescription next() {
                return AnnotationDescription.ForLoadedAnnotation.of(new DefaultArgument(this.iterator.next()));
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }

            protected static class DefaultArgument
            implements Argument {
                private static final String VALUE = "value";
                private static final String BINDING_MECHANIC = "bindingMechanic";
                private final int parameterIndex;

                protected DefaultArgument(int parameterIndex) {
                    this.parameterIndex = parameterIndex;
                }

                @Override
                public int value() {
                    return this.parameterIndex;
                }

                @Override
                public BindingMechanic bindingMechanic() {
                    return BindingMechanic.UNIQUE;
                }

                public Class<Argument> annotationType() {
                    return Argument.class;
                }

                @Override
                public boolean equals(Object other) {
                    return this == other || other instanceof Argument && this.parameterIndex == ((Argument)other).value();
                }

                @Override
                public int hashCode() {
                    return (127 * BINDING_MECHANIC.hashCode() ^ BindingMechanic.UNIQUE.hashCode()) + (127 * VALUE.hashCode() ^ this.parameterIndex);
                }

                @Override
                public String toString() {
                    return "@" + Argument.class.getName() + "(bindingMechanic=" + BindingMechanic.UNIQUE.name() + ", value=" + this.parameterIndex + ")";
                }
            }
        }
    }

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Argument>
    {
        INSTANCE;


        @Override
        public Class<Argument> getHandledType() {
            return Argument.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Argument> annotation, int targetParameterIndex, MethodDescription source, MethodDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            Argument argument = annotation.loadSilent();
            if (argument.value() < 0) {
                throw new IllegalArgumentException(String.format("Argument annotation on %d's argument virtual %s holds negative index", targetParameterIndex, target));
            }
            if (source.getParameterTypes().size() <= argument.value()) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return argument.bindingMechanic().makeBinding((TypeDescription)source.getParameterTypes().get(argument.value()), (TypeDescription)target.getParameterTypes().get(targetParameterIndex), argument.value(), assigner, RuntimeType.Verifier.check(target, targetParameterIndex), source.getParameterOffset(argument.value()));
        }
    }

    public static enum BindingMechanic {
        UNIQUE{

            @Override
            protected MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription sourceType, TypeDescription targetType, int sourceParameterIndex, Assigner assigner, boolean dynamicallyTyped, int parameterOffset) {
                return MethodDelegationBinder.ParameterBinding.Unique.of(new StackManipulation.Compound(MethodVariableAccess.forType(sourceType).loadFromIndex(parameterOffset), assigner.assign(sourceType, targetType, dynamicallyTyped)), new ArgumentTypeResolver.ParameterIndexToken(sourceParameterIndex));
            }
        }
        ,
        ANONYMOUS{

            @Override
            protected MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription sourceType, TypeDescription targetType, int sourceParameterIndex, Assigner assigner, boolean dynamicallyTyped, int parameterOffset) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(new StackManipulation.Compound(MethodVariableAccess.forType(sourceType).loadFromIndex(parameterOffset), assigner.assign(sourceType, targetType, dynamicallyTyped)));
            }
        };


        protected abstract MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription var1, TypeDescription var2, int var3, Assigner var4, boolean var5, int var6);
    }
}

