/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.IgnoreForBinding;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.RuntimeType;
import net.bytebuddy.instrumentation.method.bytecode.stack.Removal;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class TargetMethodAnnotationDrivenBinder
implements MethodDelegationBinder {
    private final DelegationProcessor delegationProcessor;
    private final DefaultsProvider defaultsProvider;
    private final TerminationHandler terminationHandler;
    private final Assigner assigner;
    private final MethodDelegationBinder.MethodInvoker methodInvoker;

    public TargetMethodAnnotationDrivenBinder(List<ParameterBinder<?>> parameterBinders, DefaultsProvider defaultsProvider, TerminationHandler terminationHandler, Assigner assigner, MethodDelegationBinder.MethodInvoker methodInvoker) {
        this.delegationProcessor = new DelegationProcessor(parameterBinders);
        this.defaultsProvider = defaultsProvider;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.methodInvoker = methodInvoker;
    }

    @Override
    public MethodDelegationBinder.MethodBinding bind(Instrumentation.Target instrumentationTarget, MethodDescription source, MethodDescription target) {
        if (IgnoreForBinding.Verifier.check(target)) {
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        StackManipulation methodTermination = this.terminationHandler.resolve(this.assigner, source, target);
        if (!methodTermination.isValid()) {
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        MethodDelegationBinder.MethodBinding.Builder methodDelegationBindingBuilder = new MethodDelegationBinder.MethodBinding.Builder(this.methodInvoker, target);
        Iterator<AnnotationDescription> defaults = this.defaultsProvider.makeIterator(instrumentationTarget, source, target);
        for (int targetParameterIndex = 0; targetParameterIndex < target.getParameterTypes().size(); ++targetParameterIndex) {
            MethodDelegationBinder.ParameterBinding<?> parameterBinding = this.delegationProcessor.handler(target.getParameterAnnotations().get(targetParameterIndex), defaults).bind(targetParameterIndex, source, target, instrumentationTarget, this.assigner);
            if (parameterBinding.isValid() && methodDelegationBindingBuilder.append(parameterBinding)) continue;
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        return methodDelegationBindingBuilder.build(methodTermination);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TargetMethodAnnotationDrivenBinder that = (TargetMethodAnnotationDrivenBinder)other;
        return this.assigner.equals(that.assigner) && this.defaultsProvider.equals(that.defaultsProvider) && this.terminationHandler.equals(that.terminationHandler) && this.delegationProcessor.equals(that.delegationProcessor) && this.methodInvoker.equals(that.methodInvoker);
    }

    public int hashCode() {
        int result = this.delegationProcessor.hashCode();
        result = 31 * result + this.defaultsProvider.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.methodInvoker.hashCode();
        return result;
    }

    public String toString() {
        return "TargetMethodAnnotationDrivenBinder{delegationProcessor=" + this.delegationProcessor + ", defaultsProvider=" + this.defaultsProvider + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", methodInvoker=" + this.methodInvoker + '}';
    }

    private static class DelegationProcessor {
        private final Map<TypeDescription, ParameterBinder<?>> parameterBinders;

        private DelegationProcessor(List<ParameterBinder<?>> parameterBinders) {
            HashMap parameterBinderMap = new HashMap();
            for (ParameterBinder<?> parameterBinder : parameterBinders) {
                if (parameterBinderMap.put(new TypeDescription.ForLoadedType(parameterBinder.getHandledType()), parameterBinder) == null) continue;
                throw new IllegalArgumentException("Attempt to bind two handlers to " + parameterBinder.getHandledType());
            }
            this.parameterBinders = Collections.unmodifiableMap(parameterBinderMap);
        }

        private Handler handler(List<AnnotationDescription> annotations, Iterator<AnnotationDescription> defaults) {
            Handler handler = null;
            for (AnnotationDescription annotation : annotations) {
                ParameterBinder<?> parameterBinder = this.parameterBinders.get(annotation.getAnnotationType());
                if (parameterBinder != null && handler != null) {
                    throw new IllegalStateException("Ambiguous binding for parameter annotated with two handled annotation types");
                }
                if (parameterBinder == null) continue;
                handler = this.makeHandler(parameterBinder, annotation);
            }
            if (handler == null) {
                if (defaults.hasNext()) {
                    AnnotationDescription defaultAnnotation = defaults.next();
                    ParameterBinder<?> parameterBinder = this.parameterBinders.get(defaultAnnotation.getAnnotationType());
                    if (parameterBinder == null) {
                        return Handler.Unbound.INSTANCE;
                    }
                    handler = this.makeHandler(parameterBinder, defaultAnnotation);
                } else {
                    return Handler.Unbound.INSTANCE;
                }
            }
            return handler;
        }

        private Handler makeHandler(ParameterBinder<?> parameterBinder, AnnotationDescription annotation) {
            return new Handler.Bound(parameterBinder, annotation.prepare(parameterBinder.getHandledType()));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.parameterBinders.equals(((DelegationProcessor)other).parameterBinders);
        }

        public int hashCode() {
            return this.parameterBinders.hashCode();
        }

        public String toString() {
            return "TargetMethodAnnotationDrivenBinder.DelegationProcessor{parameterBinders=" + this.parameterBinders + '}';
        }

        private static interface Handler {
            public MethodDelegationBinder.ParameterBinding<?> bind(int var1, MethodDescription var2, MethodDescription var3, Instrumentation.Target var4, Assigner var5);

            public static class Bound<T extends Annotation>
            implements Handler {
                private final ParameterBinder<T> parameterBinder;
                private final AnnotationDescription.Loadable<T> annotation;

                public Bound(ParameterBinder<T> parameterBinder, AnnotationDescription.Loadable<T> annotation) {
                    this.parameterBinder = parameterBinder;
                    this.annotation = annotation;
                }

                @Override
                public MethodDelegationBinder.ParameterBinding<?> bind(int targetParameterIndex, MethodDescription source, MethodDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
                    return this.parameterBinder.bind(this.annotation, targetParameterIndex, source, target, instrumentationTarget, assigner);
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DelegationProcessor.Handler.Bound{parameterBinder=" + this.parameterBinder + ", annotation=" + this.annotation + '}';
                }
            }

            public static enum Unbound implements Handler
            {
                INSTANCE;


                @Override
                public MethodDelegationBinder.ParameterBinding<?> bind(int targetParameterIndex, MethodDescription source, MethodDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
                    return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                }
            }
        }
    }

    public static interface TerminationHandler {
        public StackManipulation resolve(Assigner var1, MethodDescription var2, MethodDescription var3);

        public static enum Dropping implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(Assigner assigner, MethodDescription source, MethodDescription target) {
                return Removal.pop(target.isConstructor() ? target.getDeclaringType() : target.getReturnType());
            }
        }

        public static enum Returning implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(Assigner assigner, MethodDescription source, MethodDescription target) {
                return new StackManipulation.Compound(assigner.assign(target.isConstructor() ? target.getDeclaringType() : target.getReturnType(), source.getReturnType(), RuntimeType.Verifier.check(target)), MethodReturn.returning(source.getReturnType()));
            }
        }
    }

    public static interface DefaultsProvider {
        public Iterator<AnnotationDescription> makeIterator(Instrumentation.Target var1, MethodDescription var2, MethodDescription var3);

        public static enum Empty implements DefaultsProvider
        {
            INSTANCE;


            @Override
            public Iterator<AnnotationDescription> makeIterator(Instrumentation.Target instrumentationTarget, MethodDescription source, MethodDescription target) {
                return EmptyIterator.INSTANCE;
            }

            private static enum EmptyIterator implements Iterator<AnnotationDescription>
            {
                INSTANCE;


                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public AnnotationDescription next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new NoSuchElementException();
                }
            }
        }
    }

    public static interface ParameterBinder<T extends Annotation> {
        public Class<T> getHandledType();

        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<T> var1, int var2, MethodDescription var3, MethodDescription var4, Instrumentation.Target var5, Assigner var6);
    }
}

