/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.pool;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.type.PackageDescription;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.FilterableList;
import net.bytebuddy.utility.PropertyDispatcher;

public interface TypePool {
    public Resolution describe(String var1);

    public void clear();

    public static class LazyTypeDescription
    extends TypeDescription.AbstractTypeDescription.OfSimpleType {
        private final TypePool typePool;
        private final int modifiers;
        private final String name;
        private final String superTypeName;
        private final String[] interfaceInternalName;
        private final DeclarationContext declarationContext;
        private final boolean anonymousType;
        private final List<AnnotationDescription> declaredAnnotations;
        private final List<FieldDescription> declaredFields;
        private final List<MethodDescription> declaredMethods;
        private final String genericSignature;

        protected LazyTypeDescription(TypePool typePool, int modifiers, String name, String superTypeName, String genericSignature, String[] interfaceName, DeclarationContext declarationContext, boolean anonymousType, List<AnnotationToken> annotationTokens, List<FieldToken> fieldTokens, List<MethodToken> methodTokens) {
            this.typePool = typePool;
            this.modifiers = modifiers;
            this.name = name.replace('/', '.');
            this.superTypeName = superTypeName == null ? null : superTypeName.replace('/', '.');
            this.interfaceInternalName = interfaceName;
            this.declarationContext = declarationContext;
            this.anonymousType = anonymousType;
            this.declaredAnnotations = new ArrayList<AnnotationDescription>(annotationTokens.size());
            for (AnnotationToken annotationToken : annotationTokens) {
                this.declaredAnnotations.add(annotationToken.toAnnotationDescription(typePool));
            }
            this.declaredFields = new ArrayList<FieldDescription>(fieldTokens.size());
            for (FieldToken fieldToken : fieldTokens) {
                this.declaredFields.add(fieldToken.toFieldDescription(this));
            }
            this.declaredMethods = new ArrayList<MethodDescription>(methodTokens.size());
            for (MethodToken methodToken : methodTokens) {
                this.declaredMethods.add(methodToken.toMethodDescription(this));
            }
            this.genericSignature = genericSignature;
        }

        @Override
        public TypeDescription getSupertype() {
            return this.superTypeName == null || this.isInterface() ? null : this.typePool.describe(this.superTypeName).resolve();
        }

        @Override
        public TypeList getInterfaces() {
            return (TypeList)((Object)(this.interfaceInternalName == null ? new TypeList.Empty() : new LazyTypeList(this.interfaceInternalName)));
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return this.declarationContext.getEnclosingMethod(this.typePool);
        }

        @Override
        public TypeDescription getEnclosingType() {
            return this.declarationContext.getEnclosingType(this.typePool);
        }

        @Override
        public String getCanonicalName() {
            return this.name.replace('$', '.');
        }

        @Override
        public boolean isAnonymousClass() {
            return this.anonymousType;
        }

        @Override
        public boolean isLocalClass() {
            return !this.anonymousType && this.declarationContext.isDeclaredInMethod();
        }

        @Override
        public boolean isMemberClass() {
            return this.declarationContext.isDeclaredInType();
        }

        @Override
        public FieldList getDeclaredFields() {
            return new FieldList.Explicit(this.declaredFields);
        }

        @Override
        public MethodList getDeclaredMethods() {
            return new MethodList.Explicit(this.declaredMethods);
        }

        @Override
        public PackageDescription getPackage() {
            String packageName = this.getPackageName();
            return packageName == null ? null : new LazyPackageDescription(packageName);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declarationContext.isDeclaredInType() ? this.declarationContext.getEnclosingType(this.typePool) : null;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }

        @Override
        public String getGenericSignature() {
            return this.genericSignature;
        }

        protected class LazyTypeList
        extends FilterableList.AbstractBase<TypeDescription, TypeList>
        implements TypeList {
            private final String[] name;
            private final String[] internalName;
            private final int stackSize;

            protected LazyTypeList(String methodDescriptor) {
                Type[] parameterType = Type.getArgumentTypes(methodDescriptor);
                this.name = new String[parameterType.length];
                this.internalName = new String[parameterType.length];
                int index = 0;
                int stackSize = 0;
                for (Type aParameterType : parameterType) {
                    this.name[index] = aParameterType.getSort() == 9 ? aParameterType.getInternalName().replace('/', '.') : aParameterType.getClassName();
                    this.internalName[index] = aParameterType.getSort() == 9 ? aParameterType.getInternalName().replace('/', '.') : aParameterType.getClassName();
                    stackSize += aParameterType.getSize();
                    ++index;
                }
                this.stackSize = stackSize;
            }

            protected LazyTypeList(String[] internalName) {
                this.name = new String[internalName.length];
                this.internalName = internalName;
                int index = 0;
                for (String anInternalName : internalName) {
                    this.name[index++] = anInternalName.replace('/', '.');
                }
                this.stackSize = index;
            }

            @Override
            public TypeDescription get(int index) {
                return LazyTypeDescription.this.typePool.describe(this.name[index]).resolve();
            }

            @Override
            public int size() {
                return this.name.length;
            }

            @Override
            public String[] toInternalNames() {
                return this.internalName.length == 0 ? null : this.internalName;
            }

            @Override
            public int getStackSize() {
                return this.stackSize;
            }

            @Override
            protected TypeList wrap(List<TypeDescription> values) {
                return new TypeList.Explicit(values);
            }
        }

        private class LazyPackageDescription
        extends PackageDescription.AbstractPackageDescription {
            private static final String PACKAGE_INFO = ".package-info";
            private final String name;

            private LazyPackageDescription(String name) {
                this.name = name;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                Resolution resolution = LazyTypeDescription.this.typePool.describe(this.name + PACKAGE_INFO);
                return resolution.isResolved() ? resolution.resolve().getDeclaredAnnotations() : new AnnotationList.Empty();
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean isSealed() {
                return false;
            }
        }

        private class LazyMethodDescription
        extends MethodDescription.AbstractMethodDescription {
            private final int modifiers;
            private final String internalName;
            private final String returnTypeName;
            private final String genericSignature;
            private final TypeList parameterTypes;
            private final TypeList exceptionTypes;
            private final List<AnnotationDescription> declaredAnnotations;
            private final List<List<AnnotationDescription>> declaredParameterAnnotations;
            private final AnnotationValue<?, ?> defaultValue;

            private LazyMethodDescription(int modifiers, String internalName, String methodDescriptor, String genericSignature, String[] exceptionInternalName, List<AnnotationToken> annotationTokens, Map<Integer, List<AnnotationToken>> parameterAnnotationTokens, AnnotationValue<?, ?> defaultValue) {
                this.modifiers = modifiers;
                this.internalName = internalName;
                Type returnType = Type.getReturnType(methodDescriptor);
                this.returnTypeName = returnType.getSort() == 9 ? returnType.getDescriptor().replace('/', '.') : returnType.getClassName();
                this.parameterTypes = new LazyTypeList(methodDescriptor);
                this.genericSignature = genericSignature;
                this.exceptionTypes = (TypeList)((Object)(exceptionInternalName == null ? new TypeList.Empty() : new LazyTypeList(exceptionInternalName)));
                this.declaredAnnotations = new ArrayList<AnnotationDescription>(annotationTokens.size());
                for (AnnotationToken annotationToken : annotationTokens) {
                    this.declaredAnnotations.add(annotationToken.toAnnotationDescription(LazyTypeDescription.this.typePool));
                }
                this.declaredParameterAnnotations = new ArrayList<List<AnnotationDescription>>(this.parameterTypes.size());
                for (int index = 0; index < this.parameterTypes.size(); ++index) {
                    List<AnnotationToken> tokens = parameterAnnotationTokens.get(index);
                    ArrayList<AnnotationDescription> annotationDescriptions = new ArrayList<AnnotationDescription>(tokens.size());
                    for (AnnotationToken annotationToken : tokens) {
                        annotationDescriptions.add(annotationToken.toAnnotationDescription(LazyTypeDescription.this.typePool));
                    }
                    this.declaredParameterAnnotations.add(annotationDescriptions);
                }
                this.defaultValue = defaultValue;
            }

            @Override
            public TypeDescription getReturnType() {
                return LazyTypeDescription.this.typePool.describe(this.returnTypeName).resolve();
            }

            @Override
            public TypeList getParameterTypes() {
                return this.parameterTypes;
            }

            @Override
            public TypeList getExceptionTypes() {
                return this.exceptionTypes;
            }

            @Override
            public boolean isConstructor() {
                return this.internalName.equals("<init>");
            }

            @Override
            public boolean isTypeInitializer() {
                return false;
            }

            @Override
            public List<AnnotationList> getParameterAnnotations() {
                return AnnotationList.Explicit.asList(this.declaredParameterAnnotations);
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Explicit(this.declaredAnnotations);
            }

            @Override
            public boolean represents(Method method) {
                return this.equals(new MethodDescription.ForLoadedMethod(method));
            }

            @Override
            public boolean represents(Constructor<?> constructor) {
                return this.equals(new MethodDescription.ForLoadedConstructor(constructor));
            }

            @Override
            public String getInternalName() {
                return this.internalName;
            }

            @Override
            public TypeDescription getDeclaringType() {
                return LazyTypeDescription.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }

            @Override
            public Object getDefaultValue() {
                return this.defaultValue == null ? null : this.defaultValue.resolve(LazyTypeDescription.this.typePool);
            }

            @Override
            public String getGenericSignature() {
                return this.genericSignature;
            }
        }

        private class LazyFieldDescription
        extends FieldDescription.AbstractFieldDescription {
            private final int modifiers;
            private final String name;
            private final String fieldTypeName;
            private final String genericSignature;
            private final List<AnnotationDescription> declaredAnnotations;

            private LazyFieldDescription(int modifiers, String name, String descriptor, String genericSignature, List<AnnotationToken> annotationTokens) {
                this.modifiers = modifiers;
                this.name = name;
                Type fieldType = Type.getType(descriptor);
                this.fieldTypeName = fieldType.getSort() == 9 ? fieldType.getInternalName().replace('/', '.') : fieldType.getClassName();
                this.genericSignature = genericSignature;
                this.declaredAnnotations = new ArrayList<AnnotationDescription>(annotationTokens.size());
                for (AnnotationToken annotationToken : annotationTokens) {
                    this.declaredAnnotations.add(annotationToken.toAnnotationDescription(LazyTypeDescription.this.typePool));
                }
            }

            @Override
            public TypeDescription getFieldType() {
                return LazyTypeDescription.this.typePool.describe(this.fieldTypeName).resolve();
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Explicit(this.declaredAnnotations);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public TypeDescription getDeclaringType() {
                return LazyTypeDescription.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }

            @Override
            public String getGenericSignature() {
                return this.genericSignature;
            }
        }

        private static class LazyAnnotationDescription
        extends AnnotationDescription.AbstractAnnotationDescription {
            protected final TypePool typePool;
            protected final Map<String, AnnotationValue<?, ?>> values;
            private final String descriptor;

            private LazyAnnotationDescription(TypePool typePool, String descriptor, Map<String, AnnotationValue<?, ?>> values) {
                this.typePool = typePool;
                this.descriptor = descriptor;
                this.values = values;
            }

            @Override
            public Object getValue(MethodDescription methodDescription) {
                Object value;
                if (!methodDescription.getDeclaringType().getDescriptor().equals(this.descriptor)) {
                    throw new IllegalArgumentException(methodDescription + " is not declared by " + this.getAnnotationType());
                }
                AnnotationValue<?, ?> annotationValue = this.values.get(methodDescription.getName());
                Object object = value = annotationValue == null ? ((MethodDescription)((MethodList)this.getAnnotationType().getDeclaredMethods().filter(ElementMatchers.is(methodDescription))).getOnly()).getDefaultValue() : annotationValue.resolve(this.typePool);
                if (value == null) {
                    throw new IllegalStateException(methodDescription + " is not defined on annotation");
                }
                return PropertyDispatcher.of(value.getClass()).conditionalClone(value);
            }

            @Override
            public TypeDescription getAnnotationType() {
                return this.typePool.describe(this.descriptor.substring(1, this.descriptor.length() - 1).replace('/', '.')).resolve();
            }

            public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
                return new Loadable(this.typePool, this.descriptor, this.values, annotationType);
            }

            private static class Loadable<S extends Annotation>
            extends LazyAnnotationDescription
            implements AnnotationDescription.Loadable<S> {
                private final Class<S> annotationType;

                private Loadable(TypePool typePool, String descriptor, Map<String, AnnotationValue<?, ?>> values, Class<S> annotationType) {
                    super(typePool, descriptor, values);
                    if (!Type.getDescriptor(annotationType).equals(descriptor)) {
                        throw new IllegalArgumentException(annotationType + " does not correspond to " + descriptor);
                    }
                    this.annotationType = annotationType;
                }

                @Override
                public S load() throws ClassNotFoundException {
                    return this.load(this.annotationType.getClassLoader());
                }

                @Override
                public S load(ClassLoader classLoader) throws ClassNotFoundException {
                    return (S)((Annotation)Proxy.newProxyInstance(classLoader, new Class[]{this.annotationType}, (InvocationHandler)new AnnotationInvocationHandler(this.annotationType.getClassLoader(), this.annotationType, this.values)));
                }

                @Override
                public S loadSilent() {
                    try {
                        return this.load();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Could not load a type that is linked by the annotation value", e);
                    }
                }

                @Override
                public S loadSilent(ClassLoader classLoader) {
                    try {
                        return this.load(classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Could not load a type that is linked by the annotation value", e);
                    }
                }
            }
        }

        protected static class MethodToken {
            private final int modifiers;
            private final String name;
            private final String descriptor;
            private final String genericSignature;
            private final String[] exceptionName;
            private final List<AnnotationToken> annotationTokens;
            private final Map<Integer, List<AnnotationToken>> parameterAnnotationTokens;
            private final AnnotationValue<?, ?> defaultValue;

            protected MethodToken(int modifiers, String name, String descriptor, String genericSignature, String[] exceptionName, List<AnnotationToken> annotationTokens, Map<Integer, List<AnnotationToken>> parameterAnnotationTokens, AnnotationValue<?, ?> defaultValue) {
                this.modifiers = modifiers;
                this.name = name;
                this.descriptor = descriptor;
                this.genericSignature = genericSignature;
                this.exceptionName = exceptionName;
                this.annotationTokens = annotationTokens;
                this.parameterAnnotationTokens = parameterAnnotationTokens;
                this.defaultValue = defaultValue;
            }

            protected int getModifiers() {
                return this.modifiers;
            }

            protected String getName() {
                return this.name;
            }

            protected String getDescriptor() {
                return this.descriptor;
            }

            protected String getGenericSignature() {
                return this.genericSignature;
            }

            protected String[] getExceptionName() {
                return this.exceptionName;
            }

            protected List<AnnotationToken> getAnnotationTokens() {
                return this.annotationTokens;
            }

            protected Map<Integer, List<AnnotationToken>> getParameterAnnotationTokens() {
                return this.parameterAnnotationTokens;
            }

            protected AnnotationValue<?, ?> getDefaultValue() {
                return this.defaultValue;
            }

            private MethodDescription toMethodDescription(LazyTypeDescription lazyTypeDescription) {
                LazyTypeDescription lazyTypeDescription2 = lazyTypeDescription;
                lazyTypeDescription2.getClass();
                return lazyTypeDescription2.new LazyMethodDescription(this.getModifiers(), this.getName(), this.getDescriptor(), this.getGenericSignature(), this.getExceptionName(), this.getAnnotationTokens(), this.getParameterAnnotationTokens(), this.getDefaultValue());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null) return false;
                if (this.getClass() != other.getClass()) {
                    return false;
                }
                MethodToken that = (MethodToken)other;
                if (this.modifiers != that.modifiers) return false;
                if (!this.annotationTokens.equals(that.annotationTokens)) return false;
                if (!this.defaultValue.equals(that.defaultValue)) return false;
                if (!this.descriptor.equals(that.descriptor)) return false;
                if (this.genericSignature != null) {
                    if (!this.genericSignature.equals(that.genericSignature)) {
                        return false;
                    }
                } else if (that.genericSignature != null) return false;
                if (!Arrays.equals(this.exceptionName, that.exceptionName)) return false;
                if (!this.name.equals(that.name)) return false;
                if (!this.parameterAnnotationTokens.equals(that.parameterAnnotationTokens)) return false;
                return true;
            }

            public int hashCode() {
                int result = this.modifiers;
                result = 31 * result + this.name.hashCode();
                result = 31 * result + this.descriptor.hashCode();
                result = 31 * result + (this.genericSignature != null ? this.genericSignature.hashCode() : 0);
                result = 31 * result + Arrays.hashCode(this.exceptionName);
                result = 31 * result + this.annotationTokens.hashCode();
                result = 31 * result + this.parameterAnnotationTokens.hashCode();
                result = 31 * result + this.defaultValue.hashCode();
                return result;
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.MethodToken{modifiers=" + this.modifiers + ", name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + ", genericSignature='" + this.genericSignature + '\'' + ", exceptionName=" + Arrays.toString(this.exceptionName) + ", annotationTokens=" + this.annotationTokens + ", parameterAnnotationTokens=" + this.parameterAnnotationTokens + ", defaultValue=" + this.defaultValue + '}';
            }
        }

        protected static class FieldToken {
            private final int modifiers;
            private final String name;
            private final String descriptor;
            private final String genericSignature;
            private final List<AnnotationToken> annotationTokens;

            protected FieldToken(int modifiers, String name, String descriptor, String genericSignature, List<AnnotationToken> annotationTokens) {
                this.modifiers = modifiers;
                this.name = name;
                this.descriptor = descriptor;
                this.genericSignature = genericSignature;
                this.annotationTokens = annotationTokens;
            }

            protected int getModifiers() {
                return this.modifiers;
            }

            protected String getName() {
                return this.name;
            }

            protected String getDescriptor() {
                return this.descriptor;
            }

            protected String getGenericSignature() {
                return this.genericSignature;
            }

            protected List<AnnotationToken> getAnnotationTokens() {
                return this.annotationTokens;
            }

            private FieldDescription toFieldDescription(LazyTypeDescription lazyTypeDescription) {
                LazyTypeDescription lazyTypeDescription2 = lazyTypeDescription;
                lazyTypeDescription2.getClass();
                return lazyTypeDescription2.new LazyFieldDescription(this.getModifiers(), this.getName(), this.getDescriptor(), this.getGenericSignature(), this.getAnnotationTokens());
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                FieldToken that = (FieldToken)other;
                return this.modifiers == that.modifiers && this.annotationTokens.equals(that.annotationTokens) && this.descriptor.equals(that.descriptor) && !(this.genericSignature == null ? that.genericSignature != null : !this.genericSignature.equals(that.genericSignature)) && this.name.equals(that.name);
            }

            public int hashCode() {
                int result = this.modifiers;
                result = 31 * result + this.name.hashCode();
                result = 31 * result + this.descriptor.hashCode();
                result = 31 * result + (this.genericSignature != null ? this.genericSignature.hashCode() : 0);
                result = 31 * result + this.annotationTokens.hashCode();
                return result;
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.FieldToken{modifiers=" + this.modifiers + ", name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + ", genericSignature='" + this.genericSignature + '\'' + ", annotationTokens=" + this.annotationTokens + '}';
            }
        }

        protected static class AnnotationToken {
            private final String descriptor;
            private final Map<String, AnnotationValue<?, ?>> values;

            protected AnnotationToken(String descriptor, Map<String, AnnotationValue<?, ?>> values) {
                this.descriptor = descriptor;
                this.values = values;
            }

            public String getDescriptor() {
                return this.descriptor;
            }

            public Map<String, AnnotationValue<?, ?>> getValues() {
                return this.values;
            }

            private AnnotationDescription toAnnotationDescription(TypePool typePool) {
                return new LazyAnnotationDescription(typePool, this.descriptor, this.values);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                AnnotationToken that = (AnnotationToken)other;
                return this.descriptor.equals(that.descriptor) && this.values.equals(that.values);
            }

            public int hashCode() {
                int result = this.descriptor.hashCode();
                result = 31 * result + this.values.hashCode();
                return result;
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.AnnotationToken{descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
            }
        }

        protected static class AnnotationInvocationHandler
        implements InvocationHandler {
            private static final String HASH_CODE = "hashCode";
            private static final String EQUALS = "equals";
            private static final String TO_STRING = "toString";
            private final ClassLoader classLoader;
            private final Class<? extends Annotation> annotationType;
            private final LinkedHashMap<Method, AnnotationValue.Loaded<?>> values;

            public AnnotationInvocationHandler(ClassLoader classLoader, Class<? extends Annotation> annotationType, Map<String, AnnotationValue<?, ?>> values) throws ClassNotFoundException {
                this.classLoader = classLoader;
                this.annotationType = annotationType;
                Method[] declaredMethod = annotationType.getDeclaredMethods();
                this.values = new LinkedHashMap(declaredMethod.length);
                TypeDescription.ForLoadedType thisType = new TypeDescription.ForLoadedType(this.getClass());
                for (Method method : declaredMethod) {
                    AnnotationValue<?, ?> annotationValue;
                    if (!new MethodDescription.ForLoadedMethod(method).isVisibleTo(thisType)) {
                        method.setAccessible(true);
                    }
                    this.values.put(method, (annotationValue = values.get(method.getName())) == null ? DefaultValue.of(method) : annotationValue.load(classLoader));
                }
            }

            private static Class<?> asWrapper(Class<?> type) {
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        return Boolean.class;
                    }
                    if (type == Byte.TYPE) {
                        return Byte.class;
                    }
                    if (type == Short.TYPE) {
                        return Short.class;
                    }
                    if (type == Character.TYPE) {
                        return Character.class;
                    }
                    if (type == Integer.TYPE) {
                        return Integer.class;
                    }
                    if (type == Long.TYPE) {
                        return Long.class;
                    }
                    if (type == Float.TYPE) {
                        return Float.class;
                    }
                    if (type == Double.TYPE) {
                        return Double.class;
                    }
                }
                return type;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] arguments) {
                if (method.getDeclaringClass() != this.annotationType) {
                    if (method.getName().equals(HASH_CODE)) {
                        return this.hashCodeRepresentation();
                    }
                    if (method.getName().equals(EQUALS) && method.getParameterTypes().length == 1) {
                        return this.equalsRepresentation(proxy, arguments[0]);
                    }
                    if (method.getName().equals(TO_STRING)) {
                        return this.toStringRepresentation();
                    }
                    return this.annotationType;
                }
                Object value = this.values.get(method).resolve();
                if (!AnnotationInvocationHandler.asWrapper(method.getReturnType()).isAssignableFrom(value.getClass())) {
                    throw new AnnotationTypeMismatchException(method, value.getClass().toString());
                }
                return value;
            }

            protected String toStringRepresentation() {
                StringBuilder toString = new StringBuilder();
                toString.append('@');
                toString.append(this.annotationType.getName());
                toString.append('(');
                boolean firstMember = true;
                for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                    if (!entry.getValue().getState().isDefined()) continue;
                    if (firstMember) {
                        firstMember = false;
                    } else {
                        toString.append(", ");
                    }
                    toString.append(entry.getKey().getName());
                    toString.append('=');
                    toString.append(entry.getValue().toString());
                }
                toString.append(')');
                return toString.toString();
            }

            private int hashCodeRepresentation() {
                int hashCode = 0;
                for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                    if (!entry.getValue().getState().isDefined()) continue;
                    hashCode += 127 * entry.getKey().getName().hashCode() ^ entry.getValue().hashCode();
                }
                return hashCode;
            }

            private boolean equalsRepresentation(Object self, Object other) {
                Object invocationHandler;
                if (self == other) {
                    return true;
                }
                if (!this.annotationType.isInstance(other)) {
                    return false;
                }
                if (Proxy.isProxyClass(other.getClass()) && (invocationHandler = Proxy.getInvocationHandler(other)) instanceof AnnotationInvocationHandler) {
                    return invocationHandler.equals(this);
                }
                try {
                    for (Map.Entry entry : this.values.entrySet()) {
                        if (((AnnotationValue.Loaded)entry.getValue()).getState().isResolved()) {
                            try {
                                if (PropertyDispatcher.of(((Method)entry.getKey()).getReturnType()).equals(((AnnotationValue.Loaded)entry.getValue()).resolve(), ((Method)entry.getKey()).invoke(other, new Object[0]))) continue;
                                return false;
                            }
                            catch (RuntimeException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                }
                catch (InvocationTargetException ignored) {
                    return false;
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                return true;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AnnotationInvocationHandler)) {
                    return false;
                }
                AnnotationInvocationHandler that = (AnnotationInvocationHandler)other;
                if (!this.annotationType.equals(that.annotationType)) {
                    return false;
                }
                for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                    AnnotationValue.Loaded<?> value = that.values.get(entry.getKey());
                    if (PropertyDispatcher.of(value.getClass()).equals(value, entry.getValue())) continue;
                    return false;
                }
                return true;
            }

            public int hashCode() {
                int result = this.annotationType.hashCode();
                result = 31 * result + this.values.hashCode();
                for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                    result = 31 * result + PropertyDispatcher.of(entry.getValue().getClass()).hashCode(entry.getValue());
                }
                return result;
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.AnnotationInvocationHandler{annotationType=" + this.annotationType + ", classLoader=" + this.classLoader + ", values=" + this.values + '}';
            }

            private static class Missing
            implements AnnotationValue.Loaded<Void> {
                private final Class<? extends Annotation> annotationType;
                private final String property;

                private Missing(Class<? extends Annotation> annotationType, String property) {
                    this.annotationType = annotationType;
                    this.property = property;
                }

                @Override
                public AnnotationValue.Loaded.State getState() {
                    return AnnotationValue.Loaded.State.NON_DEFINED;
                }

                @Override
                public Void resolve() {
                    throw new IncompleteAnnotationException(this.annotationType, this.property);
                }
            }

            protected static class DefaultValue
            implements AnnotationValue.Loaded<Object> {
                private final Object defaultValue;
                private final PropertyDispatcher propertyDispatcher;

                private DefaultValue(Object defaultValue) {
                    this.defaultValue = defaultValue;
                    this.propertyDispatcher = PropertyDispatcher.of(defaultValue.getClass());
                }

                protected static AnnotationValue.Loaded<?> of(Method method) {
                    Object defaultValue = method.getDefaultValue();
                    return defaultValue == null ? new Missing(method.getDeclaringClass(), method.getName()) : new DefaultValue(defaultValue);
                }

                @Override
                public AnnotationValue.Loaded.State getState() {
                    return AnnotationValue.Loaded.State.RESOLVED;
                }

                @Override
                public Object resolve() {
                    return this.propertyDispatcher.conditionalClone(this.defaultValue);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AnnotationValue.Loaded)) {
                        return false;
                    }
                    AnnotationValue.Loaded loaded = (AnnotationValue.Loaded)other;
                    return loaded.getState().isResolved() && this.propertyDispatcher.equals(this.defaultValue, loaded.resolve());
                }

                public int hashCode() {
                    return this.propertyDispatcher.hashCode(this.defaultValue);
                }

                public String toString() {
                    return this.propertyDispatcher.toString(this.defaultValue);
                }
            }
        }

        protected static interface AnnotationValue<T, S> {
            public T resolve(TypePool var1);

            public Loaded<S> load(ClassLoader var1) throws ClassNotFoundException;

            public static class ForComplexArray
            implements AnnotationValue<Object[], Object[]> {
                private final ComponentTypeReference componentTypeReference;
                private List<AnnotationValue<?, ?>> value;

                public ForComplexArray(ComponentTypeReference componentTypeReference, List<AnnotationValue<?, ?>> value) {
                    this.value = value;
                    this.componentTypeReference = componentTypeReference;
                }

                @Override
                public Object[] resolve(TypePool typePool) {
                    Class componentType;
                    TypeDescription componentTypeDescription = typePool.describe(this.componentTypeReference.lookup()).resolve();
                    if (componentTypeDescription.represents(Class.class)) {
                        componentType = TypeDescription.class;
                    } else if (componentTypeDescription.isAssignableTo(Enum.class)) {
                        componentType = AnnotationDescription.EnumerationValue.class;
                    } else if (componentTypeDescription.isAssignableTo(Annotation.class)) {
                        componentType = AnnotationDescription.class;
                    } else if (componentTypeDescription.represents(String.class)) {
                        componentType = String.class;
                    } else {
                        throw new IllegalStateException("Unexpected complex array component type " + componentTypeDescription);
                    }
                    Object[] array = (Object[])Array.newInstance(componentType, this.value.size());
                    int index = 0;
                    for (AnnotationValue<?, ?> annotationValue : this.value) {
                        Array.set(array, index++, annotationValue.resolve(typePool));
                    }
                    return array;
                }

                @Override
                public net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<Object[]> load(ClassLoader classLoader) throws ClassNotFoundException {
                    ArrayList loadedValues = new ArrayList(this.value.size());
                    for (AnnotationValue<?, ?> value : this.value) {
                        loadedValues.add(value.load(classLoader));
                    }
                    return new Loaded(classLoader.loadClass(this.componentTypeReference.lookup()), loadedValues);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.componentTypeReference.equals(((ForComplexArray)other).componentTypeReference) && this.value.equals(((ForComplexArray)other).value);
                }

                public int hashCode() {
                    return 31 * this.value.hashCode() + this.componentTypeReference.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.AnnotationValue.ForComplexArray{value=" + this.value + ", componentTypeReference=" + this.componentTypeReference + '}';
                }

                protected static class Loaded
                implements net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<Object[]> {
                    private final Class<?> componentType;
                    private final List<net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<?>> values;

                    public Loaded(Class<?> componentType, List<net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<?>> values) {
                        this.componentType = componentType;
                        this.values = values;
                    }

                    @Override
                    public Loaded.State getState() {
                        for (net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<?> value : this.values) {
                            if (value.getState().isResolved()) continue;
                            return Loaded.State.NON_RESOLVED;
                        }
                        return Loaded.State.RESOLVED;
                    }

                    @Override
                    public Object[] resolve() {
                        Object[] array = (Object[])Array.newInstance(this.componentType, this.values.size());
                        int index = 0;
                        for (net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<?> annotationValue : this.values) {
                            Array.set(array, index++, annotationValue.resolve());
                        }
                        return array;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded)) {
                            return false;
                        }
                        net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded loadedOther = (net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded)other;
                        if (!loadedOther.getState().isResolved()) {
                            return false;
                        }
                        Object otherValue = loadedOther.resolve();
                        if (!(otherValue instanceof Object[])) {
                            return false;
                        }
                        Object[] otherArrayValue = (Object[])otherValue;
                        if (this.values.size() != otherArrayValue.length) {
                            return false;
                        }
                        Iterator<net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<?>> iterator = this.values.iterator();
                        for (Object value : otherArrayValue) {
                            net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<?> self = iterator.next();
                            if (self.getState().isResolved() && self.resolve().equals(value)) continue;
                            return false;
                        }
                        return true;
                    }

                    public int hashCode() {
                        int result = 1;
                        for (net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<?> value : this.values) {
                            result = 31 * result + value.hashCode();
                        }
                        return result;
                    }

                    public String toString() {
                        StringBuilder stringBuilder = new StringBuilder("[");
                        for (net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<?> value : this.values) {
                            stringBuilder.append(value.toString());
                        }
                        return stringBuilder.append("]").toString();
                    }
                }

                public static interface ComponentTypeReference {
                    public String lookup();
                }
            }

            public static class ForType
            implements AnnotationValue<TypeDescription, Class<?>> {
                private static final boolean NO_INITIALIZATION = false;
                private final String name;

                public ForType(Type type) {
                    this.name = type.getSort() == 9 ? type.getInternalName().replace('/', '.') : type.getClassName();
                }

                @Override
                public TypeDescription resolve(TypePool typePool) {
                    return typePool.describe(this.name).resolve();
                }

                @Override
                public net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<Class<?>> load(ClassLoader classLoader) throws ClassNotFoundException {
                    return new Loaded(Class.forName(this.name, false, classLoader));
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((ForType)other).name);
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.AnnotationValue.ForType{name='" + this.name + '\'' + '}';
                }

                protected static class Loaded
                implements net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<Class<?>> {
                    private final Class<?> type;

                    public Loaded(Class<?> type) {
                        this.type = type;
                    }

                    @Override
                    public Loaded.State getState() {
                        return Loaded.State.RESOLVED;
                    }

                    @Override
                    public Class<?> resolve() {
                        return this.type;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded)) {
                            return false;
                        }
                        net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded loadedOther = (net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded)other;
                        return loadedOther.getState().isResolved() && this.type.equals(loadedOther.resolve());
                    }

                    public int hashCode() {
                        return this.type.hashCode();
                    }

                    public String toString() {
                        return this.type.toString();
                    }
                }
            }

            public static class ForEnumeration
            implements AnnotationValue<AnnotationDescription.EnumerationValue, Enum<?>> {
                private final String descriptor;
                private final String value;

                public ForEnumeration(String descriptor, String value) {
                    this.descriptor = descriptor;
                    this.value = value;
                }

                @Override
                public AnnotationDescription.EnumerationValue resolve(TypePool typePool) {
                    return new LazyEnumerationValue(typePool);
                }

                @Override
                public Loaded<Enum<?>> load(ClassLoader classLoader) throws ClassNotFoundException {
                    Class<?> enumType = classLoader.loadClass(this.descriptor.substring(1, this.descriptor.length() - 1).replace('/', '.'));
                    try {
                        return enumType.isEnum() ? new LegalRuntimeEnumeration((Enum<?>)Enum.valueOf(enumType, this.value)) : new IncompatibleRuntimeType(enumType);
                    }
                    catch (IllegalArgumentException ignored) {
                        return new UnknownRuntimeEnumeration(enumType, this.value);
                    }
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.descriptor.equals(((ForEnumeration)other).descriptor) && this.value.equals(((ForEnumeration)other).value);
                }

                public int hashCode() {
                    return 31 * this.descriptor.hashCode() + this.value.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.AnnotationValue.ForEnumeration{descriptor='" + this.descriptor + '\'' + ", value='" + this.value + '\'' + '}';
                }

                protected class LazyEnumerationValue
                extends AnnotationDescription.EnumerationValue.AbstractEnumerationValue {
                    private final TypePool typePool;

                    protected LazyEnumerationValue(TypePool typePool) {
                        this.typePool = typePool;
                    }

                    @Override
                    public String getValue() {
                        return ForEnumeration.this.value;
                    }

                    @Override
                    public TypeDescription getEnumerationType() {
                        return this.typePool.describe(ForEnumeration.this.descriptor.substring(1, ForEnumeration.this.descriptor.length() - 1).replace('/', '.')).resolve();
                    }

                    @Override
                    public <T extends Enum<T>> T load(Class<T> type) {
                        return Enum.valueOf(type, ForEnumeration.this.value);
                    }
                }

                protected static class IncompatibleRuntimeType
                implements Loaded<Enum<?>> {
                    private final Class<?> type;

                    public IncompatibleRuntimeType(Class<?> type) {
                        this.type = type;
                    }

                    @Override
                    public Loaded.State getState() {
                        return Loaded.State.NON_RESOLVED;
                    }

                    @Override
                    public Enum<?> resolve() {
                        throw new IncompatibleClassChangeError("Not an enumeration type: " + this.type.toString());
                    }
                }

                protected static class UnknownRuntimeEnumeration
                implements Loaded<Enum<?>> {
                    private final Class<? extends Enum<?>> enumType;
                    private final String value;

                    public UnknownRuntimeEnumeration(Class<? extends Enum<?>> enumType, String value) {
                        this.enumType = enumType;
                        this.value = value;
                    }

                    @Override
                    public Loaded.State getState() {
                        return Loaded.State.NON_RESOLVED;
                    }

                    @Override
                    public Enum<?> resolve() {
                        throw new EnumConstantNotPresentException(this.enumType, this.value);
                    }
                }

                protected static class LegalRuntimeEnumeration
                implements Loaded<Enum<?>> {
                    private final Enum<?> value;

                    public LegalRuntimeEnumeration(Enum<?> value) {
                        this.value = value;
                    }

                    @Override
                    public Loaded.State getState() {
                        return Loaded.State.RESOLVED;
                    }

                    @Override
                    public Enum<?> resolve() {
                        return this.value;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof Loaded)) {
                            return false;
                        }
                        Loaded loadedOther = (Loaded)other;
                        return loadedOther.getState().isResolved() && this.value.equals(loadedOther.resolve());
                    }

                    public int hashCode() {
                        return this.value.hashCode();
                    }

                    public String toString() {
                        return this.value.toString();
                    }
                }
            }

            public static class ForAnnotation
            implements AnnotationValue<AnnotationDescription, Annotation> {
                private final AnnotationToken annotationToken;

                public ForAnnotation(AnnotationToken annotationToken) {
                    this.annotationToken = annotationToken;
                }

                @Override
                public AnnotationDescription resolve(TypePool typePool) {
                    return this.annotationToken.toAnnotationDescription(typePool);
                }

                @Override
                public Loaded<Annotation> load(ClassLoader classLoader) throws ClassNotFoundException {
                    Class<?> type = classLoader.loadClass(this.annotationToken.getDescriptor().substring(1, this.annotationToken.getDescriptor().length() - 1).replace('/', '.'));
                    return type.isAnnotation() ? new LegalRuntimeType(classLoader, type, this.annotationToken.getValues()) : new IncompatibleRuntimeType(type);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.annotationToken.equals(((ForAnnotation)other).annotationToken);
                }

                public int hashCode() {
                    return this.annotationToken.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.AnnotationValue.ForAnnotation{annotationToken=" + this.annotationToken + '}';
                }

                protected static class IncompatibleRuntimeType
                implements Loaded<Annotation> {
                    private final Class<?> incompatibleType;

                    public IncompatibleRuntimeType(Class<?> incompatibleType) {
                        this.incompatibleType = incompatibleType;
                    }

                    @Override
                    public Loaded.State getState() {
                        return Loaded.State.NON_RESOLVED;
                    }

                    @Override
                    public Annotation resolve() {
                        throw new IncompatibleClassChangeError("Not an annotation type: " + this.incompatibleType.toString());
                    }
                }

                protected static class LegalRuntimeType
                implements Loaded<Annotation> {
                    private final Annotation annotation;

                    public LegalRuntimeType(ClassLoader classLoader, Class<? extends Annotation> annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) throws ClassNotFoundException {
                        this.annotation = (Annotation)Proxy.newProxyInstance(classLoader, new Class[]{annotationType}, (InvocationHandler)new AnnotationInvocationHandler(classLoader, annotationType, annotationValues));
                    }

                    @Override
                    public Loaded.State getState() {
                        return Loaded.State.RESOLVED;
                    }

                    @Override
                    public Annotation resolve() {
                        return this.annotation;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof Loaded)) {
                            return false;
                        }
                        Loaded loadedOther = (Loaded)other;
                        return loadedOther.getState().isResolved() && this.annotation.equals(loadedOther.resolve());
                    }

                    public int hashCode() {
                        return this.annotation.hashCode();
                    }

                    public String toString() {
                        return this.annotation.toString();
                    }
                }
            }

            public static class Trivial<U>
            implements AnnotationValue<U, U> {
                private final U value;
                private final PropertyDispatcher propertyDispatcher;

                public Trivial(U value) {
                    this.value = value;
                    this.propertyDispatcher = PropertyDispatcher.of(value.getClass());
                }

                @Override
                public U resolve(TypePool typePool) {
                    return this.value;
                }

                @Override
                public net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<U> load(ClassLoader classLoader) {
                    return new Loaded<U>(this.value, this.propertyDispatcher);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.propertyDispatcher.equals(this.value, ((Trivial)other).value);
                }

                public int hashCode() {
                    return this.propertyDispatcher.hashCode(this.value);
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.AnnotationValue.Trivial{value=" + this.value + ", propertyDispatcher=" + (Object)((Object)this.propertyDispatcher) + '}';
                }

                protected static class Loaded<V>
                implements net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded<V> {
                    private final V value;
                    private final PropertyDispatcher propertyDispatcher;

                    protected Loaded(V value, PropertyDispatcher propertyDispatcher) {
                        this.value = value;
                        this.propertyDispatcher = propertyDispatcher;
                    }

                    @Override
                    public Loaded.State getState() {
                        return Loaded.State.RESOLVED;
                    }

                    @Override
                    public V resolve() {
                        return this.propertyDispatcher.conditionalClone(this.value);
                    }

                    public int hashCode() {
                        return this.propertyDispatcher.hashCode(this.value);
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded)) {
                            return false;
                        }
                        net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded loadedOther = (net.bytebuddy.pool.TypePool$LazyTypeDescription$AnnotationValue$Loaded)other;
                        return loadedOther.getState().isResolved() && this.propertyDispatcher.equals(this.value, loadedOther.resolve());
                    }

                    public String toString() {
                        return this.propertyDispatcher.toString(this.value);
                    }
                }
            }

            public static interface Loaded<U> {
                public State getState();

                public U resolve();

                public static enum State {
                    NON_DEFINED,
                    NON_RESOLVED,
                    RESOLVED;


                    public boolean isDefined() {
                        return this != NON_DEFINED;
                    }

                    public boolean isResolved() {
                        return this == RESOLVED;
                    }
                }
            }
        }

        protected static interface DeclarationContext {
            public MethodDescription getEnclosingMethod(TypePool var1);

            public TypeDescription getEnclosingType(TypePool var1);

            public boolean isSelfDeclared();

            public boolean isDeclaredInType();

            public boolean isDeclaredInMethod();

            public static class DeclaredInMethod
            implements DeclarationContext {
                private final String name;
                private final String methodName;
                private final String methodDescriptor;

                public DeclaredInMethod(String internalName, String methodName, String methodDescriptor) {
                    this.name = internalName.replace('/', '.');
                    this.methodName = methodName;
                    this.methodDescriptor = methodDescriptor;
                }

                @Override
                public MethodDescription getEnclosingMethod(TypePool typePool) {
                    return (MethodDescription)((MethodList)this.getEnclosingType(typePool).getDeclaredMethods().filter(("<init>".equals(this.methodName) ? ElementMatchers.isConstructor() : ElementMatchers.named(this.methodName)).and(ElementMatchers.hasDescriptor(this.methodDescriptor)))).getOnly();
                }

                @Override
                public TypeDescription getEnclosingType(TypePool typePool) {
                    return typePool.describe(this.name).resolve();
                }

                @Override
                public boolean isSelfDeclared() {
                    return false;
                }

                @Override
                public boolean isDeclaredInType() {
                    return false;
                }

                @Override
                public boolean isDeclaredInMethod() {
                    return true;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    DeclaredInMethod that = (DeclaredInMethod)other;
                    return this.methodDescriptor.equals(that.methodDescriptor) && this.methodName.equals(that.methodName) && this.name.equals(that.name);
                }

                public int hashCode() {
                    int result = this.name.hashCode();
                    result = 31 * result + this.methodName.hashCode();
                    result = 31 * result + this.methodDescriptor.hashCode();
                    return result;
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.DeclarationContext.DeclaredInMethod{name='" + this.name + '\'' + ", methodName='" + this.methodName + '\'' + ", methodDescriptor='" + this.methodDescriptor + '\'' + '}';
                }
            }

            public static class DeclaredInType
            implements DeclarationContext {
                private final String name;

                public DeclaredInType(String internalName) {
                    this.name = internalName.replace('/', '.');
                }

                @Override
                public MethodDescription getEnclosingMethod(TypePool typePool) {
                    return null;
                }

                @Override
                public TypeDescription getEnclosingType(TypePool typePool) {
                    return typePool.describe(this.name).resolve();
                }

                @Override
                public boolean isSelfDeclared() {
                    return false;
                }

                @Override
                public boolean isDeclaredInType() {
                    return true;
                }

                @Override
                public boolean isDeclaredInMethod() {
                    return false;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((DeclaredInType)other).name);
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.DeclarationContext.DeclaredInType{name='" + this.name + '\'' + '}';
                }
            }

            public static enum SelfDeclared implements DeclarationContext
            {
                INSTANCE;


                @Override
                public MethodDescription getEnclosingMethod(TypePool typePool) {
                    return null;
                }

                @Override
                public TypeDescription getEnclosingType(TypePool typePool) {
                    return null;
                }

                @Override
                public boolean isSelfDeclared() {
                    return true;
                }

                @Override
                public boolean isDeclaredInType() {
                    return false;
                }

                @Override
                public boolean isDeclaredInMethod() {
                    return false;
                }
            }
        }
    }

    public static class Default
    extends AbstractBase {
        private static final int ASM_VERSION = 327680;
        private static final int ASM_MANUAL = 0;
        private final ClassFileLocator classFileLocator;

        public Default(CacheProvider cacheProvider, ClassFileLocator classFileLocator) {
            super(cacheProvider);
            this.classFileLocator = classFileLocator;
        }

        public static TypePool ofClassPath() {
            return new Default(new CacheProvider.Simple(), ClassFileLocator.ForClassLoader.ofClassPath());
        }

        @Override
        protected Resolution doDescribe(String name) {
            try {
                ClassFileLocator.Resolution resolution = this.classFileLocator.locate(name);
                return resolution.isResolved() ? new Resolution.Simple(this.parse(resolution.resolve())) : new Resolution.Illegal(name);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading class file", e);
            }
        }

        private TypeDescription parse(byte[] binaryRepresentation) {
            ClassReader classReader = new ClassReader(binaryRepresentation);
            TypeExtractor typeExtractor = new TypeExtractor();
            classReader.accept(typeExtractor, 0);
            return typeExtractor.toTypeDescription();
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.classFileLocator.equals(((Default)other).classFileLocator);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.classFileLocator.hashCode();
        }

        public String toString() {
            return "TypePool.Default{classFileLocator=" + this.classFileLocator + ", cacheProvider=" + this.cacheProvider + '}';
        }

        protected class TypeExtractor
        extends ClassVisitor {
            private final List<LazyTypeDescription.AnnotationToken> annotationTokens;
            private final List<LazyTypeDescription.FieldToken> fieldTokens;
            private final List<LazyTypeDescription.MethodToken> methodTokens;
            private int modifiers;
            private String internalName;
            private String superTypeName;
            private String genericSignature;
            private String[] interfaceName;
            private boolean anonymousType;
            private LazyTypeDescription.DeclarationContext declarationContext;

            protected TypeExtractor() {
                super(327680);
                this.annotationTokens = new LinkedList<LazyTypeDescription.AnnotationToken>();
                this.fieldTokens = new LinkedList<LazyTypeDescription.FieldToken>();
                this.methodTokens = new LinkedList<LazyTypeDescription.MethodToken>();
                this.anonymousType = false;
                this.declarationContext = LazyTypeDescription.DeclarationContext.SelfDeclared.INSTANCE;
            }

            @Override
            public void visit(int classFileVersion, int modifiers, String internalName, String genericSignature, String superTypeName, String[] interfaceName) {
                this.modifiers = modifiers;
                this.internalName = internalName;
                this.genericSignature = genericSignature;
                this.superTypeName = superTypeName;
                this.interfaceName = interfaceName;
            }

            @Override
            public void visitOuterClass(String typeName, String methodName, String methodDescriptor) {
                if (methodName != null) {
                    this.declarationContext = new LazyTypeDescription.DeclarationContext.DeclaredInMethod(typeName, methodName, methodDescriptor);
                } else if (typeName != null) {
                    this.declarationContext = new LazyTypeDescription.DeclarationContext.DeclaredInType(typeName);
                }
            }

            @Override
            public void visitInnerClass(String internalName, String outerName, String innerName, int modifiers) {
                if (internalName.equals(this.internalName)) {
                    this.modifiers = modifiers;
                    if (innerName == null) {
                        this.anonymousType = true;
                    }
                    if (this.declarationContext.isSelfDeclared()) {
                        this.declarationContext = new LazyTypeDescription.DeclarationContext.DeclaredInType(outerName);
                    }
                }
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return new AnnotationExtractor(new OnTypeCollector(descriptor), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
            }

            @Override
            public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String genericSignature, Object defaultValue) {
                return new FieldExtractor(modifiers, internalName, descriptor, genericSignature);
            }

            @Override
            public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String genericSignature, String[] exceptionName) {
                if (internalName.equals("<clinit>")) {
                    return null;
                }
                return new MethodExtractor(modifiers, internalName, descriptor, genericSignature, exceptionName);
            }

            protected TypeDescription toTypeDescription() {
                return new LazyTypeDescription(Default.this, this.modifiers, this.internalName, this.superTypeName, this.genericSignature, this.interfaceName, this.declarationContext, this.anonymousType, this.annotationTokens, this.fieldTokens, this.methodTokens);
            }

            public String toString() {
                return "TypePool.Default.TypeExtractor{typePool=" + Default.this + ", annotationTokens=" + this.annotationTokens + ", fieldTokens=" + this.fieldTokens + ", methodTokens=" + this.methodTokens + ", modifiers=" + this.modifiers + ", internalName='" + this.internalName + '\'' + ", superTypeName='" + this.superTypeName + '\'' + ", genericSignature='" + this.genericSignature + '\'' + ", interfaceName=" + Arrays.toString(this.interfaceName) + ", anonymousType=" + this.anonymousType + ", declarationContext=" + this.declarationContext + '}';
            }

            protected class MethodExtractor
            extends MethodVisitor
            implements AnnotationRegistrant {
                private final int modifiers;
                private final String internalName;
                private final String descriptor;
                private final String genericSignature;
                private final String[] exceptionName;
                private final List<LazyTypeDescription.AnnotationToken> annotationTokens;
                private final Map<Integer, List<LazyTypeDescription.AnnotationToken>> parameterAnnotationTokens;
                private LazyTypeDescription.AnnotationValue<?, ?> defaultValue;

                protected MethodExtractor(int modifiers, String internalName, String descriptor, String genericSignature, String[] exceptionName) {
                    super(327680);
                    this.modifiers = modifiers;
                    this.internalName = internalName;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.exceptionName = exceptionName;
                    this.annotationTokens = new LinkedList<LazyTypeDescription.AnnotationToken>();
                    this.parameterAnnotationTokens = new HashMap<Integer, List<LazyTypeDescription.AnnotationToken>>();
                    for (int i = 0; i < Type.getMethodType(descriptor).getArgumentTypes().length; ++i) {
                        this.parameterAnnotationTokens.put(i, new LinkedList());
                    }
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return new AnnotationExtractor(new OnMethodCollector(descriptor), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return new AnnotationExtractor(new OnMethodParameterCollector(descriptor, index), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationExtractor(this, new ComponentTypeLocator.ForArrayType(this.descriptor));
                }

                @Override
                public void register(String ignored, LazyTypeDescription.AnnotationValue<?, ?> annotationValue) {
                    this.defaultValue = annotationValue;
                }

                @Override
                public void onComplete() {
                }

                @Override
                public void visitEnd() {
                    TypeExtractor.this.methodTokens.add(new LazyTypeDescription.MethodToken(this.modifiers, this.internalName, this.descriptor, this.genericSignature, this.exceptionName, this.annotationTokens, this.parameterAnnotationTokens, this.defaultValue));
                }

                public String toString() {
                    return "TypePool.Default.TypeExtractor.MethodExtractor{typeExtractor=" + TypeExtractor.this + ", modifiers=" + this.modifiers + ", internalName='" + this.internalName + '\'' + ", descriptor='" + this.descriptor + '\'' + ", genericSignature='" + this.genericSignature + '\'' + ", exceptionName=" + Arrays.toString(this.exceptionName) + ", annotationTokens=" + this.annotationTokens + ", parameterAnnotationTokens=" + this.parameterAnnotationTokens + ", defaultValue=" + this.defaultValue + '}';
                }

                protected class OnMethodParameterCollector
                implements AnnotationRegistrant {
                    private final String descriptor;
                    private final int index;
                    private final Map<String, LazyTypeDescription.AnnotationValue<?, ?>> values;

                    protected OnMethodParameterCollector(String descriptor, int index) {
                        this.descriptor = descriptor;
                        this.index = index;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, LazyTypeDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        ((List)MethodExtractor.this.parameterAnnotationTokens.get(this.index)).add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.MethodExtractor.OnMethodParameterCollector{methodExtractor=" + MethodExtractor.this + ", descriptor='" + this.descriptor + '\'' + ", index=" + this.index + ", values=" + this.values + '}';
                    }
                }

                protected class OnMethodCollector
                implements AnnotationRegistrant {
                    private final String descriptor;
                    private final Map<String, LazyTypeDescription.AnnotationValue<?, ?>> values;

                    protected OnMethodCollector(String descriptor) {
                        this.descriptor = descriptor;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, LazyTypeDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        MethodExtractor.this.annotationTokens.add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.MethodExtractor.OnMethodCollector{methodExtractor=" + MethodExtractor.this + ", descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
                    }
                }
            }

            protected class FieldExtractor
            extends FieldVisitor {
                private final int modifiers;
                private final String internalName;
                private final String descriptor;
                private final String genericSignature;
                private final List<LazyTypeDescription.AnnotationToken> annotationTokens;

                protected FieldExtractor(int modifiers, String internalName, String descriptor, String genericSignature) {
                    super(327680);
                    this.modifiers = modifiers;
                    this.internalName = internalName;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.annotationTokens = new LinkedList<LazyTypeDescription.AnnotationToken>();
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return new AnnotationExtractor(new OnFieldCollector(descriptor), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public void visitEnd() {
                    TypeExtractor.this.fieldTokens.add(new LazyTypeDescription.FieldToken(this.modifiers, this.internalName, this.descriptor, this.genericSignature, this.annotationTokens));
                }

                public String toString() {
                    return "TypePool.Default.TypeExtractor.FieldExtractor{typeExtractor=" + TypeExtractor.this + ", modifiers=" + this.modifiers + ", internalName='" + this.internalName + '\'' + ", descriptor='" + this.descriptor + '\'' + ", genericSignature='" + this.genericSignature + '\'' + ", annotationTokens=" + this.annotationTokens + '}';
                }

                protected class OnFieldCollector
                implements AnnotationRegistrant {
                    private final String descriptor;
                    private final Map<String, LazyTypeDescription.AnnotationValue<?, ?>> values;

                    protected OnFieldCollector(String descriptor) {
                        this.descriptor = descriptor;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, LazyTypeDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        FieldExtractor.this.annotationTokens.add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.FieldExtractor.OnFieldCollector{fieldExtractor=" + FieldExtractor.this + ", descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
                    }
                }
            }

            protected class AnnotationExtractor
            extends AnnotationVisitor {
                private final AnnotationRegistrant annotationRegistrant;
                private final ComponentTypeLocator componentTypeLocator;

                protected AnnotationExtractor(AnnotationRegistrant annotationRegistrant, ComponentTypeLocator componentTypeLocator) {
                    super(327680);
                    this.annotationRegistrant = annotationRegistrant;
                    this.componentTypeLocator = componentTypeLocator;
                }

                @Override
                public void visit(String name, Object value) {
                    LazyTypeDescription.AnnotationValue<TypeDescription, Class<?>> annotationValue = value instanceof Type ? new LazyTypeDescription.AnnotationValue.ForType((Type)value) : (value.getClass().isArray() ? new LazyTypeDescription.AnnotationValue.Trivial<Object>(value) : new LazyTypeDescription.AnnotationValue.Trivial<Object>(value));
                    this.annotationRegistrant.register(name, annotationValue);
                }

                @Override
                public void visitEnum(String name, String descriptor, String value) {
                    this.annotationRegistrant.register(name, new LazyTypeDescription.AnnotationValue.ForEnumeration(descriptor, value));
                }

                @Override
                public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                    return new AnnotationExtractor(new AnnotationLookup(name, descriptor), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitArray(String name) {
                    return new AnnotationExtractor(new ArrayLookup(name, this.componentTypeLocator.bind(name)), ComponentTypeLocator.Illegal.INSTANCE);
                }

                @Override
                public void visitEnd() {
                    this.annotationRegistrant.onComplete();
                }

                public String toString() {
                    return "TypePool.Default.TypeExtractor.AnnotationExtractor{typeExtractor=" + TypeExtractor.this + "annotationRegistrant=" + this.annotationRegistrant + ", componentTypeLocator=" + this.componentTypeLocator + '}';
                }

                protected class AnnotationLookup
                implements AnnotationRegistrant {
                    private final String name;
                    private final String descriptor;
                    private final Map<String, LazyTypeDescription.AnnotationValue<?, ?>> values;

                    protected AnnotationLookup(String name, String descriptor) {
                        this.name = name;
                        this.descriptor = descriptor;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, LazyTypeDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        AnnotationExtractor.this.annotationRegistrant.register(this.name, new LazyTypeDescription.AnnotationValue.ForAnnotation(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values)));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.AnnotationExtractor.AnnotationLookup{annotationExtractor=" + AnnotationExtractor.this + ", name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
                    }
                }

                protected class ArrayLookup
                implements AnnotationRegistrant {
                    private final String name;
                    private final LazyTypeDescription.AnnotationValue.ForComplexArray.ComponentTypeReference componentTypeReference;
                    private final List<LazyTypeDescription.AnnotationValue<?, ?>> values;

                    protected ArrayLookup(String name, LazyTypeDescription.AnnotationValue.ForComplexArray.ComponentTypeReference componentTypeReference) {
                        this.name = name;
                        this.componentTypeReference = componentTypeReference;
                        this.values = new LinkedList();
                    }

                    @Override
                    public void register(String ignored, LazyTypeDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.add(annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        AnnotationExtractor.this.annotationRegistrant.register(this.name, new LazyTypeDescription.AnnotationValue.ForComplexArray(this.componentTypeReference, this.values));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.AnnotationExtractor.ArrayLookup{annotationExtractor=" + AnnotationExtractor.this + ", name='" + this.name + '\'' + ", componentTypeReference=" + this.componentTypeReference + ", values=" + this.values + '}';
                    }
                }
            }

            protected class OnTypeCollector
            implements AnnotationRegistrant {
                private final String descriptor;
                private final Map<String, LazyTypeDescription.AnnotationValue<?, ?>> values;

                protected OnTypeCollector(String descriptor) {
                    this.descriptor = descriptor;
                    this.values = new HashMap();
                }

                @Override
                public void register(String name, LazyTypeDescription.AnnotationValue<?, ?> annotationValue) {
                    this.values.put(name, annotationValue);
                }

                @Override
                public void onComplete() {
                    TypeExtractor.this.annotationTokens.add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                }

                public String toString() {
                    return "TypePool.Default.TypeExtractor.OnTypeCollector{typeExtractor=" + TypeExtractor.this + ", descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
                }
            }
        }

        protected static interface ComponentTypeLocator {
            public LazyTypeDescription.AnnotationValue.ForComplexArray.ComponentTypeReference bind(String var1);

            public static class ForArrayType
            implements ComponentTypeLocator,
            LazyTypeDescription.AnnotationValue.ForComplexArray.ComponentTypeReference {
                private final String componentType;

                public ForArrayType(String methodDescriptor) {
                    String arrayType = Type.getMethodType(methodDescriptor).getReturnType().getClassName();
                    this.componentType = arrayType.substring(0, arrayType.length() - 2);
                }

                @Override
                public LazyTypeDescription.AnnotationValue.ForComplexArray.ComponentTypeReference bind(String name) {
                    return this;
                }

                @Override
                public String lookup() {
                    return this.componentType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.componentType.equals(((ForArrayType)other).componentType);
                }

                public int hashCode() {
                    return this.componentType.hashCode();
                }

                public String toString() {
                    return "TypePool.Default.ComponentTypeLocator.ForArrayType{componentType='" + this.componentType + '\'' + '}';
                }
            }

            public static class ForAnnotationProperty
            implements ComponentTypeLocator {
                private final TypePool typePool;
                private final String annotationName;

                public ForAnnotationProperty(TypePool typePool, String annotationDescriptor) {
                    this.typePool = typePool;
                    this.annotationName = annotationDescriptor.substring(1, annotationDescriptor.length() - 1).replace('/', '.');
                }

                @Override
                public LazyTypeDescription.AnnotationValue.ForComplexArray.ComponentTypeReference bind(String name) {
                    return new Bound(name);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.annotationName.equals(((ForAnnotationProperty)other).annotationName) && this.typePool.equals(((ForAnnotationProperty)other).typePool);
                }

                public int hashCode() {
                    int result = this.typePool.hashCode();
                    result = 31 * result + this.annotationName.hashCode();
                    return result;
                }

                public String toString() {
                    return "TypePool.Default.ComponentTypeLocator.ForAnnotationProperty{typePool=" + this.typePool + ", annotationName='" + this.annotationName + '\'' + '}';
                }

                protected class Bound
                implements LazyTypeDescription.AnnotationValue.ForComplexArray.ComponentTypeReference {
                    private final String name;

                    protected Bound(String name) {
                        this.name = name;
                    }

                    @Override
                    public String lookup() {
                        return ((MethodDescription)((MethodList)ForAnnotationProperty.this.typePool.describe(ForAnnotationProperty.this.annotationName).resolve().getDeclaredMethods().filter(ElementMatchers.named(this.name))).getOnly()).getReturnType().getComponentType().getName();
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Bound)other).name) && ForAnnotationProperty.this.equals(((Bound)other).getOuter());
                    }

                    public int hashCode() {
                        return this.name.hashCode() + 31 * ForAnnotationProperty.this.hashCode();
                    }

                    private ForAnnotationProperty getOuter() {
                        return ForAnnotationProperty.this;
                    }

                    public String toString() {
                        return "TypePool.Default.ComponentTypeLocator.ForAnnotationProperty.Bound{name='" + this.name + '\'' + '}';
                    }
                }
            }

            public static enum Illegal implements ComponentTypeLocator
            {
                INSTANCE;


                @Override
                public LazyTypeDescription.AnnotationValue.ForComplexArray.ComponentTypeReference bind(String name) {
                    throw new IllegalStateException("Unexpected lookup of component type for " + name);
                }
            }
        }

        protected static interface AnnotationRegistrant {
            public void register(String var1, LazyTypeDescription.AnnotationValue<?, ?> var2);

            public void onComplete();
        }
    }

    public static abstract class AbstractBase
    implements TypePool {
        protected static final Map<String, TypeDescription> PRIMITIVE_TYPES;
        protected static final Map<String, String> PRIMITIVE_DESCRIPTORS;
        private static final String ARRAY_SYMBOL = "[";
        protected final CacheProvider cacheProvider;

        protected AbstractBase(CacheProvider cacheProvider) {
            this.cacheProvider = cacheProvider;
        }

        @Override
        public Resolution describe(String name) {
            TypeDescription typeDescription;
            Resolution resolution;
            if (name.contains("/")) {
                throw new IllegalArgumentException(name + " contains the illegal character '/'");
            }
            int arity = 0;
            while (name.startsWith(ARRAY_SYMBOL)) {
                ++arity;
                name = name.substring(1);
            }
            if (arity > 0) {
                String primitiveName = PRIMITIVE_DESCRIPTORS.get(name);
                name = primitiveName == null ? name.substring(1, name.length() - 1) : primitiveName;
            }
            Resolution resolution2 = resolution = (typeDescription = PRIMITIVE_TYPES.get(name)) == null ? this.cacheProvider.find(name) : new Resolution.Simple(typeDescription);
            if (resolution == null) {
                resolution = this.cacheProvider.register(name, this.doDescribe(name));
            }
            return ArrayTypeResolution.of(resolution, arity);
        }

        @Override
        public void clear() {
            this.cacheProvider.clear();
        }

        protected abstract Resolution doDescribe(String var1);

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.cacheProvider.equals(((AbstractBase)other).cacheProvider);
        }

        public int hashCode() {
            return this.cacheProvider.hashCode();
        }

        static {
            HashMap<String, TypeDescription.ForLoadedType> primitiveTypes = new HashMap<String, TypeDescription.ForLoadedType>();
            HashMap<String, String> primitiveDescriptors = new HashMap<String, String>();
            for (Class primitiveType : new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE}) {
                primitiveTypes.put(primitiveType.getName(), new TypeDescription.ForLoadedType(primitiveType));
                primitiveDescriptors.put(Type.getDescriptor(primitiveType), primitiveType.getName());
            }
            PRIMITIVE_TYPES = Collections.unmodifiableMap(primitiveTypes);
            PRIMITIVE_DESCRIPTORS = Collections.unmodifiableMap(primitiveDescriptors);
        }

        protected static class ArrayTypeResolution
        implements Resolution {
            private final Resolution resolution;
            private final int arity;

            protected ArrayTypeResolution(Resolution resolution, int arity) {
                this.resolution = resolution;
                this.arity = arity;
            }

            protected static Resolution of(Resolution resolution, int arity) {
                return arity == 0 ? resolution : new ArrayTypeResolution(resolution, arity);
            }

            @Override
            public boolean isResolved() {
                return this.resolution.isResolved();
            }

            @Override
            public TypeDescription resolve() {
                return TypeDescription.ArrayProjection.of(this.resolution.resolve(), this.arity);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.arity == ((ArrayTypeResolution)other).arity && this.resolution.equals(((ArrayTypeResolution)other).resolution);
            }

            public int hashCode() {
                int result = this.resolution.hashCode();
                result = 31 * result + this.arity;
                return result;
            }

            public String toString() {
                return "TypePool.AbstractBase.ArrayTypeResolution{resolution=" + this.resolution + ", arity=" + this.arity + '}';
            }
        }
    }

    public static interface CacheProvider {
        public Resolution find(String var1);

        public Resolution register(String var1, Resolution var2);

        public void clear();

        public static class Simple
        implements CacheProvider {
            private final ConcurrentMap<String, Resolution> cache = new ConcurrentHashMap<String, Resolution>();

            @Override
            public Resolution find(String name) {
                return (Resolution)this.cache.get(name);
            }

            @Override
            public Resolution register(String name, Resolution resolution) {
                Resolution cached = this.cache.putIfAbsent(name, resolution);
                return cached == null ? resolution : cached;
            }

            @Override
            public void clear() {
                this.cache.clear();
            }

            public String toString() {
                return "TypePool.CacheProvider.Simple{cache=" + this.cache + '}';
            }
        }

        public static enum NoOp implements CacheProvider
        {
            INSTANCE;


            @Override
            public Resolution find(String name) {
                return null;
            }

            @Override
            public Resolution register(String name, Resolution resolution) {
                return resolution;
            }

            @Override
            public void clear() {
            }
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public TypeDescription resolve();

        public static class Illegal
        implements Resolution {
            private final String name;

            public Illegal(String name) {
                this.name = name;
            }

            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public TypeDescription resolve() {
                throw new IllegalStateException("Cannot resolve type description for " + this.name);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Illegal)other).name);
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public String toString() {
                return "TypePool.Resolution.Illegal{name='" + this.name + '\'' + '}';
            }
        }

        public static class Simple
        implements Resolution {
            private final TypeDescription typeDescription;

            public Simple(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            public TypeDescription resolve() {
                return this.typeDescription;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((Simple)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "TypePool.Resolution.Simple{typeDescription=" + this.typeDescription + '}';
            }
        }
    }
}

