/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.Removal;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.DoubleConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.FloatConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.IntegerConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.LongConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.NullConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.TextConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.RandomString;

public class MethodCall
implements Instrumentation {
    protected final MethodLocator methodLocator;
    protected final TargetHandler targetHandler;
    protected final List<ArgumentLoader> argumentLoaders;
    protected final MethodInvoker methodInvoker;
    protected final TerminationHandler terminationHandler;
    protected final Assigner assigner;
    protected final boolean dynamicallyTyped;

    protected MethodCall(MethodLocator methodLocator, TargetHandler targetHandler, List<ArgumentLoader> argumentLoaders, MethodInvoker methodInvoker, TerminationHandler terminationHandler, Assigner assigner, boolean dynamicallyTyped) {
        this.methodLocator = methodLocator;
        this.targetHandler = targetHandler;
        this.argumentLoaders = argumentLoaders;
        this.methodInvoker = methodInvoker;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.dynamicallyTyped = dynamicallyTyped;
    }

    private static Assigner defaultAssigner() {
        return new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE));
    }

    private static boolean defaultDynamicallyTyped() {
        return false;
    }

    public static WithoutSpecifiedTarget invoke(Method method) {
        return MethodCall.invoke(new MethodDescription.ForLoadedMethod(ByteBuddyCommons.nonNull(method)));
    }

    public static WithoutSpecifiedTarget invoke(Constructor<?> constructor) {
        return MethodCall.invoke(new MethodDescription.ForLoadedConstructor(ByteBuddyCommons.nonNull(constructor)));
    }

    public static WithoutSpecifiedTarget invoke(MethodDescription methodDescription) {
        return MethodCall.invoke(new MethodLocator.ForExplicitMethod(ByteBuddyCommons.nonNull(methodDescription)));
    }

    public static WithoutSpecifiedTarget invoke(MethodLocator methodLocator) {
        return new WithoutSpecifiedTarget(ByteBuddyCommons.nonNull(methodLocator));
    }

    public static MethodCall construct(Constructor<?> constructor) {
        return MethodCall.construct(new MethodDescription.ForLoadedConstructor(ByteBuddyCommons.nonNull(constructor)));
    }

    public static MethodCall construct(MethodDescription methodDescription) {
        if (!methodDescription.isConstructor()) {
            throw new IllegalArgumentException("Not a constructor: " + methodDescription);
        }
        return new MethodCall(new MethodLocator.ForExplicitMethod(methodDescription), TargetHandler.ForConstructingInvocation.INSTANCE, Collections.<ArgumentLoader>emptyList(), MethodInvoker.ForStandardInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, MethodCall.defaultAssigner(), MethodCall.defaultDynamicallyTyped());
    }

    public static MethodCall invokeSuper() {
        return new WithoutSpecifiedTarget(MethodLocator.ForInterceptedMethod.INSTANCE).onSuper();
    }

    public MethodCall with(Object ... argument) {
        ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(argument.length);
        for (Object anArgument : argument) {
            argumentLoaders.add(ArgumentLoader.ForStaticField.of(anArgument));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, ByteBuddyCommons.join(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.dynamicallyTyped);
    }

    public MethodCall withReference(Object ... argument) {
        ArrayList<ArgumentLoader.ForNullConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForNullConstant>(argument.length);
        for (Object anArgument : argument) {
            argumentLoaders.add((ArgumentLoader.ForNullConstant)(anArgument == null ? ArgumentLoader.ForNullConstant.INSTANCE : new ArgumentLoader.ForStaticField(anArgument)));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, ByteBuddyCommons.join(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.dynamicallyTyped);
    }

    public MethodCall withArgument(int ... index) {
        ArrayList<ArgumentLoader.ForMethodParameter> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameter>(index.length);
        for (int anIndex : index) {
            if (anIndex < 0) {
                throw new IllegalArgumentException("Negative index: " + anIndex);
            }
            argumentLoaders.add(new ArgumentLoader.ForMethodParameter(anIndex));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, ByteBuddyCommons.join(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.dynamicallyTyped);
    }

    public MethodCall withThis() {
        return new MethodCall(this.methodLocator, this.targetHandler, ByteBuddyCommons.join(this.argumentLoaders, ArgumentLoader.ForThisReference.INSTANCE), this.methodInvoker, this.terminationHandler, this.assigner, this.dynamicallyTyped);
    }

    public MethodCall withInstanceField(Class<?> type, String name) {
        return this.withInstanceField(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)), name);
    }

    public MethodCall withInstanceField(TypeDescription typeDescription, String name) {
        return new MethodCall(this.methodLocator, this.targetHandler, ByteBuddyCommons.join(this.argumentLoaders, new ArgumentLoader.ForInstanceField(ByteBuddyCommons.nonNull(typeDescription), ByteBuddyCommons.nonNull(name))), this.methodInvoker, this.terminationHandler, this.assigner, this.dynamicallyTyped);
    }

    public MethodCall withField(String ... fieldName) {
        ArrayList<ArgumentLoader.ForExistingField> argumentLoaders = new ArrayList<ArgumentLoader.ForExistingField>(fieldName.length);
        for (String aFieldName : fieldName) {
            argumentLoaders.add(new ArgumentLoader.ForExistingField(aFieldName));
        }
        return new MethodCall(this.methodLocator, this.targetHandler, ByteBuddyCommons.join(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.dynamicallyTyped);
    }

    public MethodCall withAssigner(Assigner assigner, boolean dynamicallyTyped) {
        return new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, this.terminationHandler, ByteBuddyCommons.nonNull(assigner), dynamicallyTyped);
    }

    public Instrumentation andThen(Instrumentation instrumentation) {
        return new Instrumentation.Compound(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, TerminationHandler.ForChainedInvocation.INSTANCE, this.assigner, this.dynamicallyTyped), ByteBuddyCommons.nonNull(instrumentation));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        for (ArgumentLoader argumentLoader : this.argumentLoaders) {
            instrumentedType = argumentLoader.prepare(instrumentedType);
        }
        return this.targetHandler.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
        return new Appender(instrumentationTarget);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodCall)) {
            return false;
        }
        MethodCall that = (MethodCall)other;
        return this.dynamicallyTyped == that.dynamicallyTyped && this.argumentLoaders.equals(that.argumentLoaders) && this.assigner.equals(that.assigner) && this.methodInvoker.equals(that.methodInvoker) && this.methodLocator.equals(that.methodLocator) && this.targetHandler.equals(that.targetHandler) && this.terminationHandler.equals(that.terminationHandler);
    }

    public int hashCode() {
        int result = this.methodLocator.hashCode();
        result = 31 * result + this.targetHandler.hashCode();
        result = 31 * result + this.argumentLoaders.hashCode();
        result = 31 * result + this.methodInvoker.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + (this.dynamicallyTyped ? 1 : 0);
        return result;
    }

    public String toString() {
        return "MethodCall{methodLocator=" + this.methodLocator + ", targetHandler=" + this.targetHandler + ", argumentLoaders=" + this.argumentLoaders + ", methodInvoker=" + this.methodInvoker + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", dynamicallyTyped=" + this.dynamicallyTyped + '}';
    }

    protected class Appender
    implements ByteCodeAppender {
        private final Instrumentation.Target instrumentationTarget;

        protected Appender(Instrumentation.Target instrumentationTarget) {
            this.instrumentationTarget = instrumentationTarget;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            MethodDescription invokedMethod = MethodCall.this.methodLocator.resolve(instrumentedMethod);
            TypeList methodParameters = invokedMethod.getParameterTypes();
            if (methodParameters.size() != MethodCall.this.argumentLoaders.size()) {
                throw new IllegalStateException(invokedMethod + " does not take " + MethodCall.this.argumentLoaders.size() + " arguments");
            }
            int index = 0;
            StackManipulation[] argumentInstruction = new StackManipulation[MethodCall.this.argumentLoaders.size()];
            for (ArgumentLoader argumentLoader : MethodCall.this.argumentLoaders) {
                argumentInstruction[index] = argumentLoader.resolve(this.instrumentationTarget.getTypeDescription(), invokedMethod, (TypeDescription)methodParameters.get(index++), MethodCall.this.assigner, MethodCall.this.dynamicallyTyped);
            }
            StackManipulation.Size size = new StackManipulation.Compound(MethodCall.this.targetHandler.resolve(invokedMethod, this.instrumentationTarget.getTypeDescription()), new StackManipulation.Compound(argumentInstruction), MethodCall.this.methodInvoker.invoke(invokedMethod, this.instrumentationTarget), MethodCall.this.terminationHandler.resolve(invokedMethod, instrumentedMethod, MethodCall.this.assigner, MethodCall.this.dynamicallyTyped)).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        private MethodCall getOuter() {
            return MethodCall.this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender appender = (Appender)other;
            return this.instrumentationTarget.equals(appender.instrumentationTarget) && MethodCall.this.equals(appender.getOuter());
        }

        public int hashCode() {
            return this.instrumentationTarget.hashCode() + 31 * MethodCall.this.hashCode();
        }

        public String toString() {
            return "MethodCall.Appender{methodCall=" + MethodCall.this + ", instrumentationTarget=" + this.instrumentationTarget + '}';
        }
    }

    public static class WithoutSpecifiedTarget
    extends MethodCall {
        protected WithoutSpecifiedTarget(MethodLocator methodLocator) {
            super(methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, Collections.<ArgumentLoader>emptyList(), MethodInvoker.ForStandardInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, MethodCall.defaultAssigner(), MethodCall.defaultDynamicallyTyped());
        }

        public MethodCall on(Object target) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForStaticField(ByteBuddyCommons.nonNull(target)), this.argumentLoaders, MethodInvoker.ForStandardInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.dynamicallyTyped);
        }

        public MethodCall onInstanceField(Class<?> type, String fieldName) {
            return this.onInstanceField(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)), ByteBuddyCommons.nonNull(fieldName));
        }

        public MethodCall onInstanceField(TypeDescription typeDescription, String fieldName) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForInstanceField(ByteBuddyCommons.nonNull(fieldName), ByteBuddyCommons.nonVoid(typeDescription)), this.argumentLoaders, MethodInvoker.ForStandardInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.dynamicallyTyped);
        }

        public MethodCall onSuper() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, this.argumentLoaders, MethodInvoker.ForSuperMethodInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.dynamicallyTyped);
        }

        public MethodCall onDefault() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, this.argumentLoaders, MethodInvoker.ForDefaultMethodInvocation.INSTANCE, TerminationHandler.ForMethodReturn.INSTANCE, this.assigner, this.dynamicallyTyped);
        }

        @Override
        public String toString() {
            return "MethodCall.WithoutSpecifiedTarget{methodLocator=" + this.methodLocator + ", targetHandler=" + this.targetHandler + ", argumentLoaders=" + this.argumentLoaders + ", methodInvoker=" + this.methodInvoker + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", dynamicallyTyped=" + this.dynamicallyTyped + '}';
        }
    }

    protected static interface TerminationHandler {
        public StackManipulation resolve(MethodDescription var1, MethodDescription var2, Assigner var3, boolean var4);

        public static enum ForChainedInvocation implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription interceptedMethod, Assigner assigner, boolean dynamicallyTyped) {
                return Removal.pop(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType() : invokedMethod.getReturnType());
            }
        }

        public static enum ForMethodReturn implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription interceptedMethod, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation stackManipulation = assigner.assign(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType() : invokedMethod.getReturnType(), interceptedMethod.getReturnType(), dynamicallyTyped);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot return " + invokedMethod.getReturnType() + " from " + interceptedMethod);
                }
                return new StackManipulation.Compound(stackManipulation, MethodReturn.returning(interceptedMethod.getReturnType()));
            }
        }
    }

    protected static interface MethodInvoker {
        public StackManipulation invoke(MethodDescription var1, Instrumentation.Target var2);

        public static enum ForDefaultMethodInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription methodDescription, Instrumentation.Target instrumentationTarget) {
                if (!methodDescription.isDefaultMethod()) {
                    throw new IllegalStateException("Not a default method: " + methodDescription);
                }
                Instrumentation.SpecialMethodInvocation stackManipulation = instrumentationTarget.invokeDefault(methodDescription.getDeclaringType(), methodDescription.getUniqueSignature());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + methodDescription + " on " + instrumentationTarget);
                }
                return stackManipulation;
            }
        }

        public static enum ForSuperMethodInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription methodDescription, Instrumentation.Target instrumentationTarget) {
                Instrumentation.SpecialMethodInvocation stackManipulation = instrumentationTarget.invokeSuper(methodDescription, Instrumentation.Target.MethodLookup.Default.EXACT);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + methodDescription + " as a super method");
                }
                return stackManipulation;
            }
        }

        public static enum ForStandardInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription methodDescription, Instrumentation.Target instrumentationTarget) {
                if (!methodDescription.isStatic() && !methodDescription.isInvokableOn(instrumentationTarget.getTypeDescription())) {
                    throw new IllegalStateException("Cannot invoke " + methodDescription + " for " + instrumentationTarget);
                }
                return MethodInvocation.invoke(methodDescription);
            }
        }
    }

    protected static interface ArgumentLoader {
        public StackManipulation resolve(TypeDescription var1, MethodDescription var2, TypeDescription var3, Assigner var4, boolean var5);

        public InstrumentedType prepare(InstrumentedType var1);

        public static class ForTextConstant
        implements ArgumentLoader {
            private final String value;

            public ForTextConstant(String value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new TextConstant(this.value), assigner.assign(new TypeDescription.ForLoadedType(String.class), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign String value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value.equals(((ForTextConstant)other).value);
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForTextConstant{value='" + this.value + '\'' + '}';
            }
        }

        public static class ForDoubleConstant
        implements ArgumentLoader {
            private final double value;

            public ForDoubleConstant(double value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(DoubleConstant.forValue(this.value), assigner.assign(new TypeDescription.ForLoadedType(Double.TYPE), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign double value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Double.compare(((ForDoubleConstant)other).value, this.value) == 0;
            }

            public int hashCode() {
                long temp = Double.doubleToLongBits(this.value);
                return (int)(temp ^ temp >>> 32);
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForDoubleConstant{value=" + this.value + '}';
            }
        }

        public static class ForFloatConstant
        implements ArgumentLoader {
            private final float value;

            public ForFloatConstant(float value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FloatConstant.forValue(this.value), assigner.assign(new TypeDescription.ForLoadedType(Float.TYPE), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign float value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Float.compare(((ForFloatConstant)other).value, this.value) == 0;
            }

            public int hashCode() {
                return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForFloatConstant{value=" + this.value + '}';
            }
        }

        public static class ForLongConstant
        implements ArgumentLoader {
            private final long value;

            public ForLongConstant(long value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(LongConstant.forValue(this.value), assigner.assign(new TypeDescription.ForLoadedType(Long.TYPE), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign long value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForLongConstant)other).value;
            }

            public int hashCode() {
                return (int)(this.value ^ this.value >>> 32);
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForLongConstant{value=" + this.value + '}';
            }
        }

        public static class ForIntegerConstant
        implements ArgumentLoader {
            private final int value;

            public ForIntegerConstant(int value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.ForLoadedType(Integer.TYPE), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign integer value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForIntegerConstant)other).value;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForIntegerConstant{value=" + this.value + '}';
            }
        }

        public static class ForCharacterConstant
        implements ArgumentLoader {
            private final char value;

            public ForCharacterConstant(char value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.ForLoadedType(Character.TYPE), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign char value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForCharacterConstant)other).value;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForCharacterConstant{value=" + this.value + '}';
            }
        }

        public static class ForShortConstant
        implements ArgumentLoader {
            private final short value;

            public ForShortConstant(short value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.ForLoadedType(Short.TYPE), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign short value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForShortConstant)other).value;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForShortConstant{value=" + this.value + '}';
            }
        }

        public static class ForByteConstant
        implements ArgumentLoader {
            private final byte value;

            public ForByteConstant(byte value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.ForLoadedType(Byte.TYPE), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign byte value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForByteConstant)other).value;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForByteConstant{value=" + this.value + '}';
            }
        }

        public static class ForBooleanConstant
        implements ArgumentLoader {
            private final boolean value;

            public ForBooleanConstant(boolean value) {
                this.value = value;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(this.value), assigner.assign(new TypeDescription.ForLoadedType(Boolean.TYPE), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign boolean value to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ForBooleanConstant)other).value;
            }

            public int hashCode() {
                return this.value ? 1 : 0;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForBooleanConstant{value=" + this.value + '}';
            }
        }

        public static class ForExistingField
        implements ArgumentLoader {
            private final String fieldName;

            public ForExistingField(String fieldName) {
                this.fieldName = fieldName;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                TypeDescription currentType = instrumentedType;
                FieldDescription fieldDescription = null;
                do {
                    FieldList fieldList;
                    if ((fieldList = (FieldList)currentType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).size() == 0) continue;
                    fieldDescription = (FieldDescription)fieldList.getOnly();
                } while ((currentType = currentType.getSupertype()) != null && (fieldDescription == null || !fieldDescription.isVisibleTo(instrumentedType)));
                if (fieldDescription == null || !fieldDescription.isVisibleTo(instrumentedType)) {
                    throw new IllegalStateException(instrumentedType + " does not define a visible field " + this.fieldName);
                }
                if (!fieldDescription.isStatic() && interceptedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static " + fieldDescription + " from " + interceptedMethod);
                }
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(fieldDescription.isStatic() ? StackManipulation.LegalTrivial.INSTANCE : MethodVariableAccess.REFERENCE.loadFromIndex(0), FieldAccess.forField(fieldDescription).getter(), assigner.assign(fieldDescription.getFieldType(), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + fieldDescription + " to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForExistingField)other).fieldName);
            }

            public int hashCode() {
                return this.fieldName.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForExistingField{fieldName='" + this.fieldName + '\'' + '}';
            }
        }

        public static class ForInstanceField
        implements ArgumentLoader {
            private static final int MODIFIERS = 4098;
            private final TypeDescription fieldType;
            private final String fieldName;

            public ForInstanceField(TypeDescription fieldType, String fieldName) {
                this.fieldType = fieldType;
                this.fieldName = fieldName;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                if (interceptedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access instance field from static " + interceptedMethod);
                }
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFromIndex(0), FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter(), assigner.assign(this.fieldType, targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign field " + this.fieldName + " of type " + this.fieldType + " to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(this.fieldName, this.fieldType, 4098);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForInstanceField that = (ForInstanceField)other;
                return this.fieldName.equals(that.fieldName) && this.fieldType.equals(that.fieldType);
            }

            public int hashCode() {
                int result = this.fieldType.hashCode();
                result = 31 * result + this.fieldName.hashCode();
                return result;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForInstanceField{fieldType=" + this.fieldType + ", fieldName='" + this.fieldName + '\'' + '}';
            }
        }

        public static class ForStaticField
        implements ArgumentLoader {
            private static final String FIELD_PREFIX = "methodCall";
            private static final int FIELD_MODIFIER = 4106;
            private final Object value;
            private final String fieldName;

            protected ForStaticField(Object value) {
                this.value = value;
                this.fieldName = String.format("%s$%s", FIELD_PREFIX, RandomString.make());
            }

            public static ArgumentLoader of(Object value) {
                if (value == null) {
                    return ForNullConstant.INSTANCE;
                }
                if (value.getClass() == String.class) {
                    return new ForTextConstant((String)value);
                }
                if (value.getClass() == Boolean.class) {
                    return new ForBooleanConstant((Boolean)value);
                }
                if (value.getClass() == Byte.class) {
                    return new ForByteConstant((Byte)value);
                }
                if (value.getClass() == Short.class) {
                    return new ForShortConstant((Short)value);
                }
                if (value.getClass() == Character.class) {
                    return new ForCharacterConstant(((Character)value).charValue());
                }
                if (value.getClass() == Integer.class) {
                    return new ForIntegerConstant((Integer)value);
                }
                if (value.getClass() == Long.class) {
                    return new ForLongConstant((Long)value);
                }
                if (value.getClass() == Float.class) {
                    return new ForFloatConstant(((Float)value).floatValue());
                }
                if (value.getClass() == Double.class) {
                    return new ForDoubleConstant((Double)value);
                }
                return new ForStaticField(value);
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter(), assigner.assign(new TypeDescription.ForLoadedType(this.value.getClass()), targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.value.getClass() + " to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(this.fieldName, new TypeDescription.ForLoadedType(this.value.getClass()), 4106).withInitializer(new LoadedTypeInitializer.ForStaticField<Object>(this.fieldName, this.value, true));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.value.equals(((ForStaticField)other).value);
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForStaticField{value=" + this.value + ", fieldName='" + this.fieldName + '\'' + '}';
            }
        }

        public static class ForMethodParameter
        implements ArgumentLoader {
            private final int index;

            public ForMethodParameter(int index) {
                this.index = index;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                if (this.index >= interceptedMethod.getParameterTypes().size()) {
                    throw new IllegalStateException(interceptedMethod + " does not have a parameter with index " + this.index);
                }
                TypeDescription originType = (TypeDescription)interceptedMethod.getParameterTypes().get(this.index);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.forType(originType).loadFromIndex(interceptedMethod.getParameterOffset(this.index)), assigner.assign(originType, targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + originType + " to " + targetType + " for " + interceptedMethod);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.index == ((ForMethodParameter)other).index;
            }

            public int hashCode() {
                return this.index;
            }

            public String toString() {
                return "MethodCall.ArgumentLoader.ForMethodParameter{index=" + this.index + '}';
            }
        }

        public static enum ForThisReference implements ArgumentLoader
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                if (interceptedMethod.isStatic()) {
                    throw new IllegalStateException(interceptedMethod + " has no instance");
                }
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFromIndex(0), assigner.assign(instrumentedType, targetType, dynamicallyTyped));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + instrumentedType + " to " + targetType);
                }
                return stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }

        public static enum ForNullConstant implements ArgumentLoader
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription interceptedMethod, TypeDescription targetType, Assigner assigner, boolean dynamicallyTyped) {
                if (targetType.isPrimitive()) {
                    throw new IllegalStateException("Cannot assign null to " + targetType);
                }
                return NullConstant.INSTANCE;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }
    }

    protected static interface TargetHandler {
        public StackManipulation resolve(MethodDescription var1, TypeDescription var2);

        public InstrumentedType prepare(InstrumentedType var1);

        public static class ForInstanceField
        implements TargetHandler {
            private static final int FIELD_MODIFIERS = 4098;
            private final String fieldName;
            private final TypeDescription fieldType;

            public ForInstanceField(String fieldName, TypeDescription fieldType) {
                this.fieldName = fieldName;
                this.fieldType = fieldType;
            }

            @Override
            public StackManipulation resolve(MethodDescription methodDescription, TypeDescription instrumentedType) {
                if (methodDescription.isStatic() || !methodDescription.isInvokableOn(this.fieldType)) {
                    throw new IllegalStateException("Cannot invoke " + methodDescription + " on " + this.fieldType);
                }
                return new StackManipulation.Compound(methodDescription.isStatic() ? StackManipulation.LegalTrivial.INSTANCE : MethodVariableAccess.REFERENCE.loadFromIndex(0), FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter());
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(this.fieldName, this.fieldType, 4098);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForInstanceField)other).fieldName) && this.fieldType.equals(((ForInstanceField)other).fieldType);
            }

            public int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + this.fieldType.hashCode();
                return result;
            }

            public String toString() {
                return "MethodCall.TargetHandler.ForInstanceField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
            }
        }

        public static class ForStaticField
        implements TargetHandler {
            private static final String FIELD_PREFIX = "invocationTarget";
            private static final int FIELD_MODIFIERS = 4106;
            private final Object target;
            private final String fieldName;

            public ForStaticField(Object target) {
                this.target = target;
                this.fieldName = String.format("%s$%s", FIELD_PREFIX, RandomString.make());
            }

            @Override
            public StackManipulation resolve(MethodDescription methodDescription, TypeDescription instrumentedType) {
                if (methodDescription.isStatic() || !methodDescription.getDeclaringType().isInstance(this.target)) {
                    throw new IllegalStateException("Cannot invoke " + methodDescription + " on " + this.target);
                }
                return FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter();
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(this.fieldName, new TypeDescription.ForLoadedType(this.target.getClass()), 4106).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.target));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.target.equals(((ForStaticField)other).target);
            }

            public int hashCode() {
                return this.target.hashCode();
            }

            public String toString() {
                return "MethodCall.TargetHandler.ForStaticField{target=" + this.target + ", fieldName='" + this.fieldName + '\'' + '}';
            }
        }

        public static enum ForConstructingInvocation implements TargetHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription methodDescription, TypeDescription instrumentedType) {
                return new StackManipulation.Compound(TypeCreation.forType(methodDescription.getDeclaringType()), Duplication.SINGLE);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }

        public static enum ForSelfOrStaticInvocation implements TargetHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription methodDescription, TypeDescription instrumentedType) {
                return new StackManipulation.Compound(methodDescription.isStatic() ? StackManipulation.LegalTrivial.INSTANCE : MethodVariableAccess.REFERENCE.loadFromIndex(0), (StackManipulation)((Object)(methodDescription.isConstructor() ? Duplication.SINGLE : StackManipulation.LegalTrivial.INSTANCE)));
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }
    }

    public static interface MethodLocator {
        public MethodDescription resolve(MethodDescription var1);

        public static class ForExplicitMethod
        implements MethodLocator {
            private final MethodDescription methodDescription;

            public ForExplicitMethod(MethodDescription methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public MethodDescription resolve(MethodDescription instrumentedMethod) {
                return this.methodDescription;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((ForExplicitMethod)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodCall.MethodLocator.ForExplicitMethod{methodDescription=" + this.methodDescription + '}';
            }
        }

        public static enum ForInterceptedMethod implements MethodLocator
        {
            INSTANCE;


            @Override
            public MethodDescription resolve(MethodDescription instrumentedMethod) {
                return instrumentedMethod;
            }
        }
    }
}

