/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.attribute;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationAppender;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.ClassVisitor;

public interface TypeAttributeAppender {
    public void apply(ClassVisitor var1, TypeDescription var2);

    public static class Compound
    implements TypeAttributeAppender {
        private final TypeAttributeAppender[] typeAttributeAppender;

        public Compound(TypeAttributeAppender ... typeAttributeAppender) {
            this.typeAttributeAppender = typeAttributeAppender;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
            for (TypeAttributeAppender typeAttributeAppender : this.typeAttributeAppender) {
                typeAttributeAppender.apply(classVisitor, typeDescription);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.typeAttributeAppender, ((Compound)other).typeAttributeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeAttributeAppender);
        }

        public String toString() {
            return "TypeAttributeAppender.Compound{typeAttributeAppender=" + Arrays.toString(this.typeAttributeAppender) + '}';
        }
    }

    public static class ForType
    implements TypeAttributeAppender {
        private final TypeDescription typeDescription;

        public ForType(Class<?> type) {
            this.typeDescription = new TypeDescription.ForLoadedType(type);
        }

        public ForType(TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (AnnotationDescription annotation : this.typeDescription.getDeclaredAnnotations()) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForType)other).typeDescription);
        }

        public int hashCode() {
            return this.typeDescription.hashCode();
        }

        public String toString() {
            return "TypeAttributeAppender.ForType{typeDescription=" + this.typeDescription + '}';
        }
    }

    public static class ForAnnotation
    implements TypeAttributeAppender {
        private final AnnotationList annotations;

        public ForAnnotation(Annotation ... annotation) {
            this.annotations = new AnnotationList.ForLoadedAnnotation(annotation);
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (AnnotationDescription annotation : this.annotations) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotations.equals(((ForAnnotation)other).annotations);
        }

        public int hashCode() {
            return this.annotations.hashCode();
        }

        public String toString() {
            return "TypeAttributeAppender.ForAnnotation{annotations=" + this.annotations + '}';
        }
    }

    public static enum ForSuperType implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (AnnotationDescription annotation : typeDescription.getSupertype().getDeclaredAnnotations()) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }
    }

    public static enum NoOp implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
        }
    }
}

