/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.matcher.FilterableList;

public interface MethodList
extends FilterableList<MethodDescription, MethodList> {

    public static class Empty
    extends FilterableList.Empty<MethodDescription, MethodList>
    implements MethodList {
    }

    public static class Explicit
    extends FilterableList.AbstractBase<MethodDescription, MethodList>
    implements MethodList {
        private final List<? extends MethodDescription> methodDescriptions;

        public Explicit(List<? extends MethodDescription> methodDescriptions) {
            this.methodDescriptions = Collections.unmodifiableList(methodDescriptions);
        }

        @Override
        public MethodDescription get(int index) {
            return this.methodDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.methodDescriptions.size();
        }

        @Override
        protected MethodList wrap(List<MethodDescription> values) {
            return new Explicit(values);
        }
    }

    public static class ForLoadedType
    extends FilterableList.AbstractBase<MethodDescription, MethodList>
    implements MethodList {
        private final Method[] methods;
        private final Constructor<?>[] constructors;

        public ForLoadedType(Class<?> type) {
            this.constructors = type.getDeclaredConstructors();
            this.methods = type.getDeclaredMethods();
        }

        public ForLoadedType(Constructor<?>[] constructors, Method[] methods) {
            this.constructors = constructors;
            this.methods = methods;
        }

        @Override
        public MethodDescription get(int index) {
            if (index < this.constructors.length) {
                return new MethodDescription.ForLoadedConstructor(this.constructors[index]);
            }
            return new MethodDescription.ForLoadedMethod(this.methods[index - this.constructors.length]);
        }

        @Override
        public int size() {
            return this.constructors.length + this.methods.length;
        }

        @Override
        protected MethodList wrap(List<MethodDescription> values) {
            return new Explicit(values);
        }
    }
}

