/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.io.Serializable;
import net.bytebuddy.instrumentation.type.TypeDescription;

public enum JavaType {
    METHOD_HANDLE("java.lang.invoke.MethodHandle"){

        @Override
        protected boolean isSubTypeOf(TypeDescription typeDescription) {
            return typeDescription.represents(Object.class);
        }
    }
    ,
    METHOD_TYPE("java.lang.invoke.MethodType"){

        @Override
        protected boolean isSubTypeOf(TypeDescription typeDescription) {
            return typeDescription.represents(Object.class) || typeDescription.represents(Serializable.class);
        }
    }
    ,
    METHOD_TYPES_LOOKUP("java.lang.invoke.MethodHandles$Lookup"){

        @Override
        protected boolean isSubTypeOf(TypeDescription typeDescription) {
            return typeDescription.represents(Object.class);
        }
    }
    ,
    CALL_SITE("java.lang.invoke.CallSite"){

        @Override
        protected boolean isSubTypeOf(TypeDescription typeDescription) {
            return typeDescription.represents(Object.class);
        }
    };

    private final TypeLookup typeLookup;

    private JavaType(String typeName) {
        TypeLookup typeLookup;
        try {
            typeLookup = new TypeLookup.ForLoadedType(Class.forName(typeName));
        }
        catch (Exception ignored) {
            typeLookup = new TypeLookup.ForNamedType(typeName);
        }
        this.typeLookup = typeLookup;
    }

    public boolean isAssignableFrom(TypeDescription typeDescription) {
        return this.typeLookup.isAssignableFrom(typeDescription);
    }

    public boolean isAssignableTo(TypeDescription typeDescription) {
        return this.representedBy(typeDescription) || this.isSubTypeOf(typeDescription);
    }

    protected abstract boolean isSubTypeOf(TypeDescription var1);

    public boolean representedBy(TypeDescription typeDescription) {
        return this.typeLookup.represents(typeDescription);
    }

    public Class<?> load() {
        return this.typeLookup.load();
    }

    protected static interface TypeLookup {
        public boolean isAssignableFrom(TypeDescription var1);

        public boolean represents(TypeDescription var1);

        public Class<?> load();

        public static class ForLoadedType
        implements TypeLookup {
            private final Class<?> type;

            public ForLoadedType(Class<?> type) {
                this.type = type;
            }

            @Override
            public boolean isAssignableFrom(TypeDescription typeDescription) {
                return typeDescription.isAssignableTo(this.type);
            }

            @Override
            public boolean represents(TypeDescription typeDescription) {
                return typeDescription.represents(this.type);
            }

            @Override
            public Class<?> load() {
                return this.type;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.type.equals(((ForLoadedType)other).type);
            }

            public int hashCode() {
                return this.type.hashCode();
            }

            public String toString() {
                return "JavaType.TypeLookup.ForLoadedType{type=" + this.type + '}';
            }
        }

        public static class ForNamedType
        implements TypeLookup {
            private final String typeName;

            public ForNamedType(String typeName) {
                this.typeName = typeName;
            }

            @Override
            public boolean isAssignableFrom(TypeDescription typeDescription) {
                do {
                    if (!typeDescription.getName().equals(this.typeName)) continue;
                    return true;
                } while ((typeDescription = typeDescription.getSupertype()) != null);
                return false;
            }

            @Override
            public boolean represents(TypeDescription typeDescription) {
                return typeDescription.getName().equals(this.typeName);
            }

            @Override
            public Class<?> load() {
                throw new IllegalStateException("Could not load " + this.typeName);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeName.equals(((ForNamedType)other).typeName);
            }

            public int hashCode() {
                return this.typeName.hashCode();
            }

            public String toString() {
                return "JavaType.TypeLookup.ForNamedType{typeName='" + this.typeName + '\'' + '}';
            }
        }
    }
}

