/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.NullConstant;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface MethodRebaseResolver {
    public static final int REBASED_METHOD_MODIFIER = 4098;

    public Resolution resolve(MethodDescription var1);

    public static class Default
    implements MethodRebaseResolver {
        private final ElementMatcher<? super MethodDescription> ignoredMethods;
        private final TypeDescription placeholderType;
        private final MethodNameTransformer methodNameTransformer;

        public Default(ElementMatcher<? super MethodDescription> ignoredMethods, TypeDescription placeholderType, MethodNameTransformer methodNameTransformer) {
            this.ignoredMethods = ignoredMethods;
            this.placeholderType = placeholderType;
            this.methodNameTransformer = methodNameTransformer;
        }

        @Override
        public Resolution resolve(MethodDescription methodDescription) {
            return this.ignoredMethods.matches(methodDescription) ? new Resolution.Preserved(methodDescription) : this.rebase(methodDescription);
        }

        private Resolution rebase(MethodDescription methodDescription) {
            return methodDescription.isConstructor() ? new Resolution.ForRebasedConstructor(methodDescription, this.placeholderType) : new Resolution.ForRebasedMethod(methodDescription, this.methodNameTransformer);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Default aDefault = (Default)other;
            return this.ignoredMethods.equals(aDefault.ignoredMethods) && this.placeholderType.equals(aDefault.placeholderType) && this.methodNameTransformer.equals(aDefault.methodNameTransformer);
        }

        public int hashCode() {
            int result = this.ignoredMethods.hashCode();
            result = 31 * result + this.placeholderType.hashCode();
            result = 31 * result + this.methodNameTransformer.hashCode();
            return result;
        }

        public String toString() {
            return "MethodRebaseResolver.Default{ignoredMethods=" + this.ignoredMethods + ", placeholderType=" + this.placeholderType + ", methodNameTransformer=" + this.methodNameTransformer + '}';
        }
    }

    public static interface Resolution {
        public boolean isRebased();

        public MethodDescription getResolvedMethod();

        public StackManipulation getAdditionalArguments();

        public static class ForRebasedConstructor
        implements Resolution {
            private final MethodDescription methodDescription;

            public ForRebasedConstructor(MethodDescription methodDescription, TypeDescription placeholderType) {
                this.methodDescription = new MethodDescription.Latent(methodDescription.getInternalName(), methodDescription.getDeclaringType(), methodDescription.getReturnType(), ByteBuddyCommons.join(methodDescription.getParameters().asTypeList(), placeholderType), 4098, methodDescription.getExceptionTypes());
            }

            @Override
            public boolean isRebased() {
                return true;
            }

            @Override
            public MethodDescription getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                return NullConstant.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((ForRebasedConstructor)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.Resolution.ForRebasedConstructor{methodDescription=" + this.methodDescription + '}';
            }
        }

        public static class ForRebasedMethod
        implements Resolution {
            private final MethodDescription methodDescription;

            public ForRebasedMethod(MethodDescription methodDescription, MethodNameTransformer methodNameTransformer) {
                this.methodDescription = new MethodDescription.Latent(methodNameTransformer.transform(methodDescription.getInternalName()), methodDescription.getDeclaringType(), methodDescription.getReturnType(), methodDescription.getParameters().asTypeList(), 0x1002 | (methodDescription.isStatic() ? 8 : 0) | (methodDescription.isNative() ? 256 : 0), methodDescription.getExceptionTypes());
            }

            @Override
            public boolean isRebased() {
                return true;
            }

            @Override
            public MethodDescription getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                return StackManipulation.LegalTrivial.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((ForRebasedMethod)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.Resolution.ForRebasedMethod{methodDescription=" + this.methodDescription + '}';
            }
        }

        public static class Preserved
        implements Resolution {
            private final MethodDescription methodDescription;

            public Preserved(MethodDescription methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public boolean isRebased() {
                return false;
            }

            @Override
            public MethodDescription getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                throw new IllegalStateException("A non-rebased method never requires additional arguments");
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((Preserved)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.Resolution.Preserved{methodDescription=" + this.methodDescription + '}';
            }
        }
    }

    public static interface MethodNameTransformer {
        public String transform(String var1);

        public static class Prefixing
        implements MethodNameTransformer {
            private static final String DEFAULT_PREFIX = "original";
            private final String prefix;

            public Prefixing() {
                this(DEFAULT_PREFIX);
            }

            public Prefixing(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public String transform(String originalName) {
                return String.format("%s%s", this.prefix, originalName);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((Prefixing)other).prefix);
            }

            public int hashCode() {
                return this.prefix.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.MethodNameTransformer.Prefixing{prefix='" + this.prefix + '\'' + '}';
            }
        }

        public static class Suffixing
        implements MethodNameTransformer {
            private static final String DEFAULT_SUFFIX = "original";
            private final String suffix;

            public Suffixing() {
                this(DEFAULT_SUFFIX);
            }

            public Suffixing(String suffix) {
                this.suffix = suffix;
            }

            @Override
            public String transform(String originalName) {
                return String.format("%s$%s", originalName, this.suffix);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.suffix.equals(((Suffixing)other).suffix);
            }

            public int hashCode() {
                return this.suffix.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.MethodNameTransformer.Suffixing{suffix='" + this.suffix + '\'' + '}';
            }
        }
    }

    public static enum NoOp implements MethodRebaseResolver
    {
        INSTANCE;


        @Override
        public Resolution resolve(MethodDescription methodDescription) {
            return new Resolution.Preserved(methodDescription);
        }
    }
}

