/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.collection.ArrayFactory;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.MethodConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;

public abstract class InvocationHandlerAdapter
implements Instrumentation {
    private static final String PREFIX = "invocationHandler";
    protected final String fieldName;
    protected final Assigner assigner;
    protected final boolean cacheMethods;

    protected InvocationHandlerAdapter(String fieldName, boolean cacheMethods, Assigner assigner) {
        this.fieldName = fieldName;
        this.cacheMethods = cacheMethods;
        this.assigner = assigner;
    }

    private static Assigner defaultAssigner() {
        return new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE));
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler) {
        return InvocationHandlerAdapter.of(invocationHandler, String.format("%s$%d", PREFIX, Math.abs(invocationHandler.hashCode())));
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler, String fieldName) {
        return new ForStaticDelegation(ByteBuddyCommons.isValidIdentifier(fieldName), false, InvocationHandlerAdapter.defaultAssigner(), ByteBuddyCommons.nonNull(invocationHandler));
    }

    public static InvocationHandlerAdapter toInstanceField(String fieldName) {
        return new ForInstanceDelegation(ByteBuddyCommons.isValidIdentifier(fieldName), false, InvocationHandlerAdapter.defaultAssigner());
    }

    private List<StackManipulation> argumentValuesOf(MethodDescription instrumentedMethod) {
        TypeList parameterTypes = instrumentedMethod.getParameters().asTypeList();
        ArrayList<StackManipulation> instruction = new ArrayList<StackManipulation>(parameterTypes.size());
        TypeDescription.ForLoadedType objectType = new TypeDescription.ForLoadedType(Object.class);
        int currentIndex = 1;
        for (TypeDescription parameterType : parameterTypes) {
            instruction.add(new StackManipulation.Compound(MethodVariableAccess.forType(parameterType).loadOffset(currentIndex), this.assigner.assign(parameterType, objectType, false)));
            currentIndex += parameterType.getStackSize().getSize();
        }
        return instruction;
    }

    public abstract AssignerConfigurable withMethodCache();

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod, TypeDescription instrumentedType, StackManipulation preparingManipulation) {
        TypeDescription.ForLoadedType objectType = new TypeDescription.ForLoadedType(Object.class);
        TypeDescription.ForLoadedType invocationHandlerType = new TypeDescription.ForLoadedType(InvocationHandler.class);
        StackManipulation.Size stackSize = new StackManipulation.Compound(preparingManipulation, FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter(), MethodVariableAccess.forType(objectType).loadOffset(0), this.cacheMethods ? MethodConstant.forMethod(instrumentedMethod).cached() : MethodConstant.forMethod(instrumentedMethod), ArrayFactory.targeting(objectType).withValues(this.argumentValuesOf(instrumentedMethod)), MethodInvocation.invoke((MethodDescription)invocationHandlerType.getDeclaredMethods().getOnly()), this.assigner.assign(objectType, instrumentedMethod.getReturnType(), true), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InvocationHandlerAdapter that = (InvocationHandlerAdapter)other;
        return this.cacheMethods == that.cacheMethods && this.assigner.equals(that.assigner) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + (this.cacheMethods ? 1 : 0);
        return result;
    }

    protected static class ForInstanceDelegation
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        protected ForInstanceDelegation(String fieldName, boolean cacheMethods, Assigner assigner) {
            super(fieldName, cacheMethods, assigner);
        }

        @Override
        public AssignerConfigurable withMethodCache() {
            return new ForInstanceDelegation(this.fieldName, true, this.assigner);
        }

        @Override
        public Instrumentation withAssigner(Assigner assigner) {
            return new ForInstanceDelegation(this.fieldName, this.cacheMethods, ByteBuddyCommons.nonNull(assigner));
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(this.fieldName, new TypeDescription.ForLoadedType(InvocationHandler.class), 1);
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new Appender(instrumentationTarget.getTypeDescription());
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForInstanceDelegation{fieldName=" + this.fieldName + "cacheMethods=" + this.cacheMethods + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                return ForInstanceDelegation.this.apply(methodVisitor, instrumentationContext, instrumentedMethod, this.instrumentedType, MethodVariableAccess.forType(this.instrumentedType).loadOffset(0));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForInstanceDelegation.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForInstanceDelegation.this;
            }

            public int hashCode() {
                return 31 * ForInstanceDelegation.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForInstanceDelegation.Appender{invocationHandlerAdapter=" + ForInstanceDelegation.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static class ForStaticDelegation
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        protected final InvocationHandler invocationHandler;

        protected ForStaticDelegation(String fieldName, boolean cacheMethods, Assigner assigner, InvocationHandler invocationHandler) {
            super(fieldName, cacheMethods, assigner);
            this.invocationHandler = invocationHandler;
        }

        @Override
        public AssignerConfigurable withMethodCache() {
            return new ForStaticDelegation(this.fieldName, true, this.assigner, this.invocationHandler);
        }

        @Override
        public Instrumentation withAssigner(Assigner assigner) {
            return new ForStaticDelegation(this.fieldName, this.cacheMethods, ByteBuddyCommons.nonNull(assigner), this.invocationHandler);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(this.fieldName, new TypeDescription.ForLoadedType(InvocationHandler.class), 8).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.invocationHandler));
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new Appender(instrumentationTarget.getTypeDescription());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.invocationHandler.equals(((ForStaticDelegation)other).invocationHandler);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.invocationHandler.hashCode();
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForStaticDelegation{fieldName=" + this.fieldName + ", cacheMethods=" + this.cacheMethods + ", invocationHandler=" + this.invocationHandler + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                return ForStaticDelegation.this.apply(methodVisitor, instrumentationContext, instrumentedMethod, this.instrumentedType, StackManipulation.LegalTrivial.INSTANCE);
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForStaticDelegation.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForStaticDelegation.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            public int hashCode() {
                return 31 * ForStaticDelegation.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForStaticDelegation.Appender{invocationHandlerAdapter=" + ForStaticDelegation.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static interface AssignerConfigurable
    extends Instrumentation {
        public Instrumentation withAssigner(Assigner var1);
    }
}

