/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.bytebuddy.instrumentation.ModifierReviewable;
import net.bytebuddy.instrumentation.NamedElement;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotatedElement;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.utility.JavaMethod;

public interface ParameterDescription
extends AnnotatedElement,
NamedElement,
ModifierReviewable {
    public static final String NAME_PREFIX = "arg";

    public TypeDescription getTypeDescription();

    public MethodDescription getDeclaringMethod();

    public int getIndex();

    public boolean isNamed();

    public int getOffset();

    public static class Latent
    extends AbstractParameterDescription {
        private final MethodDescription declaringMethod;
        private final TypeDescription parameterType;
        private final int index;
        private final int offset;

        public Latent(MethodDescription declaringMethod, TypeDescription parameterType, int index, int offset) {
            this.declaringMethod = declaringMethod;
            this.parameterType = parameterType;
            this.index = index;
            this.offset = offset;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.parameterType;
        }

        @Override
        public MethodDescription getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }
    }

    public static class ForLoadedParameter
    extends AbstractParameterDescription {
        protected static final JavaMethod GET_TYPE;
        private static final JavaMethod GET_NAME;
        private static final JavaMethod GET_DECLARING_EXECUTABLE;
        private static final JavaMethod IS_NAME_PRESENT;
        private static final JavaMethod GET_MODIFIERS;
        private static final JavaMethod GET_DECLARED_ANNOTATIONS;
        private final Object parameter;
        private final int index;

        protected ForLoadedParameter(Object parameter, int index) {
            this.parameter = parameter;
            this.index = index;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return new TypeDescription.ForLoadedType((Class)GET_TYPE.invoke(this.parameter, new Object[0]));
        }

        @Override
        public MethodDescription getDeclaringMethod() {
            Object executable = GET_DECLARING_EXECUTABLE.invoke(this.parameter, new Object[0]);
            if (executable instanceof Method) {
                return new MethodDescription.ForLoadedMethod((Method)executable);
            }
            if (executable instanceof Constructor) {
                return new MethodDescription.ForLoadedConstructor((Constructor)executable);
            }
            throw new IllegalStateException("Unknown executable type: " + executable);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation((Annotation[])GET_DECLARED_ANNOTATIONS.invoke(this.parameter, new Object[0]));
        }

        @Override
        public String getName() {
            return (String)GET_NAME.invoke(this.parameter, new Object[0]);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isNamed() {
            return (Boolean)IS_NAME_PRESENT.invoke(this.parameter, new Object[0]);
        }

        @Override
        public int getModifiers() {
            return (Integer)GET_MODIFIERS.invoke(this.parameter, new Object[0]);
        }

        static {
            JavaMethod getType;
            JavaMethod getDeclaredAnnotations;
            JavaMethod getModifiers;
            JavaMethod isNamePresent;
            JavaMethod getDeclaringExecutable;
            JavaMethod getName;
            try {
                Class<?> parameterType = Class.forName("java.lang.reflect.Parameter");
                getName = new JavaMethod.ForLoadedMethod(parameterType.getDeclaredMethod("getName", new Class[0]));
                getDeclaringExecutable = new JavaMethod.ForLoadedMethod(parameterType.getDeclaredMethod("getDeclaringExecutable", new Class[0]));
                isNamePresent = new JavaMethod.ForLoadedMethod(parameterType.getDeclaredMethod("isNamePresent", new Class[0]));
                getModifiers = new JavaMethod.ForLoadedMethod(parameterType.getDeclaredMethod("getModifiers", new Class[0]));
                getDeclaredAnnotations = new JavaMethod.ForLoadedMethod(parameterType.getDeclaredMethod("getDeclaredAnnotations", new Class[0]));
                getType = new JavaMethod.ForLoadedMethod(parameterType.getDeclaredMethod("getType", new Class[0]));
            }
            catch (Exception ignored) {
                getName = JavaMethod.ForUnavailableMethod.INSTANCE;
                getDeclaringExecutable = JavaMethod.ForUnavailableMethod.INSTANCE;
                isNamePresent = JavaMethod.ForUnavailableMethod.INSTANCE;
                getModifiers = JavaMethod.ForUnavailableMethod.INSTANCE;
                getDeclaredAnnotations = JavaMethod.ForUnavailableMethod.INSTANCE;
                getType = JavaMethod.ForUnavailableMethod.INSTANCE;
            }
            GET_NAME = getName;
            GET_DECLARING_EXECUTABLE = getDeclaringExecutable;
            IS_NAME_PRESENT = isNamePresent;
            GET_MODIFIERS = getModifiers;
            GET_DECLARED_ANNOTATIONS = getDeclaredAnnotations;
            GET_TYPE = getType;
        }

        protected static class OfLegacyVmConstructor
        extends AbstractParameterDescription {
            private final Constructor<?> constructor;
            private final int index;
            private final Class<?> parameterType;
            private final Annotation[] parameterAnnotation;

            protected OfLegacyVmConstructor(Constructor<?> constructor, int index, Class<?> parameterType, Annotation[] parameterAnnotation) {
                this.constructor = constructor;
                this.index = index;
                this.parameterType = parameterType;
                this.parameterAnnotation = parameterAnnotation;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return new TypeDescription.ForLoadedType(this.parameterType);
            }

            @Override
            public MethodDescription getDeclaringMethod() {
                return new MethodDescription.ForLoadedConstructor(this.constructor);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotation(this.parameterAnnotation);
            }
        }

        protected static class OfLegacyVmMethod
        extends AbstractParameterDescription {
            private final Method method;
            private final int index;
            private final Class<?> parameterType;
            private final Annotation[] parameterAnnotation;

            protected OfLegacyVmMethod(Method method, int index, Class<?> parameterType, Annotation[] parameterAnnotation) {
                this.method = method;
                this.index = index;
                this.parameterType = parameterType;
                this.parameterAnnotation = parameterAnnotation;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return new TypeDescription.ForLoadedType(this.parameterType);
            }

            @Override
            public MethodDescription getDeclaringMethod() {
                return new MethodDescription.ForLoadedMethod(this.method);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotation(this.parameterAnnotation);
            }
        }
    }

    public static abstract class AbstractParameterDescription
    extends ModifierReviewable.AbstractModifierReviewable
    implements ParameterDescription {
        @Override
        public String getName() {
            return ParameterDescription.NAME_PREFIX.concat(String.valueOf(this.getIndex()));
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        @Override
        public int getOffset() {
            TypeList parameterType = this.getDeclaringMethod().getParameters().asTypeList();
            int offset = this.getDeclaringMethod().isStatic() ? StackSize.ZERO.getSize() : StackSize.SINGLE.getSize();
            for (int i = 0; i < this.getIndex(); ++i) {
                offset += ((TypeDescription)parameterType.get(i)).getStackSize().getSize();
            }
            return offset;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterDescription)) {
                return false;
            }
            ParameterDescription parameterDescription = (ParameterDescription)other;
            return this.getDeclaringMethod().equals(parameterDescription.getDeclaringMethod()) && this.getIndex() == parameterDescription.getIndex();
        }

        public int hashCode() {
            return this.getDeclaringMethod().hashCode() ^ this.getIndex();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Modifier.toString(this.getModifiers()));
            if (this.getModifiers() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.isVarArgs() ? this.getTypeDescription().getName().replaceFirst("\\[\\]$", "...") : this.getTypeDescription().getName());
            return stringBuilder.append(' ').append(this.getName()).toString();
        }
    }
}

