/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface MethodDelegationBinder {
    public MethodBinding bind(Instrumentation.Target var1, MethodDescription var2, MethodDescription var3);

    public static class Processor {
        private static final int ONLY = 0;
        private static final int LEFT = 0;
        private static final int RIGHT = 1;
        private final MethodDelegationBinder methodDelegationBinder;
        private final AmbiguityResolver ambiguityResolver;

        public Processor(MethodDelegationBinder methodDelegationBinder, AmbiguityResolver ambiguityResolver) {
            this.methodDelegationBinder = methodDelegationBinder;
            this.ambiguityResolver = ambiguityResolver;
        }

        public MethodDelegationBinder getMethodDelegationBinder() {
            return this.methodDelegationBinder;
        }

        public AmbiguityResolver getAmbiguityResolver() {
            return this.ambiguityResolver;
        }

        public MethodBinding process(Instrumentation.Target instrumentationTarget, MethodDescription source, Iterable<? extends MethodDescription> targets) {
            List<MethodBinding> possibleDelegations = this.bind(instrumentationTarget, source, targets);
            if (possibleDelegations.size() == 0) {
                throw new IllegalArgumentException("No method can be bound to " + source);
            }
            return this.resolve(source, possibleDelegations);
        }

        private List<MethodBinding> bind(Instrumentation.Target instrumentationTarget, MethodDescription source, Iterable<? extends MethodDescription> targets) {
            LinkedList<MethodBinding> possibleDelegations = new LinkedList<MethodBinding>();
            for (MethodDescription methodDescription : targets) {
                MethodBinding methodBinding;
                if (!methodDescription.isVisibleTo(instrumentationTarget.getTypeDescription()) || !(methodBinding = this.methodDelegationBinder.bind(instrumentationTarget, source, methodDescription)).isValid()) continue;
                possibleDelegations.add(methodBinding);
            }
            return possibleDelegations;
        }

        private MethodBinding resolve(MethodDescription source, List<MethodBinding> targets) {
            switch (targets.size()) {
                case 1: {
                    return targets.get(0);
                }
                case 2: {
                    MethodBinding left = targets.get(0);
                    MethodBinding right = targets.get(1);
                    switch (this.ambiguityResolver.resolve(source, left, right)) {
                        case LEFT: {
                            return left;
                        }
                        case RIGHT: {
                            return right;
                        }
                        case UNKNOWN: 
                        case AMBIGUOUS: {
                            throw new IllegalArgumentException(String.format("Could not resolve ambiguous delegation of %s: %s or %s", source, left, right));
                        }
                    }
                    throw new AssertionError();
                }
            }
            MethodBinding left = targets.get(0);
            MethodBinding right = targets.get(1);
            switch (this.ambiguityResolver.resolve(source, left, right)) {
                case LEFT: {
                    targets.remove(1);
                    return this.resolve(source, targets);
                }
                case RIGHT: {
                    targets.remove(0);
                    return this.resolve(source, targets);
                }
                case UNKNOWN: 
                case AMBIGUOUS: {
                    targets.remove(1);
                    targets.remove(0);
                    MethodBinding subResult = this.resolve(source, targets);
                    switch (this.ambiguityResolver.resolve(source, left, subResult).merge(this.ambiguityResolver.resolve(source, right, subResult))) {
                        case RIGHT: {
                            return subResult;
                        }
                        case UNKNOWN: 
                        case AMBIGUOUS: 
                        case LEFT: {
                            throw new IllegalArgumentException("Could not resolve ambiguous delegation to either " + left + " or " + right);
                        }
                    }
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.ambiguityResolver.equals(((Processor)other).ambiguityResolver) && this.methodDelegationBinder.equals(((Processor)other).methodDelegationBinder);
        }

        public int hashCode() {
            return 31 * this.methodDelegationBinder.hashCode() + this.ambiguityResolver.hashCode();
        }

        public String toString() {
            return "MethodDelegationBinder.Processor{methodDelegationBinder=" + this.methodDelegationBinder + ", ambiguityResolver=" + this.ambiguityResolver + '}';
        }
    }

    public static interface AmbiguityResolver {
        public Resolution resolve(MethodDescription var1, MethodBinding var2, MethodBinding var3);

        public static class Chain
        implements AmbiguityResolver {
            private final List<AmbiguityResolver> ambiguityResolvers;

            protected Chain(AmbiguityResolver ... ambiguityResolver) {
                this.ambiguityResolvers = Chain.unchained(Arrays.asList(ambiguityResolver));
            }

            public static AmbiguityResolver of(AmbiguityResolver ... ambiguityResolver) {
                if (ambiguityResolver.length == 1) {
                    return ambiguityResolver[0];
                }
                return new Chain(ambiguityResolver);
            }

            private static List<AmbiguityResolver> unchained(List<AmbiguityResolver> chained) {
                ArrayList<AmbiguityResolver> ambiguityResolvers = new ArrayList<AmbiguityResolver>();
                for (AmbiguityResolver ambiguityResolver : chained) {
                    if (ambiguityResolver instanceof Chain) {
                        ambiguityResolvers.addAll(Chain.unchained(((Chain)ambiguityResolver).ambiguityResolvers));
                        continue;
                    }
                    ambiguityResolvers.add(ambiguityResolver);
                }
                return ambiguityResolvers;
            }

            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                Resolution resolution = Resolution.UNKNOWN;
                Iterator<AmbiguityResolver> iterator = this.ambiguityResolvers.iterator();
                while (resolution.isUnresolved() && iterator.hasNext()) {
                    resolution = iterator.next().resolve(source, left, right);
                }
                return resolution;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.ambiguityResolvers.equals(((Chain)other).ambiguityResolvers);
            }

            public int hashCode() {
                return this.ambiguityResolvers.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.Chain{ambiguityResolvers=" + this.ambiguityResolvers + '}';
            }
        }

        public static enum NoOp implements AmbiguityResolver
        {
            INSTANCE;


            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                return Resolution.UNKNOWN;
            }
        }

        public static enum Resolution {
            UNKNOWN(true),
            LEFT(false),
            RIGHT(false),
            AMBIGUOUS(true);

            private final boolean unresolved;

            private Resolution(boolean unresolved) {
                this.unresolved = unresolved;
            }

            public boolean isUnresolved() {
                return this.unresolved;
            }

            public Resolution merge(Resolution other) {
                switch (this) {
                    case UNKNOWN: {
                        return other;
                    }
                    case AMBIGUOUS: {
                        return AMBIGUOUS;
                    }
                    case LEFT: 
                    case RIGHT: {
                        return other == this ? this : AMBIGUOUS;
                    }
                }
                throw new AssertionError();
            }
        }
    }

    public static interface MethodBinding
    extends StackManipulation {
        public Integer getTargetParameterIndex(Object var1);

        public MethodDescription getTarget();

        public static class Builder {
            private final MethodInvoker methodInvoker;
            private final MethodDescription target;
            private final List<StackManipulation> parameterStackManipulations;
            private final LinkedHashMap<Object, Integer> registeredTargetIndices;
            private int nextParameterIndex;

            public Builder(MethodInvoker methodInvoker, MethodDescription target) {
                this.methodInvoker = methodInvoker;
                this.target = target;
                this.parameterStackManipulations = new ArrayList<StackManipulation>(target.getParameters().size());
                this.registeredTargetIndices = new LinkedHashMap(target.getParameters().size());
                this.nextParameterIndex = 0;
            }

            public boolean append(ParameterBinding<?> parameterBinding) {
                this.parameterStackManipulations.add(parameterBinding);
                return this.registeredTargetIndices.put(parameterBinding.getIdentificationToken(), this.nextParameterIndex++) == null;
            }

            public MethodBinding build(StackManipulation terminatingManipulation) {
                if (this.target.getParameters().size() != this.nextParameterIndex) {
                    throw new IllegalStateException("The number of parameters bound does not equal the target's number of parameters");
                }
                return new Build(this.target, this.registeredTargetIndices, this.methodInvoker.invoke(this.target), this.parameterStackManipulations, terminatingManipulation);
            }

            public int getNextParameterIndex() {
                return this.nextParameterIndex;
            }

            public String toString() {
                return "MethodDelegationBinder.MethodBinding.Builder{methodInvoker=" + this.methodInvoker + ", target=" + this.target + ", parameterStackManipulations=" + this.parameterStackManipulations + ", registeredTargetIndices=" + this.registeredTargetIndices + '}';
            }

            private static class Build
            implements MethodBinding {
                private final MethodDescription target;
                private final Map<?, Integer> registeredTargetIndices;
                private final StackManipulation methodInvocation;
                private final List<StackManipulation> parameterStackManipulations;
                private final StackManipulation terminatingStackManipulation;

                private Build(MethodDescription target, Map<?, Integer> registeredTargetIndices, StackManipulation methodInvocation, List<StackManipulation> parameterStackManipulations, StackManipulation terminatingStackManipulation) {
                    this.target = target;
                    this.registeredTargetIndices = new HashMap(registeredTargetIndices);
                    this.methodInvocation = methodInvocation;
                    this.parameterStackManipulations = new ArrayList<StackManipulation>(parameterStackManipulations);
                    this.terminatingStackManipulation = terminatingStackManipulation;
                }

                @Override
                public boolean isValid() {
                    boolean result = this.methodInvocation.isValid() && this.terminatingStackManipulation.isValid();
                    Iterator<StackManipulation> assignment = this.parameterStackManipulations.iterator();
                    while (result && assignment.hasNext()) {
                        result = assignment.next().isValid();
                    }
                    return result;
                }

                @Override
                public Integer getTargetParameterIndex(Object parameterBindingToken) {
                    return this.registeredTargetIndices.get(parameterBindingToken);
                }

                @Override
                public MethodDescription getTarget() {
                    return this.target;
                }

                @Override
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                    StackManipulation.Size size = new StackManipulation.Size(0, 0);
                    for (StackManipulation stackManipulation : this.parameterStackManipulations) {
                        size = size.aggregate(stackManipulation.apply(methodVisitor, instrumentationContext));
                    }
                    size = size.aggregate(this.methodInvocation.apply(methodVisitor, instrumentationContext));
                    return size.aggregate(this.terminatingStackManipulation.apply(methodVisitor, instrumentationContext));
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Build build = (Build)other;
                    return this.methodInvocation.equals(build.methodInvocation) && this.parameterStackManipulations.equals(build.parameterStackManipulations) && this.registeredTargetIndices.equals(build.registeredTargetIndices) && this.terminatingStackManipulation.equals(build.terminatingStackManipulation) && this.target.equals(build.target);
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + this.registeredTargetIndices.hashCode();
                    result = 31 * result + this.methodInvocation.hashCode();
                    result = 31 * result + this.parameterStackManipulations.hashCode();
                    result = 31 * result + this.terminatingStackManipulation.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodBinding to " + this.target + " (" + (this.isValid() ? "valid" : "invalid") + ')';
                }
            }
        }

        public static enum Illegal implements MethodBinding
        {
            INSTANCE;


            @Override
            public Integer getTargetParameterIndex(Object parameterBindingToken) {
                throw new IllegalStateException();
            }

            @Override
            public MethodDescription getTarget() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                throw new IllegalStateException();
            }
        }
    }

    public static interface ParameterBinding<T>
    extends StackManipulation {
        public T getIdentificationToken();

        public static class Unique<T>
        implements ParameterBinding<T> {
            private final T identificationToken;
            private final StackManipulation delegate;

            public Unique(StackManipulation delegate, T identificationToken) {
                this.delegate = delegate;
                this.identificationToken = identificationToken;
            }

            public static <S> Unique<S> of(StackManipulation delegate, S identificationToken) {
                return new Unique<S>(delegate, identificationToken);
            }

            @Override
            public T getIdentificationToken() {
                return this.identificationToken;
            }

            @Override
            public boolean isValid() {
                return this.delegate.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                return this.delegate.apply(methodVisitor, instrumentationContext);
            }
        }

        public static class Anonymous
        implements ParameterBinding<Object> {
            private final Object anonymousToken;
            private final StackManipulation delegate;

            public Anonymous(StackManipulation delegate) {
                this.delegate = delegate;
                this.anonymousToken = new Object();
            }

            @Override
            public Object getIdentificationToken() {
                return this.anonymousToken;
            }

            @Override
            public boolean isValid() {
                return this.delegate.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                return this.delegate.apply(methodVisitor, instrumentationContext);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.anonymousToken.equals(((Anonymous)other).anonymousToken);
            }

            public int hashCode() {
                return this.anonymousToken.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.ParameterBinding.Anonymous{delegate=" + this.delegate + '}';
            }
        }

        public static enum Illegal implements ParameterBinding<Void>
        {
            INSTANCE;


            @Override
            public Void getIdentificationToken() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                throw new IllegalStateException("An illegal parameter binding must not be applied");
            }
        }
    }

    public static interface MethodInvoker {
        public StackManipulation invoke(MethodDescription var1);

        public static class Virtual
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            public Virtual(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public StackManipulation invoke(MethodDescription methodDescription) {
                return MethodInvocation.invoke(methodDescription).virtual(this.typeDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((Virtual)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.MethodInvoker.Virtual{typeDescription=" + this.typeDescription + '}';
            }
        }

        public static enum Simple implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription methodDescription) {
                return MethodInvocation.invoke(methodDescription);
            }
        }
    }
}

