/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.ParameterDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.RuntimeType;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.collection.ArrayFactory;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.TypeDescription;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface AllArguments {
    public Assignment value() default Assignment.STRICT;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<AllArguments>
    {
        INSTANCE;


        @Override
        public Class<AllArguments> getHandledType() {
            return AllArguments.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<AllArguments> annotation, MethodDescription source, ParameterDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            if (!target.getTypeDescription().isArray()) {
                throw new IllegalStateException("Expected an array type for all argument annotation on " + source);
            }
            ArrayFactory arrayFactory = ArrayFactory.targeting(target.getTypeDescription().getComponentType());
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(source.getParameters().size());
            int offset = source.isStatic() ? 0 : 1;
            boolean dynamicallyTyped = RuntimeType.Verifier.check(target);
            for (TypeDescription sourceParameter : source.getParameters().asTypeList()) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.forType(sourceParameter).loadOffset(offset), assigner.assign(sourceParameter, arrayFactory.getComponentType(), dynamicallyTyped));
                if (stackManipulation.isValid()) {
                    stackManipulations.add(stackManipulation);
                } else if (annotation.loadSilent().value().isStrict()) {
                    return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                }
                offset += sourceParameter.getStackSize().getSize();
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(arrayFactory.withValues(stackManipulations));
        }
    }

    public static enum Assignment {
        STRICT(true),
        SLACK(false);

        private final boolean strict;

        private Assignment(boolean strict) {
            this.strict = strict;
        }

        protected boolean isStrict() {
            return this.strict;
        }
    }
}

