/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.ParameterDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.ClassConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.MethodConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.MethodHandleConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.MethodTypeConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.TextConstant;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.utility.JavaType;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Origin {
    public boolean cacheMethod() default false;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Origin>
    {
        INSTANCE;


        @Override
        public Class<Origin> getHandledType() {
            return Origin.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Origin> annotation, MethodDescription source, ParameterDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            TypeDescription parameterType = target.getTypeDescription();
            if (parameterType.represents(Class.class)) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(ClassConstant.of(instrumentationTarget.getOriginType()));
            }
            if (parameterType.represents(Method.class)) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(annotation.loadSilent().cacheMethod() ? MethodConstant.forMethod(source).cached() : MethodConstant.forMethod(source));
            }
            if (parameterType.represents(String.class)) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(new TextConstant(source.getUniqueSignature()));
            }
            if (JavaType.METHOD_HANDLE.representedBy(parameterType)) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(MethodHandleConstant.of(source));
            }
            if (JavaType.METHOD_TYPE.representedBy(parameterType)) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(new MethodTypeConstant(source));
            }
            throw new IllegalStateException("The " + target + " method's " + target.getIndex() + " parameter is annotated with a Origin annotation with an argument not representing a Class" + " Method, String, MethodType or MethodHandle type");
        }
    }
}

