/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.ParameterDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.TypeProxy;
import net.bytebuddy.matcher.ElementMatchers;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Super {
    public Instantiation strategy() default Instantiation.CONSTRUCTOR;

    public boolean ignoreFinalizer() default true;

    public boolean serializableProxy() default false;

    public Class<?>[] constructorParameters() default {};

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Super>
    {
        INSTANCE;

        private static final MethodDescription STRATEGY;

        @Override
        public Class<Super> getHandledType() {
            return Super.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Super> annotation, MethodDescription source, ParameterDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            if (source.isStatic() || !instrumentationTarget.getTypeDescription().isAssignableTo(target.getTypeDescription())) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(annotation.getValue(STRATEGY, AnnotationDescription.EnumerationValue.class).load(Instantiation.class).proxyFor(target.getTypeDescription(), instrumentationTarget, annotation));
        }

        static {
            MethodList annotationProperties = new TypeDescription.ForLoadedType(Super.class).getDeclaredMethods();
            STRATEGY = (MethodDescription)((MethodList)annotationProperties.filter(ElementMatchers.returns(Instantiation.class))).getOnly();
        }
    }

    public static enum Instantiation {
        CONSTRUCTOR{

            @Override
            protected StackManipulation proxyFor(TypeDescription parameterType, Instrumentation.Target instrumentationTarget, AnnotationDescription.Loadable<Super> annotation) {
                TypeDescription[] constructorParameters = annotation.getValue(CONSTRUCTOR_PARAMETERS, TypeDescription[].class);
                ArrayList<TypeDescription> typeDescriptions = new ArrayList<TypeDescription>(constructorParameters.length);
                for (TypeDescription constructorParameter : constructorParameters) {
                    typeDescriptions.add(constructorParameter.represents(TargetType.class) ? TargetType.DESCRIPTION : constructorParameter);
                }
                return new TypeProxy.ForSuperMethodByConstructor(parameterType, instrumentationTarget, typeDescriptions, annotation.getValue(IGNORE_FINALIZER, Boolean.class), annotation.getValue(SERIALIZABLE_PROXY, Boolean.class));
            }
        }
        ,
        UNSAFE{

            @Override
            protected StackManipulation proxyFor(TypeDescription parameterType, Instrumentation.Target instrumentationTarget, AnnotationDescription.Loadable<Super> annotation) {
                return new TypeProxy.ForSuperMethodByReflectionFactory(parameterType, instrumentationTarget, annotation.getValue(IGNORE_FINALIZER, Boolean.class), annotation.getValue(SERIALIZABLE_PROXY, Boolean.class));
            }
        };

        private static final MethodDescription IGNORE_FINALIZER;
        private static final MethodDescription SERIALIZABLE_PROXY;
        private static final MethodDescription CONSTRUCTOR_PARAMETERS;

        protected abstract StackManipulation proxyFor(TypeDescription var1, Instrumentation.Target var2, AnnotationDescription.Loadable<Super> var3);

        static {
            MethodList annotationProperties = new TypeDescription.ForLoadedType(Super.class).getDeclaredMethods();
            IGNORE_FINALIZER = (MethodDescription)((MethodList)annotationProperties.filter(ElementMatchers.named("ignoreFinalizer"))).getOnly();
            SERIALIZABLE_PROXY = (MethodDescription)((MethodList)annotationProperties.filter(ElementMatchers.named("serializableProxy"))).getOnly();
            CONSTRUCTOR_PARAMETERS = (MethodDescription)((MethodList)annotationProperties.filter(ElementMatchers.named("constructorParameters"))).getOnly();
        }
    }
}

