/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Callable;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.ParameterDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.MethodCallProxy;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface SuperCall {
    public boolean serializableProxy() default false;

    public boolean fallbackToDefault() default true;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<SuperCall>
    {
        INSTANCE;


        @Override
        public Class<SuperCall> getHandledType() {
            return SuperCall.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<SuperCall> annotation, MethodDescription source, ParameterDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            TypeDescription targetType = target.getTypeDescription();
            if (!(targetType.represents(Runnable.class) || targetType.represents(Callable.class) || targetType.represents(Object.class))) {
                throw new IllegalStateException("A super method call proxy can only be assigned to Runnable or Callable types: " + target);
            }
            Instrumentation.SpecialMethodInvocation specialMethodInvocation = instrumentationTarget.invokeSuper(source, Instrumentation.Target.MethodLookup.Default.EXACT);
            if (!specialMethodInvocation.isValid() && source.isDefaultMethod() && instrumentationTarget.getTypeDescription().getInterfaces().contains(source.getDeclaringType()) && annotation.loadSilent().fallbackToDefault()) {
                specialMethodInvocation = instrumentationTarget.invokeDefault(source.getDeclaringType(), source.getUniqueSignature());
            }
            return specialMethodInvocation.isValid() ? new MethodDelegationBinder.ParameterBinding.Anonymous(new MethodCallProxy.AssignableSignatureCall(specialMethodInvocation, annotation.loadSilent().serializableProxy())) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }
    }
}

