/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack;

import java.util.Arrays;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface StackManipulation {
    public boolean isValid();

    public Size apply(MethodVisitor var1, Instrumentation.Context var2);

    public static class Compound
    implements StackManipulation {
        private final StackManipulation[] stackManipulation;

        public Compound(StackManipulation ... stackManipulation) {
            this.stackManipulation = stackManipulation;
        }

        @Override
        public boolean isValid() {
            for (StackManipulation stackManipulation : this.stackManipulation) {
                if (stackManipulation.isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            Size size = new Size(0, 0);
            for (StackManipulation stackManipulation : this.stackManipulation) {
                size = size.aggregate(stackManipulation.apply(methodVisitor, instrumentationContext));
            }
            return size;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.stackManipulation, ((Compound)other).stackManipulation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.stackManipulation);
        }

        public String toString() {
            return "StackManipulation.Compound{stackManipulation=" + Arrays.asList(this.stackManipulation) + "}";
        }
    }

    public static class Size {
        private final int sizeImpact;
        private final int maximalSize;

        public Size(int sizeImpact, int maximalSize) {
            this.sizeImpact = sizeImpact;
            this.maximalSize = maximalSize;
        }

        public int getSizeImpact() {
            return this.sizeImpact;
        }

        public int getMaximalSize() {
            return this.maximalSize;
        }

        public Size aggregate(Size other) {
            return this.aggregate(other.sizeImpact, other.maximalSize);
        }

        private Size aggregate(int sizeChange, int interimMaximalSize) {
            return new Size(this.sizeImpact + sizeChange, Math.max(this.maximalSize, this.sizeImpact + interimMaximalSize));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.maximalSize == ((Size)other).maximalSize && this.sizeImpact == ((Size)other).sizeImpact;
        }

        public int hashCode() {
            return 31 * this.sizeImpact + this.maximalSize;
        }

        public String toString() {
            return "StackManipulation.Size{sizeImpact=" + this.sizeImpact + ", maximalSize=" + this.maximalSize + '}';
        }
    }

    public static enum LegalTrivial implements StackManipulation
    {
        INSTANCE;


        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            return StackSize.ZERO.toIncreasingSize();
        }
    }

    public static enum Illegal implements StackManipulation
    {
        INSTANCE;


        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            throw new IllegalStateException("An illegal stack manipulation must not be applied");
        }
    }
}

