/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.constant;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.MethodVisitor;

public class MethodHandleConstant
implements StackManipulation {
    private static final StackManipulation.Size SIZE = StackSize.SINGLE.toIncreasingSize();
    private final Handle handle;

    private MethodHandleConstant(Handle handle) {
        this.handle = handle;
    }

    public static StackManipulation of(MethodDescription methodDescription) {
        return methodDescription.isTypeInitializer() ? StackManipulation.Illegal.INSTANCE : new MethodHandleConstant(new Handle(MethodHandleConstant.tagFor(methodDescription), methodDescription.getDeclaringType().getInternalName(), methodDescription.getInternalName(), methodDescription.getDescriptor()));
    }

    private static int tagFor(MethodDescription methodDescription) {
        if (methodDescription.isConstructor()) {
            return 8;
        }
        if (methodDescription.isStatic()) {
            return 6;
        }
        if (methodDescription.isPrivate() || methodDescription.isDefaultMethod()) {
            return 7;
        }
        if (methodDescription.isInterface()) {
            return 9;
        }
        return 5;
    }

    public static StackManipulation ofGetter(FieldDescription fieldDescription) {
        return MethodHandleConstant.of(fieldDescription, fieldDescription.isStatic() ? 2 : 1);
    }

    public static StackManipulation ofPutter(FieldDescription fieldDescription) {
        return MethodHandleConstant.of(fieldDescription, fieldDescription.isStatic() ? 4 : 3);
    }

    private static StackManipulation of(FieldDescription fieldDescription, int tag) {
        return new MethodHandleConstant(new Handle(tag, fieldDescription.getDeclaringType().getInternalName(), fieldDescription.getInternalName(), fieldDescription.getDescriptor()));
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
        methodVisitor.visitLdcInsn(this.handle);
        return SIZE;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.handle.equals(((MethodHandleConstant)other).handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "MethodHandleConstant{handle=" + this.handle + '}';
    }
}

