/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.member;

import java.util.Iterator;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.DownCasting;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum MethodVariableAccess {
    INTEGER(21, 5, StackSize.SINGLE),
    LONG(22, 8, StackSize.DOUBLE),
    FLOAT(23, 11, StackSize.SINGLE),
    DOUBLE(24, 14, StackSize.DOUBLE),
    REFERENCE(25, 17, StackSize.SINGLE);

    private final int loadOpcode;
    private final int loadOpcodeShortcutOffset;
    private final StackManipulation.Size size;

    private MethodVariableAccess(int loadOpcode, int loadOpcodeShortcutOffset, StackSize stackSize) {
        this.loadOpcode = loadOpcode;
        this.loadOpcodeShortcutOffset = loadOpcodeShortcutOffset;
        this.size = stackSize.toIncreasingSize();
    }

    public static MethodVariableAccess forType(TypeDescription typeDescription) {
        if (typeDescription.isPrimitive()) {
            if (typeDescription.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDescription.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDescription.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDescription.represents(Void.TYPE)) {
                throw new IllegalArgumentException("Variable type cannot be void");
            }
            return INTEGER;
        }
        return REFERENCE;
    }

    public static StackManipulation loadThisReferenceAndArguments(MethodDescription methodDescription) {
        return MethodVariableAccess.loadArguments(methodDescription, TypeCastingHandler.NoOp.INSTANCE, true);
    }

    public static StackManipulation loadArguments(MethodDescription methodDescription) {
        return MethodVariableAccess.loadArguments(methodDescription, TypeCastingHandler.NoOp.INSTANCE, false);
    }

    public static StackManipulation forBridgeMethodInvocation(MethodDescription bridgeMethod, MethodDescription targetMethod) {
        return MethodVariableAccess.loadArguments(bridgeMethod, new TypeCastingHandler.ForBridgeTarget(targetMethod), false);
    }

    private static StackManipulation loadArguments(MethodDescription methodDescription, TypeCastingHandler typeCastingHandler, boolean includeThisReference) {
        int offset;
        int stackValues = (!includeThisReference || methodDescription.isStatic() ? 0 : 1) + methodDescription.getParameters().size();
        StackManipulation[] stackManipulation = new StackManipulation[stackValues];
        int parameterIndex = 0;
        if (!methodDescription.isStatic()) {
            if (includeThisReference) {
                stackManipulation[parameterIndex++] = REFERENCE.loadOffset(0);
            }
            offset = StackSize.SINGLE.getSize();
        } else {
            offset = StackSize.ZERO.getSize();
        }
        for (TypeDescription parameterType : methodDescription.getParameters().asTypeList()) {
            stackManipulation[parameterIndex++] = typeCastingHandler.wrapNext(MethodVariableAccess.forType(parameterType).loadOffset(offset), parameterType);
            offset += parameterType.getStackSize().getSize();
        }
        return new StackManipulation.Compound(stackManipulation);
    }

    public StackManipulation loadOffset(int variableOffset) {
        return new ArgumentLoadingStackManipulation(variableOffset);
    }

    protected class ArgumentLoadingStackManipulation
    implements StackManipulation {
        private final int variableIndex;

        protected ArgumentLoadingStackManipulation(int variableIndex) {
            this.variableIndex = variableIndex;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            switch (this.variableIndex) {
                case 0: {
                    methodVisitor.visitInsn(MethodVariableAccess.this.loadOpcode + MethodVariableAccess.this.loadOpcodeShortcutOffset);
                    break;
                }
                case 1: {
                    methodVisitor.visitInsn(MethodVariableAccess.this.loadOpcode + MethodVariableAccess.this.loadOpcodeShortcutOffset + 1);
                    break;
                }
                case 2: {
                    methodVisitor.visitInsn(MethodVariableAccess.this.loadOpcode + MethodVariableAccess.this.loadOpcodeShortcutOffset + 2);
                    break;
                }
                case 3: {
                    methodVisitor.visitInsn(MethodVariableAccess.this.loadOpcode + MethodVariableAccess.this.loadOpcodeShortcutOffset + 3);
                    break;
                }
                default: {
                    methodVisitor.visitVarInsn(MethodVariableAccess.this.loadOpcode, this.variableIndex);
                }
            }
            return MethodVariableAccess.this.size;
        }

        private MethodVariableAccess getMethodVariableAccess() {
            return MethodVariableAccess.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && MethodVariableAccess.this == ((ArgumentLoadingStackManipulation)other).getMethodVariableAccess() && this.variableIndex == ((ArgumentLoadingStackManipulation)other).variableIndex;
        }

        public int hashCode() {
            return MethodVariableAccess.this.hashCode() + 31 * this.variableIndex;
        }

        public String toString() {
            return "MethodVariableAccess.ArgumentLoadingStackManipulation{methodVariableAccess=" + (Object)((Object)MethodVariableAccess.this) + " ,variableIndex=" + this.variableIndex + '}';
        }
    }

    protected static interface TypeCastingHandler {
        public StackManipulation wrapNext(StackManipulation var1, TypeDescription var2);

        public static class ForBridgeTarget
        implements TypeCastingHandler {
            private final Iterator<TypeDescription> typeIterator;

            public ForBridgeTarget(MethodDescription targetMethod) {
                this.typeIterator = targetMethod.getParameters().asTypeList().iterator();
            }

            @Override
            public StackManipulation wrapNext(StackManipulation variableAccess, TypeDescription parameterType) {
                TypeDescription targetParameterType = this.typeIterator.next();
                return targetParameterType.equals(parameterType) ? variableAccess : new StackManipulation.Compound(variableAccess, new DownCasting(targetParameterType));
            }

            public String toString() {
                return "MethodVariableAccess.TypeCastingHandler.ForBridgeTarget{typeIterator=" + this.typeIterator + '}';
            }
        }

        public static enum NoOp implements TypeCastingHandler
        {
            INSTANCE;


            @Override
            public StackManipulation wrapNext(StackManipulation variableAccess, TypeDescription parameterType) {
                return variableAccess;
            }
        }
    }
}

