/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import net.bytebuddy.instrumentation.ModifierReviewable;
import net.bytebuddy.matcher.ElementMatcher;

public class ModifierMatcher<T extends ModifierReviewable>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final Mode mode;

    public ModifierMatcher(Mode mode) {
        this.mode = mode;
    }

    @Override
    public boolean matches(T target) {
        return (this.mode.getModifiers() & target.getModifiers()) != 0;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.mode == ((ModifierMatcher)other).mode;
    }

    public int hashCode() {
        return this.mode.hashCode();
    }

    public String toString() {
        return this.mode.getDescription();
    }

    public static enum Mode {
        PUBLIC(1, "isPublic()"),
        PROTECTED(4, "isProtected()"),
        PRIVATE(2, "isPrivate()"),
        FINAL(16, "isFinal()"),
        STATIC(8, "isStatic()"),
        SYNCHRONIZED(32, "isSynchronized()"),
        NATIVE(256, "isNative()"),
        STRICT(2048, "isStrict()"),
        VAR_ARGS(128, "isVarArgs()"),
        SYNTHETIC(4096, "isSynthetic()"),
        BRIDGE(64, "isBridge()");

        private final int modifiers;
        private final String description;

        private Mode(int modifiers, String description) {
            this.modifiers = modifiers;
            this.description = description;
        }

        protected String getDescription() {
            return this.description;
        }

        protected int getModifiers() {
            return this.modifiers;
        }
    }
}

