/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public interface JavaMethod {
    public boolean isInvokable();

    public Object invoke(Object var1, Object ... var2);

    public static class ForLoadedMethod
    implements JavaMethod {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke(Object instance, Object ... argument) {
            try {
                return this.method.invoke(instance, argument);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot invoke dynamically-linked method", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Exception when invoking method", e.getCause());
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.method.equals(((ForLoadedMethod)other).method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return "JavaMethod.ForLoadedMethod{method=" + this.method + '}';
        }
    }

    public static enum ForUnavailableMethod implements JavaMethod
    {
        INSTANCE;


        @Override
        public boolean isInvokable() {
            return false;
        }

        @Override
        public Object invoke(Object instance, Object ... argument) {
            throw new IllegalStateException("Java language feature is not available for current virtual machine");
        }
    }
}

