/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Map;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import net.bytebuddy.dynamic.loading.ClassInjector;

public interface ClassLoadingStrategy {
    public Map<TypeDescription, Class<?>> load(ClassLoader var1, Map<TypeDescription, byte[]> var2);

    public static class ForBootstrapInjection
    implements ClassLoadingStrategy {
        private final Instrumentation instrumentation;
        private final File folder;

        public ForBootstrapInjection(Instrumentation instrumentation, File folder) {
            this.instrumentation = instrumentation;
            this.folder = folder;
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            ClassInjector classInjector = classLoader == null ? new ClassInjector.UsingInstrumentation(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation) : new ClassInjector.UsingReflection(classLoader);
            return classInjector.inject(types);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForBootstrapInjection that = (ForBootstrapInjection)other;
            return this.folder.equals(that.folder) && this.instrumentation.equals(that.instrumentation);
        }

        public int hashCode() {
            int result = this.instrumentation.hashCode();
            result = 31 * result + this.folder.hashCode();
            return result;
        }

        public String toString() {
            return "ClassLoadingStrategy.ForBootstrapInjection{instrumentation=" + this.instrumentation + ", folder=" + this.folder + '}';
        }
    }

    public static interface WithDefaultProtectionDomain
    extends ClassLoadingStrategy {
        public ClassLoadingStrategy withProtectionDomain(ProtectionDomain var1);
    }

    public static enum Default implements WithDefaultProtectionDomain
    {
        WRAPPER{

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return ByteArrayClassLoader.load(classLoader, types, DEFAULT_PROTECTION_DOMAIN, ByteArrayClassLoader.PersistenceHandler.LATENT, false);
            }

            @Override
            public ClassLoadingStrategy withProtectionDomain(ProtectionDomain protectionDomain) {
                return new ProtectionDomainWrapper(protectionDomain, ByteArrayClassLoader.PersistenceHandler.LATENT, false);
            }
        }
        ,
        WRAPPER_PERSISTENT{

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return ByteArrayClassLoader.load(classLoader, types, DEFAULT_PROTECTION_DOMAIN, ByteArrayClassLoader.PersistenceHandler.MANIFEST, false);
            }

            @Override
            public ClassLoadingStrategy withProtectionDomain(ProtectionDomain protectionDomain) {
                return new ProtectionDomainWrapper(protectionDomain, ByteArrayClassLoader.PersistenceHandler.MANIFEST, false);
            }
        }
        ,
        CHILD_FIRST{

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return ByteArrayClassLoader.load(classLoader, types, DEFAULT_PROTECTION_DOMAIN, ByteArrayClassLoader.PersistenceHandler.LATENT, true);
            }

            @Override
            public ClassLoadingStrategy withProtectionDomain(ProtectionDomain protectionDomain) {
                return new ProtectionDomainWrapper(protectionDomain, ByteArrayClassLoader.PersistenceHandler.LATENT, true);
            }
        }
        ,
        CHILD_FIRST_PERSISTENT{

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return ByteArrayClassLoader.load(classLoader, types, DEFAULT_PROTECTION_DOMAIN, ByteArrayClassLoader.PersistenceHandler.MANIFEST, true);
            }

            @Override
            public ClassLoadingStrategy withProtectionDomain(ProtectionDomain protectionDomain) {
                return new ProtectionDomainWrapper(protectionDomain, ByteArrayClassLoader.PersistenceHandler.MANIFEST, true);
            }
        }
        ,
        INJECTION{

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return new ClassInjector.UsingReflection(classLoader).inject(types);
            }

            @Override
            public ClassLoadingStrategy withProtectionDomain(ProtectionDomain protectionDomain) {
                return new ProtectionDomainInjection(protectionDomain);
            }
        };

        private static final boolean PARENT_LAST = true;
        private static final boolean PARENT_FIRST = false;
        private static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN;

        public String toString() {
            return "ClassLoadingStrategy.Default." + this.name();
        }

        static {
            DEFAULT_PROTECTION_DOMAIN = null;
        }

        protected static class ProtectionDomainWrapper
        implements ClassLoadingStrategy {
            private final ProtectionDomain protectionDomain;
            private final ByteArrayClassLoader.PersistenceHandler persistenceHandler;
            private final boolean childFirst;

            public ProtectionDomainWrapper(ProtectionDomain protectionDomain, ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst) {
                this.protectionDomain = protectionDomain;
                this.persistenceHandler = persistenceHandler;
                this.childFirst = childFirst;
            }

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return ByteArrayClassLoader.load(classLoader, types, this.protectionDomain, this.persistenceHandler, this.childFirst);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ProtectionDomainWrapper that = (ProtectionDomainWrapper)other;
                return this.childFirst == that.childFirst && this.persistenceHandler == that.persistenceHandler && this.protectionDomain.equals(that.protectionDomain);
            }

            public int hashCode() {
                int result = this.protectionDomain.hashCode();
                result = 31 * result + (this.childFirst ? 1 : 0);
                result = 31 * result + this.persistenceHandler.hashCode();
                return result;
            }

            public String toString() {
                return "ClassLoadingStrategy.Default.ProtectionDomainWrapper{protectionDomain=" + this.protectionDomain + ", childFirst=" + this.childFirst + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + '}';
            }
        }

        protected static class ProtectionDomainInjection
        implements ClassLoadingStrategy {
            private final ProtectionDomain protectionDomain;

            protected ProtectionDomainInjection(ProtectionDomain protectionDomain) {
                this.protectionDomain = protectionDomain;
            }

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return new ClassInjector.UsingReflection(classLoader, this.protectionDomain).inject(types);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.protectionDomain.equals(((ProtectionDomainInjection)other).protectionDomain);
            }

            public int hashCode() {
                return this.protectionDomain.hashCode();
            }

            public String toString() {
                return "ClassLoadingStrategy.Default.ProtectionDomainInjection{protectionDomain=" + this.protectionDomain + '}';
            }
        }
    }
}

