/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ModifierResolver;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodLookupEngine;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMethodMatcher;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface MethodRegistry {
    public MethodRegistry prepend(LatentMethodMatcher var1, Handler var2, MethodAttributeAppender.Factory var3);

    public MethodRegistry append(LatentMethodMatcher var1, Handler var2, MethodAttributeAppender.Factory var3);

    public Prepared prepare(InstrumentedType var1, MethodLookupEngine var2, LatentMethodMatcher var3);

    public static class Default
    implements MethodRegistry {
        private final List<Entry> entries;

        public Default() {
            this.entries = Collections.emptyList();
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public MethodRegistry prepend(LatentMethodMatcher methodMatcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory) {
            return new Default(ByteBuddyCommons.join(new Entry(methodMatcher, handler, attributeAppenderFactory), this.entries));
        }

        @Override
        public MethodRegistry append(LatentMethodMatcher methodMatcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory) {
            return new Default(ByteBuddyCommons.join(this.entries, new Entry(methodMatcher, handler, attributeAppenderFactory)));
        }

        @Override
        public net.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared prepare(InstrumentedType instrumentedType, MethodLookupEngine methodLookupEngine, LatentMethodMatcher methodFilter) {
            HashMap<MethodDescription, Entry> implementations = new HashMap<MethodDescription, Entry>();
            HashSet<Handler> handlers = new HashSet<Handler>(this.entries.size());
            int helperMethodIndex = instrumentedType.getDeclaredMethods().size();
            for (Entry entry : this.entries) {
                if (!handlers.add(entry.getHandler())) continue;
                instrumentedType = entry.getHandler().prepare(instrumentedType);
                MethodList helperMethods = instrumentedType.getDeclaredMethods();
                for (MethodDescription helperMethod : (MethodList)helperMethods.subList(helperMethodIndex, helperMethods.size())) {
                    implementations.put(helperMethod, entry);
                }
                helperMethodIndex = helperMethods.size();
            }
            MethodLookupEngine.Finding finding = methodLookupEngine.process(instrumentedType);
            ElementMatcher.Junction<? super MethodDescription> instrumented = ElementMatchers.not(ElementMatchers.anyOf(implementations.keySet())).and(methodFilter.resolve(instrumentedType));
            List<MethodDescription> methodDescriptions = ByteBuddyCommons.join(MethodDescription.Latent.typeInitializerOf(instrumentedType), finding.getInvokableMethods().filter(instrumented));
            block2: for (MethodDescription methodDescription : methodDescriptions) {
                for (Entry entry : this.entries) {
                    if (!entry.resolve(instrumentedType).matches(methodDescription)) continue;
                    implementations.put(methodDescription, entry);
                    continue block2;
                }
            }
            return new Prepared(implementations, instrumentedType.getLoadedTypeInitializer(), instrumentedType.getTypeInitializer(), finding);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Default)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "MethodRegistry.Default{entries=" + this.entries + '}';
        }

        protected static class Compiled
        implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final InstrumentedType.TypeInitializer typeInitializer;
            private final Map<MethodDescription, TypeWriter.MethodPool.Entry> implementations;

            public Compiled(TypeDescription instrumentedType, LoadedTypeInitializer loadedTypeInitializer, InstrumentedType.TypeInitializer typeInitializer, Map<MethodDescription, TypeWriter.MethodPool.Entry> implementations) {
                this.instrumentedType = instrumentedType;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.implementations = implementations;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public InstrumentedType.TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList getInstrumentedMethods() {
                return (MethodList)new MethodList.Explicit(new ArrayList<MethodDescription>(this.implementations.keySet())).filter(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
            }

            @Override
            public TypeWriter.MethodPool.Entry target(MethodDescription methodDescription) {
                TypeWriter.MethodPool.Entry entry = this.implementations.get(methodDescription);
                return entry == null ? TypeWriter.MethodPool.Entry.ForSkippedMethod.INSTANCE : entry;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Compiled compiled = (Compiled)other;
                return this.instrumentedType.equals(compiled.instrumentedType) && this.loadedTypeInitializer.equals(compiled.loadedTypeInitializer) && this.typeInitializer.equals(compiled.typeInitializer) && this.implementations.equals(compiled.implementations);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.loadedTypeInitializer.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.implementations.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Compiled{instrumentedType=" + this.instrumentedType + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", implementations=" + this.implementations + '}';
            }
        }

        protected static class Prepared
        implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared {
            private final Map<MethodDescription, Entry> implementations;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final InstrumentedType.TypeInitializer typeInitializer;
            private final MethodLookupEngine.Finding finding;

            public Prepared(Map<MethodDescription, Entry> implementations, LoadedTypeInitializer loadedTypeInitializer, InstrumentedType.TypeInitializer typeInitializer, MethodLookupEngine.Finding finding) {
                this.implementations = implementations;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.finding = finding;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.finding.getTypeDescription();
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public InstrumentedType.TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList getInstrumentedMethods() {
                return (MethodList)new MethodList.Explicit(new ArrayList<MethodDescription>(this.implementations.keySet())).filter(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
            }

            @Override
            public net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled compile(Implementation.Target.Factory implementationTargetFactory) {
                HashMap<Handler, Handler.Compiled> compilationCache = new HashMap<Handler, Handler.Compiled>(this.implementations.size());
                HashMap<MethodAttributeAppender.Factory, MethodAttributeAppender> attributeAppenderCache = new HashMap<MethodAttributeAppender.Factory, MethodAttributeAppender>(this.implementations.size());
                HashMap<MethodDescription, TypeWriter.MethodPool.Entry> entries = new HashMap<MethodDescription, TypeWriter.MethodPool.Entry>(this.implementations.size());
                Implementation.Target implementationTarget = implementationTargetFactory.make(this.finding, this.getInstrumentedMethods());
                for (Map.Entry<MethodDescription, Entry> entry : this.implementations.entrySet()) {
                    MethodAttributeAppender cachedAttributeAppender;
                    Handler.Compiled cachedEntry = (Handler.Compiled)compilationCache.get(entry.getValue().getHandler());
                    if (cachedEntry == null) {
                        cachedEntry = entry.getValue().getHandler().compile(implementationTarget);
                        compilationCache.put(entry.getValue().getHandler(), cachedEntry);
                    }
                    if ((cachedAttributeAppender = (MethodAttributeAppender)attributeAppenderCache.get(entry.getValue().getAppenderFactory())) == null) {
                        cachedAttributeAppender = entry.getValue().getAppenderFactory().make(this.finding.getTypeDescription());
                        attributeAppenderCache.put(entry.getValue().getAppenderFactory(), cachedAttributeAppender);
                    }
                    entries.put(entry.getKey(), cachedEntry.assemble(cachedAttributeAppender));
                }
                return new Compiled(this.finding.getTypeDescription(), this.loadedTypeInitializer, this.typeInitializer, entries);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Prepared prepared = (Prepared)other;
                return this.implementations.equals(prepared.implementations) && this.loadedTypeInitializer.equals(prepared.loadedTypeInitializer) && this.typeInitializer.equals(prepared.typeInitializer) && this.finding.equals(prepared.finding);
            }

            public int hashCode() {
                int result = this.implementations.hashCode();
                result = 31 * result + this.loadedTypeInitializer.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.finding.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Prepared{implementations=" + this.implementations + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", finding=" + this.finding + '}';
            }
        }

        protected static class Entry
        implements LatentMethodMatcher {
            private final LatentMethodMatcher methodMatcher;
            private final Handler handler;
            private final MethodAttributeAppender.Factory attributeAppenderFactory;

            protected Entry(LatentMethodMatcher methodMatcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory) {
                this.methodMatcher = methodMatcher;
                this.handler = handler;
                this.attributeAppenderFactory = attributeAppenderFactory;
            }

            protected Handler getHandler() {
                return this.handler;
            }

            protected MethodAttributeAppender.Factory getAppenderFactory() {
                return this.attributeAppenderFactory;
            }

            @Override
            public ElementMatcher<? super MethodDescription> resolve(TypeDescription instrumentedType) {
                return this.methodMatcher.resolve(instrumentedType);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.methodMatcher.equals(entry.methodMatcher) && this.handler.equals(entry.handler) && this.attributeAppenderFactory.equals(entry.attributeAppenderFactory);
            }

            public int hashCode() {
                int result = this.methodMatcher.hashCode();
                result = 31 * result + this.handler.hashCode();
                result = 31 * result + this.attributeAppenderFactory.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Entry{methodMatcher=" + this.methodMatcher + ", handler=" + this.handler + ", attributeAppenderFactory=" + this.attributeAppenderFactory + '}';
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.MethodPool {
        public TypeDescription getInstrumentedType();

        public MethodList getInstrumentedMethods();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public InstrumentedType.TypeInitializer getTypeInitializer();
    }

    public static interface Prepared {
        public TypeDescription getInstrumentedType();

        public MethodList getInstrumentedMethods();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public InstrumentedType.TypeInitializer getTypeInitializer();

        public Compiled compile(Implementation.Target.Factory var1);
    }

    public static interface Handler {
        public InstrumentedType prepare(InstrumentedType var1);

        public Compiled compile(Implementation.Target var1);

        public static class ForAnnotationValue
        implements Handler,
        Compiled {
            private final Object annotationValue;
            private final ModifierResolver modifierResolver;

            public static Handler of(Object annotationValue, ModifierResolver modifierResolver) {
                TypeDescription.ForLoadedType typeDescription = new TypeDescription.ForLoadedType(annotationValue.getClass());
                if (!typeDescription.isAnnotationValue() && !typeDescription.isPrimitiveWrapper()) {
                    throw new IllegalArgumentException("Does not describe an annotation value: " + annotationValue);
                }
                return new ForAnnotationValue(annotationValue, modifierResolver);
            }

            protected ForAnnotationValue(Object annotationValue, ModifierResolver modifierResolver) {
                this.annotationValue = annotationValue;
                this.modifierResolver = modifierResolver;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public TypeWriter.MethodPool.Entry assemble(MethodAttributeAppender attributeAppender) {
                return new TypeWriter.MethodPool.Entry.ForAnnotationDefaultValue(this.annotationValue, attributeAppender, this.modifierResolver);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.annotationValue.equals(((ForAnnotationValue)other).annotationValue) && this.modifierResolver.equals(((ForAnnotationValue)other).modifierResolver);
            }

            public int hashCode() {
                return this.annotationValue.hashCode() + 31 * this.modifierResolver.hashCode();
            }

            public String toString() {
                return "MethodRegistry.Handler.ForAnnotationValue{annotationValue=" + this.annotationValue + ", modifierResolver=" + this.modifierResolver + '}';
            }
        }

        public static class ForImplementation
        implements Handler {
            private final Implementation implementation;
            private final ModifierResolver modifierResolver;

            public ForImplementation(Implementation implementation, ModifierResolver modifierResolver) {
                this.implementation = implementation;
                this.modifierResolver = modifierResolver;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return this.implementation.prepare(instrumentedType);
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return new Compiled(this.implementation.appender(implementationTarget), this.modifierResolver);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.implementation.equals(((ForImplementation)other).implementation) && this.modifierResolver.equals(((ForImplementation)other).modifierResolver);
            }

            public int hashCode() {
                return this.implementation.hashCode() + 31 * this.modifierResolver.hashCode();
            }

            public String toString() {
                return "MethodRegistry.Handler.ForImplementation{implementation=" + this.implementation + ", modifierResolver=" + this.modifierResolver + '}';
            }

            protected static class Compiled
            implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Handler$Compiled {
                private final ByteCodeAppender byteCodeAppender;
                private final ModifierResolver modifierResolver;

                protected Compiled(ByteCodeAppender byteCodeAppender, ModifierResolver modifierResolver) {
                    this.byteCodeAppender = byteCodeAppender;
                    this.modifierResolver = modifierResolver;
                }

                @Override
                public TypeWriter.MethodPool.Entry assemble(MethodAttributeAppender attributeAppender) {
                    return new TypeWriter.MethodPool.Entry.ForImplementation(this.byteCodeAppender, attributeAppender, this.modifierResolver);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppender.equals(((Compiled)other).byteCodeAppender) && this.modifierResolver.equals(((Compiled)other).modifierResolver);
                }

                public int hashCode() {
                    return this.byteCodeAppender.hashCode() + 31 * this.modifierResolver.hashCode();
                }

                public String toString() {
                    return "MethodRegistry.Handler.ForImplementation.Compiled{byteCodeAppender=" + this.byteCodeAppender + ", modifierResolver=" + this.modifierResolver + '}';
                }
            }
        }

        public static interface Compiled {
            public TypeWriter.MethodPool.Entry assemble(MethodAttributeAppender var1);
        }

        public static class ForAbstractMethod
        implements Handler,
        Compiled {
            private final ModifierResolver modifierResolver;

            public ForAbstractMethod(ModifierResolver modifierResolver) {
                this.modifierResolver = modifierResolver;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public TypeWriter.MethodPool.Entry assemble(MethodAttributeAppender attributeAppender) {
                return new TypeWriter.MethodPool.Entry.ForAbstractMethod(attributeAppender, this.modifierResolver);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.modifierResolver.equals(((ForAbstractMethod)other).modifierResolver);
            }

            public int hashCode() {
                return this.modifierResolver.hashCode();
            }

            public String toString() {
                return "MethodRegistry.Handler.ForAbstractMethod{modifierResolver=" + this.modifierResolver + '}';
            }
        }
    }
}

