/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.FilterableList;

public interface TypeList
extends FilterableList<TypeDescription, TypeList> {
    public String[] toInternalNames();

    public int getStackSize();

    public static class Empty
    extends FilterableList.Empty<TypeDescription, TypeList>
    implements TypeList {
        @Override
        public String[] toInternalNames() {
            return null;
        }

        @Override
        public int getStackSize() {
            return 0;
        }
    }

    public static class Explicit
    extends FilterableList.AbstractBase<TypeDescription, TypeList>
    implements TypeList {
        private final List<? extends TypeDescription> typeDescriptions;

        public Explicit(List<? extends TypeDescription> typeDescriptions) {
            this.typeDescriptions = typeDescriptions;
        }

        @Override
        public TypeDescription get(int index) {
            return this.typeDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.typeDescriptions.size();
        }

        @Override
        public String[] toInternalNames() {
            String[] internalNames = new String[this.typeDescriptions.size()];
            int i = 0;
            for (TypeDescription typeDescription : this.typeDescriptions) {
                internalNames[i++] = typeDescription.getInternalName();
            }
            return internalNames.length == 0 ? null : internalNames;
        }

        @Override
        public int getStackSize() {
            int stackSize = 0;
            for (TypeDescription typeDescription : this.typeDescriptions) {
                stackSize += typeDescription.getStackSize().getSize();
            }
            return stackSize;
        }

        @Override
        protected TypeList wrap(List<TypeDescription> values) {
            return new Explicit(values);
        }
    }

    public static class ForLoadedType
    extends FilterableList.AbstractBase<TypeDescription, TypeList>
    implements TypeList {
        private final Class<?>[] type;

        public ForLoadedType(Class<?> ... type) {
            this.type = type;
        }

        public ForLoadedType(List<Class<?>> types) {
            this.type = types.toArray(new Class[types.size()]);
        }

        @Override
        public TypeDescription get(int index) {
            return new TypeDescription.ForLoadedType(this.type[index]);
        }

        @Override
        public int size() {
            return this.type.length;
        }

        @Override
        public String[] toInternalNames() {
            String[] internalNames = new String[this.type.length];
            int i = 0;
            for (Class<?> aType : this.type) {
                internalNames[i++] = Type.getInternalName(aType);
            }
            return internalNames.length == 0 ? null : internalNames;
        }

        @Override
        public int getStackSize() {
            return StackSize.sizeOf(Arrays.asList(this.type));
        }

        @Override
        protected TypeList wrap(List<TypeDescription> values) {
            return new Explicit(values);
        }
    }
}

