/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.FilterableList;

public interface MethodList
extends FilterableList<MethodDescription, MethodList> {

    public static class Empty
    extends FilterableList.Empty<MethodDescription, MethodList>
    implements MethodList {
    }

    public static class Explicit
    extends FilterableList.AbstractBase<MethodDescription, MethodList>
    implements MethodList {
        private final List<? extends MethodDescription> methodDescriptions;

        public Explicit(List<? extends MethodDescription> methodDescriptions) {
            this.methodDescriptions = Collections.unmodifiableList(methodDescriptions);
        }

        @Override
        public MethodDescription get(int index) {
            return this.methodDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.methodDescriptions.size();
        }

        @Override
        protected MethodList wrap(List<MethodDescription> values) {
            return new Explicit(values);
        }
    }

    public static class ForLoadedType
    extends FilterableList.AbstractBase<MethodDescription, MethodList>
    implements MethodList {
        private final List<? extends Method> methods;
        private final List<? extends Constructor<?>> constructors;

        public ForLoadedType(Class<?> type) {
            this(type.getDeclaredConstructors(), type.getDeclaredMethods());
        }

        public ForLoadedType(Constructor<?>[] constructor, Method[] method) {
            this(Arrays.asList(constructor), Arrays.asList(method));
        }

        public ForLoadedType(List<? extends Constructor<?>> constructors, List<? extends Method> methods) {
            this.constructors = constructors;
            this.methods = methods;
        }

        @Override
        public MethodDescription get(int index) {
            return index < this.constructors.size() ? new MethodDescription.ForLoadedConstructor(this.constructors.get(index)) : new MethodDescription.ForLoadedMethod(this.methods.get(index - this.constructors.size()));
        }

        @Override
        public int size() {
            return this.constructors.size() + this.methods.size();
        }

        @Override
        protected MethodList wrap(List<MethodDescription> values) {
            return new Explicit(values);
        }
    }
}

