/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.ByteBuddyCommons;

public enum SuperMethodCall implements Implementation
{
    INSTANCE;


    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget, Appender.TerminationHandler.RETURNING);
    }

    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(WithoutReturn.INSTANCE, ByteBuddyCommons.nonNull(implementation));
    }

    public String toString() {
        return "SuperMethodCall." + this.name();
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;
        private final TerminationHandler terminationHandler;

        protected Appender(Implementation.Target implementationTarget, TerminationHandler terminationHandler) {
            this.implementationTarget = implementationTarget;
            this.terminationHandler = terminationHandler;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            Implementation.SpecialMethodInvocation superMethodCall;
            Implementation.SpecialMethodInvocation specialMethodInvocation = superMethodCall = instrumentedMethod.isDefaultMethod() && this.implementationTarget.getTypeDescription().getInterfaces().contains(instrumentedMethod.getDeclaringType()) ? this.implementationTarget.invokeDefault(instrumentedMethod.getDeclaringType(), instrumentedMethod.getUniqueSignature()) : this.implementationTarget.invokeSuper(instrumentedMethod, Implementation.Target.MethodLookup.Default.EXACT);
            if (!superMethodCall.isValid()) {
                throw new IllegalStateException("Cannot call super (or default) method of " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisReferenceAndArguments(instrumentedMethod), superMethodCall, this.terminationHandler.of(instrumentedMethod)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.implementationTarget.equals(((Appender)other).implementationTarget) && this.terminationHandler.equals((Object)((Appender)other).terminationHandler);
        }

        public int hashCode() {
            return this.implementationTarget.hashCode() + 31 * this.terminationHandler.hashCode();
        }

        public String toString() {
            return "SuperMethodCall.Appender{implementationTarget=" + this.implementationTarget + ", terminationHandler=" + (Object)((Object)this.terminationHandler) + '}';
        }

        protected static enum TerminationHandler {
            RETURNING{

                @Override
                protected StackManipulation of(MethodDescription methodDescription) {
                    return MethodReturn.returning(methodDescription.getReturnType());
                }
            }
            ,
            DROPPING{

                @Override
                protected StackManipulation of(MethodDescription methodDescription) {
                    return Removal.pop(methodDescription.getReturnType());
                }
            };


            protected abstract StackManipulation of(MethodDescription var1);

            public String toString() {
                return "SuperMethodCall.Appender.TerminationHandler." + this.name();
            }
        }
    }

    protected static enum WithoutReturn implements Implementation
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget, Appender.TerminationHandler.DROPPING);
        }

        public String toString() {
            return "SuperMethodCall.WithoutReturn." + this.name();
        }
    }
}

