/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.auxiliary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodLookupEngine;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.implementation.bytecode.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.implementation.bytecode.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public class MethodCallProxy
implements AuxiliaryType {
    private static final String FIELD_NAME_PREFIX = "argument";
    private final Implementation.SpecialMethodInvocation specialMethodInvocation;
    private final boolean serializableProxy;
    private final Assigner assigner;

    public MethodCallProxy(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializableProxy) {
        this(specialMethodInvocation, serializableProxy, new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE)));
    }

    public MethodCallProxy(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializableProxy, Assigner assigner) {
        this.specialMethodInvocation = specialMethodInvocation;
        this.serializableProxy = serializableProxy;
        this.assigner = assigner;
    }

    private static LinkedHashMap<String, TypeDescription> extractFields(MethodDescription methodDescription) {
        ParameterList parameters = methodDescription.getParameters();
        LinkedHashMap<String, TypeDescription> typeDescriptions = new LinkedHashMap<String, TypeDescription>((methodDescription.isStatic() ? 0 : 1) + parameters.size());
        int currentIndex = 0;
        if (!methodDescription.isStatic()) {
            typeDescriptions.put(MethodCallProxy.fieldName(currentIndex++), methodDescription.getDeclaringType());
        }
        for (ParameterDescription parameterDescription : parameters) {
            typeDescriptions.put(MethodCallProxy.fieldName(currentIndex++), parameterDescription.getTypeDescription());
        }
        return typeDescriptions;
    }

    private static String fieldName(int index) {
        return String.format("%s%d", FIELD_NAME_PREFIX, index);
    }

    @Override
    public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
        Class[] classArray;
        MethodDescription accessorMethod = methodAccessorFactory.registerAccessorFor(this.specialMethodInvocation);
        LinkedHashMap<String, TypeDescription> parameterFields = MethodCallProxy.extractFields(accessorMethod);
        DynamicType.Builder.MethodAnnotationTarget methodAnnotationTarget = new ByteBuddy(classFileVersion).subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).methodLookupEngine(ProxyMethodLookupEngine.INSTANCE).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER).implement(Runnable.class, Callable.class).intercept(new MethodCall(accessorMethod, this.assigner));
        if (this.serializableProxy) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Serializable.class;
        } else {
            classArray = new Class[]{};
        }
        DynamicType.Builder<Object> builder = methodAnnotationTarget.implement(classArray).defineConstructor((List<TypeDescription>)new ArrayList<TypeDescription>(parameterFields.values()), new ModifierContributor.ForMethod[0]).intercept(ConstructorCall.INSTANCE);
        for (Map.Entry<String, TypeDescription> field : parameterFields.entrySet()) {
            builder = builder.defineField(field.getKey(), field.getValue(), Visibility.PRIVATE);
        }
        return builder.make();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodCallProxy that = (MethodCallProxy)other;
        return this.serializableProxy == that.serializableProxy && this.assigner.equals(that.assigner) && this.specialMethodInvocation.equals(that.specialMethodInvocation);
    }

    public int hashCode() {
        int result = this.specialMethodInvocation.hashCode();
        result = 31 * result + (this.serializableProxy ? 1 : 0);
        result = 31 * result + this.assigner.hashCode();
        return result;
    }

    public String toString() {
        return "MethodCallProxy{specialMethodInvocation=" + this.specialMethodInvocation + ", serializableProxy=" + this.serializableProxy + ", assigner=" + this.assigner + '}';
    }

    public static class AssignableSignatureCall
    implements StackManipulation {
        private final Implementation.SpecialMethodInvocation specialMethodInvocation;
        private final boolean serializable;

        public AssignableSignatureCall(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializable) {
            this.specialMethodInvocation = specialMethodInvocation;
            this.serializable = serializable;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            TypeDescription auxiliaryType = implementationContext.register(new MethodCallProxy(this.specialMethodInvocation, this.serializable));
            return new StackManipulation.Compound(TypeCreation.forType(auxiliaryType), Duplication.SINGLE, MethodVariableAccess.loadThisReferenceAndArguments(this.specialMethodInvocation.getMethodDescription()), MethodInvocation.invoke((MethodDescription)((MethodList)auxiliaryType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly())).apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.serializable == ((AssignableSignatureCall)other).serializable && this.specialMethodInvocation.equals(((AssignableSignatureCall)other).specialMethodInvocation);
        }

        public int hashCode() {
            return 31 * this.specialMethodInvocation.hashCode() + (this.serializable ? 1 : 0);
        }

        public String toString() {
            return "MethodCallProxy.AssignableSignatureCall{specialMethodInvocation=" + this.specialMethodInvocation + ", serializableProxy=" + this.serializable + '}';
        }
    }

    protected static class MethodCall
    implements Implementation {
        private final MethodDescription accessorMethod;
        private final Assigner assigner;

        protected MethodCall(MethodDescription accessorMethod, Assigner assigner) {
            this.accessorMethod = accessorMethod;
            this.assigner = assigner;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getTypeDescription());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.accessorMethod.equals(((MethodCall)other).accessorMethod) && this.assigner.equals(((MethodCall)other).assigner);
        }

        public int hashCode() {
            return this.accessorMethod.hashCode() + 31 * this.assigner.hashCode();
        }

        public String toString() {
            return "MethodCallProxy.MethodCall{accessorMethod=" + this.accessorMethod + ", assigner=" + this.assigner + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                StackManipulation thisReference = MethodVariableAccess.forType(this.instrumentedType).loadOffset(0);
                FieldList fieldList = this.instrumentedType.getDeclaredFields();
                StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                int index = 0;
                for (FieldDescription fieldDescription : fieldList) {
                    fieldLoading[index++] = new StackManipulation.Compound(thisReference, FieldAccess.forField(fieldDescription).getter());
                }
                StackManipulation.Size stackSize = new StackManipulation.Compound(new StackManipulation.Compound(fieldLoading), MethodInvocation.invoke(MethodCall.this.accessorMethod), MethodCall.this.assigner.assign(MethodCall.this.accessorMethod.getReturnType(), instrumentedMethod.getReturnType(), true), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private MethodCall getMethodCall() {
                return MethodCall.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && MethodCall.this.equals(((Appender)other).getMethodCall());
            }

            public int hashCode() {
                return 31 * MethodCall.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "MethodCallProxy.MethodCall.Appender{methodCall=" + MethodCall.this + ", instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static enum ConstructorCall implements Implementation
    {
        INSTANCE;

        private final MethodDescription objectTypeDefaultConstructor = (MethodDescription)((MethodList)TypeDescription.OBJECT.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getTypeDescription());
        }

        public String toString() {
            return "MethodCallProxy.ConstructorCall." + this.name();
        }

        protected static class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                StackManipulation thisReference = MethodVariableAccess.REFERENCE.loadOffset(0);
                FieldList fieldList = this.instrumentedType.getDeclaredFields();
                StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                int index = 0;
                for (FieldDescription fieldDescription : fieldList) {
                    fieldLoading[index] = new StackManipulation.Compound(thisReference, MethodVariableAccess.forType(fieldDescription.getFieldType()).loadOffset(((ParameterDescription)instrumentedMethod.getParameters().get(index)).getOffset()), FieldAccess.forField(fieldDescription).putter());
                    ++index;
                }
                StackManipulation.Size stackSize = new StackManipulation.Compound(thisReference, MethodInvocation.invoke(INSTANCE.objectTypeDefaultConstructor), new StackManipulation.Compound(fieldLoading), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "MethodCallProxy.ConstructorCall.Appender{instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static enum ProxyMethodLookupEngine implements MethodLookupEngine,
    MethodLookupEngine.Factory
    {
        INSTANCE;

        private final MethodList methodList;

        private ProxyMethodLookupEngine() {
            ArrayList<MethodDescription> methodDescriptions = new ArrayList<MethodDescription>(2);
            methodDescriptions.addAll(new MethodList.ForLoadedType(Runnable.class));
            methodDescriptions.addAll(new MethodList.ForLoadedType(Callable.class));
            this.methodList = new MethodList.Explicit(methodDescriptions);
        }

        @Override
        public MethodLookupEngine.Finding process(TypeDescription typeDescription) {
            ArrayList<MethodDescription> methodDescriptions = new ArrayList<MethodDescription>(3);
            methodDescriptions.addAll(this.methodList);
            methodDescriptions.addAll(typeDescription.getDeclaredMethods());
            return new MethodLookupEngine.Finding.Default(typeDescription, new MethodList.Explicit(methodDescriptions), Collections.<TypeDescription, Set<MethodDescription>>emptyMap());
        }

        @Override
        public MethodLookupEngine make(boolean extractDefaultMethods) {
            return this;
        }

        public String toString() {
            return "MethodCallProxy.ProxyMethodLookupEngine." + this.name();
        }
    }
}

