/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.auxiliary.TypeProxy;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Super {
    public Instantiation strategy() default Instantiation.CONSTRUCTOR;

    public boolean ignoreFinalizer() default true;

    public boolean serializableProxy() default false;

    public Class<?>[] constructorParameters() default {};

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Super>
    {
        INSTANCE;

        private static final MethodDescription STRATEGY;

        @Override
        public Class<Super> getHandledType() {
            return Super.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Super> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
            if (source.isStatic() || !implementationTarget.getTypeDescription().isAssignableTo(target.getTypeDescription())) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(annotation.getValue(STRATEGY, AnnotationDescription.EnumerationValue.class).load(Instantiation.class).proxyFor(target.getTypeDescription(), implementationTarget, annotation));
        }

        public String toString() {
            return "Super.Binder." + this.name();
        }

        static {
            MethodList annotationProperties = new TypeDescription.ForLoadedType(Super.class).getDeclaredMethods();
            STRATEGY = (MethodDescription)((MethodList)annotationProperties.filter(ElementMatchers.returns(Instantiation.class))).getOnly();
        }
    }

    public static enum Instantiation {
        CONSTRUCTOR{

            @Override
            protected StackManipulation proxyFor(TypeDescription parameterType, Implementation.Target implementationTarget, AnnotationDescription.Loadable<Super> annotation) {
                TypeDescription[] constructorParameters = annotation.getValue(CONSTRUCTOR_PARAMETERS, TypeDescription[].class);
                ArrayList<TypeDescription> typeDescriptions = new ArrayList<TypeDescription>(constructorParameters.length);
                for (TypeDescription constructorParameter : constructorParameters) {
                    typeDescriptions.add(TargetType.resolve(constructorParameter, implementationTarget.getTypeDescription()));
                }
                return new TypeProxy.ForSuperMethodByConstructor(parameterType, implementationTarget, typeDescriptions, annotation.getValue(IGNORE_FINALIZER, Boolean.class), annotation.getValue(SERIALIZABLE_PROXY, Boolean.class));
            }
        }
        ,
        UNSAFE{

            @Override
            protected StackManipulation proxyFor(TypeDescription parameterType, Implementation.Target implementationTarget, AnnotationDescription.Loadable<Super> annotation) {
                return new TypeProxy.ForSuperMethodByReflectionFactory(parameterType, implementationTarget, annotation.getValue(IGNORE_FINALIZER, Boolean.class), annotation.getValue(SERIALIZABLE_PROXY, Boolean.class));
            }
        };

        private static final MethodDescription IGNORE_FINALIZER;
        private static final MethodDescription SERIALIZABLE_PROXY;
        private static final MethodDescription CONSTRUCTOR_PARAMETERS;

        protected abstract StackManipulation proxyFor(TypeDescription var1, Implementation.Target var2, AnnotationDescription.Loadable<Super> var3);

        public String toString() {
            return "Super.Instantiation." + this.name();
        }

        static {
            MethodList annotationProperties = new TypeDescription.ForLoadedType(Super.class).getDeclaredMethods();
            IGNORE_FINALIZER = (MethodDescription)((MethodList)annotationProperties.filter(ElementMatchers.named("ignoreFinalizer"))).getOnly();
            SERIALIZABLE_PROXY = (MethodDescription)((MethodList)annotationProperties.filter(ElementMatchers.named("serializableProxy"))).getOnly();
            CONSTRUCTOR_PARAMETERS = (MethodDescription)((MethodList)annotationProperties.filter(ElementMatchers.named("constructorParameters"))).getOnly();
        }
    }
}

