/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.assign;

import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.MethodVisitor;

public class TypeCasting
implements StackManipulation {
    private final String targetTypeInternalName;

    public TypeCasting(TypeDescription targetType) {
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast to primitive type " + targetType);
        }
        this.targetTypeInternalName = targetType.getInternalName();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitTypeInsn(192, this.targetTypeInternalName);
        return StackSize.ZERO.toIncreasingSize();
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.targetTypeInternalName.equals(((TypeCasting)other).targetTypeInternalName);
    }

    public int hashCode() {
        return this.targetTypeInternalName.hashCode();
    }

    public String toString() {
        return "TypeCasting{targetTypeInternalName='" + this.targetTypeInternalName + '\'' + '}';
    }
}

