/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent.builder;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.inline.MethodRebaseResolver;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.StreamDrainer;

public interface AgentBuilder {
    public Identified rebase(RawMatcher var1);

    public Identified rebase(ElementMatcher<? super TypeDescription> var1);

    public Identified rebase(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

    public AgentBuilder withByteBuddy(ByteBuddy var1);

    public AgentBuilder withListener(Listener var1);

    public AgentBuilder withBinaryLocator(BinaryLocator var1);

    public AgentBuilder withNativeMethodPrefix(String var1);

    public AgentBuilder disableSelfInitialization();

    public AgentBuilder allowRetransformation();

    public AgentBuilder enableBootstrapInjection(File var1, Instrumentation var2);

    public ClassFileTransformer makeRaw();

    public ClassFileTransformer installOn(Instrumentation var1);

    public ClassFileTransformer installOnByteBuddyAgent();

    public static class Default
    implements AgentBuilder {
        protected static final String NO_NATIVE_PREFIX = "";
        private static final String BYTE_BUDDY_AGENT_TYPE = "net.bytebuddy.agent.ByteBuddyAgent";
        private static final String GET_INSTRUMENTATION_METHOD = "getInstrumentation";
        private static final Object STATIC_METHOD = null;
        private static final byte[] NO_TRANSFORMATION = null;
        private final ByteBuddy byteBuddy;
        private final BinaryLocator binaryLocator;
        private final Listener listener;
        private final String nativeMethodPrefix;
        private final boolean disableSelfInitialization;
        private final boolean retransformation;
        private final BootstrapInjectionStrategy bootstrapInjectionStrategy;
        private final List<Transformation> entries;

        public Default() {
            this(new ByteBuddy());
        }

        public Default(ByteBuddy byteBuddy) {
            this(ByteBuddyCommons.nonNull(byteBuddy), BinaryLocator.Default.INSTANCE, Listener.NoOp.INSTANCE, NO_NATIVE_PREFIX, false, false, BootstrapInjectionStrategy.Disabled.INSTANCE, Collections.emptyList());
        }

        protected Default(ByteBuddy byteBuddy, BinaryLocator binaryLocator, Listener listener, String nativeMethodPrefix, boolean disableSelfInitialization, boolean retransformation, BootstrapInjectionStrategy bootstrapInjectionStrategy, List<Transformation> entries) {
            this.byteBuddy = byteBuddy;
            this.binaryLocator = binaryLocator;
            this.listener = listener;
            this.nativeMethodPrefix = nativeMethodPrefix;
            this.disableSelfInitialization = disableSelfInitialization;
            this.retransformation = retransformation;
            this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
            this.entries = entries;
        }

        @Override
        public Identified rebase(RawMatcher matcher) {
            return new Matched(ByteBuddyCommons.nonNull(matcher), Transformer.NoOp.INSTANCE);
        }

        @Override
        public Identified rebase(ElementMatcher<? super TypeDescription> typeMatcher) {
            return this.rebase(typeMatcher, ElementMatchers.any());
        }

        @Override
        public Identified rebase(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
            return this.rebase(new RawMatcher.ForElementMatcherPair(ByteBuddyCommons.nonNull(typeMatcher), ByteBuddyCommons.nonNull(classLoaderMatcher)));
        }

        @Override
        public AgentBuilder withByteBuddy(ByteBuddy byteBuddy) {
            return new Default(ByteBuddyCommons.nonNull(byteBuddy), this.binaryLocator, this.listener, this.nativeMethodPrefix, this.disableSelfInitialization, this.retransformation, this.bootstrapInjectionStrategy, this.entries);
        }

        @Override
        public AgentBuilder withListener(Listener listener) {
            return new Default(this.byteBuddy, this.binaryLocator, new Listener.Compound(this.listener, ByteBuddyCommons.nonNull(listener)), this.nativeMethodPrefix, this.disableSelfInitialization, this.retransformation, this.bootstrapInjectionStrategy, this.entries);
        }

        @Override
        public AgentBuilder withBinaryLocator(BinaryLocator binaryLocator) {
            return new Default(this.byteBuddy, ByteBuddyCommons.nonNull(binaryLocator), this.listener, this.nativeMethodPrefix, this.disableSelfInitialization, this.retransformation, this.bootstrapInjectionStrategy, this.entries);
        }

        @Override
        public AgentBuilder withNativeMethodPrefix(String prefix) {
            if (ByteBuddyCommons.nonNull(prefix).length() == 0) {
                throw new IllegalArgumentException("The empty string is not a legal value for a native method prefix");
            }
            return new Default(this.byteBuddy, this.binaryLocator, this.listener, prefix, this.disableSelfInitialization, this.retransformation, this.bootstrapInjectionStrategy, this.entries);
        }

        @Override
        public AgentBuilder allowRetransformation() {
            return new Default(this.byteBuddy, this.binaryLocator, this.listener, this.nativeMethodPrefix, this.disableSelfInitialization, true, this.bootstrapInjectionStrategy, this.entries);
        }

        @Override
        public AgentBuilder disableSelfInitialization() {
            return new Default(this.byteBuddy, this.binaryLocator, this.listener, this.nativeMethodPrefix, true, this.retransformation, this.bootstrapInjectionStrategy, this.entries);
        }

        @Override
        public AgentBuilder enableBootstrapInjection(File folder, Instrumentation instrumentation) {
            return new Default(this.byteBuddy, this.binaryLocator, this.listener, this.nativeMethodPrefix, true, this.retransformation, new BootstrapInjectionStrategy.Enabled(ByteBuddyCommons.nonNull(folder), ByteBuddyCommons.nonNull(instrumentation)), this.entries);
        }

        @Override
        public ClassFileTransformer makeRaw() {
            return new ExecutingTransformer();
        }

        @Override
        public ClassFileTransformer installOn(Instrumentation instrumentation) {
            ClassFileTransformer classFileTransformer = this.makeRaw();
            instrumentation.addTransformer(classFileTransformer, this.retransformation);
            if (!NO_NATIVE_PREFIX.equals(ByteBuddyCommons.nonNull(this.nativeMethodPrefix))) {
                instrumentation.setNativeMethodPrefix(classFileTransformer, this.nativeMethodPrefix);
            }
            return classFileTransformer;
        }

        @Override
        public ClassFileTransformer installOnByteBuddyAgent() {
            try {
                return this.installOn((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(BYTE_BUDDY_AGENT_TYPE).getDeclaredMethod(GET_INSTRUMENTATION_METHOD, new Class[0]).invoke(STATIC_METHOD, new Object[0]));
            }
            catch (Exception exception) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Default aDefault = (Default)other;
            return this.binaryLocator.equals(aDefault.binaryLocator) && this.byteBuddy.equals(aDefault.byteBuddy) && this.listener.equals(aDefault.listener) && this.nativeMethodPrefix.equals(aDefault.nativeMethodPrefix) && this.disableSelfInitialization == aDefault.disableSelfInitialization && this.retransformation == aDefault.retransformation && this.bootstrapInjectionStrategy.equals(aDefault.bootstrapInjectionStrategy) && this.entries.equals(aDefault.entries);
        }

        public int hashCode() {
            int result = this.byteBuddy.hashCode();
            result = 31 * result + this.binaryLocator.hashCode();
            result = 31 * result + this.listener.hashCode();
            result = 31 * result + this.nativeMethodPrefix.hashCode();
            result = 31 * result + (this.disableSelfInitialization ? 1 : 0);
            result = 31 * result + (this.retransformation ? 1 : 0);
            result = 31 * result + this.bootstrapInjectionStrategy.hashCode();
            result = 31 * result + this.entries.hashCode();
            return result;
        }

        public String toString() {
            return "AgentBuilder.Default{byteBuddy=" + this.byteBuddy + ", binaryLocator=" + this.binaryLocator + ", listener=" + this.listener + ", nativeMethodPrefix=" + this.nativeMethodPrefix + ", disableSelfInitialization=" + this.disableSelfInitialization + ", retransformation=" + this.retransformation + ", bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", entries=" + this.entries + '}';
        }

        protected class Matched
        implements Identified.Extendable {
            private final RawMatcher rawMatcher;
            private final Transformer transformer;

            protected Matched(RawMatcher rawMatcher, Transformer transformer) {
                this.rawMatcher = rawMatcher;
                this.transformer = transformer;
            }

            @Override
            public Identified.Extendable transform(Transformer transformer) {
                return new Matched(this.rawMatcher, new Transformer.Compound(this.transformer, ByteBuddyCommons.nonNull(transformer)));
            }

            @Override
            public Identified rebase(RawMatcher matcher) {
                return this.materialize().rebase(matcher);
            }

            @Override
            public Identified rebase(ElementMatcher<? super TypeDescription> typeMatcher) {
                return this.materialize().rebase(typeMatcher);
            }

            @Override
            public Identified rebase(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                return this.materialize().rebase(typeMatcher, classLoaderMatcher);
            }

            @Override
            public AgentBuilder withByteBuddy(ByteBuddy byteBuddy) {
                return this.materialize().withByteBuddy(byteBuddy);
            }

            @Override
            public AgentBuilder withListener(Listener listener) {
                return this.materialize().withListener(listener);
            }

            @Override
            public AgentBuilder withBinaryLocator(BinaryLocator binaryLocator) {
                return this.materialize().withBinaryLocator(binaryLocator);
            }

            @Override
            public AgentBuilder withNativeMethodPrefix(String prefix) {
                return this.materialize().withNativeMethodPrefix(prefix);
            }

            @Override
            public AgentBuilder disableSelfInitialization() {
                return this.materialize().disableSelfInitialization();
            }

            @Override
            public AgentBuilder allowRetransformation() {
                return this.materialize().allowRetransformation();
            }

            @Override
            public AgentBuilder enableBootstrapInjection(File folder, Instrumentation instrumentation) {
                return this.materialize().enableBootstrapInjection(folder, instrumentation);
            }

            @Override
            public ClassFileTransformer makeRaw() {
                return this.materialize().makeRaw();
            }

            @Override
            public ClassFileTransformer installOn(Instrumentation instrumentation) {
                return this.materialize().installOn(instrumentation);
            }

            @Override
            public ClassFileTransformer installOnByteBuddyAgent() {
                return this.materialize().installOnByteBuddyAgent();
            }

            protected AgentBuilder materialize() {
                return new Default(Default.this.byteBuddy, Default.this.binaryLocator, Default.this.listener, Default.this.nativeMethodPrefix, Default.this.disableSelfInitialization, Default.this.retransformation, Default.this.bootstrapInjectionStrategy, ByteBuddyCommons.join(new Transformation(this.rawMatcher, this.transformer), Default.this.entries));
            }

            private Default getOuter() {
                return Default.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.rawMatcher.equals(((Matched)other).rawMatcher) && this.transformer.equals(((Matched)other).transformer) && Default.this.equals(((Matched)other).getOuter());
            }

            public int hashCode() {
                int result = this.rawMatcher.hashCode();
                result = 31 * result + this.transformer.hashCode();
                result = 31 * result + Default.this.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.Matched{rawMatcher=" + this.rawMatcher + ", transformer=" + this.transformer + ", agentBuilder=" + Default.this + '}';
            }
        }

        protected class ExecutingTransformer
        implements ClassFileTransformer {
            private final MethodRebaseResolver.MethodNameTransformer methodNameTransformer;
            private final InitializationStrategy initializationStrategy;

            public ExecutingTransformer() {
                this.methodNameTransformer = Default.NO_NATIVE_PREFIX.equals(Default.this.nativeMethodPrefix) ? new MethodRebaseResolver.MethodNameTransformer.Suffixing() : new MethodRebaseResolver.MethodNameTransformer.Prefixing(Default.this.nativeMethodPrefix);
                this.initializationStrategy = Default.this.disableSelfInitialization ? InitializationStrategy.NoOp.INSTANCE : new InitializationStrategy.SelfInjection();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                String binaryTypeName = internalTypeName.replace('/', '.');
                try {
                    BinaryLocator.Initialized initialized = Default.this.binaryLocator.initialize(binaryTypeName, binaryRepresentation, classLoader);
                    TypeDescription typeDescription = initialized.getTypePool().describe(binaryTypeName).resolve();
                    for (Transformation transformation : Default.this.entries) {
                        if (!transformation.matches(typeDescription, classLoader, classBeingRedefined, protectionDomain)) continue;
                        DynamicType.Unloaded<?> dynamicType = this.initializationStrategy.apply(transformation.transform(Default.this.byteBuddy.rebase(typeDescription, initialized.getClassFileLocator(), this.methodNameTransformer), typeDescription)).make();
                        Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = dynamicType.getLoadedTypeInitializers();
                        if (loadedTypeInitializers.size() > 1) {
                            ClassInjector classInjector = classLoader == null ? Default.this.bootstrapInjectionStrategy.make(protectionDomain) : new ClassInjector.UsingReflection(classLoader, protectionDomain, PackageDefinitionStrategy.NoOp.INSTANCE);
                            for (Map.Entry<TypeDescription, Class<?>> auxiliary : classInjector.inject(dynamicType.getRawAuxiliaryTypes()).entrySet()) {
                                this.initializationStrategy.initialize(auxiliary.getValue(), loadedTypeInitializers.get(auxiliary.getKey()));
                            }
                        }
                        this.initializationStrategy.register(binaryTypeName, classLoader, loadedTypeInitializers.get(dynamicType.getTypeDescription()));
                        Default.this.listener.onTransformation(typeDescription, dynamicType);
                        byte[] byArray = dynamicType.getBytes();
                        return byArray;
                    }
                    Default.this.listener.onIgnored(binaryTypeName);
                    Object object = NO_TRANSFORMATION;
                    return object;
                }
                catch (Throwable throwable) {
                    Default.this.listener.onError(binaryTypeName, throwable);
                    byte[] byArray = NO_TRANSFORMATION;
                    return byArray;
                }
                finally {
                    Default.this.listener.onComplete(binaryTypeName);
                }
            }

            public String toString() {
                return "AgentBuilder.Default.ExecutingTransformer{agentBuilder=" + Default.this + ", methodNameTransformer=" + this.methodNameTransformer + ", initializationStrategy=" + this.initializationStrategy + '}';
            }
        }

        protected static class Transformation
        implements RawMatcher,
        Transformer {
            private final RawMatcher rawMatcher;
            private final Transformer transformer;

            protected Transformation(RawMatcher rawMatcher, Transformer transformer) {
                this.rawMatcher = rawMatcher;
                this.transformer = transformer;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.rawMatcher.matches(typeDescription, classLoader, classBeingRedefined, protectionDomain);
            }

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription) {
                return this.transformer.transform(builder, typeDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.rawMatcher.equals(((Transformation)other).rawMatcher) && this.transformer.equals(((Transformation)other).transformer);
            }

            public int hashCode() {
                int result = this.rawMatcher.hashCode();
                result = 31 * result + this.transformer.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.Transformation{rawMatcher=" + this.rawMatcher + ", transformer=" + this.transformer + '}';
            }
        }

        protected static interface BootstrapInjectionStrategy {
            public ClassInjector make(ProtectionDomain var1);

            public static class Enabled
            implements BootstrapInjectionStrategy {
                private final File folder;
                private final Instrumentation instrumentation;

                public Enabled(File folder, Instrumentation instrumentation) {
                    this.folder = folder;
                    this.instrumentation = instrumentation;
                }

                @Override
                public ClassInjector make(ProtectionDomain protectionDomain) {
                    return new ClassInjector.UsingInstrumentation(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Enabled enabled = (Enabled)other;
                    return this.folder.equals(enabled.folder) && this.instrumentation.equals(enabled.instrumentation);
                }

                public int hashCode() {
                    int result = this.folder.hashCode();
                    result = 31 * result + this.instrumentation.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.BootstrapInjectionStrategy.Enabled{folder=" + this.folder + ", instrumentation=" + this.instrumentation + '}';
                }
            }

            public static enum Disabled implements BootstrapInjectionStrategy
            {
                INSTANCE;


                @Override
                public ClassInjector make(ProtectionDomain protectionDomain) {
                    throw new IllegalStateException("Injecting classes into the bootstrap class loader was not enabled");
                }

                public String toString() {
                    return "AgentBuilder.Default.BootstrapInjectionStrategy.Disabled." + this.name();
                }
            }
        }

        public static interface InitializationStrategy {
            public void initialize(Class<?> var1, LoadedTypeInitializer var2);

            public DynamicType.Builder<?> apply(DynamicType.Builder<?> var1);

            public void register(String var1, ClassLoader var2, LoadedTypeInitializer var3);

            public static class SelfInjection
            implements InitializationStrategy,
            Implementation,
            ByteCodeAppender {
                private final Nexus.Accessor accessor = Nexus.Accessor.INSTANCE;

                @Override
                public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                    return builder.invokable(ElementMatchers.none()).intercept(this);
                }

                @Override
                public void initialize(Class<?> type, LoadedTypeInitializer loadedTypeInitializer) {
                    loadedTypeInitializer.onLoad(type);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withInitializer(this.accessor.initializerFor(instrumentedType));
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return this;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                    throw new IllegalStateException("Initialization strategy illegally applied to " + instrumentedMethod);
                }

                @Override
                public void register(String name, ClassLoader classLoader, LoadedTypeInitializer loadedTypeInitializer) {
                    if (loadedTypeInitializer.isAlive()) {
                        this.accessor.register(name, classLoader, loadedTypeInitializer);
                    }
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.accessor == ((SelfInjection)other).accessor;
                }

                public int hashCode() {
                    return this.accessor.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.Default.InitializationStrategy.SelfInjection{accessor=" + (Object)((Object)this.accessor) + '}';
                }

                public static class Nexus {
                    private static final ConcurrentMap<Nexus, Object> TYPE_INITIALIZERS = new ConcurrentHashMap<Nexus, Object>();
                    private final String name;
                    private final ClassLoader classLoader;

                    private Nexus(Class<?> type) {
                        this.name = type.getName();
                        this.classLoader = type.getClassLoader();
                    }

                    private Nexus(String name, ClassLoader classLoader) {
                        this.name = name;
                        this.classLoader = classLoader;
                    }

                    public static void initialize(Class<?> type) throws Exception {
                        Object typeInitializer = TYPE_INITIALIZERS.remove(new Nexus(type));
                        if (typeInitializer != null) {
                            typeInitializer.getClass().getMethod("onLoad", Class.class).invoke(typeInitializer, type);
                        }
                    }

                    public static void register(String name, ClassLoader classLoader, Object typeInitializer) {
                        TYPE_INITIALIZERS.put(new Nexus(name, classLoader), typeInitializer);
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Nexus nexus = (Nexus)other;
                        return !(this.classLoader == null ? nexus.classLoader != null : !this.classLoader.equals(nexus.classLoader)) && this.name.equals(nexus.name);
                    }

                    public int hashCode() {
                        int result = this.name.hashCode();
                        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.Default.InitializationStrategy.SelfInjection.Nexus{name='" + this.name + '\'' + ", classLoader=" + this.classLoader + '}';
                    }

                    protected static enum Accessor {
                        INSTANCE;

                        private static final Object STATIC_METHOD;
                        private final Method registration;
                        private final MethodDescription systemClassLoader;
                        private final MethodDescription loadClass;
                        private final MethodDescription getDeclaredMethod;
                        private final MethodDescription invokeMethod;

                        private Accessor() {
                            try {
                                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                TypeDescription.ForLoadedType nexusType = new TypeDescription.ForLoadedType(Nexus.class);
                                Class<?> nexus = new ClassInjector.UsingReflection(classLoader).inject(Collections.singletonMap(nexusType, new StreamDrainer().drain(classLoader.getResourceAsStream(Nexus.class.getName().replace('.', '/') + ".class")))).get(nexusType);
                                this.registration = nexus.getDeclaredMethod("register", String.class, ClassLoader.class, Object.class);
                                this.systemClassLoader = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("getSystemClassLoader"))).getOnly();
                                this.loadClass = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("loadClass").and(ElementMatchers.takesArguments(String.class)))).getOnly();
                                this.getDeclaredMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Class.class).getDeclaredMethods().filter(ElementMatchers.named("getDeclaredMethod").and(ElementMatchers.takesArguments(String.class, Class[].class)))).getOnly();
                                this.invokeMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Method.class).getDeclaredMethods().filter(ElementMatchers.named("invoke").and(ElementMatchers.takesArguments(Object.class, Object[].class)))).getOnly();
                            }
                            catch (Exception exception) {
                                throw new IllegalStateException("Cannot create type initialization accessor", exception);
                            }
                        }

                        public void register(String name, ClassLoader classLoader, Object typeInitializer) {
                            try {
                                this.registration.invoke(STATIC_METHOD, name, classLoader, typeInitializer);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot register type initializer for " + name, exception);
                            }
                            catch (InvocationTargetException exception) {
                                throw new IllegalStateException("Cannot register type initializer for " + name, exception.getCause());
                            }
                        }

                        public ByteCodeAppender initializerFor(TypeDescription instrumentedType) {
                            return new ByteCodeAppender.Simple(new StackManipulation.Compound(MethodInvocation.invoke(this.systemClassLoader), new TextConstant(Nexus.class.getName()), MethodInvocation.invoke(this.loadClass), new TextConstant("initialize"), ArrayFactory.forType(TypeDescription.CLASS).withValues(Collections.singletonList(ClassConstant.of(TypeDescription.CLASS))), MethodInvocation.invoke(this.getDeclaredMethod), NullConstant.INSTANCE, ArrayFactory.forType(TypeDescription.OBJECT).withValues(Collections.singletonList(ClassConstant.of(instrumentedType))), MethodInvocation.invoke(this.invokeMethod), Removal.SINGLE));
                        }

                        public String toString() {
                            return "AgentBuilder.Default.InitializationStrategy.SelfInjection.Nexus.Accessor." + this.name();
                        }

                        static {
                            STATIC_METHOD = null;
                        }
                    }
                }
            }

            public static enum NoOp implements InitializationStrategy
            {
                INSTANCE;


                @Override
                public void initialize(Class<?> type, LoadedTypeInitializer loadedTypeInitializer) {
                }

                @Override
                public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                    return builder;
                }

                @Override
                public void register(String name, ClassLoader classLoader, LoadedTypeInitializer loadedTypeInitializer) {
                }

                public String toString() {
                    return "AgentBuilder.Default.InitializationStrategy.NoOp." + this.name();
                }
            }
        }
    }

    public static interface Listener {
        public void onTransformation(TypeDescription var1, DynamicType var2);

        public void onError(String var1, Throwable var2);

        public void onIgnored(String var1);

        public void onComplete(String var1);

        public static class Compound
        implements Listener {
            private final Listener[] listener;

            public Compound(Listener ... listener) {
                this.listener = listener;
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, DynamicType dynamicType) {
                for (Listener listener : this.listener) {
                    listener.onTransformation(typeDescription, dynamicType);
                }
            }

            @Override
            public void onError(String typeName, Throwable throwable) {
                for (Listener listener : this.listener) {
                    listener.onError(typeName, throwable);
                }
            }

            @Override
            public void onIgnored(String typeName) {
                for (Listener listener : this.listener) {
                    listener.onIgnored(typeName);
                }
            }

            @Override
            public void onComplete(String typeName) {
                for (Listener listener : this.listener) {
                    listener.onComplete(typeName);
                }
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.listener, ((Compound)other).listener);
            }

            public int hashCode() {
                return Arrays.hashCode(this.listener);
            }

            public String toString() {
                return "AgentBuilder.Listener.Compound{listener=" + Arrays.toString(this.listener) + '}';
            }
        }

        public static enum NoOp implements Listener
        {
            INSTANCE;


            @Override
            public void onTransformation(TypeDescription typeDescription, DynamicType dynamicType) {
            }

            @Override
            public void onError(String typeName, Throwable throwable) {
            }

            @Override
            public void onIgnored(String typeName) {
            }

            @Override
            public void onComplete(String typeName) {
            }

            public String toString() {
                return "AgentBuilder.Listener.NoOp." + this.name();
            }
        }
    }

    public static interface BinaryLocator {
        public Initialized initialize(String var1, byte[] var2, ClassLoader var3);

        public static interface Initialized {
            public TypePool getTypePool();

            public ClassFileLocator getClassFileLocator();
        }

        public static enum Default implements BinaryLocator
        {
            INSTANCE;


            @Override
            public net.bytebuddy.agent.builder.AgentBuilder$BinaryLocator$Initialized initialize(String typeName, byte[] binaryRepresentation, ClassLoader classLoader) {
                return new Initialized(typeName, binaryRepresentation, new TypePool.CacheProvider.Simple(), ClassFileLocator.ForClassLoader.of(classLoader));
            }

            public String toString() {
                return "AgentBuilder.BinaryLocator.Default." + this.name();
            }

            protected static class Initialized
            implements net.bytebuddy.agent.builder.AgentBuilder$BinaryLocator$Initialized,
            ClassFileLocator {
                private final String typeName;
                private final byte[] binaryRepresentation;
                private final ClassFileLocator classFileLocator;
                private final TypePool typePool;

                public Initialized(String typeName, byte[] binaryRepresentation, TypePool.CacheProvider cacheProvider, ClassFileLocator classFileLocator) {
                    this.typeName = typeName;
                    this.binaryRepresentation = binaryRepresentation;
                    this.typePool = new TypePool.Default(cacheProvider, classFileLocator);
                    this.classFileLocator = classFileLocator;
                }

                @Override
                public TypePool getTypePool() {
                    return this.typePool;
                }

                @Override
                public ClassFileLocator getClassFileLocator() {
                    return this;
                }

                @Override
                public ClassFileLocator.Resolution locate(String typeName) throws IOException {
                    return this.typeName.equals(typeName) ? new ClassFileLocator.Resolution.Explicit(this.binaryRepresentation) : this.classFileLocator.locate(typeName);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Initialized that = (Initialized)other;
                    return Arrays.equals(this.binaryRepresentation, that.binaryRepresentation) && this.classFileLocator.equals(that.classFileLocator) && this.typeName.equals(that.typeName) && this.typePool.equals(that.typePool);
                }

                public int hashCode() {
                    int result = this.typeName.hashCode();
                    result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
                    result = 31 * result + this.classFileLocator.hashCode();
                    result = 31 * result + this.typePool.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.BinaryLocator.Default.Initialized{typeName='" + this.typeName + '\'' + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + ", classFileLocator=" + this.classFileLocator + ", typePool=" + this.typePool + '}';
                }
            }
        }
    }

    public static interface Transformer {
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> var1, TypeDescription var2);

        public static class Compound
        implements Transformer {
            private final Transformer[] transformer;

            public Compound(Transformer ... transformer) {
                this.transformer = transformer;
            }

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription) {
                for (Transformer transformer : this.transformer) {
                    builder = transformer.transform(builder, typeDescription);
                }
                return builder;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.transformer, ((Compound)other).transformer);
            }

            public int hashCode() {
                return Arrays.hashCode(this.transformer);
            }

            public String toString() {
                return "AgentBuilder.Transformer.Compound{transformer=" + Arrays.toString(this.transformer) + '}';
            }
        }

        public static enum NoOp implements Transformer
        {
            INSTANCE;


            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription) {
                return builder;
            }

            public String toString() {
                return "AgentBuilder.Transformer.NoOp." + this.name();
            }
        }
    }

    public static interface RawMatcher {
        public boolean matches(TypeDescription var1, ClassLoader var2, Class<?> var3, ProtectionDomain var4);

        public static class ForElementMatcherPair
        implements RawMatcher {
            private final ElementMatcher<? super TypeDescription> typeMatcher;
            private final ElementMatcher<? super ClassLoader> classLoaderMatcher;

            public ForElementMatcherPair(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                this.typeMatcher = typeMatcher;
                this.classLoaderMatcher = classLoaderMatcher;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.classLoaderMatcher.matches(classLoader) && this.typeMatcher.matches(typeDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.classLoaderMatcher.equals(((ForElementMatcherPair)other).classLoaderMatcher) && this.typeMatcher.equals(((ForElementMatcherPair)other).typeMatcher);
            }

            public int hashCode() {
                int result = this.typeMatcher.hashCode();
                result = 31 * result + this.classLoaderMatcher.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.ForElementMatcherPair{typeMatcher=" + this.typeMatcher + ", classLoaderMatcher=" + this.classLoaderMatcher + '}';
            }
        }
    }

    public static interface Identified {
        public Extendable transform(Transformer var1);

        public static interface Extendable
        extends AgentBuilder,
        Identified {
        }
    }
}

