/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.FilterableList;

public interface TypeList
extends FilterableList<TypeDescription, TypeList> {
    public String[] toInternalNames();

    public int getStackSize();

    public GenericTypeList asGenericTypes();

    public GenericTypeList accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> var1);

    public static class Empty
    extends FilterableList.Empty<TypeDescription, TypeList>
    implements TypeList {
        @Override
        public String[] toInternalNames() {
            return null;
        }

        @Override
        public int getStackSize() {
            return 0;
        }

        @Override
        public GenericTypeList asGenericTypes() {
            return new GenericTypeList.Empty();
        }

        @Override
        public GenericTypeList accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            return new GenericTypeList.Empty();
        }
    }

    public static class Explicit
    extends AbstractBase {
        private final List<? extends TypeDescription> typeDescriptions;

        public Explicit(List<? extends TypeDescription> typeDescriptions) {
            this.typeDescriptions = typeDescriptions;
        }

        @Override
        public TypeDescription get(int index) {
            return this.typeDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.typeDescriptions.size();
        }

        @Override
        public String[] toInternalNames() {
            String[] internalNames = new String[this.typeDescriptions.size()];
            int i = 0;
            for (TypeDescription typeDescription : this.typeDescriptions) {
                internalNames[i++] = typeDescription.getInternalName();
            }
            return internalNames.length == 0 ? null : internalNames;
        }

        @Override
        public int getStackSize() {
            int stackSize = 0;
            for (TypeDescription typeDescription : this.typeDescriptions) {
                stackSize += typeDescription.getStackSize().getSize();
            }
            return stackSize;
        }

        @Override
        public GenericTypeList asGenericTypes() {
            return new GenericTypeList.Explicit(this.typeDescriptions);
        }
    }

    public static class ForLoadedType
    extends AbstractBase {
        private final List<? extends Class<?>> types;

        public ForLoadedType(Class<?> ... type) {
            this(Arrays.asList(type));
        }

        public ForLoadedType(List<? extends Class<?>> types) {
            this.types = types;
        }

        @Override
        public TypeDescription get(int index) {
            return new TypeDescription.ForLoadedType(this.types.get(index));
        }

        @Override
        public int size() {
            return this.types.size();
        }

        @Override
        public String[] toInternalNames() {
            String[] internalNames = new String[this.types.size()];
            int i = 0;
            for (Class<?> type : this.types) {
                internalNames[i++] = Type.getInternalName(type);
            }
            return internalNames.length == 0 ? null : internalNames;
        }

        @Override
        public int getStackSize() {
            return StackSize.sizeOf(this.types);
        }

        @Override
        public GenericTypeList asGenericTypes() {
            return new GenericTypeList.ForLoadedType(this.types);
        }
    }

    public static abstract class AbstractBase
    extends FilterableList.AbstractBase<TypeDescription, TypeList>
    implements TypeList {
        @Override
        protected TypeList wrap(List<TypeDescription> values) {
            return new Explicit(values);
        }

        @Override
        public GenericTypeList accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            ArrayList<GenericTypeDescription> visited = new ArrayList<GenericTypeDescription>(this.size());
            for (TypeDescription typeDescription : this) {
                visited.add(typeDescription.accept(visitor));
            }
            return new GenericTypeList.Explicit(visited);
        }
    }
}

