/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type.generic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.description.type.generic.TypeVariableSource;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.signature.SignatureVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.JavaMethod;

public interface GenericTypeDescription
extends NamedElement,
Iterable<GenericTypeDescription> {
    public static final TypeDescription NO_OWNER_TYPE = null;

    public Sort getSort();

    public String getTypeName();

    public TypeDescription asRawType();

    public GenericTypeDescription getSuperType();

    public GenericTypeList getInterfaces();

    public FieldList<?> getDeclaredFields();

    public MethodList<?> getDeclaredMethods();

    public GenericTypeList getUpperBounds();

    public GenericTypeList getLowerBounds();

    public GenericTypeDescription getComponentType();

    public GenericTypeList getParameters();

    public GenericTypeDescription getOwnerType();

    public TypeVariableSource getVariableSource();

    public String getSymbol();

    public StackSize getStackSize();

    public boolean isArray();

    public boolean isPrimitive();

    public <T> T accept(Visitor<T> var1);

    public static class SuperTypeIterator
    implements Iterator<GenericTypeDescription> {
        private GenericTypeDescription nextType;

        public SuperTypeIterator(GenericTypeDescription initialType) {
            this.nextType = initialType;
        }

        @Override
        public boolean hasNext() {
            return this.nextType != null;
        }

        @Override
        public GenericTypeDescription next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("End of type hierarchy");
            }
            try {
                GenericTypeDescription genericTypeDescription = this.nextType;
                return genericTypeDescription;
            }
            finally {
                this.nextType = this.nextType.getSuperType();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public String toString() {
            return "GenericTypeDescription.SuperTypeIterator{nextType=" + this.nextType + '}';
        }
    }

    public static abstract class LazyProjection
    implements GenericTypeDescription {
        protected abstract GenericTypeDescription resolve();

        @Override
        public Sort getSort() {
            return this.resolve().getSort();
        }

        @Override
        public GenericTypeList getInterfaces() {
            return this.resolve().getInterfaces();
        }

        @Override
        public GenericTypeDescription getSuperType() {
            return this.resolve().getSuperType();
        }

        public FieldList getDeclaredFields() {
            return this.resolve().getDeclaredFields();
        }

        public MethodList getDeclaredMethods() {
            return this.resolve().getDeclaredMethods();
        }

        @Override
        public GenericTypeList getUpperBounds() {
            return this.resolve().getUpperBounds();
        }

        @Override
        public GenericTypeList getLowerBounds() {
            return this.resolve().getLowerBounds();
        }

        @Override
        public GenericTypeDescription getComponentType() {
            return this.resolve().getComponentType();
        }

        @Override
        public GenericTypeList getParameters() {
            return this.resolve().getParameters();
        }

        @Override
        public TypeVariableSource getVariableSource() {
            return this.resolve().getVariableSource();
        }

        @Override
        public GenericTypeDescription getOwnerType() {
            return this.resolve().getOwnerType();
        }

        @Override
        public String getTypeName() {
            return this.resolve().getTypeName();
        }

        @Override
        public String getSymbol() {
            return this.resolve().getSymbol();
        }

        @Override
        public String getSourceCodeName() {
            return this.resolve().getSourceCodeName();
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return this.resolve().accept(visitor);
        }

        @Override
        public StackSize getStackSize() {
            return this.asRawType().getStackSize();
        }

        @Override
        public boolean isArray() {
            return this.asRawType().isArray();
        }

        @Override
        public boolean isPrimitive() {
            return this.asRawType().isPrimitive();
        }

        @Override
        public Iterator<GenericTypeDescription> iterator() {
            return this.resolve().iterator();
        }

        public int hashCode() {
            return this.resolve().hashCode();
        }

        public boolean equals(Object other) {
            return this.resolve().equals(other);
        }

        public String toString() {
            return this.resolve().toString();
        }

        public static class OfLoadedParameter
        extends LazyProjection {
            protected static final JavaMethod GET_TYPE;
            protected static final JavaMethod GET_GENERIC_TYPE;
            private final Object parameter;

            public OfLoadedParameter(Object parameter) {
                this.parameter = parameter;
            }

            @Override
            protected GenericTypeDescription resolve() {
                return Sort.describe((Type)GET_GENERIC_TYPE.invoke(this.parameter, new Object[0]));
            }

            @Override
            public TypeDescription asRawType() {
                return new TypeDescription.ForLoadedType((Class)GET_TYPE.invoke(this.parameter, new Object[0]));
            }

            static {
                JavaMethod getGenericType;
                JavaMethod getType;
                try {
                    Class<?> parameterType = Class.forName("java.lang.reflect.Parameter");
                    getType = new JavaMethod.ForLoadedMethod(parameterType.getDeclaredMethod("getType", new Class[0]));
                    getGenericType = new JavaMethod.ForLoadedMethod(parameterType.getDeclaredMethod("getParameterizedType", new Class[0]));
                }
                catch (Exception ignored) {
                    getType = JavaMethod.ForUnavailableMethod.INSTANCE;
                    getGenericType = JavaMethod.ForUnavailableMethod.INSTANCE;
                }
                GET_TYPE = getType;
                GET_GENERIC_TYPE = getGenericType;
            }

            public static class OfLegacyVmMethod
            extends LazyProjection {
                private final Method method;
                private final int index;
                private final Class<?> rawType;

                public OfLegacyVmMethod(Method method, int index, Class<?> rawType) {
                    this.method = method;
                    this.index = index;
                    this.rawType = rawType;
                }

                @Override
                protected GenericTypeDescription resolve() {
                    return Sort.describe(this.method.getGenericParameterTypes()[this.index]);
                }

                @Override
                public TypeDescription asRawType() {
                    return new TypeDescription.ForLoadedType(this.rawType);
                }
            }

            public static class OfLegacyVmConstructor
            extends LazyProjection {
                private final Constructor<?> constructor;
                private final int index;
                private final Class<?> rawType;

                public OfLegacyVmConstructor(Constructor<?> constructor, int index, Class<?> rawType) {
                    this.constructor = constructor;
                    this.index = index;
                    this.rawType = rawType;
                }

                @Override
                protected GenericTypeDescription resolve() {
                    return Sort.describe(this.constructor.getGenericParameterTypes()[this.index]);
                }

                @Override
                public TypeDescription asRawType() {
                    return new TypeDescription.ForLoadedType(this.rawType);
                }
            }
        }

        public static class OfLoadedReturnType
        extends LazyProjection {
            private final Method method;

            public OfLoadedReturnType(Method method) {
                this.method = method;
            }

            @Override
            protected GenericTypeDescription resolve() {
                return Sort.describe(this.method.getGenericReturnType());
            }

            @Override
            public TypeDescription asRawType() {
                return new TypeDescription.ForLoadedType(this.method.getReturnType());
            }
        }

        public static class OfLoadedFieldType
        extends LazyProjection {
            private final Field field;

            public OfLoadedFieldType(Field field) {
                this.field = field;
            }

            @Override
            protected GenericTypeDescription resolve() {
                return Sort.describe(this.field.getGenericType());
            }

            @Override
            public TypeDescription asRawType() {
                return new TypeDescription.ForLoadedType(this.field.getType());
            }
        }

        public static class OfLoadedSuperType
        extends LazyProjection {
            private final Class<?> type;

            public OfLoadedSuperType(Class<?> type) {
                this.type = type;
            }

            @Override
            protected GenericTypeDescription resolve() {
                Type superClass = this.type.getGenericSuperclass();
                return superClass == null ? null : Sort.describe(superClass);
            }

            @Override
            public TypeDescription asRawType() {
                Class<?> superClass = this.type.getSuperclass();
                return superClass == null ? null : new TypeDescription.ForLoadedType(superClass);
            }
        }

        public static class OfPotentiallyRawType
        extends LazyProjection {
            private final GenericTypeDescription unresolvedType;
            private final Visitor<? extends GenericTypeDescription> transformer;

            public OfPotentiallyRawType(GenericTypeDescription unresolvedType, Visitor<? extends GenericTypeDescription> transformer) {
                this.unresolvedType = unresolvedType;
                this.transformer = transformer;
            }

            public static GenericTypeDescription of(GenericTypeDescription unresolvedType, Visitor<? extends GenericTypeDescription> transformer) {
                if (unresolvedType == null) {
                    return null;
                }
                return new OfPotentiallyRawType(unresolvedType, transformer);
            }

            @Override
            protected GenericTypeDescription resolve() {
                return ForParameterizedType.Raw.check(this.unresolvedType, this.transformer);
            }

            @Override
            public TypeDescription asRawType() {
                return this.unresolvedType.asRawType();
            }
        }
    }

    public static abstract class ForTypeVariable
    implements GenericTypeDescription {
        @Override
        public Sort getSort() {
            return Sort.VARIABLE;
        }

        @Override
        public TypeDescription asRawType() {
            GenericTypeList upperBounds = this.getUpperBounds();
            return upperBounds.isEmpty() ? TypeDescription.OBJECT : ((GenericTypeDescription)upperBounds.get(0)).asRawType();
        }

        @Override
        public GenericTypeDescription getSuperType() {
            throw new IllegalStateException("A type variable does not imply a super type definition: " + this);
        }

        @Override
        public GenericTypeList getInterfaces() {
            throw new IllegalStateException("A type variable does not imply an interface type definition: " + this);
        }

        public FieldList getDeclaredFields() {
            throw new IllegalStateException("A type variable does not imply field definitions: " + this);
        }

        public MethodList getDeclaredMethods() {
            throw new IllegalStateException("A type variable does not imply method definitions: " + this);
        }

        @Override
        public GenericTypeDescription getComponentType() {
            throw new IllegalStateException("A type variable does not imply a component type: " + this);
        }

        @Override
        public GenericTypeList getParameters() {
            throw new IllegalStateException("A type variable does not imply type parameters: " + this);
        }

        @Override
        public GenericTypeList getLowerBounds() {
            throw new IllegalStateException("A type variable does not imply lower bounds: " + this);
        }

        @Override
        public GenericTypeDescription getOwnerType() {
            throw new IllegalStateException("A type variable does not imply an owner type: " + this);
        }

        @Override
        public String getTypeName() {
            return this.toString();
        }

        @Override
        public String getSourceCodeName() {
            return this.getSymbol();
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.onTypeVariable(this);
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.SINGLE;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public Iterator<GenericTypeDescription> iterator() {
            throw new IllegalStateException("A type variable does not imply a super type definition: " + this);
        }

        public int hashCode() {
            return this.getVariableSource().hashCode() ^ this.getSymbol().hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof GenericTypeDescription)) {
                return false;
            }
            GenericTypeDescription genericTypeDescription = (GenericTypeDescription)other;
            return genericTypeDescription.getSort().isTypeVariable() && this.getSymbol().equals(genericTypeDescription.getSymbol()) && this.getVariableSource().equals(genericTypeDescription.getVariableSource());
        }

        public String toString() {
            return this.getSymbol();
        }

        public static class OfLoadedType
        extends ForTypeVariable {
            private final TypeVariable<?> typeVariable;

            public OfLoadedType(TypeVariable<?> typeVariable) {
                this.typeVariable = typeVariable;
            }

            @Override
            public TypeVariableSource getVariableSource() {
                Object genericDeclaration = this.typeVariable.getGenericDeclaration();
                if (genericDeclaration instanceof Class) {
                    return new TypeDescription.ForLoadedType((Class)genericDeclaration);
                }
                if (genericDeclaration instanceof Method) {
                    return new MethodDescription.ForLoadedMethod((Method)genericDeclaration);
                }
                if (genericDeclaration instanceof Constructor) {
                    return new MethodDescription.ForLoadedConstructor((Constructor)genericDeclaration);
                }
                throw new IllegalStateException("Unknown declaration: " + genericDeclaration);
            }

            @Override
            public GenericTypeList getUpperBounds() {
                return new GenericTypeList.ForLoadedType(this.typeVariable.getBounds());
            }

            @Override
            public String getSymbol() {
                return this.typeVariable.getName();
            }
        }

        public static abstract class InDetachedForm
        extends ForTypeVariable {
            @Override
            public Sort getSort() {
                return Sort.VARIABLE_DETACHED;
            }

            @Override
            public TypeVariableSource getVariableSource() {
                throw new IllegalStateException("A detached type variable does not imply a source: " + this);
            }

            @Override
            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GenericTypeDescription)) {
                    return false;
                }
                GenericTypeDescription typeVariable = (GenericTypeDescription)other;
                return typeVariable.getSort().isDetachedTypeVariable() && this.getSymbol().equals(typeVariable.getSymbol());
            }

            @Override
            public int hashCode() {
                return this.getSymbol().hashCode();
            }
        }
    }

    public static abstract class ForParameterizedType
    implements GenericTypeDescription {
        @Override
        public Sort getSort() {
            return Sort.PARAMETERIZED;
        }

        @Override
        public GenericTypeDescription getSuperType() {
            return LazyProjection.OfPotentiallyRawType.of(this.asRawType().getSuperType(), Visitor.Substitutor.ForTypeVariableBinding.bind(this));
        }

        @Override
        public GenericTypeList getInterfaces() {
            return new GenericTypeList.OfPotentiallyRawType(this.asRawType().getInterfaces(), Visitor.Substitutor.ForTypeVariableBinding.bind(this));
        }

        public FieldList getDeclaredFields() {
            return new FieldList.TypeSubstituting(this, this.asRawType().getDeclaredFields(), Visitor.Substitutor.ForTypeVariableBinding.bind(this));
        }

        public MethodList getDeclaredMethods() {
            return new MethodList.TypeSubstituting(this, this.asRawType().getDeclaredMethods(), Visitor.Substitutor.ForTypeVariableBinding.bind(this));
        }

        @Override
        public GenericTypeList getUpperBounds() {
            throw new IllegalStateException("A parameterized type does not imply upper bounds: " + this);
        }

        @Override
        public GenericTypeList getLowerBounds() {
            throw new IllegalStateException("A parameterized type does not imply lower bounds: " + this);
        }

        @Override
        public GenericTypeDescription getComponentType() {
            throw new IllegalStateException("A parameterized type does not imply a component type: " + this);
        }

        @Override
        public TypeVariableSource getVariableSource() {
            throw new IllegalStateException("A parameterized type does not imply a type variable source: " + this);
        }

        @Override
        public String getSymbol() {
            throw new IllegalStateException("A parameterized type does not imply a symbol: " + this);
        }

        @Override
        public String getTypeName() {
            return this.toString();
        }

        @Override
        public String getSourceCodeName() {
            return this.toString();
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public Iterator<GenericTypeDescription> iterator() {
            return new SuperTypeIterator(this);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.onParameterizedType(this);
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.SINGLE;
        }

        public int hashCode() {
            int result = 1;
            for (GenericTypeDescription genericTypeDescription : this.getParameters()) {
                result = 31 * result + genericTypeDescription.hashCode();
            }
            GenericTypeDescription ownerType = this.getOwnerType();
            return result ^ (ownerType == null ? this.asRawType().hashCode() : ownerType.hashCode());
        }

        public boolean equals(Object other) {
            if (!(other instanceof GenericTypeDescription)) {
                return false;
            }
            GenericTypeDescription genericTypeDescription = (GenericTypeDescription)other;
            if (!genericTypeDescription.getSort().isParameterized()) {
                return false;
            }
            GenericTypeDescription ownerType = this.getOwnerType();
            GenericTypeDescription otherOwnerType = genericTypeDescription.getOwnerType();
            return !(!this.asRawType().equals(genericTypeDescription.asRawType()) || ownerType == null && otherOwnerType != null || ownerType != null && !ownerType.equals(otherOwnerType) || !this.getParameters().equals(genericTypeDescription.getParameters()));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            GenericTypeDescription ownerType = this.getOwnerType();
            if (ownerType != null) {
                stringBuilder.append(ownerType.getTypeName());
                stringBuilder.append(".");
                stringBuilder.append(ownerType.getSort().isParameterized() ? this.asRawType().getName().replace(ownerType.asRawType().getName() + "$", "") : this.asRawType().getName());
            } else {
                stringBuilder.append(this.asRawType().getName());
            }
            GenericTypeList actualTypeArguments = this.getParameters();
            if (!actualTypeArguments.isEmpty()) {
                stringBuilder.append("<");
                boolean multiple = false;
                for (GenericTypeDescription genericTypeDescription : actualTypeArguments) {
                    if (multiple) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(genericTypeDescription.getTypeName());
                    multiple = true;
                }
                stringBuilder.append(">");
            }
            return stringBuilder.toString();
        }

        public static class Raw
        implements GenericTypeDescription {
            private final TypeDescription typeDescription;

            protected Raw(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            public static GenericTypeDescription check(GenericTypeDescription typeDescription, Visitor<? extends GenericTypeDescription> transformer) {
                return typeDescription.getParameters().size() != typeDescription.asRawType().getTypeVariables().size() ? new Raw(typeDescription.asRawType()) : typeDescription.accept(transformer);
            }

            @Override
            public GenericTypeDescription getSuperType() {
                GenericTypeDescription superType = this.typeDescription.getSuperType();
                return superType == null ? null : superType.accept(Visitor.TypeVariableErasing.INSTANCE);
            }

            @Override
            public GenericTypeList getInterfaces() {
                return this.typeDescription.getInterfaces().accept(Visitor.TypeVariableErasing.INSTANCE);
            }

            public FieldList getDeclaredFields() {
                return new FieldList.TypeSubstituting(this, this.typeDescription.getDeclaredFields(), Visitor.TypeVariableErasing.INSTANCE);
            }

            public MethodList getDeclaredMethods() {
                return new MethodList.TypeSubstituting(this, this.typeDescription.getDeclaredMethods(), Visitor.TypeVariableErasing.INSTANCE);
            }

            @Override
            public GenericTypeDescription getOwnerType() {
                TypeDescription ownerType = this.typeDescription.getOwnerType();
                return ownerType == null ? null : new Raw(ownerType);
            }

            @Override
            public TypeDescription asRawType() {
                return this.typeDescription;
            }

            @Override
            public Sort getSort() {
                return this.typeDescription.getSort();
            }

            @Override
            public GenericTypeList getParameters() {
                return this.typeDescription.getParameters();
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.onNonGenericType(this);
            }

            @Override
            public String getTypeName() {
                return this.typeDescription.getTypeName();
            }

            @Override
            public GenericTypeList getUpperBounds() {
                return this.typeDescription.getUpperBounds();
            }

            @Override
            public GenericTypeList getLowerBounds() {
                return this.typeDescription.getLowerBounds();
            }

            @Override
            public GenericTypeDescription getComponentType() {
                TypeDescription componentType = this.typeDescription.getComponentType();
                return componentType == null ? null : new Raw(componentType);
            }

            @Override
            public TypeVariableSource getVariableSource() {
                return this.typeDescription.getVariableSource();
            }

            @Override
            public String getSymbol() {
                return this.typeDescription.getSymbol();
            }

            @Override
            public StackSize getStackSize() {
                return this.typeDescription.getStackSize();
            }

            @Override
            public String getSourceCodeName() {
                return this.typeDescription.getSourceCodeName();
            }

            @Override
            public boolean isArray() {
                return this.typeDescription.isArray();
            }

            @Override
            public boolean isPrimitive() {
                return this.typeDescription.isPrimitive();
            }

            @Override
            public Iterator<GenericTypeDescription> iterator() {
                return new SuperTypeIterator(this);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public boolean equals(Object other) {
                return this.typeDescription.equals(other);
            }

            public String toString() {
                return this.typeDescription.toString();
            }
        }

        public static class Latent
        extends ForParameterizedType {
            private final TypeDescription rawType;
            private final List<? extends GenericTypeDescription> parameters;
            private final GenericTypeDescription ownerType;

            public Latent(TypeDescription rawType, List<? extends GenericTypeDescription> parameters, GenericTypeDescription ownerType) {
                this.rawType = rawType;
                this.parameters = parameters;
                this.ownerType = ownerType;
            }

            @Override
            public TypeDescription asRawType() {
                return this.rawType;
            }

            @Override
            public GenericTypeList getParameters() {
                return new GenericTypeList.Explicit(this.parameters);
            }

            @Override
            public GenericTypeDescription getOwnerType() {
                return this.ownerType;
            }
        }

        public static class OfLoadedType
        extends ForParameterizedType {
            private final ParameterizedType parameterizedType;

            public OfLoadedType(ParameterizedType parameterizedType) {
                this.parameterizedType = parameterizedType;
            }

            @Override
            public GenericTypeList getParameters() {
                return new GenericTypeList.ForLoadedType(this.parameterizedType.getActualTypeArguments());
            }

            @Override
            public GenericTypeDescription getOwnerType() {
                Type ownerType = this.parameterizedType.getOwnerType();
                return ownerType == null ? null : Sort.describe(ownerType);
            }

            @Override
            public TypeDescription asRawType() {
                return new TypeDescription.ForLoadedType((Class)this.parameterizedType.getRawType());
            }
        }
    }

    public static abstract class ForWildcardType
    implements GenericTypeDescription {
        public static final String SYMBOL = "?";

        @Override
        public Sort getSort() {
            return Sort.WILDCARD;
        }

        @Override
        public TypeDescription asRawType() {
            throw new IllegalStateException("A wildcard does not represent an erasable type: " + this);
        }

        @Override
        public GenericTypeDescription getSuperType() {
            throw new IllegalStateException("A wildcard does not imply a super type definition: " + this);
        }

        @Override
        public GenericTypeList getInterfaces() {
            throw new IllegalStateException("A wildcard does not imply an interface type definition: " + this);
        }

        public FieldList getDeclaredFields() {
            throw new IllegalStateException("A wildcard does not imply field definitions: " + this);
        }

        public MethodList getDeclaredMethods() {
            throw new IllegalStateException("A wildcard does not imply method definitions: " + this);
        }

        @Override
        public GenericTypeDescription getComponentType() {
            throw new IllegalStateException("A wildcard does not imply a component type: " + this);
        }

        @Override
        public TypeVariableSource getVariableSource() {
            throw new IllegalStateException("A wildcard does not imply a type variable source: " + this);
        }

        @Override
        public GenericTypeList getParameters() {
            throw new IllegalStateException("A wildcard does not imply type parameters: " + this);
        }

        @Override
        public GenericTypeDescription getOwnerType() {
            throw new IllegalStateException("A wildcard does not imply an owner type: " + this);
        }

        @Override
        public String getSymbol() {
            throw new IllegalStateException("A wildcard does not imply a symbol: " + this);
        }

        @Override
        public String getTypeName() {
            return this.toString();
        }

        @Override
        public String getSourceCodeName() {
            return this.toString();
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public Iterator<GenericTypeDescription> iterator() {
            throw new IllegalStateException("A wildcard does not imply a super type definition: " + this);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.onWildcardType(this);
        }

        @Override
        public StackSize getStackSize() {
            throw new IllegalStateException("A wildcard does not imply an operand stack size: " + this);
        }

        public int hashCode() {
            int lowerHash = 1;
            int upperHash = 1;
            for (GenericTypeDescription genericTypeDescription : this.getLowerBounds()) {
                lowerHash = 31 * lowerHash + genericTypeDescription.hashCode();
            }
            for (GenericTypeDescription genericTypeDescription : this.getUpperBounds()) {
                upperHash = 31 * upperHash + genericTypeDescription.hashCode();
            }
            return lowerHash ^ upperHash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof GenericTypeDescription)) {
                return false;
            }
            GenericTypeDescription genericTypeDescription = (GenericTypeDescription)other;
            return genericTypeDescription.getSort().isWildcard() && this.getUpperBounds().equals(genericTypeDescription.getUpperBounds()) && this.getLowerBounds().equals(genericTypeDescription.getLowerBounds());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(SYMBOL);
            GenericTypeList bounds = this.getLowerBounds();
            if (!bounds.isEmpty()) {
                stringBuilder.append(" super ");
            } else {
                bounds = this.getUpperBounds();
                if (((GenericTypeDescription)bounds.getOnly()).equals(TypeDescription.OBJECT)) {
                    return SYMBOL;
                }
                stringBuilder.append(" extends ");
            }
            return stringBuilder.append(((GenericTypeDescription)bounds.getOnly()).getTypeName()).toString();
        }

        public static class Latent
        extends ForWildcardType {
            private final List<? extends GenericTypeDescription> upperBounds;
            private final List<? extends GenericTypeDescription> lowerBounds;

            protected Latent(List<? extends GenericTypeDescription> upperBounds, List<? extends GenericTypeDescription> lowerBounds) {
                this.upperBounds = upperBounds;
                this.lowerBounds = lowerBounds;
            }

            public static GenericTypeDescription unbounded() {
                return new Latent(Collections.singletonList(TypeDescription.OBJECT), Collections.emptyList());
            }

            public static GenericTypeDescription boundedAbove(GenericTypeDescription upperBound) {
                return new Latent(Collections.singletonList(upperBound), Collections.emptyList());
            }

            public static GenericTypeDescription boundedBelow(GenericTypeDescription lowerBound) {
                return new Latent(Collections.singletonList(TypeDescription.OBJECT), Collections.singletonList(lowerBound));
            }

            @Override
            public GenericTypeList getUpperBounds() {
                return new GenericTypeList.Explicit(this.upperBounds);
            }

            @Override
            public GenericTypeList getLowerBounds() {
                return new GenericTypeList.Explicit(this.lowerBounds);
            }
        }

        public static class OfLoadedType
        extends ForWildcardType {
            private final WildcardType wildcardType;

            public OfLoadedType(WildcardType wildcardType) {
                this.wildcardType = wildcardType;
            }

            @Override
            public GenericTypeList getLowerBounds() {
                return new GenericTypeList.ForLoadedType(this.wildcardType.getLowerBounds());
            }

            @Override
            public GenericTypeList getUpperBounds() {
                return new GenericTypeList.ForLoadedType(this.wildcardType.getUpperBounds());
            }
        }
    }

    public static abstract class ForGenericArray
    implements GenericTypeDescription {
        @Override
        public Sort getSort() {
            return this.getComponentType().getSort().isNonGeneric() ? Sort.NON_GENERIC : Sort.GENERIC_ARRAY;
        }

        @Override
        public TypeDescription asRawType() {
            return TypeDescription.ArrayProjection.of(this.getComponentType().asRawType(), 1);
        }

        @Override
        public GenericTypeDescription getSuperType() {
            return TypeDescription.OBJECT;
        }

        @Override
        public GenericTypeList getInterfaces() {
            return TypeDescription.ARRAY_INTERFACES;
        }

        public FieldList getDeclaredFields() {
            return new FieldList.Empty();
        }

        public MethodList getDeclaredMethods() {
            return new MethodList.Empty();
        }

        @Override
        public GenericTypeList getUpperBounds() {
            throw new IllegalStateException("An array type does not imply upper type bounds: " + this);
        }

        @Override
        public GenericTypeList getLowerBounds() {
            throw new IllegalStateException("An array type does not imply lower type bounds: " + this);
        }

        @Override
        public TypeVariableSource getVariableSource() {
            throw new IllegalStateException("An array type does not imply a type variable source: " + this);
        }

        @Override
        public GenericTypeList getParameters() {
            return new GenericTypeList.Empty();
        }

        @Override
        public GenericTypeDescription getOwnerType() {
            return NO_OWNER_TYPE;
        }

        @Override
        public String getSymbol() {
            throw new IllegalStateException("An array type does not imply a symbol: " + this);
        }

        @Override
        public String getTypeName() {
            return this.getSort().isNonGeneric() ? this.asRawType().getTypeName() : this.toString();
        }

        @Override
        public String getSourceCodeName() {
            return this.getSort().isNonGeneric() ? this.asRawType().getSourceCodeName() : this.toString();
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public Iterator<GenericTypeDescription> iterator() {
            return new SuperTypeIterator(this);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return this.getSort().isNonGeneric() ? visitor.onNonGenericType(this) : visitor.onGenericArray(this);
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.SINGLE;
        }

        public boolean equals(Object other) {
            if (this.getSort().isNonGeneric()) {
                return this.asRawType().equals(other);
            }
            if (!(other instanceof GenericTypeDescription)) {
                return false;
            }
            GenericTypeDescription genericTypeDescription = (GenericTypeDescription)other;
            return genericTypeDescription.getSort().isGenericArray() && this.getComponentType().equals(genericTypeDescription.getComponentType());
        }

        public int hashCode() {
            return this.getSort().isNonGeneric() ? this.asRawType().hashCode() : this.getComponentType().hashCode();
        }

        public String toString() {
            return this.getSort().isNonGeneric() ? this.asRawType().toString() : this.getComponentType().getTypeName() + "[]";
        }

        public static class Latent
        extends ForGenericArray {
            private final GenericTypeDescription componentType;
            private final int arity;

            protected Latent(GenericTypeDescription componentType, int arity) {
                this.componentType = componentType;
                this.arity = arity;
            }

            public static GenericTypeDescription of(GenericTypeDescription componentType, int arity) {
                if (arity < 0) {
                    throw new IllegalArgumentException("Arrays cannot have a negative arity");
                }
                while (componentType.getSort().isGenericArray()) {
                    componentType = componentType.getComponentType();
                    ++arity;
                }
                return arity == 0 ? componentType : new Latent(componentType, arity);
            }

            @Override
            public GenericTypeDescription getComponentType() {
                return this.arity == 1 ? this.componentType : new Latent(this.componentType, this.arity - 1);
            }
        }

        public static class OfLoadedType
        extends ForGenericArray {
            private final GenericArrayType genericArrayType;

            public OfLoadedType(GenericArrayType genericArrayType) {
                this.genericArrayType = genericArrayType;
            }

            @Override
            public GenericTypeDescription getComponentType() {
                return Sort.describe(this.genericArrayType.getGenericComponentType());
            }
        }
    }

    public static interface Visitor<T> {
        public T onGenericArray(GenericTypeDescription var1);

        public T onWildcardType(GenericTypeDescription var1);

        public T onParameterizedType(GenericTypeDescription var1);

        public T onTypeVariable(GenericTypeDescription var1);

        public T onNonGenericType(GenericTypeDescription var1);

        public static abstract class Substitutor
        implements Visitor<GenericTypeDescription> {
            @Override
            public GenericTypeDescription onParameterizedType(GenericTypeDescription parameterizedType) {
                GenericTypeDescription ownerType = parameterizedType.getOwnerType();
                ArrayList<GenericTypeDescription> parameters = new ArrayList<GenericTypeDescription>(parameterizedType.getParameters().size());
                for (GenericTypeDescription parameter : parameterizedType.getParameters()) {
                    parameters.add(parameter.accept(this));
                }
                return new ForParameterizedType.Latent(parameterizedType.asRawType().accept(this).asRawType(), parameters, ownerType == null ? null : ownerType.accept(this));
            }

            @Override
            public GenericTypeDescription onGenericArray(GenericTypeDescription genericArray) {
                return ForGenericArray.Latent.of(genericArray.getComponentType().accept(this), 1);
            }

            @Override
            public GenericTypeDescription onWildcardType(GenericTypeDescription wildcardType) {
                GenericTypeList lowerBounds = wildcardType.getLowerBounds();
                return lowerBounds.isEmpty() ? ForWildcardType.Latent.boundedAbove(((GenericTypeDescription)wildcardType.getUpperBounds().getOnly()).accept(this)) : ForWildcardType.Latent.boundedBelow(((GenericTypeDescription)lowerBounds.getOnly()).accept(this));
            }

            @Override
            public GenericTypeDescription onNonGenericType(GenericTypeDescription typeDescription) {
                int arity = 0;
                while (typeDescription.isArray()) {
                    typeDescription = typeDescription.getComponentType();
                    ++arity;
                }
                return ForGenericArray.Latent.of(this.onSimpleType(typeDescription), arity);
            }

            protected abstract GenericTypeDescription onSimpleType(GenericTypeDescription var1);

            public static class ForTypeVariableBinding
            extends Substitutor {
                private final Map<GenericTypeDescription, GenericTypeDescription> bindings;

                protected ForTypeVariableBinding(Map<GenericTypeDescription, GenericTypeDescription> bindings) {
                    this.bindings = bindings;
                }

                public static Visitor<GenericTypeDescription> bind(GenericTypeDescription typeDescription) {
                    HashMap<GenericTypeDescription, GenericTypeDescription> bindings = new HashMap<GenericTypeDescription, GenericTypeDescription>();
                    do {
                        GenericTypeList parameters = typeDescription.getParameters();
                        GenericTypeList typeVariables = typeDescription.asRawType().getTypeVariables();
                        if (parameters.size() != typeVariables.size()) {
                            return TypeVariableErasing.INSTANCE;
                        }
                        for (int index = 0; index < typeVariables.size(); ++index) {
                            bindings.put((GenericTypeDescription)typeVariables.get(index), (GenericTypeDescription)parameters.get(index));
                        }
                    } while ((typeDescription = typeDescription.getOwnerType()) != null && typeDescription.getSort().isParameterized());
                    return new ForTypeVariableBinding(bindings);
                }

                @Override
                public GenericTypeDescription onTypeVariable(GenericTypeDescription typeVariable) {
                    GenericTypeDescription substitution = this.bindings.get(typeVariable);
                    return substitution == null ? typeVariable.asRawType() : substitution;
                }

                @Override
                public GenericTypeDescription onNonGenericType(GenericTypeDescription typeDescription) {
                    return typeDescription;
                }

                @Override
                protected GenericTypeDescription onSimpleType(GenericTypeDescription typeDescription) {
                    throw new UnsupportedOperationException();
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ForTypeVariableBinding)) {
                        return false;
                    }
                    ForTypeVariableBinding that = (ForTypeVariableBinding)other;
                    return this.bindings.equals(that.bindings);
                }

                public int hashCode() {
                    return this.bindings.hashCode();
                }

                public String toString() {
                    return "GenericTypeDescription.Visitor.Substitutor.ForTypeVariableBinding{bindings=" + this.bindings + '}';
                }
            }

            public static class ForDetachment
            extends Substitutor {
                private final ElementMatcher<? super TypeDescription> typeMatcher;
                private final Map<String, GenericTypeDescription> detachedVariables;

                public ForDetachment(ElementMatcher<? super TypeDescription> typeMatcher) {
                    this.typeMatcher = typeMatcher;
                    this.detachedVariables = new HashMap<String, GenericTypeDescription>();
                }

                @Override
                public GenericTypeDescription onTypeVariable(GenericTypeDescription genericTypeDescription) {
                    GenericTypeDescription typeVariable = this.detachedVariables.get(genericTypeDescription.getSymbol());
                    return typeVariable == null ? new DetachedTypeVariable(genericTypeDescription.getSymbol(), genericTypeDescription.getUpperBounds(), this) : typeVariable;
                }

                @Override
                protected GenericTypeDescription onSimpleType(GenericTypeDescription typeDescription) {
                    return this.typeMatcher.matches(typeDescription.asRawType()) ? TargetType.DESCRIPTION : typeDescription;
                }

                protected void register(String symbol, GenericTypeDescription typeVariable) {
                    this.detachedVariables.put(symbol, typeVariable);
                }

                public String toString() {
                    return "GenericTypeDescription.Visitor.Substitutor.ForDetachment{typeMatcher=" + this.typeMatcher + ", detachedVariables=" + this.detachedVariables + '}';
                }

                protected static class DetachedTypeVariable
                extends ForTypeVariable.InDetachedForm {
                    private final String symbol;
                    private final List<GenericTypeDescription> bounds;

                    protected DetachedTypeVariable(String symbol, List<GenericTypeDescription> bounds, ForDetachment visitor) {
                        this.symbol = symbol;
                        visitor.register(symbol, this);
                        this.bounds = new ArrayList<GenericTypeDescription>(bounds.size());
                        for (GenericTypeDescription bound : bounds) {
                            this.bounds.add(bound.accept(visitor));
                        }
                    }

                    @Override
                    public GenericTypeList getUpperBounds() {
                        return new GenericTypeList.Explicit(this.bounds);
                    }

                    @Override
                    public String getSymbol() {
                        return this.symbol;
                    }
                }
            }

            public static class ForAttachment
            extends Substitutor {
                private final TypeDescription declaringType;
                private final TypeVariableSource typeVariableSource;

                protected ForAttachment(TypeDescription declaringType, TypeVariableSource typeVariableSource) {
                    this.declaringType = declaringType;
                    this.typeVariableSource = typeVariableSource;
                }

                public static ForAttachment of(FieldDescription fieldDescription) {
                    return new ForAttachment(fieldDescription.getDeclaringType().asRawType(), fieldDescription.getDeclaringType().asRawType());
                }

                public static ForAttachment of(MethodDescription methodDescription) {
                    return new ForAttachment(methodDescription.getDeclaringType().asRawType(), methodDescription);
                }

                public static ForAttachment of(ParameterDescription parameterDescription) {
                    return new ForAttachment(parameterDescription.getDeclaringMethod().getDeclaringType().asRawType(), parameterDescription.getDeclaringMethod());
                }

                public static ForAttachment of(TypeDescription typeDescription) {
                    return new ForAttachment(typeDescription, typeDescription);
                }

                @Override
                public GenericTypeDescription onTypeVariable(GenericTypeDescription genericTypeDescription) {
                    GenericTypeDescription typeVariable = this.typeVariableSource.findVariable(genericTypeDescription.getSymbol());
                    return typeVariable == null ? genericTypeDescription.asRawType() : typeVariable;
                }

                @Override
                protected GenericTypeDescription onSimpleType(GenericTypeDescription typeDescription) {
                    return typeDescription.equals(TargetType.DESCRIPTION) ? this.declaringType : typeDescription;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ForAttachment)) {
                        return false;
                    }
                    ForAttachment that = (ForAttachment)other;
                    return this.declaringType.equals(that.declaringType) && this.typeVariableSource.equals(that.typeVariableSource);
                }

                public int hashCode() {
                    int result = this.declaringType.hashCode();
                    result = 31 * result + this.typeVariableSource.hashCode();
                    return result;
                }

                public String toString() {
                    return "GenericTypeDescription.Visitor.Substitutor.ForAttachment{declaringType=" + this.declaringType + ", typeVariableSource=" + this.typeVariableSource + '}';
                }
            }
        }

        public static class ForSignatureVisitor
        implements Visitor<SignatureVisitor> {
            private static final int ONLY_CHARACTER = 0;
            protected final SignatureVisitor signatureVisitor;

            public ForSignatureVisitor(SignatureVisitor signatureVisitor) {
                this.signatureVisitor = signatureVisitor;
            }

            @Override
            public SignatureVisitor onGenericArray(GenericTypeDescription genericArray) {
                genericArray.getComponentType().accept(new ForSignatureVisitor(this.signatureVisitor.visitArrayType()));
                return this.signatureVisitor;
            }

            @Override
            public SignatureVisitor onWildcardType(GenericTypeDescription wildcardType) {
                throw new IllegalStateException("Unexpected wildcard: " + wildcardType);
            }

            @Override
            public SignatureVisitor onParameterizedType(GenericTypeDescription parameterizedType) {
                this.onOwnableType(parameterizedType);
                this.signatureVisitor.visitEnd();
                return this.signatureVisitor;
            }

            private void onOwnableType(GenericTypeDescription genericTypeDescription) {
                GenericTypeDescription ownerType = genericTypeDescription.getOwnerType();
                if (ownerType != null && ownerType.getSort().isParameterized()) {
                    this.onOwnableType(ownerType);
                    this.signatureVisitor.visitInnerClassType(genericTypeDescription.asRawType().getSimpleName());
                } else {
                    this.signatureVisitor.visitClassType(genericTypeDescription.asRawType().getInternalName());
                }
                for (GenericTypeDescription upperBound : genericTypeDescription.getParameters()) {
                    upperBound.accept(new OfParameter(this.signatureVisitor));
                }
            }

            @Override
            public SignatureVisitor onTypeVariable(GenericTypeDescription typeVariable) {
                this.signatureVisitor.visitTypeVariable(typeVariable.getSymbol());
                return this.signatureVisitor;
            }

            @Override
            public SignatureVisitor onNonGenericType(GenericTypeDescription typeDescription) {
                if (typeDescription.isArray()) {
                    typeDescription.getComponentType().accept(new ForSignatureVisitor(this.signatureVisitor.visitArrayType()));
                } else if (typeDescription.isPrimitive()) {
                    this.signatureVisitor.visitBaseType(typeDescription.asRawType().getDescriptor().charAt(0));
                } else {
                    this.signatureVisitor.visitClassType(typeDescription.asRawType().getInternalName());
                    this.signatureVisitor.visitEnd();
                }
                return this.signatureVisitor;
            }

            public boolean equals(Object other) {
                return this == other || other instanceof ForSignatureVisitor && this.signatureVisitor.equals(((ForSignatureVisitor)other).signatureVisitor);
            }

            public int hashCode() {
                return this.signatureVisitor.hashCode();
            }

            public String toString() {
                return "GenericTypeDescription.Visitor.ForSignatureVisitor{signatureVisitor=" + this.signatureVisitor + '}';
            }

            protected static class OfParameter
            extends ForSignatureVisitor {
                protected OfParameter(SignatureVisitor signatureVisitor) {
                    super(signatureVisitor);
                }

                @Override
                public SignatureVisitor onWildcardType(GenericTypeDescription wildcardType) {
                    GenericTypeList upperBounds = wildcardType.getUpperBounds();
                    GenericTypeList lowerBounds = wildcardType.getLowerBounds();
                    if (lowerBounds.isEmpty() && ((GenericTypeDescription)upperBounds.getOnly()).asRawType().represents(Object.class)) {
                        this.signatureVisitor.visitTypeArgument();
                    } else if (!lowerBounds.isEmpty()) {
                        ((GenericTypeDescription)lowerBounds.getOnly()).accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('-')));
                    } else {
                        ((GenericTypeDescription)upperBounds.getOnly()).accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('+')));
                    }
                    return this.signatureVisitor;
                }

                @Override
                public SignatureVisitor onGenericArray(GenericTypeDescription genericArray) {
                    genericArray.accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('=')));
                    return this.signatureVisitor;
                }

                @Override
                public SignatureVisitor onParameterizedType(GenericTypeDescription parameterizedType) {
                    parameterizedType.accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('=')));
                    return this.signatureVisitor;
                }

                @Override
                public SignatureVisitor onTypeVariable(GenericTypeDescription typeVariable) {
                    typeVariable.accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('=')));
                    return this.signatureVisitor;
                }

                @Override
                public SignatureVisitor onNonGenericType(GenericTypeDescription typeDescription) {
                    typeDescription.accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('=')));
                    return this.signatureVisitor;
                }

                @Override
                public String toString() {
                    return "GenericTypeDescription.Visitor.ForSignatureVisitor.OfParameter{}";
                }
            }
        }

        public static enum TypeVariableErasing implements Visitor<GenericTypeDescription>
        {
            INSTANCE;


            @Override
            public GenericTypeDescription onGenericArray(GenericTypeDescription genericArray) {
                return ForGenericArray.Latent.of(genericArray.getComponentType().accept(this), 1);
            }

            @Override
            public GenericTypeDescription onWildcardType(GenericTypeDescription wildcardType) {
                GenericTypeList lowerBounds = wildcardType.getLowerBounds();
                return lowerBounds.isEmpty() ? ForWildcardType.Latent.boundedAbove(((GenericTypeDescription)wildcardType.getUpperBounds().getOnly()).accept(this)) : ForWildcardType.Latent.boundedBelow(((GenericTypeDescription)lowerBounds.getOnly()).accept(this));
            }

            @Override
            public GenericTypeDescription onParameterizedType(GenericTypeDescription parameterizedType) {
                ArrayList<GenericTypeDescription> parameters = new ArrayList<GenericTypeDescription>(parameterizedType.getParameters().size());
                for (GenericTypeDescription parameter : parameterizedType.getParameters()) {
                    if (parameter.accept(PartialErasureReviser.INSTANCE).booleanValue()) {
                        return parameterizedType.asRawType();
                    }
                    parameters.add(parameter.accept(this));
                }
                GenericTypeDescription ownerType = parameterizedType.getOwnerType();
                return new ForParameterizedType.Latent(parameterizedType.asRawType(), parameters, ownerType == null ? null : ownerType.accept(this));
            }

            @Override
            public GenericTypeDescription onTypeVariable(GenericTypeDescription typeVariable) {
                return typeVariable.asRawType();
            }

            @Override
            public GenericTypeDescription onNonGenericType(GenericTypeDescription typeDescription) {
                return new ForParameterizedType.Raw(typeDescription.asRawType());
            }

            public String toString() {
                return "GenericTypeDescription.Visitor.TypeVariableErasing." + this.name();
            }

            protected static enum PartialErasureReviser implements Visitor<Boolean>
            {
                INSTANCE;


                @Override
                public Boolean onGenericArray(GenericTypeDescription genericArray) {
                    return genericArray.getComponentType().accept(this);
                }

                @Override
                public Boolean onWildcardType(GenericTypeDescription wildcardType) {
                    GenericTypeList lowerBounds = wildcardType.getLowerBounds();
                    return lowerBounds.isEmpty() ? ((GenericTypeDescription)wildcardType.getUpperBounds().getOnly()).accept(this) : ((GenericTypeDescription)lowerBounds.getOnly()).accept(this);
                }

                @Override
                public Boolean onParameterizedType(GenericTypeDescription parameterizedType) {
                    return false;
                }

                @Override
                public Boolean onTypeVariable(GenericTypeDescription typeVariable) {
                    return true;
                }

                @Override
                public Boolean onNonGenericType(GenericTypeDescription typeDescription) {
                    return false;
                }

                public String toString() {
                    return "GenericTypeDescription.Visitor.TypeVariableErasing.PartialErasureReviser." + this.name();
                }
            }
        }

        public static enum TypeErasing implements Visitor<TypeDescription>
        {
            INSTANCE;


            @Override
            public TypeDescription onGenericArray(GenericTypeDescription genericArray) {
                return genericArray.asRawType();
            }

            @Override
            public TypeDescription onWildcardType(GenericTypeDescription wildcardType) {
                throw new IllegalArgumentException("Cannot erase a wilcard type");
            }

            @Override
            public TypeDescription onParameterizedType(GenericTypeDescription parameterizedType) {
                return parameterizedType.asRawType();
            }

            @Override
            public TypeDescription onTypeVariable(GenericTypeDescription typeVariable) {
                return typeVariable.asRawType();
            }

            @Override
            public TypeDescription onNonGenericType(GenericTypeDescription typeDescription) {
                return typeDescription.asRawType();
            }

            public String toString() {
                return "GenericTypeDescription.Visitor.TypeErasing." + this.name();
            }
        }

        public static enum NoOp implements Visitor<GenericTypeDescription>
        {
            INSTANCE;


            @Override
            public GenericTypeDescription onGenericArray(GenericTypeDescription genericArray) {
                return genericArray;
            }

            @Override
            public GenericTypeDescription onWildcardType(GenericTypeDescription wildcardType) {
                return wildcardType;
            }

            @Override
            public GenericTypeDescription onParameterizedType(GenericTypeDescription parameterizedType) {
                return parameterizedType;
            }

            @Override
            public GenericTypeDescription onTypeVariable(GenericTypeDescription typeVariable) {
                return typeVariable;
            }

            @Override
            public GenericTypeDescription onNonGenericType(GenericTypeDescription typeDescription) {
                return typeDescription;
            }

            public String toString() {
                return "GenericTypeDescription.Visitor.NoOp." + this.name();
            }
        }
    }

    public static enum Sort {
        NON_GENERIC,
        GENERIC_ARRAY,
        PARAMETERIZED,
        WILDCARD,
        VARIABLE,
        VARIABLE_DETACHED,
        VARIABLE_SYMBOLIC;


        public static GenericTypeDescription describe(Type type) {
            if (type instanceof Class) {
                return new TypeDescription.ForLoadedType((Class)type);
            }
            if (type instanceof GenericArrayType) {
                return new ForGenericArray.OfLoadedType((GenericArrayType)type);
            }
            if (type instanceof ParameterizedType) {
                return new ForParameterizedType.OfLoadedType((ParameterizedType)type);
            }
            if (type instanceof TypeVariable) {
                return new ForTypeVariable.OfLoadedType((TypeVariable)type);
            }
            if (type instanceof WildcardType) {
                return new ForWildcardType.OfLoadedType((WildcardType)type);
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }

        public boolean isNonGeneric() {
            return this == NON_GENERIC;
        }

        public boolean isParameterized() {
            return this == PARAMETERIZED;
        }

        public boolean isGenericArray() {
            return this == GENERIC_ARRAY;
        }

        public boolean isWildcard() {
            return this == WILDCARD;
        }

        public boolean isTypeVariable() {
            return this == VARIABLE;
        }

        public boolean isDetachedTypeVariable() {
            return this == VARIABLE_DETACHED;
        }

        public boolean isSymbolicTypeVariable() {
            return this == VARIABLE_SYMBOLIC;
        }

        public String toString() {
            return "GenericTypeDescription.Sort." + this.name();
        }
    }
}

